/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.levelgen.feature.treedecorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamabnormals.atmospheric.common.levelgen.feature.treedecorators.YuccaFlowersDecorator;
import com.teamabnormals.atmospheric.core.registry.AtmosphericFeatures;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class YuccaFlowerPatchDecorator
extends TreeDecorator {
    public static final MapCodec<YuccaFlowerPatchDecorator> CODEC = RecordCodecBuilder.mapCodec(codec -> codec.group((App)BlockStateProvider.CODEC.fieldOf("block_provider").forGetter(instance -> instance.blockProvider)).apply((Applicative)codec, YuccaFlowerPatchDecorator::new));
    private final BlockStateProvider blockProvider;

    public YuccaFlowerPatchDecorator(BlockStateProvider blockProvider) {
        this.blockProvider = blockProvider;
    }

    public void place(TreeDecorator.Context context) {
        LevelSimulatedReader level = context.level();
        RandomSource random = context.random();
        BlockPos pos = YuccaFlowerPatchDecorator.getLowestBlockPos((ObjectArrayList<BlockPos>)context.logs());
        for (int j = 0; j < 64; ++j) {
            BlockPos offsetPos = pos.offset(random.nextInt(8) - random.nextInt(8), random.nextInt(4) - random.nextInt(4), random.nextInt(8) - random.nextInt(8));
            if (!level.isStateAtPosition(offsetPos.below(), state -> state.is(BlockTags.SAND))) continue;
            YuccaFlowersDecorator.placeFlower(context, this.blockProvider.getState(random, offsetPos), offsetPos);
        }
    }

    public static BlockPos getLowestBlockPos(ObjectArrayList<BlockPos> positions) {
        BlockPos lowest = (BlockPos)positions.get(0);
        for (BlockPos pos : positions) {
            if (pos.getY() >= lowest.getY()) continue;
            lowest = pos;
        }
        return lowest;
    }

    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)AtmosphericFeatures.YUCCA_FLOWER_PATCH.get();
    }
}

