/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.levelgen.feature.treedecorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamabnormals.atmospheric.core.registry.AtmosphericFeatures;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class YuccaFlowersDecorator
extends TreeDecorator {
    public static final MapCodec<YuccaFlowersDecorator> CODEC = RecordCodecBuilder.mapCodec(codec -> codec.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(instance -> Float.valueOf(instance.probability)), (App)BlockStateProvider.CODEC.fieldOf("block_provider").forGetter(instance -> instance.blockProvider)).apply((Applicative)codec, YuccaFlowersDecorator::new));
    private final float probability;
    private final BlockStateProvider blockProvider;

    public YuccaFlowersDecorator(float probability, BlockStateProvider blockProvider) {
        this.probability = probability;
        this.blockProvider = blockProvider;
    }

    public void place(TreeDecorator.Context context) {
        RandomSource random = context.random();
        for (BlockPos pos : context.leaves()) {
            if (!(random.nextFloat() < this.probability)) continue;
            YuccaFlowersDecorator.placeFlower(context, this.blockProvider.getState(random, pos.above()), pos.above());
        }
    }

    public static void placeFlower(TreeDecorator.Context context, BlockState state, BlockPos pos) {
        if (context.isAir(pos)) {
            if (state.getBlock() instanceof DoublePlantBlock) {
                if (context.isAir(pos.above())) {
                    context.setBlock(pos, (BlockState)state.setValue((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
                    context.setBlock(pos.above(), (BlockState)state.setValue((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER));
                }
            } else {
                context.setBlock(pos, state);
            }
        }
    }

    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)AtmosphericFeatures.YUCCA_FLOWERS.get();
    }
}

