/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.core;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.teamabnormals.atmospheric.core.AtmosphericConfig;
import com.teamabnormals.atmospheric.core.data.client.AtmosphericBlockStateProvider;
import com.teamabnormals.atmospheric.core.data.client.AtmosphericItemModelProvider;
import com.teamabnormals.atmospheric.core.data.client.AtmosphericSpriteSourceProvider;
import com.teamabnormals.atmospheric.core.data.server.AtmosphericAdvancementProvider;
import com.teamabnormals.atmospheric.core.data.server.AtmosphericDataMapProvider;
import com.teamabnormals.atmospheric.core.data.server.AtmosphericDatapackProvider;
import com.teamabnormals.atmospheric.core.data.server.AtmosphericLootTableProvider;
import com.teamabnormals.atmospheric.core.data.server.AtmosphericRecipeProvider;
import com.teamabnormals.atmospheric.core.data.server.modifiers.AtmosphericAdvancementModifierProvider;
import com.teamabnormals.atmospheric.core.data.server.modifiers.AtmosphericChunkGeneratorModifierProvider;
import com.teamabnormals.atmospheric.core.data.server.modifiers.AtmosphericDataRemolderProvider;
import com.teamabnormals.atmospheric.core.data.server.tags.AtmosphericBannerPatternTagsProvider;
import com.teamabnormals.atmospheric.core.data.server.tags.AtmosphericBiomeTagsProvider;
import com.teamabnormals.atmospheric.core.data.server.tags.AtmosphericBlockTagsProvider;
import com.teamabnormals.atmospheric.core.data.server.tags.AtmosphericDamageTypeTagsProvider;
import com.teamabnormals.atmospheric.core.data.server.tags.AtmosphericEntityTypeTagsProvider;
import com.teamabnormals.atmospheric.core.data.server.tags.AtmosphericItemTagsProvider;
import com.teamabnormals.atmospheric.core.data.server.tags.AtmosphericPaintingVariantTagsProvider;
import com.teamabnormals.atmospheric.core.data.server.tags.AtmosphericStructureTagsProvider;
import com.teamabnormals.atmospheric.core.data.server.tags.AtmosphericTrimMaterialTagsProvider;
import com.teamabnormals.atmospheric.core.other.AtmosphericClientCompat;
import com.teamabnormals.atmospheric.core.other.AtmosphericCompat;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.atmospheric.core.registry.AtmosphericConditionSerializers;
import com.teamabnormals.atmospheric.core.registry.AtmosphericCriteriaTriggers;
import com.teamabnormals.atmospheric.core.registry.AtmosphericDataSerializers;
import com.teamabnormals.atmospheric.core.registry.AtmosphericDecoratedPotPatterns;
import com.teamabnormals.atmospheric.core.registry.AtmosphericEntityTypes;
import com.teamabnormals.atmospheric.core.registry.AtmosphericFeatures;
import com.teamabnormals.atmospheric.core.registry.AtmosphericItems;
import com.teamabnormals.atmospheric.core.registry.AtmosphericMobEffects;
import com.teamabnormals.atmospheric.core.registry.AtmosphericParticleTypes;
import com.teamabnormals.atmospheric.core.registry.AtmosphericPlacementModifierTypes;
import com.teamabnormals.atmospheric.core.registry.AtmosphericRegistries;
import com.teamabnormals.atmospheric.core.registry.AtmosphericSoundEvents;
import com.teamabnormals.atmospheric.core.registry.AtmosphericVillagerTypes;
import com.teamabnormals.atmospheric.core.registry.helper.AtmosphericBlockSubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.ISubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import com.teamabnormals.gallery.core.data.client.GalleryItemModelProvider;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@Mod(value="atmospheric")
public class Atmospheric {
    public static final String MOD_ID = "atmospheric";
    public static final RegistryHelper REGISTRY_HELPER = RegistryHelper.create((String)"atmospheric", helper -> helper.putSubHelper(Registries.BLOCK, (ISubRegistryHelper)new AtmosphericBlockSubRegistryHelper((RegistryHelper)helper)));

    public Atmospheric(IEventBus bus, ModContainer container) {
        AtmosphericBlocks.BLOCKS.register(bus);
        AtmosphericItems.ITEMS.register(bus);
        AtmosphericEntityTypes.ENTITY_TYPES.register(bus);
        AtmosphericSoundEvents.SOUND_EVENTS.register(bus);
        AtmosphericFeatures.FEATURES.register(bus);
        AtmosphericFeatures.TREE_DECORATOR_TYPES.register(bus);
        AtmosphericPlacementModifierTypes.PLACEMENT_MODIFIER_TYPES.register(bus);
        AtmosphericParticleTypes.PARTICLES.register(bus);
        AtmosphericMobEffects.EFFECTS.register(bus);
        AtmosphericMobEffects.POTIONS.register(bus);
        AtmosphericConditionSerializers.CONDITION_SERIALIZERS.register(bus);
        AtmosphericDecoratedPotPatterns.DECORATED_POT_PATTERNS.register(bus);
        AtmosphericVillagerTypes.VILLAGER_TYPES.register(bus);
        AtmosphericDataSerializers.SERIALIZERS.register(bus);
        AtmosphericCriteriaTriggers.TRIGGERS.register(bus);
        bus.addListener(AtmosphericRegistries::registerRegistries);
        bus.addListener(this::commonSetup);
        bus.addListener(this::clientSetup);
        bus.addListener(this::dataSetup);
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)AtmosphericConfig.COMMON_SPEC);
        AtmosphericCompat.setupDates();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        HashSet validBlocks = Sets.newHashSet((Iterable)BlockEntityType.BRUSHABLE_BLOCK.validBlocks);
        validBlocks.addAll(Sets.newHashSet((Object[])new Block[]{(Block)AtmosphericBlocks.SUSPICIOUS_ARID_SAND.get(), (Block)AtmosphericBlocks.SUSPICIOUS_RED_ARID_SAND.get()}));
        BlockEntityType.BRUSHABLE_BLOCK.validBlocks = ImmutableSet.copyOf((Collection)validBlocks);
        event.enqueueWork(() -> {
            AtmosphericCompat.registerCompat();
            AtmosphericDecoratedPotPatterns.registerDecoratedPotPatterns();
        });
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(AtmosphericClientCompat::registerCompat);
    }

    private void dataSetup(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture provider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        boolean server = event.includeServer();
        AtmosphericDatapackProvider datapack = new AtmosphericDatapackProvider(output, provider);
        generator.addProvider(server, (DataProvider)datapack);
        provider = datapack.getRegistryProvider();
        AtmosphericBlockTagsProvider blockTags = new AtmosphericBlockTagsProvider(output, provider, helper);
        generator.addProvider(server, (DataProvider)blockTags);
        generator.addProvider(server, (DataProvider)new AtmosphericItemTagsProvider(output, provider, blockTags.contentsGetter(), helper));
        generator.addProvider(server, (DataProvider)new AtmosphericEntityTypeTagsProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new AtmosphericBiomeTagsProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new AtmosphericBannerPatternTagsProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new AtmosphericTrimMaterialTagsProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new AtmosphericStructureTagsProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new AtmosphericDamageTypeTagsProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new AtmosphericPaintingVariantTagsProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new AtmosphericLootTableProvider(output, provider));
        generator.addProvider(server, (DataProvider)new AtmosphericRecipeProvider(output, provider));
        generator.addProvider(server, (DataProvider)AtmosphericAdvancementProvider.create(output, provider, helper));
        generator.addProvider(server, (DataProvider)new AtmosphericAdvancementModifierProvider(output, provider));
        generator.addProvider(server, (DataProvider)new AtmosphericDataRemolderProvider(output, provider));
        generator.addProvider(server, (DataProvider)new AtmosphericChunkGeneratorModifierProvider(output, provider));
        generator.addProvider(server, (DataProvider)new AtmosphericDataMapProvider(output, provider));
        boolean client = event.includeClient();
        generator.addProvider(client, (DataProvider)new AtmosphericBlockStateProvider(output, helper));
        generator.addProvider(client, (DataProvider)new AtmosphericItemModelProvider(output, helper));
        generator.addProvider(client, (DataProvider)new AtmosphericSpriteSourceProvider(output, provider, helper));
        generator.addProvider(client, (DataProvider)new GalleryItemModelProvider(MOD_ID, output, helper, provider));
    }

    public static ResourceLocation location(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

