/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.core.data.client;

import com.mojang.datafixers.util.Pair;
import com.teamabnormals.atmospheric.common.block.CandleGateauBlock;
import com.teamabnormals.atmospheric.common.block.DragonRootsBlock;
import com.teamabnormals.atmospheric.common.block.OrangeBlock;
import com.teamabnormals.atmospheric.common.block.state.properties.DragonRootsStage;
import com.teamabnormals.atmospheric.core.Atmospheric;
import com.teamabnormals.atmospheric.core.other.AtmosphericBlockFamilies;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.blueprint.core.data.client.BlueprintBlockStateProvider;
import com.teamabnormals.blueprint.core.data.client.BlueprintItemModelProvider;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;

public class AtmosphericBlockStateProvider
extends BlueprintBlockStateProvider {
    public AtmosphericBlockStateProvider(PackOutput output, ExistingFileHelper helper) {
        super(output, "atmospheric", helper);
    }

    protected void registerStatesAndModels() {
        this.blockFamily(AtmosphericBlockFamilies.DOLERITE_FAMILY);
        this.blockFamily(AtmosphericBlockFamilies.POLISHED_DOLERITE_FAMILY);
        this.blockFamily(AtmosphericBlockFamilies.ROSEWOOD_PLANKS_FAMILY);
        this.logBlocks((DeferredHolder)AtmosphericBlocks.ROSEWOOD_LOG, (DeferredHolder)AtmosphericBlocks.ROSEWOOD);
        this.logBlocks((DeferredHolder)AtmosphericBlocks.STRIPPED_ROSEWOOD_LOG, (DeferredHolder)AtmosphericBlocks.STRIPPED_ROSEWOOD);
        this.leavesBlock((DeferredHolder)AtmosphericBlocks.ROSEWOOD_LEAVES);
        this.crossBlockWithPot((DeferredHolder)AtmosphericBlocks.ROSEWOOD_SAPLING, (DeferredHolder)AtmosphericBlocks.POTTED_ROSEWOOD_SAPLING);
        this.hangingSignBlocks((DeferredHolder)AtmosphericBlocks.STRIPPED_ROSEWOOD_LOG, (DeferredHolder)AtmosphericBlocks.ROSEWOOD_HANGING_SIGNS.getFirst(), (DeferredHolder)AtmosphericBlocks.ROSEWOOD_HANGING_SIGNS.getSecond());
        this.woodworksBlocks((DeferredHolder)AtmosphericBlocks.ROSEWOOD_PLANKS, (DeferredHolder)AtmosphericBlocks.ROSEWOOD_BOARDS, (DeferredHolder)AtmosphericBlocks.ROSEWOOD_LADDER, (DeferredHolder)AtmosphericBlocks.ROSEWOOD_BOOKSHELF, (DeferredHolder)AtmosphericBlocks.ROSEWOOD_BEEHIVE, (DeferredHolder)AtmosphericBlocks.ROSEWOOD_CHEST, (DeferredHolder)AtmosphericBlocks.TRAPPED_ROSEWOOD_CHEST);
        this.chiseledBookshelfBlock((DeferredHolder)AtmosphericBlocks.CHISELED_ROSEWOOD_BOOKSHELF, DEFAULT_BOOKSHELF_POSITIONS);
        this.leafPileBlock((DeferredHolder)AtmosphericBlocks.ROSEWOOD_LEAVES, (DeferredHolder)AtmosphericBlocks.ROSEWOOD_LEAF_PILE);
        this.directionalBlock((DeferredHolder)AtmosphericBlocks.PASSION_FRUIT_CRATE);
        this.directionalBlockSharedBottom((DeferredHolder)AtmosphericBlocks.SHIMMERING_PASSION_FRUIT_CRATE, (DeferredHolder)AtmosphericBlocks.PASSION_FRUIT_CRATE);
        this.blockFamily(AtmosphericBlockFamilies.MORADO_PLANKS_FAMILY);
        this.logBlocks((DeferredHolder)AtmosphericBlocks.MORADO_LOG, (DeferredHolder)AtmosphericBlocks.MORADO_WOOD);
        this.logBlocks((DeferredHolder)AtmosphericBlocks.STRIPPED_MORADO_LOG, (DeferredHolder)AtmosphericBlocks.STRIPPED_MORADO_WOOD);
        this.leavesBlock((DeferredHolder)AtmosphericBlocks.MORADO_LEAVES);
        this.crossBlockWithPot((DeferredHolder)AtmosphericBlocks.MORADO_SAPLING, (DeferredHolder)AtmosphericBlocks.POTTED_MORADO_SAPLING);
        this.hangingSignBlocks((DeferredHolder)AtmosphericBlocks.STRIPPED_MORADO_LOG, (Pair)AtmosphericBlocks.MORADO_HANGING_SIGNS);
        this.woodworksBlocks((DeferredHolder)AtmosphericBlocks.MORADO_PLANKS, (DeferredHolder)AtmosphericBlocks.MORADO_BOARDS, (DeferredHolder)AtmosphericBlocks.MORADO_LADDER, (DeferredHolder)AtmosphericBlocks.MORADO_BOOKSHELF, (DeferredHolder)AtmosphericBlocks.MORADO_BEEHIVE, (DeferredHolder)AtmosphericBlocks.MORADO_CHEST, (DeferredHolder)AtmosphericBlocks.TRAPPED_MORADO_CHEST);
        this.chiseledBookshelfBlock((DeferredHolder)AtmosphericBlocks.CHISELED_MORADO_BOOKSHELF, ALTERNATE_BOOKSHELF_POSITIONS);
        this.leafPileBlock((DeferredHolder)AtmosphericBlocks.MORADO_LEAVES, (DeferredHolder)AtmosphericBlocks.MORADO_LEAF_PILE);
        this.blockFamily(AtmosphericBlockFamilies.YUCCA_PLANKS_FAMILY);
        this.logBlocks((DeferredHolder)AtmosphericBlocks.YUCCA_LOG, (DeferredHolder)AtmosphericBlocks.YUCCA_WOOD);
        this.logBlocks((DeferredHolder)AtmosphericBlocks.STRIPPED_YUCCA_LOG, (DeferredHolder)AtmosphericBlocks.STRIPPED_YUCCA_WOOD);
        this.leavesBlock((DeferredHolder)AtmosphericBlocks.YUCCA_LEAVES);
        this.crossBlockWithPot((DeferredHolder)AtmosphericBlocks.YUCCA_SAPLING, (DeferredHolder)AtmosphericBlocks.POTTED_YUCCA_SAPLING);
        this.hangingSignBlocks((DeferredHolder)AtmosphericBlocks.STRIPPED_YUCCA_LOG, (Pair)AtmosphericBlocks.YUCCA_HANGING_SIGNS);
        this.woodworksBlocks((DeferredHolder)AtmosphericBlocks.YUCCA_PLANKS, (DeferredHolder)AtmosphericBlocks.YUCCA_BOARDS, (DeferredHolder)AtmosphericBlocks.YUCCA_LADDER, (DeferredHolder)AtmosphericBlocks.YUCCA_BOOKSHELF, (DeferredHolder)AtmosphericBlocks.YUCCA_BEEHIVE, (DeferredHolder)AtmosphericBlocks.YUCCA_CHEST, (DeferredHolder)AtmosphericBlocks.TRAPPED_YUCCA_CHEST);
        this.chiseledBookshelfBlock((DeferredHolder)AtmosphericBlocks.CHISELED_YUCCA_BOOKSHELF, DEFAULT_BOOKSHELF_POSITIONS);
        this.leafPileBlock((DeferredHolder)AtmosphericBlocks.YUCCA_LEAVES, (DeferredHolder)AtmosphericBlocks.YUCCA_LEAF_PILE);
        this.directionalBlock((DeferredHolder)AtmosphericBlocks.YUCCA_CASK);
        this.directionalBlockSharedSide((DeferredHolder)AtmosphericBlocks.ROASTED_YUCCA_CASK, (DeferredHolder)AtmosphericBlocks.YUCCA_CASK);
        this.flowerPotBlock(AtmosphericBlocks.POTTED_ALOE_VERA);
        this.brushableBlock((DeferredHolder)AtmosphericBlocks.SUSPICIOUS_ARID_SAND);
        this.brushableBlock((DeferredHolder)AtmosphericBlocks.SUSPICIOUS_RED_ARID_SAND);
        this.blockFamily(AtmosphericBlockFamilies.ASPEN_PLANKS_FAMILY);
        this.logBlocks((DeferredHolder)AtmosphericBlocks.ASPEN_LOG, (DeferredHolder)AtmosphericBlocks.ASPEN_WOOD);
        this.logBlocks((DeferredHolder)AtmosphericBlocks.STRIPPED_ASPEN_LOG, (DeferredHolder)AtmosphericBlocks.STRIPPED_ASPEN_WOOD);
        this.watchfulAspenLogBlocks(AtmosphericBlocks.ASPEN_LOG, AtmosphericBlocks.WATCHFUL_ASPEN_LOG, AtmosphericBlocks.WATCHFUL_ASPEN_WOOD);
        this.leavesBlock((DeferredHolder)AtmosphericBlocks.ASPEN_LEAVES);
        this.crossBlockWithPot((DeferredHolder)AtmosphericBlocks.ASPEN_SAPLING, (DeferredHolder)AtmosphericBlocks.POTTED_ASPEN_SAPLING);
        this.hangingSignBlocks((DeferredHolder)AtmosphericBlocks.STRIPPED_ASPEN_LOG, (Pair)AtmosphericBlocks.ASPEN_HANGING_SIGNS);
        this.woodworksBlocks((DeferredHolder)AtmosphericBlocks.ASPEN_PLANKS, (DeferredHolder)AtmosphericBlocks.ASPEN_BOARDS, (DeferredHolder)AtmosphericBlocks.ASPEN_LADDER, (DeferredHolder)AtmosphericBlocks.ASPEN_BOOKSHELF, (DeferredHolder)AtmosphericBlocks.ASPEN_BEEHIVE, (DeferredHolder)AtmosphericBlocks.ASPEN_CHEST, (DeferredHolder)AtmosphericBlocks.TRAPPED_ASPEN_CHEST);
        this.chiseledBookshelfBlock((DeferredHolder)AtmosphericBlocks.CHISELED_ASPEN_BOOKSHELF, ALTERNATE_BOOKSHELF_POSITIONS);
        this.leafPileBlock((DeferredHolder)AtmosphericBlocks.ASPEN_LEAVES, (DeferredHolder)AtmosphericBlocks.ASPEN_LEAF_PILE);
        this.leavesBlock((DeferredHolder)AtmosphericBlocks.GREEN_ASPEN_LEAVES);
        this.crossBlockWithPot((DeferredHolder)AtmosphericBlocks.GREEN_ASPEN_SAPLING, (DeferredHolder)AtmosphericBlocks.POTTED_GREEN_ASPEN_SAPLING);
        this.leafPileBlock((DeferredHolder)AtmosphericBlocks.GREEN_ASPEN_LEAVES, (DeferredHolder)AtmosphericBlocks.GREEN_ASPEN_LEAF_PILE);
        this.crossBlockWithCustomPot((DeferredHolder)AtmosphericBlocks.AGAVE, (DeferredHolder)AtmosphericBlocks.POTTED_AGAVE);
        this.crossBlockWithCustomPot((DeferredHolder)AtmosphericBlocks.GOLDEN_GROWTHS, (DeferredHolder)AtmosphericBlocks.POTTED_GOLDEN_GROWTHS);
        this.blockFamily(AtmosphericBlockFamilies.LAUREL_PLANKS_FAMILY);
        this.logBlocks((DeferredHolder)AtmosphericBlocks.LAUREL_LOG, (DeferredHolder)AtmosphericBlocks.LAUREL_WOOD);
        this.logBlocks((DeferredHolder)AtmosphericBlocks.STRIPPED_LAUREL_LOG, (DeferredHolder)AtmosphericBlocks.STRIPPED_LAUREL_WOOD);
        this.leavesBlock((DeferredHolder)AtmosphericBlocks.LAUREL_LEAVES);
        this.crossBlockWithPot((DeferredHolder)AtmosphericBlocks.LAUREL_SAPLING, (DeferredHolder)AtmosphericBlocks.POTTED_LAUREL_SAPLING);
        this.hangingSignBlocks((DeferredHolder)AtmosphericBlocks.STRIPPED_LAUREL_LOG, (Pair)AtmosphericBlocks.LAUREL_HANGING_SIGNS);
        this.woodworksBlocks((DeferredHolder)AtmosphericBlocks.LAUREL_PLANKS, (DeferredHolder)AtmosphericBlocks.LAUREL_BOARDS, (DeferredHolder)AtmosphericBlocks.LAUREL_LADDER, (DeferredHolder)AtmosphericBlocks.LAUREL_BOOKSHELF, (DeferredHolder)AtmosphericBlocks.LAUREL_BEEHIVE, (DeferredHolder)AtmosphericBlocks.LAUREL_CHEST, (DeferredHolder)AtmosphericBlocks.TRAPPED_LAUREL_CHEST);
        this.chiseledBookshelfBlock((DeferredHolder)AtmosphericBlocks.CHISELED_LAUREL_BOOKSHELF);
        this.leafPileBlock((DeferredHolder)AtmosphericBlocks.LAUREL_LEAVES, (DeferredHolder)AtmosphericBlocks.LAUREL_LEAF_PILE);
        this.leavesBlock((DeferredHolder)AtmosphericBlocks.DRY_LAUREL_LEAVES);
        this.crossBlockWithPot((DeferredHolder)AtmosphericBlocks.DRY_LAUREL_SAPLING, (DeferredHolder)AtmosphericBlocks.POTTED_DRY_LAUREL_SAPLING);
        this.leafPileBlock((DeferredHolder)AtmosphericBlocks.DRY_LAUREL_LEAVES, (DeferredHolder)AtmosphericBlocks.DRY_LAUREL_LEAF_PILE);
        this.orange(AtmosphericBlocks.ORANGE);
        this.orange(AtmosphericBlocks.BLOOD_ORANGE);
        this.directionalBlock((DeferredHolder)AtmosphericBlocks.ORANGE_CRATE);
        this.directionalBlock((DeferredHolder)AtmosphericBlocks.BLOOD_ORANGE_CRATE);
        this.blockFamily(AtmosphericBlockFamilies.KOUSA_PLANKS_FAMILY);
        this.logBlocks((DeferredHolder)AtmosphericBlocks.KOUSA_LOG, (DeferredHolder)AtmosphericBlocks.KOUSA_WOOD);
        this.logBlocks((DeferredHolder)AtmosphericBlocks.STRIPPED_KOUSA_LOG, (DeferredHolder)AtmosphericBlocks.STRIPPED_KOUSA_WOOD);
        this.leavesBlock((DeferredHolder)AtmosphericBlocks.KOUSA_LEAVES);
        this.crossBlockWithPot((DeferredHolder)AtmosphericBlocks.KOUSA_SAPLING, (DeferredHolder)AtmosphericBlocks.POTTED_KOUSA_SAPLING);
        this.hangingSignBlocks((DeferredHolder)AtmosphericBlocks.STRIPPED_KOUSA_LOG, (Pair)AtmosphericBlocks.KOUSA_HANGING_SIGNS);
        this.woodworksBlocks((DeferredHolder)AtmosphericBlocks.KOUSA_PLANKS, (DeferredHolder)AtmosphericBlocks.KOUSA_BOARDS, (DeferredHolder)AtmosphericBlocks.KOUSA_LADDER, (DeferredHolder)AtmosphericBlocks.KOUSA_BOOKSHELF, (DeferredHolder)AtmosphericBlocks.KOUSA_BEEHIVE, (DeferredHolder)AtmosphericBlocks.KOUSA_CHEST, (DeferredHolder)AtmosphericBlocks.TRAPPED_KOUSA_CHEST);
        this.chiseledBookshelfBlock((DeferredHolder)AtmosphericBlocks.CHISELED_KOUSA_BOOKSHELF, DEFAULT_BOOKSHELF_POSITIONS);
        this.leafPileBlock((DeferredHolder)AtmosphericBlocks.KOUSA_LEAVES, (DeferredHolder)AtmosphericBlocks.KOUSA_LEAF_PILE);
        this.crossBlock((DeferredHolder)AtmosphericBlocks.HANGING_CURRANT);
        this.logBlock((DeferredHolder)AtmosphericBlocks.CURRANT_STALK_BUNDLE);
        this.leavesBlock((DeferredHolder)AtmosphericBlocks.CURRANT_LEAVES);
        this.crossBlockWithPot((DeferredHolder)AtmosphericBlocks.CURRANT_SEEDLING, (DeferredHolder)AtmosphericBlocks.POTTED_CURRANT_SEEDLING);
        this.leafPileBlock((DeferredHolder)AtmosphericBlocks.CURRANT_LEAVES, (DeferredHolder)AtmosphericBlocks.CURRANT_LEAF_PILE);
        this.directionalBlock((DeferredHolder)AtmosphericBlocks.CURRANT_CRATE);
        this.blockFamily(AtmosphericBlockFamilies.GRIMWOOD_PLANKS_FAMILY);
        this.logBlocks((DeferredHolder)AtmosphericBlocks.GRIMWOOD_LOG, (DeferredHolder)AtmosphericBlocks.GRIMWOOD);
        this.logBlocks((DeferredHolder)AtmosphericBlocks.STRIPPED_GRIMWOOD_LOG, (DeferredHolder)AtmosphericBlocks.STRIPPED_GRIMWOOD);
        this.leavesBlock((DeferredHolder)AtmosphericBlocks.GRIMWOOD_LEAVES);
        this.crossBlockWithPot((DeferredHolder)AtmosphericBlocks.GRIMWOOD_SAPLING, (DeferredHolder)AtmosphericBlocks.POTTED_GRIMWOOD_SAPLING);
        this.hangingSignBlocks((DeferredHolder)AtmosphericBlocks.STRIPPED_GRIMWOOD_LOG, (Pair)AtmosphericBlocks.GRIMWOOD_HANGING_SIGNS);
        this.woodworksBlocks((DeferredHolder)AtmosphericBlocks.GRIMWOOD_PLANKS, (DeferredHolder)AtmosphericBlocks.GRIMWOOD_BOARDS, (DeferredHolder)AtmosphericBlocks.GRIMWOOD_LADDER, (DeferredHolder)AtmosphericBlocks.GRIMWOOD_BOOKSHELF, (DeferredHolder)AtmosphericBlocks.GRIMWOOD_BEEHIVE, (DeferredHolder)AtmosphericBlocks.GRIMWOOD_CHEST, (DeferredHolder)AtmosphericBlocks.TRAPPED_GRIMWOOD_CHEST);
        this.chiseledBookshelfBlock((DeferredHolder)AtmosphericBlocks.CHISELED_GRIMWOOD_BOOKSHELF, ALTERNATE_BOOKSHELF_POSITIONS);
        this.leafPileBlock((DeferredHolder)AtmosphericBlocks.GRIMWOOD_LEAVES, (DeferredHolder)AtmosphericBlocks.GRIMWOOD_LEAF_PILE);
        this.crossBlock((DeferredHolder)AtmosphericBlocks.GRIMWEB);
        this.directionalBlock((DeferredHolder)AtmosphericBlocks.CARMINE_BLOCK);
        this.blockFamily(AtmosphericBlockFamilies.CARMINE_SHINGLES_FAMILY);
        this.block((Block)AtmosphericBlocks.CHISELED_CARMINE_SHINGLES.get());
        this.blockFamily(AtmosphericBlockFamilies.CARMINE_PAVEMENT_FAMILY);
        this.crossBlockWithPot((DeferredHolder)AtmosphericBlocks.FIRETHORN, (DeferredHolder)AtmosphericBlocks.POTTED_FIRETHORN);
        this.crossBlockWithPot((DeferredHolder)AtmosphericBlocks.FORSYTHIA, (DeferredHolder)AtmosphericBlocks.POTTED_FORSYTHIA);
        this.directionalBlock((DeferredHolder)AtmosphericBlocks.DRAGON_FRUIT_CRATE);
        this.directionalBlockSharedSide((DeferredHolder)AtmosphericBlocks.GOLDEN_DRAGON_FRUIT_CRATE, (DeferredHolder)AtmosphericBlocks.DRAGON_FRUIT_CRATE);
        this.dragonRoots(AtmosphericBlocks.DRAGON_ROOTS);
        this.block((DeferredHolder)AtmosphericBlocks.ARID_GLASS);
        this.glassPaneBlock(AtmosphericBlocks.ARID_GLASS_PANE, AtmosphericBlocks.ARID_GLASS);
        CandleGateauBlock.getCandleGateaus().forEach(this::candleCake);
    }

    public void watchfulAspenLogBlocks(DeferredBlock<Block> aspenLog, DeferredBlock<Block> log, DeferredBlock<Block> wood) {
        this.logBlock((DeferredHolder)log, this.blockTexture((Block)log.get()), AtmosphericBlockStateProvider.suffix((ResourceLocation)this.blockTexture((Block)aspenLog.get()), (String)"_top"));
        this.woodBlock((DeferredHolder)wood, (DeferredHolder)log);
    }

    public void orange(DeferredBlock<Block> block) {
        this.getVariantBuilder((Block)block.get()).forAllStatesExcept(state -> {
            boolean horizontal = Direction.Plane.HORIZONTAL.test((Direction)state.getValue((Property)BlockStateProperties.FACING));
            String addition = ((Integer)state.getValue((Property)OrangeBlock.ORANGES) == 2 ? "_double" : "") + (horizontal ? "_wall" : (state.getValue((Property)OrangeBlock.FACING) == Direction.DOWN ? "_ceiling" : ""));
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(AtmosphericBlockStateProvider.name((Block)((Block)block.get())) + addition)).parent((ModelFile)new ModelFile.UncheckedModelFile(Atmospheric.location("block/template_orange" + addition)))).texture("orange", this.blockTexture((Block)block.get()))).rotationY(horizontal ? (int)((((Direction)state.getValue((Property)BlockStateProperties.FACING)).toYRot() + 180.0f) % 360.0f) : 0).build();
        }, new Property[]{BlockStateProperties.WATERLOGGED});
    }

    public void dragonRoots(DeferredBlock<Block> block) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)block.get());
        DragonRootsBlock.FACING.getPossibleValues().forEach(dir -> {
            int yRot = ((int)dir.toYRot() + 180) % 360;
            for (DragonRootsStage stage : DragonRootsStage.values()) {
                if (stage == DragonRootsStage.NONE) continue;
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)new ModelFile.UncheckedModelFile(Atmospheric.location("block/dragon_roots_top"))).rotationY(yRot).addModel()).condition(DragonRootsBlock.TOP_STAGE, (Comparable[])new DragonRootsStage[]{stage}).condition((Property)DragonRootsBlock.FACING, (Comparable[])new Direction[]{dir});
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)new ModelFile.UncheckedModelFile(Atmospheric.location("block/dragon_roots_bottom"))).rotationY(yRot).addModel()).condition(DragonRootsBlock.BOTTOM_STAGE, (Comparable[])new DragonRootsStage[]{stage}).condition((Property)DragonRootsBlock.FACING, (Comparable[])new Direction[]{dir});
                if (stage == DragonRootsStage.ROOTS) continue;
                boolean flowering = stage == DragonRootsStage.FLOWERING || stage == DragonRootsStage.FLOWERING_ENDER;
                boolean ender = stage == DragonRootsStage.ENDER || stage == DragonRootsStage.FLOWERING_ENDER;
                String name = (flowering ? "flowering_" : "") + (ender ? "ender_" : "") + "dragon_fruit";
                String texture = Atmospheric.location("block/" + name).toString();
                String parent = "block/template_" + (flowering ? "flowering_" : "") + "dragon_fruit";
                ModelBuilder top = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(String.valueOf(Atmospheric.location(name)) + "_top")).parent((ModelFile)new ModelFile.UncheckedModelFile(Atmospheric.location(parent + "_top")))).texture("fruit", texture);
                ModelBuilder bottom = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(String.valueOf(Atmospheric.location(name)) + "_bottom")).parent((ModelFile)new ModelFile.UncheckedModelFile(Atmospheric.location(parent + "_bottom")))).texture("fruit", texture);
                if (flowering) {
                    ResourceLocation emissiveTexture = Atmospheric.location("block/flowering_dragon_fruit_emissive");
                    top = top.texture("overlay", emissiveTexture).renderType("translucent");
                    bottom = bottom.texture("overlay", emissiveTexture).renderType("translucent");
                }
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)top).rotationY(yRot).addModel()).condition(DragonRootsBlock.TOP_STAGE, (Comparable[])new DragonRootsStage[]{stage}).condition((Property)DragonRootsBlock.FACING, (Comparable[])new Direction[]{dir});
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)bottom).rotationY(yRot).addModel()).condition(DragonRootsBlock.BOTTOM_STAGE, (Comparable[])new DragonRootsStage[]{stage}).condition((Property)DragonRootsBlock.FACING, (Comparable[])new Direction[]{dir});
            }
        });
    }

    public void glassPaneBlock(DeferredBlock<Block> pane, DeferredBlock<Block> glass) {
        Block block = (Block)pane.get();
        String name = AtmosphericBlockStateProvider.name((Block)block);
        ResourceLocation texture = this.blockTexture((Block)glass.get());
        ResourceLocation edgeTexture = texture.withSuffix("_pane_top");
        ModelBuilder post = ((BlockModelBuilder)this.glassPaneBlock(name, "post").texture("pane", texture)).texture("edge", edgeTexture);
        ModelBuilder side = ((BlockModelBuilder)this.glassPaneBlock(name, "side").texture("pane", texture)).texture("edge", edgeTexture);
        ModelBuilder sideAlt = ((BlockModelBuilder)this.glassPaneBlock(name, "side_alt").texture("pane", texture)).texture("edge", edgeTexture);
        ModelBuilder noSide = this.glassPaneBlock(name, "noside").texture("pane", texture);
        ModelBuilder noSideAlt = this.glassPaneBlock(name, "noside_alt").texture("pane", texture);
        this.glassPaneBlock(block, (ModelFile)post, (ModelFile)side, (ModelFile)sideAlt, (ModelFile)noSide, (ModelFile)noSideAlt);
        this.generatedItem((ItemLike)block, AtmosphericBlockStateProvider.prefix((String)"block/", (ResourceLocation)BlueprintItemModelProvider.key((ItemLike)((ItemLike)glass.get()))));
    }

    public void glassPaneBlock(Block block, ModelFile post, ModelFile side, ModelFile sideAlt, ModelFile noSide, ModelFile noSideAlt) {
        MultiPartBlockStateBuilder builder = ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(block).part().modelFile(post).addModel()).end();
        PipeBlock.PROPERTY_BY_DIRECTION.forEach((dir, value) -> {
            if (dir.getAxis().isHorizontal()) {
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(dir == Direction.SOUTH || dir == Direction.WEST ? sideAlt : side).rotationY(dir.getAxis() == Direction.Axis.X ? 90 : 0).addModel()).condition((Property)value, (Comparable[])new Boolean[]{true}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(dir == Direction.SOUTH || dir == Direction.EAST ? noSideAlt : noSide).rotationY(dir == Direction.WEST ? 270 : (dir == Direction.SOUTH ? 90 : 0)).addModel()).condition((Property)value, (Comparable[])new Boolean[]{false}).end();
            }
        });
    }

    public BlockModelBuilder glassPaneBlock(String name, String suffix) {
        return (BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(name + "_" + suffix)).parent((ModelFile)new ModelFile.UncheckedModelFile(ResourceLocation.withDefaultNamespace((String)("block/template_glass_pane_" + suffix))));
    }

    public void slabBlock(Block block, Block slab) {
        SlabBlock slabBlock;
        if (slab instanceof SlabBlock && (slabBlock = (SlabBlock)slab) == AtmosphericBlocks.POLISHED_DOLERITE_SLAB.get()) {
            ResourceLocation side = this.blockTexture(slab);
            ResourceLocation full = this.blockTexture(block);
            this.slabBlock(slabBlock, (ModelFile)this.models().slab(AtmosphericBlockStateProvider.name((Block)slab), side, full, full), (ModelFile)this.models().slabTop(AtmosphericBlockStateProvider.name((Block)slab) + "_top", side, full, full), (ModelFile)this.models().cubeColumn(AtmosphericBlockStateProvider.name((Block)slab) + "_double", side, full));
            this.blockItem(slab);
        } else {
            super.slabBlock(block, slab);
        }
    }

    public void candleCake(CandleGateauBlock block) {
        Block candle = block.getCandle();
        ModelBuilder candleCake = ((BlockModelBuilder)this.models().withExistingParent(AtmosphericBlockStateProvider.name((Block)block), "atmospheric:block/template_yucca_gateau_with_candle")).texture("candle", this.blockTexture(candle));
        ModelBuilder candleCakeLit = ((BlockModelBuilder)this.models().withExistingParent(AtmosphericBlockStateProvider.name((Block)block) + "_lit", "atmospheric:block/template_yucca_gateau_with_candle")).texture("candle", AtmosphericBlockStateProvider.suffix((ResourceLocation)this.blockTexture(candle), (String)"_lit"));
        this.candleCakeBlock((Block)block, arg_0 -> AtmosphericBlockStateProvider.lambda$candleCake$3((ModelFile)candleCakeLit, (ModelFile)candleCake, arg_0));
    }

    public void candleCakeBlock(Block block, Function<BlockState, ModelFile> modelFunc) {
        this.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationY((int)((((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot() + 180.0f) % 360.0f)).build());
    }

    public void flowerPotBlock(DeferredBlock<Block> flowerPot, ResourceLocation potTexture) {
        this.simpleBlock((Block)flowerPot.get(), (ModelFile)this.models().singleTexture(AtmosphericBlockStateProvider.name((Block)((Block)flowerPot.get())), ResourceLocation.withDefaultNamespace((String)"block/flower_pot_cross"), "plant", potTexture));
    }

    public void flowerPotBlock(DeferredBlock<Block> flowerPot) {
        this.flowerPotBlock(flowerPot, this.blockTexture((Block)flowerPot.get()));
    }

    private static /* synthetic */ ModelFile lambda$candleCake$3(ModelFile candleCakeLit, ModelFile candleCake, BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.LIT) != false ? candleCakeLit : candleCake;
    }
}

