/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.core.data.server;

import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.atmospheric.core.registry.AtmosphericCriteriaTriggers;
import com.teamabnormals.atmospheric.core.registry.AtmosphericEntityTypes;
import com.teamabnormals.atmospheric.core.registry.AtmosphericItems;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.critereon.ConsumeItemTrigger;
import net.minecraft.advancements.critereon.DamagePredicate;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.advancements.critereon.PlayerHurtEntityTrigger;
import net.minecraft.advancements.critereon.TagPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class AtmosphericAdvancementProvider
implements AdvancementProvider.AdvancementGenerator {
    public static AdvancementProvider create(PackOutput output, CompletableFuture<HolderLookup.Provider> provider, ExistingFileHelper helper) {
        return new AdvancementProvider(output, provider, helper, List.of(new AtmosphericAdvancementProvider()));
    }

    public void generate(HolderLookup.Provider provider, Consumer<AdvancementHolder> consumer, ExistingFileHelper helper) {
        AdvancementHolder dunesPricks = AtmosphericAdvancementProvider.createAdvancement("dunes_pricks", "adventure", ResourceLocation.withDefaultNamespace((String)"adventure/root"), (ItemLike)AtmosphericBlocks.YUCCA_FLOWER.get(), AdvancementType.TASK, true, true, false).addCriterion("yucca_flower", AtmosphericCriteriaTriggers.yuccaPrick()).addCriterion("aloe_vera", AtmosphericCriteriaTriggers.aloeVeraPrick()).addCriterion("barrel_cactus", AtmosphericCriteriaTriggers.barrelCactusPrick()).save(consumer, "atmospheric:adventure/dunes_pricks");
        AtmosphericAdvancementProvider.createAdvancement("loot_arid_garden", "adventure", dunesPricks, (ItemLike)AtmosphericBlocks.BARREL_CACTUS.get(), AdvancementType.TASK, true, true, false).addCriterion("loot_arid_garden", AtmosphericCriteriaTriggers.lootAridGarden()).save(consumer, "atmospheric:adventure/loot_arid_garden");
        AdvancementHolder spitPassionFruit = AtmosphericAdvancementProvider.createAdvancement("spit_passion_fruit", "husbandry", ResourceLocation.withDefaultNamespace((String)"husbandry/root"), (ItemLike)AtmosphericItems.PASSION_FRUIT.get(), AdvancementType.TASK, true, true, false).addCriterion("spit_passion_fruit", PlayerHurtEntityTrigger.TriggerInstance.playerHurtEntityWithDamage((DamagePredicate.Builder)DamagePredicate.Builder.damageInstance().type(DamageSourcePredicate.Builder.damageType().tag(TagPredicate.is((TagKey)DamageTypeTags.IS_PROJECTILE)).direct(EntityPredicate.Builder.entity().of((EntityType)AtmosphericEntityTypes.PASSION_FRUIT_SEED.get()))))).save(consumer, "atmospheric:husbandry/spit_passion_fruit");
        AtmosphericAdvancementProvider.createAdvancement("kill_mob_with_passion_fruit", "husbandry", spitPassionFruit, (ItemLike)AtmosphericItems.SHIMMERING_PASSION_FRUIT.get(), AdvancementType.TASK, true, true, false).addCriterion("kill_mob_with_passion_fruit", KilledTrigger.TriggerInstance.playerKilledEntity(Optional.empty(), (DamageSourcePredicate.Builder)DamageSourcePredicate.Builder.damageType().tag(TagPredicate.is((TagKey)DamageTypeTags.IS_PROJECTILE)).direct(EntityPredicate.Builder.entity().of((EntityType)AtmosphericEntityTypes.PASSION_FRUIT_SEED.get())))).save(consumer, "atmospheric:husbandry/kill_mob_with_passion_fruit");
        AdvancementHolder findOrange = AtmosphericAdvancementProvider.createAdvancement("find_orange", "husbandry", ResourceLocation.withDefaultNamespace((String)"husbandry/root"), (ItemLike)AtmosphericItems.ORANGE.get(), AdvancementType.TASK, true, true, false).addCriterion("find_orange", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AtmosphericItems.ORANGE.get()})).save(consumer, "atmospheric:husbandry/find_orange");
        AtmosphericAdvancementProvider.createAdvancement("obtain_blood_orange", "husbandry", findOrange, (ItemLike)AtmosphericItems.BLOOD_ORANGE.get(), AdvancementType.TASK, true, true, false).addCriterion("obtain_blood_orange", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AtmosphericItems.BLOOD_ORANGE.get()})).save(consumer, "atmospheric:husbandry/obtain_blood_orange");
        AdvancementHolder persistenceWhileStarving = AtmosphericAdvancementProvider.createAdvancement("persistence_while_starving", "husbandry", ResourceLocation.withDefaultNamespace((String)"husbandry/root"), (ItemLike)AtmosphericItems.ROASTED_YUCCA_FRUIT.get(), AdvancementType.TASK, true, true, false).addCriterion("persistence_while_starving", AtmosphericCriteriaTriggers.persistenceWhileStarving()).save(consumer, "atmospheric:husbandry/persistence_while_starving");
        AtmosphericAdvancementProvider.createAdvancement("finish_gateau", "husbandry", persistenceWhileStarving, (ItemLike)AtmosphericBlocks.YUCCA_GATEAU.get(), AdvancementType.TASK, true, true, false).addCriterion("finish_gateau", AtmosphericCriteriaTriggers.finishGateau()).save(consumer, "atmospheric:husbandry/finish_gateau");
        AtmosphericAdvancementProvider.createAdvancement("put_out_fire", "husbandry", ResourceLocation.withDefaultNamespace((String)"husbandry/root"), (ItemLike)AtmosphericItems.ALOE_LEAVES.get(), AdvancementType.TASK, true, true, false).addCriterion("put_out_fire", AtmosphericCriteriaTriggers.putOutFire()).save(consumer, "atmospheric:husbandry/put_out_fire");
        AtmosphericAdvancementProvider.createAdvancement("forbidden_fruit", "end", ResourceLocation.withDefaultNamespace((String)"end/root"), (ItemLike)AtmosphericItems.ENDER_DRAGON_FRUIT.get(), AdvancementType.GOAL, true, true, true).addCriterion("forbidden_fruit", ConsumeItemTrigger.TriggerInstance.usedItem((ItemLike)((ItemLike)AtmosphericItems.ENDER_DRAGON_FRUIT.get()))).save(consumer, "atmospheric:end/forbidden_fruit");
    }

    private static Advancement.Builder createAdvancement(String name, String category, AdvancementHolder parent, ItemLike icon, AdvancementType frame, boolean showToast, boolean announceToChat, boolean hidden) {
        return Advancement.Builder.advancement().parent(parent).display(icon, (Component)Component.translatable((String)("advancements.atmospheric." + category + "." + name + ".title")), (Component)Component.translatable((String)("advancements.atmospheric." + category + "." + name + ".description")), null, frame, showToast, announceToChat, hidden);
    }

    private static Advancement.Builder createAdvancement(String name, String category, ResourceLocation parent, ItemLike icon, AdvancementType frame, boolean showToast, boolean announceToChat, boolean hidden) {
        return AtmosphericAdvancementProvider.createAdvancement(name, category, Advancement.Builder.advancement().build(parent), icon, frame, showToast, announceToChat, hidden);
    }
}

