/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.core.data.server;

import com.google.common.collect.ImmutableList;
import com.teamabnormals.atmospheric.common.block.AloeVeraBlock;
import com.teamabnormals.atmospheric.common.block.AloeVeraTallBlock;
import com.teamabnormals.atmospheric.common.block.BarrelCactusBlock;
import com.teamabnormals.atmospheric.common.block.CandleGateauBlock;
import com.teamabnormals.atmospheric.common.block.DragonRootsBlock;
import com.teamabnormals.atmospheric.common.block.OrangeBlock;
import com.teamabnormals.atmospheric.common.block.state.properties.DragonRootsStage;
import com.teamabnormals.atmospheric.core.other.AtmosphericLootTables;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.atmospheric.core.registry.AtmosphericEntityTypes;
import com.teamabnormals.atmospheric.core.registry.AtmosphericItems;
import com.teamabnormals.atmospheric.core.registry.AtmosphericMobEffects;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.EnchantWithLevelsFunction;
import net.minecraft.world.level.storage.loot.functions.EnchantedCountIncreaseFunction;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LimitCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetPotionFunction;
import net.minecraft.world.level.storage.loot.functions.SetStewEffectFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.InvertedLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.registries.DeferredBlock;

public class AtmosphericLootTableProvider
extends LootTableProvider {
    public AtmosphericLootTableProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
        super(output, BuiltInLootTables.all(), (List)ImmutableList.of((Object)new LootTableProvider.SubProviderEntry(AtmosphericBlockLoot::new, LootContextParamSets.BLOCK), (Object)new LootTableProvider.SubProviderEntry(AtmosphericEntityLoot::new, LootContextParamSets.ENTITY), (Object)new LootTableProvider.SubProviderEntry(AtmosphericChestLoot::new, LootContextParamSets.CHEST), (Object)new LootTableProvider.SubProviderEntry(AtmosphericArchaeologyLoot::new, LootContextParamSets.ARCHAEOLOGY)), provider);
    }

    protected void validate(WritableRegistry<LootTable> registry, ValidationContext context, ProblemReporter.Collector collector) {
    }

    public record AtmosphericArchaeologyLoot(HolderLookup.Provider registries) implements LootTableSubProvider
    {
        public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
            consumer.accept(AtmosphericLootTables.ARID_GARDEN_ARCHAEOLOGY_COMMON, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)AtmosphericItems.CARMINE_HUSK.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)AtmosphericItems.ROASTED_YUCCA_FRUIT.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)AtmosphericItems.ALOE_KERNELS.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)AtmosphericItems.ALOE_GEL_BOTTLE.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.FLOWER_POT)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BRICK)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.DEAD_BUSH)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BONE_MEAL)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.COMPOSTER))));
            consumer.accept(AtmosphericLootTables.ARID_GARDEN_ARCHAEOLOGY_RARE, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)AtmosphericItems.SCYTHE_POTTERY_SHERD.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)AtmosphericItems.SUCCULENT_POTTERY_SHERD.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)AtmosphericItems.SUN_POTTERY_SHERD.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)AtmosphericItems.PETRIFIED_ARMOR_TRIM_SMITHING_TEMPLATE.get())))));
        }
    }

    private record AtmosphericChestLoot(HolderLookup.Provider registries) implements LootTableSubProvider
    {
        public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
            consumer.accept(AtmosphericLootTables.ARID_GARDEN, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)AtmosphericBlocks.GRIMWOOD_SAPLING.get())))).withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)AtmosphericItems.GOLDEN_DRAGON_FRUIT.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.IRON_HOE).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f))).apply((LootItemFunction.Builder)EnchantWithLevelsFunction.enchantWithLevels((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)20.0f, (float)39.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.POTION).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))).apply((LootItemFunction.Builder)SetPotionFunction.setPotion(AtmosphericMobEffects.RELIEF_LONG)))).withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)3.0f, (float)6.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.IRON_HOE).setWeight(5).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.FLOWER_POT).setWeight(5).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.HONEY_BOTTLE).setWeight(5).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BRICK).setWeight(5).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)6.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.STICK).setWeight(5).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)3.0f, (float)8.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)AtmosphericBlocks.YUCCA_GATEAU.get())).setWeight(5).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)AtmosphericBlocks.YUCCA_BRANCH.get())).setWeight(5).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)AtmosphericBlocks.YUCCA_SAPLING.get())).setWeight(5).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)AtmosphericBlocks.GILIA.get())).setWeight(5).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)AtmosphericItems.ALOE_LEAVES.get())).setWeight(5).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)AtmosphericItems.ALOE_KERNELS.get())).setWeight(5).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)AtmosphericItems.ROASTED_YUCCA_FRUIT.get())).setWeight(5).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)AtmosphericBlocks.BARREL_CACTUS.get())).setWeight(5).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)6.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)AtmosphericBlocks.AGAVE.get())).setWeight(5).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)6.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)AtmosphericBlocks.YUCCA_FLOWER.get())).setWeight(5).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)6.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)AtmosphericItems.YELLOW_BLOSSOMS.get())).setWeight(5).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)3.0f, (float)8.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)AtmosphericItems.YUCCA_FRUIT.get())).setWeight(5).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)3.0f, (float)8.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SUSPICIOUS_STEW).setWeight(5).apply((LootItemFunction.Builder)SetStewEffectFunction.stewEffect().withEffect(AtmosphericMobEffects.RELIEF, (NumberProvider)UniformGenerator.between((float)7.0f, (float)10.0f)).withEffect(AtmosphericMobEffects.WORSENING, (NumberProvider)UniformGenerator.between((float)5.0f, (float)7.0f)).withEffect(AtmosphericMobEffects.PERSISTENCE, (NumberProvider)UniformGenerator.between((float)7.0f, (float)10.0f)).withEffect(MobEffects.POISON, (NumberProvider)UniformGenerator.between((float)10.0f, (float)20.0f)).withEffect(MobEffects.SATURATION, (NumberProvider)UniformGenerator.between((float)7.0f, (float)10.0f)).withEffect(MobEffects.WEAKNESS, (NumberProvider)UniformGenerator.between((float)6.0f, (float)8.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(2)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)AtmosphericItems.DRUID_ARMOR_TRIM_SMITHING_TEMPLATE.get())).setWeight(1).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f))))));
            consumer.accept(AtmosphericLootTables.KOUSA_SANCTUM_FIRE, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.FLINT_AND_STEEL))));
            consumer.accept(AtmosphericLootTables.KOUSA_SANCTUM_TRAP, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SPLASH_POTION)).apply((LootItemFunction.Builder)SetPotionFunction.setPotion((Holder)Potions.HARMING))));
            consumer.accept(AtmosphericLootTables.KOUSA_SANCTUM, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)3.0f, (float)5.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.DIAMOND).setWeight(3).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.IRON_INGOT).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)5.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GOLD_INGOT).setWeight(15).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)7.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Blocks.BAMBOO).setWeight(15).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.EMERALD).setWeight(2).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BONE).setWeight(20).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)4.0f, (float)6.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)AtmosphericItems.CURRANT.get())).setWeight(16).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)3.0f, (float)7.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SADDLE).setWeight(3)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.IRON_HORSE_ARMOR)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GOLDEN_HORSE_ARMOR)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.DIAMOND_HORSE_ARMOR)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BOOK).apply((LootItemFunction.Builder)EnchantWithLevelsFunction.enchantWithLevels((HolderLookup.Provider)this.registries, (NumberProvider)ConstantValue.exactly((float)30.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SHEARS))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(2)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)AtmosphericItems.APOSTLE_ARMOR_TRIM_SMITHING_TEMPLATE.get())).setWeight(1).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f))))));
            consumer.accept(AtmosphericLootTables.VILLAGE_SCRUBLAND_HOUSE, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)3.0f, (float)8.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)AtmosphericBlocks.FIRETHORN.get())).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)AtmosphericBlocks.FORSYTHIA.get())).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)AtmosphericBlocks.DRY_LAUREL_SAPLING.get())).setWeight(5).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)AtmosphericBlocks.MORADO_SAPLING.get())).setWeight(5).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)AtmosphericBlocks.BARREL_CACTUS.get())).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CARROT).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)7.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BREAD).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)AtmosphericItems.CARMINE_HUSK.get())).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)5.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.REDSTONE).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.EMERALD).setWeight(1).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f))))));
            consumer.accept(AtmosphericLootTables.VILLAGE_COCHINEAL_FARM_DROPPER, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)3.0f, (float)4.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)AtmosphericItems.DRAGON_FRUIT.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))))));
        }
    }

    private static class AtmosphericEntityLoot
    extends EntityLootSubProvider {
        protected AtmosphericEntityLoot(HolderLookup.Provider provider) {
            super(FeatureFlags.REGISTRY.allFlags(), provider);
        }

        public void generate() {
            this.add((EntityType)AtmosphericEntityTypes.TETRA.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.TROPICAL_FISH).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BONE_MEAL)).when(LootItemRandomChanceCondition.randomChance((float)0.05f))));
            this.add((EntityType)AtmosphericEntityTypes.COCHINEAL.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)AtmosphericItems.CARMINE_HUSK.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)4.0f, (float)7.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))));
        }

        public Stream<EntityType<?>> getKnownEntityTypes() {
            return BuiltInRegistries.ENTITY_TYPE.stream().filter(entity -> BuiltInRegistries.ENTITY_TYPE.getKey(entity).getNamespace().equals("atmospheric"));
        }
    }

    private static class AtmosphericBlockLoot
    extends BlockLootSubProvider {
        private static final Set<Item> EXPLOSION_RESISTANT = Stream.of(Blocks.DRAGON_EGG, Blocks.BEACON, Blocks.CONDUIT, Blocks.SKELETON_SKULL, Blocks.WITHER_SKELETON_SKULL, Blocks.PLAYER_HEAD, Blocks.ZOMBIE_HEAD, Blocks.CREEPER_HEAD, Blocks.DRAGON_HEAD, Blocks.PIGLIN_HEAD, Blocks.SHULKER_BOX, Blocks.BLACK_SHULKER_BOX, Blocks.BLUE_SHULKER_BOX, Blocks.BROWN_SHULKER_BOX, Blocks.CYAN_SHULKER_BOX, Blocks.GRAY_SHULKER_BOX, Blocks.GREEN_SHULKER_BOX, Blocks.LIGHT_BLUE_SHULKER_BOX, Blocks.LIGHT_GRAY_SHULKER_BOX, Blocks.LIME_SHULKER_BOX, Blocks.MAGENTA_SHULKER_BOX, Blocks.ORANGE_SHULKER_BOX, Blocks.PINK_SHULKER_BOX, Blocks.PURPLE_SHULKER_BOX, Blocks.RED_SHULKER_BOX, Blocks.WHITE_SHULKER_BOX, Blocks.YELLOW_SHULKER_BOX).map(ItemLike::asItem).collect(Collectors.toSet());
        private static final LootItemCondition.Builder HAS_SHEARS = MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(Tags.Items.TOOLS_SHEAR));
        private static final float[] GRIMWOOD_LEAVES_SAPLING_CHANCES = new float[]{0.075f, 0.09375f, 0.125f, 0.15f};
        private static final float[] NORMAL_LEAVES_SAPLING_CHANCES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};
        private static final float[] CURRANT_LEAVES_STALK_CHANCES = new float[]{0.04f, 0.044444446f, 0.05f, 0.06666667f, 0.2f};

        protected LootItemCondition.Builder doesNotHaveSilkTouch() {
            return this.hasSilkTouch().invert();
        }

        private LootItemCondition.Builder hasShearsOrSilkTouch() {
            return HAS_SHEARS.or(this.hasSilkTouch());
        }

        private LootItemCondition.Builder doesNotHaveShearsOrSilkTouch() {
            return this.hasShearsOrSilkTouch().invert();
        }

        protected AtmosphericBlockLoot(HolderLookup.Provider provider) {
            super(EXPLOSION_RESISTANT, FeatureFlags.REGISTRY.allFlags(), provider);
        }

        public void generate() {
            HolderLookup.RegistryLookup enchantments = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
            Holder.Reference fortune = enchantments.getOrThrow(Enchantments.FORTUNE);
            this.dropSelf((Block)AtmosphericBlocks.WARM_MONKEY_BRUSH.get());
            this.dropPottedContents((Block)AtmosphericBlocks.POTTED_WARM_MONKEY_BRUSH.get());
            this.dropSelf((Block)AtmosphericBlocks.HOT_MONKEY_BRUSH.get());
            this.dropPottedContents((Block)AtmosphericBlocks.POTTED_HOT_MONKEY_BRUSH.get());
            this.dropSelf((Block)AtmosphericBlocks.SCALDING_MONKEY_BRUSH.get());
            this.dropPottedContents((Block)AtmosphericBlocks.POTTED_SCALDING_MONKEY_BRUSH.get());
            this.add((Block)AtmosphericBlocks.PASSION_VINE.get(), block -> (LootTable.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootTable.lootTable().withPool(LootPool.lootPool().when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)AtmosphericBlocks.PASSION_VINE.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)AloeVeraBlock.AGE, 4))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)AtmosphericItems.PASSION_FRUIT.get()))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)AtmosphericBlocks.PASSION_VINE.get()))))));
            this.add((Block)AtmosphericBlocks.PASSION_VINE_BUNDLE.get(), block -> LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(this.hasShearsOrSilkTouch()).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block))));
            this.add((Block)AtmosphericBlocks.WATER_HYACINTH.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER));
            this.dropPottedContents((Block)AtmosphericBlocks.POTTED_WATER_HYACINTH.get());
            this.dropSelf((Block)AtmosphericBlocks.PASSION_FRUIT_CRATE.get());
            this.dropSelf((Block)AtmosphericBlocks.SHIMMERING_PASSION_FRUIT_CRATE.get());
            this.add((Block)AtmosphericBlocks.ARID_SPROUTS.get(), x$0 -> BlockLootSubProvider.createShearsOnlyDrop((ItemLike)x$0));
            this.add((Block)AtmosphericBlocks.ALOE_VERA.get(), arg_0 -> this.lambda$generate$4((Holder)fortune, arg_0));
            this.add((Block)AtmosphericBlocks.TALL_ALOE_VERA.get(), this::createTallAloeVeraDrops);
            this.dropSelf((Block)AtmosphericBlocks.ALOE_BUNDLE.get());
            this.dropSelf((Block)AtmosphericBlocks.ALOE_GEL_BLOCK.get());
            this.dropPottedContents((Block)AtmosphericBlocks.POTTED_ALOE_VERA.get());
            this.add((Block)AtmosphericBlocks.BARREL_CACTUS.get(), this::createBarrelCactusDrops);
            this.add((Block)AtmosphericBlocks.SNOWY_BARREL_CACTUS.get(), this::createBarrelCactusDrops);
            this.dropOther((Block)AtmosphericBlocks.SNOWY_CACTUS.get(), (ItemLike)Blocks.CACTUS);
            this.dropSelf((Block)AtmosphericBlocks.BARREL_CACTUS_BATCH.get());
            this.dropPottedContents((Block)AtmosphericBlocks.POTTED_BARREL_CACTUS.get());
            this.dropPottedContents((Block)AtmosphericBlocks.POTTED_SNOWY_CACTUS.get());
            this.dropPottedContents((Block)AtmosphericBlocks.POTTED_SNOWY_BARREL_CACTUS.get());
            this.dropSelf((Block)AtmosphericBlocks.GILIA.get());
            this.dropPottedContents((Block)AtmosphericBlocks.POTTED_GILIA.get());
            this.dropSelf((Block)AtmosphericBlocks.YUCCA_FLOWER.get());
            this.dropPottedContents((Block)AtmosphericBlocks.POTTED_YUCCA_FLOWER.get());
            this.add((Block)AtmosphericBlocks.TALL_YUCCA_FLOWER.get(), block -> AtmosphericBlockLoot.createDoublePlantDrops(block, (Block)AtmosphericBlocks.YUCCA_FLOWER.get()));
            this.add((Block)AtmosphericBlocks.YUCCA_GATEAU.get(), AtmosphericBlockLoot.noDrop());
            CandleGateauBlock.getCandleGateaus().forEach(block -> this.add((Block)block, AtmosphericBlockLoot.createCandleCakeDrops((Block)block.getCandle())));
            this.add((Block)AtmosphericBlocks.YUCCA_BRANCH.get(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))))));
            this.add((Block)AtmosphericBlocks.YUCCA_BUNDLE.get(), arg_0 -> this.lambda$generate$8((Holder)fortune, arg_0));
            this.add((Block)AtmosphericBlocks.ROASTED_YUCCA_BUNDLE.get(), arg_0 -> this.lambda$generate$9((Holder)fortune, arg_0));
            this.dropSelf((Block)AtmosphericBlocks.YUCCA_CASK.get());
            this.dropSelf((Block)AtmosphericBlocks.ROASTED_YUCCA_CASK.get());
            this.add((Block)AtmosphericBlocks.AGAVE.get(), x$0 -> BlockLootSubProvider.createShearsOnlyDrop((ItemLike)x$0));
            this.dropPottedContents((Block)AtmosphericBlocks.POTTED_AGAVE.get());
            this.add((Block)AtmosphericBlocks.GOLDEN_GROWTHS.get(), x$0 -> BlockLootSubProvider.createShearsOnlyDrop((ItemLike)x$0));
            this.dropPottedContents((Block)AtmosphericBlocks.POTTED_GOLDEN_GROWTHS.get());
            this.add((Block)AtmosphericBlocks.CRUSTOSE.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Blocks.DIRT));
            this.add((Block)AtmosphericBlocks.CRUSTOSE_LOG.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)AtmosphericBlocks.ASPEN_LOG.get()));
            this.add((Block)AtmosphericBlocks.CRUSTOSE_WOOD.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)AtmosphericBlocks.ASPEN_WOOD.get()));
            this.dropOther((Block)AtmosphericBlocks.CRUSTOSE_PATH.get(), (ItemLike)Blocks.DIRT);
            this.dropSelf((Block)AtmosphericBlocks.CURRANT_STALK.get());
            this.dropSelf((Block)AtmosphericBlocks.CURRANT_STALK_BUNDLE.get());
            this.dropSelf((Block)AtmosphericBlocks.CURRANT_CRATE.get());
            this.add((Block)AtmosphericBlocks.HANGING_CURRANT.get(), x$0 -> BlockLootSubProvider.createShearsOnlyDrop((ItemLike)x$0));
            this.add((Block)AtmosphericBlocks.CURRANT_SEEDLING.get(), x$0 -> BlockLootSubProvider.createShearsOnlyDrop((ItemLike)x$0));
            this.dropPottedContents((Block)AtmosphericBlocks.POTTED_CURRANT_SEEDLING.get());
            this.add((Block)AtmosphericBlocks.CURRANT_LEAF_PILE.get(), this::createLeafPileDrops);
            this.add((Block)AtmosphericBlocks.CURRANT_LEAVES.get(), arg_0 -> this.lambda$generate$17((Holder)fortune, arg_0));
            this.dropOther((Block)AtmosphericBlocks.SNOWY_BAMBOO.get(), (ItemLike)Items.BAMBOO);
            this.dropOther((Block)AtmosphericBlocks.SNOWY_BAMBOO_SAPLING.get(), (ItemLike)Items.BAMBOO);
            this.dropPottedContents((Block)AtmosphericBlocks.POTTED_SNOWY_BAMBOO.get());
            this.add((Block)AtmosphericBlocks.GRIMWEB.get(), block -> this.createSilkTouchOrShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STRING))));
            this.dropSelf((Block)AtmosphericBlocks.CARMINE_BLOCK.get());
            this.dropSelf((Block)AtmosphericBlocks.CARMINE_SHINGLES.get());
            this.dropSelf((Block)AtmosphericBlocks.CARMINE_SHINGLE_STAIRS.get());
            this.dropSelf((Block)AtmosphericBlocks.CARMINE_SHINGLE_WALL.get());
            this.add((Block)AtmosphericBlocks.CARMINE_SHINGLE_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
            this.dropSelf((Block)AtmosphericBlocks.CHISELED_CARMINE_SHINGLES.get());
            this.dropSelf((Block)AtmosphericBlocks.CARMINE_PAVEMENT.get());
            this.dropSelf((Block)AtmosphericBlocks.CARMINE_PAVEMENT_STAIRS.get());
            this.dropSelf((Block)AtmosphericBlocks.CARMINE_PAVEMENT_WALL.get());
            this.add((Block)AtmosphericBlocks.CARMINE_PAVEMENT_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
            this.dropSelf((Block)AtmosphericBlocks.FIRETHORN.get());
            this.dropPottedContents((Block)AtmosphericBlocks.POTTED_FIRETHORN.get());
            this.dropSelf((Block)AtmosphericBlocks.FORSYTHIA.get());
            this.dropPottedContents((Block)AtmosphericBlocks.POTTED_FORSYTHIA.get());
            this.dropSelf((Block)AtmosphericBlocks.DRAGON_FRUIT_CRATE.get());
            this.dropSelf((Block)AtmosphericBlocks.GOLDEN_DRAGON_FRUIT_CRATE.get());
            this.add((Block)AtmosphericBlocks.DRAGON_ROOTS.get(), this::createDragonRootsDrops);
            this.dropSelf((Block)AtmosphericBlocks.ARID_SAND.get());
            this.add((Block)AtmosphericBlocks.SUSPICIOUS_ARID_SAND.get(), AtmosphericBlockLoot.noDrop());
            this.dropSelf((Block)AtmosphericBlocks.ARID_SANDSTONE.get());
            this.dropSelf((Block)AtmosphericBlocks.ARID_SANDSTONE_STAIRS.get());
            this.add((Block)AtmosphericBlocks.ARID_SANDSTONE_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
            this.dropSelf((Block)AtmosphericBlocks.ARID_SANDSTONE_WALL.get());
            this.dropSelf((Block)AtmosphericBlocks.SMOOTH_ARID_SANDSTONE.get());
            this.dropSelf((Block)AtmosphericBlocks.SMOOTH_ARID_SANDSTONE_STAIRS.get());
            this.add((Block)AtmosphericBlocks.SMOOTH_ARID_SANDSTONE_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
            this.dropSelf((Block)AtmosphericBlocks.CUT_ARID_SANDSTONE.get());
            this.add((Block)AtmosphericBlocks.CUT_ARID_SANDSTONE_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
            this.dropSelf((Block)AtmosphericBlocks.CHISELED_ARID_SANDSTONE.get());
            this.dropSelf((Block)AtmosphericBlocks.RED_ARID_SAND.get());
            this.add((Block)AtmosphericBlocks.SUSPICIOUS_RED_ARID_SAND.get(), AtmosphericBlockLoot.noDrop());
            this.dropSelf((Block)AtmosphericBlocks.RED_ARID_SANDSTONE.get());
            this.dropSelf((Block)AtmosphericBlocks.RED_ARID_SANDSTONE_STAIRS.get());
            this.add((Block)AtmosphericBlocks.RED_ARID_SANDSTONE_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
            this.dropSelf((Block)AtmosphericBlocks.RED_ARID_SANDSTONE_WALL.get());
            this.dropSelf((Block)AtmosphericBlocks.SMOOTH_RED_ARID_SANDSTONE.get());
            this.dropSelf((Block)AtmosphericBlocks.SMOOTH_RED_ARID_SANDSTONE_STAIRS.get());
            this.add((Block)AtmosphericBlocks.SMOOTH_RED_ARID_SANDSTONE_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
            this.dropSelf((Block)AtmosphericBlocks.CUT_RED_ARID_SANDSTONE.get());
            this.add((Block)AtmosphericBlocks.CUT_RED_ARID_SANDSTONE_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
            this.dropSelf((Block)AtmosphericBlocks.CHISELED_RED_ARID_SANDSTONE.get());
            this.dropWhenSilkTouch((Block)AtmosphericBlocks.ARID_GLASS.get());
            this.dropWhenSilkTouch((Block)AtmosphericBlocks.ARID_GLASS_PANE.get());
            this.dropSelf((Block)AtmosphericBlocks.IVORY_TRAVERTINE.get());
            this.dropSelf((Block)AtmosphericBlocks.IVORY_TRAVERTINE_STAIRS.get());
            this.add((Block)AtmosphericBlocks.IVORY_TRAVERTINE_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
            this.dropSelf((Block)AtmosphericBlocks.IVORY_TRAVERTINE_WALL.get());
            this.dropSelf((Block)AtmosphericBlocks.CUT_IVORY_TRAVERTINE.get());
            this.dropSelf((Block)AtmosphericBlocks.CHISELED_IVORY_TRAVERTINE.get());
            this.dropSelf((Block)AtmosphericBlocks.PEACH_TRAVERTINE.get());
            this.dropSelf((Block)AtmosphericBlocks.PEACH_TRAVERTINE_STAIRS.get());
            this.add((Block)AtmosphericBlocks.PEACH_TRAVERTINE_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
            this.dropSelf((Block)AtmosphericBlocks.PEACH_TRAVERTINE_WALL.get());
            this.dropSelf((Block)AtmosphericBlocks.CUT_PEACH_TRAVERTINE.get());
            this.dropSelf((Block)AtmosphericBlocks.CHISELED_PEACH_TRAVERTINE.get());
            this.dropSelf((Block)AtmosphericBlocks.PERSIMMON_TRAVERTINE.get());
            this.dropSelf((Block)AtmosphericBlocks.PERSIMMON_TRAVERTINE_STAIRS.get());
            this.add((Block)AtmosphericBlocks.PERSIMMON_TRAVERTINE_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
            this.dropSelf((Block)AtmosphericBlocks.PERSIMMON_TRAVERTINE_WALL.get());
            this.dropSelf((Block)AtmosphericBlocks.CUT_PERSIMMON_TRAVERTINE.get());
            this.dropSelf((Block)AtmosphericBlocks.CHISELED_PERSIMMON_TRAVERTINE.get());
            this.dropSelf((Block)AtmosphericBlocks.SAFFRON_TRAVERTINE.get());
            this.dropSelf((Block)AtmosphericBlocks.SAFFRON_TRAVERTINE_STAIRS.get());
            this.add((Block)AtmosphericBlocks.SAFFRON_TRAVERTINE_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
            this.dropSelf((Block)AtmosphericBlocks.SAFFRON_TRAVERTINE_WALL.get());
            this.dropSelf((Block)AtmosphericBlocks.CUT_SAFFRON_TRAVERTINE.get());
            this.dropSelf((Block)AtmosphericBlocks.CHISELED_SAFFRON_TRAVERTINE.get());
            this.dropSelf((Block)AtmosphericBlocks.DOLERITE.get());
            this.dropSelf((Block)AtmosphericBlocks.DOLERITE_STAIRS.get());
            this.add((Block)AtmosphericBlocks.DOLERITE_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
            this.dropSelf((Block)AtmosphericBlocks.DOLERITE_WALL.get());
            this.dropSelf((Block)AtmosphericBlocks.POLISHED_DOLERITE.get());
            this.dropSelf((Block)AtmosphericBlocks.POLISHED_DOLERITE_STAIRS.get());
            this.add((Block)AtmosphericBlocks.POLISHED_DOLERITE_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
            this.dropSelf((Block)AtmosphericBlocks.ROSEWOOD_PLANKS.get());
            this.dropSelf((Block)AtmosphericBlocks.ROSEWOOD_LOG.get());
            this.dropSelf((Block)AtmosphericBlocks.ROSEWOOD.get());
            this.dropSelf((Block)AtmosphericBlocks.STRIPPED_ROSEWOOD_LOG.get());
            this.dropSelf((Block)AtmosphericBlocks.STRIPPED_ROSEWOOD.get());
            this.dropSelf((Block)((DeferredBlock)AtmosphericBlocks.ROSEWOOD_SIGNS.getFirst()).get());
            this.dropSelf((Block)((DeferredBlock)AtmosphericBlocks.ROSEWOOD_HANGING_SIGNS.getFirst()).get());
            this.dropSelf((Block)AtmosphericBlocks.ROSEWOOD_PRESSURE_PLATE.get());
            this.dropSelf((Block)AtmosphericBlocks.ROSEWOOD_TRAPDOOR.get());
            this.dropSelf((Block)AtmosphericBlocks.ROSEWOOD_BUTTON.get());
            this.dropSelf((Block)AtmosphericBlocks.ROSEWOOD_STAIRS.get());
            this.dropSelf((Block)AtmosphericBlocks.ROSEWOOD_FENCE.get());
            this.dropSelf((Block)AtmosphericBlocks.ROSEWOOD_FENCE_GATE.get());
            this.dropSelf((Block)AtmosphericBlocks.ROSEWOOD_BOARDS.get());
            this.add((Block)AtmosphericBlocks.ROSEWOOD_LEAF_PILE.get(), this::createLeafPileDrops);
            this.dropSelf((Block)AtmosphericBlocks.ROSEWOOD_SAPLING.get());
            this.dropPottedContents((Block)AtmosphericBlocks.POTTED_ROSEWOOD_SAPLING.get());
            this.dropSelf((Block)AtmosphericBlocks.ROSEWOOD_LADDER.get());
            this.add((Block)AtmosphericBlocks.ROSEWOOD_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
            this.add((Block)AtmosphericBlocks.ROSEWOOD_DOOR.get(), x$0 -> this.createDoorTable((Block)x$0));
            this.add((Block)AtmosphericBlocks.ROSEWOOD_BEEHIVE.get(), x$0 -> this.createBeeHiveDrop((Block)x$0));
            this.add((Block)AtmosphericBlocks.ROSEWOOD_CHEST.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.add((Block)AtmosphericBlocks.TRAPPED_ROSEWOOD_CHEST.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.add((Block)AtmosphericBlocks.ROSEWOOD_BOOKSHELF.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Items.BOOK, (NumberProvider)ConstantValue.exactly((float)3.0f)));
            this.dropWhenSilkTouch((Block)AtmosphericBlocks.CHISELED_ROSEWOOD_BOOKSHELF.get());
            this.add((Block)AtmosphericBlocks.ROSEWOOD_LEAVES.get(), block -> this.createLeavesDrops((Block)block, (Block)AtmosphericBlocks.ROSEWOOD_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
            this.dropSelf((Block)AtmosphericBlocks.MORADO_PLANKS.get());
            this.dropSelf((Block)AtmosphericBlocks.MORADO_LOG.get());
            this.dropSelf((Block)AtmosphericBlocks.MORADO_WOOD.get());
            this.dropSelf((Block)AtmosphericBlocks.STRIPPED_MORADO_LOG.get());
            this.dropSelf((Block)AtmosphericBlocks.STRIPPED_MORADO_WOOD.get());
            this.dropSelf((Block)((DeferredBlock)AtmosphericBlocks.MORADO_SIGNS.getFirst()).get());
            this.dropSelf((Block)((DeferredBlock)AtmosphericBlocks.MORADO_HANGING_SIGNS.getFirst()).get());
            this.dropSelf((Block)AtmosphericBlocks.MORADO_PRESSURE_PLATE.get());
            this.dropSelf((Block)AtmosphericBlocks.MORADO_TRAPDOOR.get());
            this.dropSelf((Block)AtmosphericBlocks.MORADO_BUTTON.get());
            this.dropSelf((Block)AtmosphericBlocks.MORADO_STAIRS.get());
            this.dropSelf((Block)AtmosphericBlocks.MORADO_FENCE.get());
            this.dropSelf((Block)AtmosphericBlocks.MORADO_FENCE_GATE.get());
            this.dropSelf((Block)AtmosphericBlocks.MORADO_BOARDS.get());
            this.add((Block)AtmosphericBlocks.MORADO_LEAF_PILE.get(), this::createLeafPileDrops);
            this.dropSelf((Block)AtmosphericBlocks.MORADO_SAPLING.get());
            this.dropPottedContents((Block)AtmosphericBlocks.POTTED_MORADO_SAPLING.get());
            this.dropSelf((Block)AtmosphericBlocks.MORADO_LADDER.get());
            this.add((Block)AtmosphericBlocks.MORADO_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
            this.add((Block)AtmosphericBlocks.MORADO_DOOR.get(), x$0 -> this.createDoorTable((Block)x$0));
            this.add((Block)AtmosphericBlocks.MORADO_BEEHIVE.get(), x$0 -> this.createBeeHiveDrop((Block)x$0));
            this.add((Block)AtmosphericBlocks.MORADO_CHEST.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.add((Block)AtmosphericBlocks.TRAPPED_MORADO_CHEST.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.add((Block)AtmosphericBlocks.MORADO_BOOKSHELF.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Items.BOOK, (NumberProvider)ConstantValue.exactly((float)3.0f)));
            this.dropWhenSilkTouch((Block)AtmosphericBlocks.CHISELED_MORADO_BOOKSHELF.get());
            this.add((Block)AtmosphericBlocks.MORADO_LEAVES.get(), block -> this.createLeavesDrops((Block)block, (Block)AtmosphericBlocks.MORADO_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
            this.add((Block)AtmosphericBlocks.FLOWERING_MORADO_LEAF_PILE.get(), this::createLeafPileDrops);
            this.add((Block)AtmosphericBlocks.FLOWERING_MORADO_LEAVES.get(), arg_0 -> this.lambda$generate$47((Holder)fortune, arg_0));
            this.dropSelf((Block)AtmosphericBlocks.YUCCA_PLANKS.get());
            this.dropSelf((Block)AtmosphericBlocks.YUCCA_LOG.get());
            this.dropSelf((Block)AtmosphericBlocks.YUCCA_WOOD.get());
            this.dropSelf((Block)AtmosphericBlocks.STRIPPED_YUCCA_LOG.get());
            this.dropSelf((Block)AtmosphericBlocks.STRIPPED_YUCCA_WOOD.get());
            this.dropSelf((Block)((DeferredBlock)AtmosphericBlocks.YUCCA_SIGNS.getFirst()).get());
            this.dropSelf((Block)((DeferredBlock)AtmosphericBlocks.YUCCA_HANGING_SIGNS.getFirst()).get());
            this.dropSelf((Block)AtmosphericBlocks.YUCCA_PRESSURE_PLATE.get());
            this.dropSelf((Block)AtmosphericBlocks.YUCCA_TRAPDOOR.get());
            this.dropSelf((Block)AtmosphericBlocks.YUCCA_BUTTON.get());
            this.dropSelf((Block)AtmosphericBlocks.YUCCA_STAIRS.get());
            this.dropSelf((Block)AtmosphericBlocks.YUCCA_FENCE.get());
            this.dropSelf((Block)AtmosphericBlocks.YUCCA_FENCE_GATE.get());
            this.dropSelf((Block)AtmosphericBlocks.YUCCA_BOARDS.get());
            this.add((Block)AtmosphericBlocks.YUCCA_LEAF_PILE.get(), this::createLeafPileDrops);
            this.dropSelf((Block)AtmosphericBlocks.YUCCA_SAPLING.get());
            this.dropPottedContents((Block)AtmosphericBlocks.POTTED_YUCCA_SAPLING.get());
            this.dropSelf((Block)AtmosphericBlocks.YUCCA_LADDER.get());
            this.add((Block)AtmosphericBlocks.YUCCA_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
            this.add((Block)AtmosphericBlocks.YUCCA_DOOR.get(), x$0 -> this.createDoorTable((Block)x$0));
            this.add((Block)AtmosphericBlocks.YUCCA_BEEHIVE.get(), x$0 -> this.createBeeHiveDrop((Block)x$0));
            this.add((Block)AtmosphericBlocks.YUCCA_CHEST.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.add((Block)AtmosphericBlocks.TRAPPED_YUCCA_CHEST.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.add((Block)AtmosphericBlocks.YUCCA_BOOKSHELF.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Items.BOOK, (NumberProvider)ConstantValue.exactly((float)3.0f)));
            this.dropWhenSilkTouch((Block)AtmosphericBlocks.CHISELED_YUCCA_BOOKSHELF.get());
            this.add((Block)AtmosphericBlocks.YUCCA_LEAVES.get(), block -> this.createLeavesDrops((Block)block, (Block)AtmosphericBlocks.YUCCA_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
            this.dropSelf((Block)AtmosphericBlocks.LAUREL_PLANKS.get());
            this.dropSelf((Block)AtmosphericBlocks.LAUREL_LOG.get());
            this.dropSelf((Block)AtmosphericBlocks.LAUREL_WOOD.get());
            this.dropSelf((Block)AtmosphericBlocks.STRIPPED_LAUREL_LOG.get());
            this.dropSelf((Block)AtmosphericBlocks.STRIPPED_LAUREL_WOOD.get());
            this.dropSelf((Block)((DeferredBlock)AtmosphericBlocks.LAUREL_SIGNS.getFirst()).get());
            this.dropSelf((Block)((DeferredBlock)AtmosphericBlocks.LAUREL_HANGING_SIGNS.getFirst()).get());
            this.dropSelf((Block)AtmosphericBlocks.LAUREL_PRESSURE_PLATE.get());
            this.dropSelf((Block)AtmosphericBlocks.LAUREL_TRAPDOOR.get());
            this.dropSelf((Block)AtmosphericBlocks.LAUREL_BUTTON.get());
            this.dropSelf((Block)AtmosphericBlocks.LAUREL_STAIRS.get());
            this.dropSelf((Block)AtmosphericBlocks.LAUREL_FENCE.get());
            this.dropSelf((Block)AtmosphericBlocks.LAUREL_FENCE_GATE.get());
            this.dropSelf((Block)AtmosphericBlocks.LAUREL_BOARDS.get());
            this.add((Block)AtmosphericBlocks.LAUREL_LEAF_PILE.get(), this::createLeafPileDrops);
            this.dropSelf((Block)AtmosphericBlocks.LAUREL_SAPLING.get());
            this.dropPottedContents((Block)AtmosphericBlocks.POTTED_LAUREL_SAPLING.get());
            this.dropSelf((Block)AtmosphericBlocks.LAUREL_LADDER.get());
            this.add((Block)AtmosphericBlocks.LAUREL_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
            this.add((Block)AtmosphericBlocks.LAUREL_DOOR.get(), x$0 -> this.createDoorTable((Block)x$0));
            this.add((Block)AtmosphericBlocks.LAUREL_BEEHIVE.get(), x$0 -> this.createBeeHiveDrop((Block)x$0));
            this.add((Block)AtmosphericBlocks.LAUREL_CHEST.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.add((Block)AtmosphericBlocks.TRAPPED_LAUREL_CHEST.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.add((Block)AtmosphericBlocks.LAUREL_BOOKSHELF.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Items.BOOK, (NumberProvider)ConstantValue.exactly((float)3.0f)));
            this.dropWhenSilkTouch((Block)AtmosphericBlocks.CHISELED_LAUREL_BOOKSHELF.get());
            this.add((Block)AtmosphericBlocks.LAUREL_LEAVES.get(), block -> this.createLeavesDrops((Block)block, (Block)AtmosphericBlocks.LAUREL_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
            this.add((Block)AtmosphericBlocks.DRY_LAUREL_LEAF_PILE.get(), this::createLeafPileDrops);
            this.dropSelf((Block)AtmosphericBlocks.DRY_LAUREL_SAPLING.get());
            this.dropPottedContents((Block)AtmosphericBlocks.POTTED_DRY_LAUREL_SAPLING.get());
            this.add((Block)AtmosphericBlocks.DRY_LAUREL_LEAVES.get(), block -> this.createLeavesDrops((Block)block, (Block)AtmosphericBlocks.DRY_LAUREL_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
            this.add((Block)AtmosphericBlocks.ORANGE.get(), block -> this.createOrangeDrops((Block)block, (Item)AtmosphericItems.ORANGE.get()));
            this.add((Block)AtmosphericBlocks.BLOOD_ORANGE.get(), block -> this.createOrangeDrops((Block)block, (Item)AtmosphericItems.BLOOD_ORANGE.get()));
            this.dropSelf((Block)AtmosphericBlocks.ORANGE_CRATE.get());
            this.dropSelf((Block)AtmosphericBlocks.BLOOD_ORANGE_CRATE.get());
            this.dropSelf((Block)AtmosphericBlocks.ASPEN_PLANKS.get());
            this.dropSelf((Block)AtmosphericBlocks.ASPEN_LOG.get());
            this.dropSelf((Block)AtmosphericBlocks.ASPEN_WOOD.get());
            this.dropSelf((Block)AtmosphericBlocks.STRIPPED_ASPEN_LOG.get());
            this.dropSelf((Block)AtmosphericBlocks.STRIPPED_ASPEN_WOOD.get());
            this.add((Block)AtmosphericBlocks.WATCHFUL_ASPEN_LOG.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)AtmosphericBlocks.ASPEN_LOG.get()));
            this.add((Block)AtmosphericBlocks.WATCHFUL_ASPEN_WOOD.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)AtmosphericBlocks.ASPEN_WOOD.get()));
            this.dropSelf((Block)((DeferredBlock)AtmosphericBlocks.ASPEN_SIGNS.getFirst()).get());
            this.dropSelf((Block)((DeferredBlock)AtmosphericBlocks.ASPEN_HANGING_SIGNS.getFirst()).get());
            this.dropSelf((Block)AtmosphericBlocks.ASPEN_PRESSURE_PLATE.get());
            this.dropSelf((Block)AtmosphericBlocks.ASPEN_TRAPDOOR.get());
            this.dropSelf((Block)AtmosphericBlocks.ASPEN_BUTTON.get());
            this.dropSelf((Block)AtmosphericBlocks.ASPEN_STAIRS.get());
            this.dropSelf((Block)AtmosphericBlocks.ASPEN_FENCE.get());
            this.dropSelf((Block)AtmosphericBlocks.ASPEN_FENCE_GATE.get());
            this.dropSelf((Block)AtmosphericBlocks.ASPEN_BOARDS.get());
            this.add((Block)AtmosphericBlocks.ASPEN_LEAF_PILE.get(), this::createLeafPileDrops);
            this.dropSelf((Block)AtmosphericBlocks.ASPEN_SAPLING.get());
            this.dropPottedContents((Block)AtmosphericBlocks.POTTED_ASPEN_SAPLING.get());
            this.dropSelf((Block)AtmosphericBlocks.ASPEN_LADDER.get());
            this.add((Block)AtmosphericBlocks.ASPEN_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
            this.add((Block)AtmosphericBlocks.ASPEN_DOOR.get(), x$0 -> this.createDoorTable((Block)x$0));
            this.add((Block)AtmosphericBlocks.ASPEN_BEEHIVE.get(), x$0 -> this.createBeeHiveDrop((Block)x$0));
            this.add((Block)AtmosphericBlocks.ASPEN_CHEST.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.add((Block)AtmosphericBlocks.TRAPPED_ASPEN_CHEST.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.add((Block)AtmosphericBlocks.ASPEN_BOOKSHELF.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Items.BOOK, (NumberProvider)ConstantValue.exactly((float)3.0f)));
            this.dropWhenSilkTouch((Block)AtmosphericBlocks.CHISELED_ASPEN_BOOKSHELF.get());
            this.add((Block)AtmosphericBlocks.ASPEN_LEAVES.get(), block -> this.createLeavesDrops((Block)block, (Block)AtmosphericBlocks.ASPEN_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
            this.add((Block)AtmosphericBlocks.GREEN_ASPEN_LEAVES.get(), block -> this.createLeavesDrops((Block)block, (Block)AtmosphericBlocks.GREEN_ASPEN_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
            this.add((Block)AtmosphericBlocks.GREEN_ASPEN_LEAF_PILE.get(), this::createLeafPileDrops);
            this.dropSelf((Block)AtmosphericBlocks.GREEN_ASPEN_SAPLING.get());
            this.dropPottedContents((Block)AtmosphericBlocks.POTTED_GREEN_ASPEN_SAPLING.get());
            this.dropSelf((Block)AtmosphericBlocks.KOUSA_PLANKS.get());
            this.dropSelf((Block)AtmosphericBlocks.KOUSA_LOG.get());
            this.dropSelf((Block)AtmosphericBlocks.KOUSA_WOOD.get());
            this.dropSelf((Block)AtmosphericBlocks.STRIPPED_KOUSA_LOG.get());
            this.dropSelf((Block)AtmosphericBlocks.STRIPPED_KOUSA_WOOD.get());
            this.dropSelf((Block)((DeferredBlock)AtmosphericBlocks.KOUSA_SIGNS.getFirst()).get());
            this.dropSelf((Block)((DeferredBlock)AtmosphericBlocks.KOUSA_HANGING_SIGNS.getFirst()).get());
            this.dropSelf((Block)AtmosphericBlocks.KOUSA_PRESSURE_PLATE.get());
            this.dropSelf((Block)AtmosphericBlocks.KOUSA_TRAPDOOR.get());
            this.dropSelf((Block)AtmosphericBlocks.KOUSA_BUTTON.get());
            this.dropSelf((Block)AtmosphericBlocks.KOUSA_STAIRS.get());
            this.dropSelf((Block)AtmosphericBlocks.KOUSA_FENCE.get());
            this.dropSelf((Block)AtmosphericBlocks.KOUSA_FENCE_GATE.get());
            this.dropSelf((Block)AtmosphericBlocks.KOUSA_BOARDS.get());
            this.add((Block)AtmosphericBlocks.KOUSA_LEAF_PILE.get(), this::createLeafPileDrops);
            this.dropSelf((Block)AtmosphericBlocks.KOUSA_SAPLING.get());
            this.dropPottedContents((Block)AtmosphericBlocks.POTTED_KOUSA_SAPLING.get());
            this.dropSelf((Block)AtmosphericBlocks.KOUSA_LADDER.get());
            this.add((Block)AtmosphericBlocks.KOUSA_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
            this.add((Block)AtmosphericBlocks.KOUSA_DOOR.get(), x$0 -> this.createDoorTable((Block)x$0));
            this.add((Block)AtmosphericBlocks.KOUSA_BEEHIVE.get(), x$0 -> this.createBeeHiveDrop((Block)x$0));
            this.add((Block)AtmosphericBlocks.KOUSA_CHEST.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.add((Block)AtmosphericBlocks.TRAPPED_KOUSA_CHEST.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.add((Block)AtmosphericBlocks.KOUSA_BOOKSHELF.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Items.BOOK, (NumberProvider)ConstantValue.exactly((float)3.0f)));
            this.dropWhenSilkTouch((Block)AtmosphericBlocks.CHISELED_KOUSA_BOOKSHELF.get());
            this.add((Block)AtmosphericBlocks.KOUSA_LEAVES.get(), block -> this.createLeavesDrops((Block)block, (Block)AtmosphericBlocks.KOUSA_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
            this.dropSelf((Block)AtmosphericBlocks.GRIMWOOD_PLANKS.get());
            this.dropSelf((Block)AtmosphericBlocks.GRIMWOOD_LOG.get());
            this.dropSelf((Block)AtmosphericBlocks.GRIMWOOD.get());
            this.dropSelf((Block)AtmosphericBlocks.STRIPPED_GRIMWOOD_LOG.get());
            this.dropSelf((Block)AtmosphericBlocks.STRIPPED_GRIMWOOD.get());
            this.dropSelf((Block)((DeferredBlock)AtmosphericBlocks.GRIMWOOD_SIGNS.getFirst()).get());
            this.dropSelf((Block)((DeferredBlock)AtmosphericBlocks.GRIMWOOD_HANGING_SIGNS.getFirst()).get());
            this.dropSelf((Block)AtmosphericBlocks.GRIMWOOD_PRESSURE_PLATE.get());
            this.dropSelf((Block)AtmosphericBlocks.GRIMWOOD_TRAPDOOR.get());
            this.dropSelf((Block)AtmosphericBlocks.GRIMWOOD_BUTTON.get());
            this.dropSelf((Block)AtmosphericBlocks.GRIMWOOD_STAIRS.get());
            this.dropSelf((Block)AtmosphericBlocks.GRIMWOOD_FENCE.get());
            this.dropSelf((Block)AtmosphericBlocks.GRIMWOOD_FENCE_GATE.get());
            this.dropSelf((Block)AtmosphericBlocks.GRIMWOOD_BOARDS.get());
            this.add((Block)AtmosphericBlocks.GRIMWOOD_LEAF_PILE.get(), this::createLeafPileDrops);
            this.dropSelf((Block)AtmosphericBlocks.GRIMWOOD_SAPLING.get());
            this.dropPottedContents((Block)AtmosphericBlocks.POTTED_GRIMWOOD_SAPLING.get());
            this.dropSelf((Block)AtmosphericBlocks.GRIMWOOD_LADDER.get());
            this.add((Block)AtmosphericBlocks.GRIMWOOD_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
            this.add((Block)AtmosphericBlocks.GRIMWOOD_DOOR.get(), x$0 -> this.createDoorTable((Block)x$0));
            this.add((Block)AtmosphericBlocks.GRIMWOOD_BEEHIVE.get(), x$0 -> this.createBeeHiveDrop((Block)x$0));
            this.add((Block)AtmosphericBlocks.GRIMWOOD_CHEST.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.add((Block)AtmosphericBlocks.TRAPPED_GRIMWOOD_CHEST.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.add((Block)AtmosphericBlocks.GRIMWOOD_BOOKSHELF.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Items.BOOK, (NumberProvider)ConstantValue.exactly((float)3.0f)));
            this.dropWhenSilkTouch((Block)AtmosphericBlocks.CHISELED_GRIMWOOD_BOOKSHELF.get());
            this.add((Block)AtmosphericBlocks.GRIMWOOD_LEAVES.get(), block -> this.createLeavesDrops((Block)block, (Block)AtmosphericBlocks.GRIMWOOD_SAPLING.get(), GRIMWOOD_LEAVES_SAPLING_CHANCES));
        }

        protected LootTable.Builder createDragonRootsDrops(Block block) {
            return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(this.doesNotHaveShearsOrSilkTouch()).add((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)block).when(InvertedLootItemCondition.invert((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty(DragonRootsBlock.TOP_STAGE, (Comparable)((Object)DragonRootsStage.NONE)))))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(this.doesNotHaveShearsOrSilkTouch()).add((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)block).when(InvertedLootItemCondition.invert((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty(DragonRootsBlock.BOTTOM_STAGE, (Comparable)((Object)DragonRootsStage.NONE))))))));
        }

        protected LootTable.Builder createBarrelCactusDrops(Block block) {
            return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, LootItem.lootTableItem((ItemLike)((ItemLike)AtmosphericBlocks.BARREL_CACTUS.get())).apply(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4)), val -> SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)val.intValue())).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BarrelCactusBlock.AGE, val - 1)))))));
        }

        protected LootTable.Builder createLeafPileDrops(Block block) {
            return this.createMultifaceBlockDrops(block, MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(Tags.Items.TOOLS_SHEAR)));
        }

        protected LootTable.Builder createTallAloeVeraDrops(Block block) {
            HolderLookup.RegistryLookup enchantments = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
            Holder.Reference fortune = enchantments.getOrThrow(Enchantments.FORTUNE);
            return (LootTable.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)AtmosphericItems.ALOE_LEAVES.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)fortune)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)AtmosphericItems.YELLOW_BLOSSOMS.get())).apply(List.of(Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8)), val -> SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)((float)val.intValue() - 5.0f))).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)AloeVeraTallBlock.AGE, val.intValue())))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)AtmosphericItems.ALOE_KERNELS.get())))));
        }

        protected LootTable.Builder createOrangeDrops(Block block, Item item) {
            return (LootTable.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f)).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)OrangeBlock.ORANGES, 2)))))));
        }

        protected static LootTable.Builder createDoublePlantDrops(Block large, Block big) {
            LootPoolSingletonContainer.Builder builder = LootItem.lootTableItem((ItemLike)big).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f)));
            return LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)builder).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)large).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER))).when(LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(new Block[]{large}).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER))), (BlockPos)new BlockPos(0, 1, 0)))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)builder).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)large).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER))).when(LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(new Block[]{large}).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER))), (BlockPos)new BlockPos(0, -1, 0))));
        }

        public Iterable<Block> getKnownBlocks() {
            return BuiltInRegistries.BLOCK.stream().filter(block -> BuiltInRegistries.BLOCK.getKey(block).getNamespace().equals("atmospheric")).collect(Collectors.toSet());
        }

        private /* synthetic */ LootTable.Builder lambda$generate$47(Holder fortune, Block block) {
            return this.createLeavesDrops(block, (Block)AtmosphericBlocks.MORADO_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(this.doesNotHaveShearsOrSilkTouch()).add(((LootPoolSingletonContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)AtmosphericItems.YELLOW_BLOSSOMS.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)fortune, (float[])CURRANT_LEAVES_STALK_CHANCES))));
        }

        private /* synthetic */ LootTable.Builder lambda$generate$17(Holder fortune, Block block) {
            return this.createSilkTouchOrShearsDispatchTable(block, ((LootPoolSingletonContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)AtmosphericBlocks.CURRANT_STALK.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)fortune, (float[])CURRANT_LEAVES_STALK_CHANCES)));
        }

        private /* synthetic */ LootTable.Builder lambda$generate$9(Holder fortune, Block block) {
            return this.createSilkTouchOrShearsDispatchTable(block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)AtmosphericItems.ROASTED_YUCCA_FRUIT.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)6.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)fortune)).apply((LootItemFunction.Builder)LimitCount.limitCount((IntRange)IntRange.upperBound((int)8)))));
        }

        private /* synthetic */ LootTable.Builder lambda$generate$8(Holder fortune, Block block) {
            return this.createSilkTouchOrShearsDispatchTable(block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)AtmosphericItems.YUCCA_FRUIT.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)6.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)fortune)).apply((LootItemFunction.Builder)LimitCount.limitCount((IntRange)IntRange.upperBound((int)8)))));
        }

        private /* synthetic */ LootTable.Builder lambda$generate$4(Holder fortune, Block block) {
            return ((LootTable.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)AtmosphericItems.ALOE_LEAVES.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)fortune))).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)AloeVeraBlock.AGE, 5)))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)AtmosphericItems.ALOE_KERNELS.get()))));
        }
    }
}

