/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.core.data.server;

import com.teamabnormals.atmospheric.core.Atmospheric;
import com.teamabnormals.atmospheric.core.other.AtmosphericBlockFamilies;
import com.teamabnormals.atmospheric.core.other.AtmosphericConditions;
import com.teamabnormals.atmospheric.core.other.tags.AtmosphericItemTags;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.atmospheric.core.registry.AtmosphericItems;
import com.teamabnormals.atmospheric.integration.boatload.AtmosphericBoatTypes;
import com.teamabnormals.blueprint.core.data.server.BlueprintRecipeProvider;
import com.teamabnormals.boatload.core.api.BoatloadBoatType;
import com.teamabnormals.boatload.core.data.server.BoatloadRecipeProvider;
import com.teamabnormals.clayworks.core.data.server.ClayworksRecipeProvider;
import com.teamabnormals.woodworks.core.data.server.WoodworksRecipeProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;

public class AtmosphericRecipeProvider
extends BlueprintRecipeProvider {
    public AtmosphericRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
        super("atmospheric", output, provider);
    }

    public void buildRecipes(RecipeOutput output) {
        this.conversionRecipe(output, (ItemLike)Items.RED_DYE, (ItemLike)AtmosphericItems.CARMINE_HUSK, "red_dye");
        this.conversionRecipe(output, (ItemLike)Items.RED_DYE, (ItemLike)AtmosphericBlocks.FIRETHORN, "red_dye");
        this.conversionRecipe(output, (ItemLike)Items.RED_DYE, (ItemLike)AtmosphericBlocks.SCALDING_MONKEY_BRUSH, "red_dye");
        this.conversionRecipe(output, (ItemLike)Items.ORANGE_DYE, (ItemLike)AtmosphericBlocks.HOT_MONKEY_BRUSH, "orange_dye");
        this.conversionRecipe(output, (ItemLike)Items.ORANGE_DYE, (ItemLike)AtmosphericBlocks.BARREL_CACTUS, "orange_dye");
        this.conversionRecipe(output, (ItemLike)Items.YELLOW_DYE, (ItemLike)AtmosphericItems.YELLOW_BLOSSOMS, "yellow_dye");
        this.conversionRecipe(output, (ItemLike)Items.YELLOW_DYE, (ItemLike)AtmosphericBlocks.WARM_MONKEY_BRUSH, "yellow_dye");
        this.conversionRecipe(output, (ItemLike)Items.YELLOW_DYE, (ItemLike)AtmosphericBlocks.FORSYTHIA, "yellow_dye");
        this.conversionRecipe(output, (ItemLike)Items.PINK_DYE, (ItemLike)AtmosphericItems.DRAGON_FRUIT, "pink_dye");
        this.conversionRecipe(output, (ItemLike)Items.MAGENTA_DYE, (ItemLike)AtmosphericBlocks.GILIA, "magenta_dye");
        this.conversionRecipe(output, (ItemLike)Items.PURPLE_DYE, (ItemLike)AtmosphericItems.CURRANT, "purple_dye");
        this.conversionRecipe(output, (ItemLike)Items.PURPLE_DYE, (ItemLike)AtmosphericBlocks.WATER_HYACINTH, "purple_dye");
        this.conversionRecipe(output, (ItemLike)Items.LIGHT_GRAY_DYE, (ItemLike)AtmosphericBlocks.YUCCA_FLOWER, "light_gray_dye");
        this.conversionRecipe(output, (ItemLike)Items.LIGHT_GRAY_DYE, (ItemLike)AtmosphericBlocks.TALL_YUCCA_FLOWER, "light_gray_dye", 2);
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtmosphericBlocks.AGAVE}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.CYAN_DYE, (float)1.0f, (int)200).unlockedBy("has_agave", AtmosphericRecipeProvider.has(AtmosphericBlocks.AGAVE)).save(output, this.getModConversionRecipeName((ItemLike)Items.CYAN_DYE, (ItemLike)AtmosphericBlocks.AGAVE));
        this.conditionalStorageRecipes(output, (ICondition)AtmosphericConditions.QUARK_LOADED, RecipeCategory.MISC, (ItemLike)AtmosphericBlocks.BARREL_CACTUS, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.BARREL_CACTUS_BATCH);
        AtmosphericRecipeProvider.trimRecipes((RecipeOutput)output, AtmosphericItems.APOSTLE_ARMOR_TRIM_SMITHING_TEMPLATE, AtmosphericBlocks.STRIPPED_KOUSA_LOG);
        AtmosphericRecipeProvider.trimRecipes((RecipeOutput)output, AtmosphericItems.DRUID_ARMOR_TRIM_SMITHING_TEMPLATE, AtmosphericBlocks.RED_ARID_SANDSTONE);
        AtmosphericRecipeProvider.trimRecipes((RecipeOutput)output, AtmosphericItems.PETRIFIED_ARMOR_TRIM_SMITHING_TEMPLATE, AtmosphericBlocks.ARID_SANDSTONE);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, AtmosphericItems.CURRANT_MUFFIN).requires(AtmosphericItemTags.FOODS_CURRANT).requires(AtmosphericItemTags.FOODS_CURRANT).requires(AtmosphericItemTags.FOODS_CURRANT).requires((ItemLike)Items.SUGAR).requires(Tags.Items.EGGS).unlockedBy("has_currant", AtmosphericRecipeProvider.has(AtmosphericItemTags.FOODS_CURRANT)).save(output);
        this.conditionalStorageRecipes(output, (ICondition)AtmosphericConditions.QUARK_LOADED, RecipeCategory.FOOD, (ItemLike)AtmosphericItems.CURRANT, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.CURRANT_CRATE);
        this.storageRecipes(output, RecipeCategory.MISC, (ItemLike)AtmosphericItems.CARMINE_HUSK, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.CARMINE_BLOCK);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, AtmosphericBlocks.CARMINE_SHINGLES, (int)4).define(Character.valueOf('#'), AtmosphericItems.CARMINE_HUSK).pattern("##").pattern("##").unlockedBy("has_carmine_husk", AtmosphericRecipeProvider.has(AtmosphericItems.CARMINE_HUSK)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, AtmosphericBlocks.CARMINE_PAVEMENT, (int)4).define(Character.valueOf('#'), AtmosphericBlocks.CARMINE_SHINGLES).pattern("##").pattern("##").unlockedBy("has_carmine_shingles", AtmosphericRecipeProvider.has(AtmosphericBlocks.CARMINE_SHINGLES)).save(output);
        AtmosphericRecipeProvider.generateRecipes((RecipeOutput)output, (BlockFamily)AtmosphericBlockFamilies.CARMINE_SHINGLES_FAMILY);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.CARMINE_SHINGLE_SLAB, (ItemLike)AtmosphericBlocks.CARMINE_SHINGLES, 2);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.CARMINE_SHINGLE_STAIRS, (ItemLike)AtmosphericBlocks.CARMINE_SHINGLES);
        this.stonecutterRecipe(output, RecipeCategory.DECORATIONS, (ItemLike)AtmosphericBlocks.CARMINE_SHINGLE_WALL, (ItemLike)AtmosphericBlocks.CARMINE_SHINGLES);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.CHISELED_CARMINE_SHINGLES, (ItemLike)AtmosphericBlocks.CARMINE_SHINGLES);
        AtmosphericRecipeProvider.generateRecipes((RecipeOutput)output, (BlockFamily)AtmosphericBlockFamilies.CARMINE_PAVEMENT_FAMILY);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.CARMINE_PAVEMENT_SLAB, (ItemLike)AtmosphericBlocks.CARMINE_PAVEMENT, 2);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.CARMINE_PAVEMENT_STAIRS, (ItemLike)AtmosphericBlocks.CARMINE_PAVEMENT);
        this.stonecutterRecipe(output, RecipeCategory.DECORATIONS, (ItemLike)AtmosphericBlocks.CARMINE_PAVEMENT_WALL, (ItemLike)AtmosphericBlocks.CARMINE_PAVEMENT);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.CARMINE_PAVEMENT, (ItemLike)AtmosphericBlocks.CARMINE_SHINGLES);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.CARMINE_PAVEMENT_SLAB, (ItemLike)AtmosphericBlocks.CARMINE_SHINGLES, 2);
        this.stonecutterRecipe(output, RecipeCategory.DECORATIONS, (ItemLike)AtmosphericBlocks.CARMINE_PAVEMENT_STAIRS, (ItemLike)AtmosphericBlocks.CARMINE_SHINGLES);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.CARMINE_PAVEMENT_WALL, (ItemLike)AtmosphericBlocks.CARMINE_SHINGLES);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AtmosphericItems.COCHINEAL_BANNER_PATTERN).requires((ItemLike)Items.PAPER).requires(AtmosphericItems.CARMINE_HUSK).unlockedBy("has_carmine_husk", AtmosphericRecipeProvider.has(AtmosphericItems.CARMINE_HUSK)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, AtmosphericItems.GOLDEN_DRAGON_FRUIT).define(Character.valueOf('#'), (ItemLike)Items.GOLD_INGOT).define(Character.valueOf('X'), AtmosphericItems.DRAGON_FRUIT).pattern("###").pattern("#X#").pattern("###").unlockedBy("has_gold_ingot", AtmosphericRecipeProvider.has((ItemLike)Items.GOLD_INGOT)).save(output);
        this.conditionalStorageRecipes(output, (ICondition)AtmosphericConditions.QUARK_LOADED, RecipeCategory.FOOD, (ItemLike)AtmosphericItems.DRAGON_FRUIT, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.DRAGON_FRUIT_CRATE);
        this.conditionalStorageRecipesWithCustomUnpacking(output, (ICondition)AtmosphericConditions.QUARK_LOADED, RecipeCategory.FOOD, (ItemLike)AtmosphericItems.GOLDEN_DRAGON_FRUIT, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.GOLDEN_DRAGON_FRUIT_CRATE, "golden_dragon_fruit_from_golden_dragon_fruit_crate", "golden_dragon_fruit");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, AtmosphericItems.CANDIED_ORANGE_SLICES).requires(AtmosphericItemTags.FOODS_ORANGE).requires((ItemLike)Items.SUGAR).unlockedBy("has_orange", AtmosphericRecipeProvider.has(AtmosphericItemTags.FOODS_ORANGE)).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, AtmosphericItems.ORANGE_PUDDING).requires(AtmosphericItemTags.FOODS_ORANGE).requires((ItemLike)Items.SWEET_BERRIES).requires((ItemLike)Items.COCOA_BEANS).requires(Tags.Items.EGGS).requires(Tags.Items.DRINKS_MILK).unlockedBy("has_orange", AtmosphericRecipeProvider.has(AtmosphericItemTags.FOODS_ORANGE)).save(output);
        this.conditionalStorageRecipes(output, (ICondition)AtmosphericConditions.QUARK_LOADED, RecipeCategory.FOOD, (ItemLike)AtmosphericItems.ORANGE, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.ORANGE_CRATE);
        this.conditionalStorageRecipes(output, (ICondition)AtmosphericConditions.QUARK_LOADED, RecipeCategory.FOOD, (ItemLike)AtmosphericItems.BLOOD_ORANGE, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.BLOOD_ORANGE_CRATE);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, AtmosphericItems.ORANGE_SORBET).requires((ItemLike)Items.BOWL).requires(AtmosphericItemTags.FOODS_ORANGE).requires((ItemLike)Blocks.ICE).requires((ItemLike)Items.SUGAR).unlockedBy("has_orange", AtmosphericRecipeProvider.has(AtmosphericItemTags.FOODS_ORANGE)).save(output.withConditions(new ICondition[]{AtmosphericConditions.NEAPOLITAN_NOT_LOADED}));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, AtmosphericItems.ORANGE_SORBET).requires((ItemLike)Items.BOWL).requires(AtmosphericItemTags.FOODS_ORANGE).requires(AtmosphericItemTags.ICE_CUBES).requires((ItemLike)Items.SUGAR).unlockedBy("has_orange", AtmosphericRecipeProvider.has(AtmosphericItemTags.FOODS_ORANGE)).save(output.withConditions(new ICondition[]{AtmosphericConditions.NEAPOLITAN_LOADED}), Atmospheric.location("orange_sorbet_from_ice_cubes"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, AtmosphericItems.PASSION_FRUIT_SORBET).requires((ItemLike)Items.BOWL).requires(AtmosphericItemTags.FOODS_PASSION_FRUIT).requires((ItemLike)Blocks.ICE).requires((ItemLike)Items.SUGAR).unlockedBy("has_passion_fruit", AtmosphericRecipeProvider.has(AtmosphericItemTags.FOODS_PASSION_FRUIT)).save(output.withConditions(new ICondition[]{AtmosphericConditions.NEAPOLITAN_NOT_LOADED}));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, AtmosphericItems.PASSION_FRUIT_SORBET).requires((ItemLike)Items.BOWL).requires(AtmosphericItemTags.FOODS_PASSION_FRUIT).requires(AtmosphericItemTags.ICE_CUBES).requires((ItemLike)Items.SUGAR).unlockedBy("has_passion_fruit", AtmosphericRecipeProvider.has(AtmosphericItemTags.FOODS_PASSION_FRUIT)).save(output.withConditions(new ICondition[]{AtmosphericConditions.NEAPOLITAN_LOADED}), Atmospheric.location("passion_fruit_sorbet_from_ice_cubes"));
        AtmosphericRecipeProvider.twoByTwoPacker((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, AtmosphericBlocks.CUT_IVORY_TRAVERTINE, AtmosphericBlocks.IVORY_TRAVERTINE);
        AtmosphericRecipeProvider.generateRecipes((RecipeOutput)output, (BlockFamily)AtmosphericBlockFamilies.CUT_IVORY_TRAVERTINE_FAMILY);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.IVORY_TRAVERTINE_SLAB, (ItemLike)AtmosphericBlocks.IVORY_TRAVERTINE, 2);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.IVORY_TRAVERTINE_STAIRS, (ItemLike)AtmosphericBlocks.IVORY_TRAVERTINE);
        this.stonecutterRecipe(output, RecipeCategory.DECORATIONS, (ItemLike)AtmosphericBlocks.IVORY_TRAVERTINE_WALL, (ItemLike)AtmosphericBlocks.IVORY_TRAVERTINE);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.CHISELED_IVORY_TRAVERTINE, (ItemLike)AtmosphericBlocks.IVORY_TRAVERTINE);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.CUT_IVORY_TRAVERTINE, (ItemLike)AtmosphericBlocks.IVORY_TRAVERTINE);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.IVORY_TRAVERTINE_SLAB, (ItemLike)AtmosphericBlocks.CUT_IVORY_TRAVERTINE, 2);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.IVORY_TRAVERTINE_STAIRS, (ItemLike)AtmosphericBlocks.CUT_IVORY_TRAVERTINE);
        this.stonecutterRecipe(output, RecipeCategory.DECORATIONS, (ItemLike)AtmosphericBlocks.IVORY_TRAVERTINE_WALL, (ItemLike)AtmosphericBlocks.CUT_IVORY_TRAVERTINE);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.CHISELED_IVORY_TRAVERTINE, (ItemLike)AtmosphericBlocks.CUT_IVORY_TRAVERTINE);
        AtmosphericRecipeProvider.twoByTwoPacker((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, AtmosphericBlocks.CUT_PEACH_TRAVERTINE, AtmosphericBlocks.PEACH_TRAVERTINE);
        AtmosphericRecipeProvider.generateRecipes((RecipeOutput)output, (BlockFamily)AtmosphericBlockFamilies.CUT_PEACH_TRAVERTINE_FAMILY);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.PEACH_TRAVERTINE_SLAB, (ItemLike)AtmosphericBlocks.PEACH_TRAVERTINE, 2);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.PEACH_TRAVERTINE_STAIRS, (ItemLike)AtmosphericBlocks.PEACH_TRAVERTINE);
        this.stonecutterRecipe(output, RecipeCategory.DECORATIONS, (ItemLike)AtmosphericBlocks.PEACH_TRAVERTINE_WALL, (ItemLike)AtmosphericBlocks.PEACH_TRAVERTINE);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.CHISELED_PEACH_TRAVERTINE, (ItemLike)AtmosphericBlocks.PEACH_TRAVERTINE);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.CUT_PEACH_TRAVERTINE, (ItemLike)AtmosphericBlocks.PEACH_TRAVERTINE);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.PEACH_TRAVERTINE_SLAB, (ItemLike)AtmosphericBlocks.CUT_PEACH_TRAVERTINE, 2);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.PEACH_TRAVERTINE_STAIRS, (ItemLike)AtmosphericBlocks.CUT_PEACH_TRAVERTINE);
        this.stonecutterRecipe(output, RecipeCategory.DECORATIONS, (ItemLike)AtmosphericBlocks.PEACH_TRAVERTINE_WALL, (ItemLike)AtmosphericBlocks.CUT_PEACH_TRAVERTINE);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.CHISELED_PEACH_TRAVERTINE, (ItemLike)AtmosphericBlocks.CUT_PEACH_TRAVERTINE);
        AtmosphericRecipeProvider.twoByTwoPacker((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, AtmosphericBlocks.CUT_PERSIMMON_TRAVERTINE, AtmosphericBlocks.PERSIMMON_TRAVERTINE);
        AtmosphericRecipeProvider.generateRecipes((RecipeOutput)output, (BlockFamily)AtmosphericBlockFamilies.CUT_PERSIMMON_TRAVERTINE_FAMILY);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.PERSIMMON_TRAVERTINE_SLAB, (ItemLike)AtmosphericBlocks.PERSIMMON_TRAVERTINE, 2);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.PERSIMMON_TRAVERTINE_STAIRS, (ItemLike)AtmosphericBlocks.PERSIMMON_TRAVERTINE);
        this.stonecutterRecipe(output, RecipeCategory.DECORATIONS, (ItemLike)AtmosphericBlocks.PERSIMMON_TRAVERTINE_WALL, (ItemLike)AtmosphericBlocks.PERSIMMON_TRAVERTINE);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.CHISELED_PERSIMMON_TRAVERTINE, (ItemLike)AtmosphericBlocks.PERSIMMON_TRAVERTINE);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.CUT_PERSIMMON_TRAVERTINE, (ItemLike)AtmosphericBlocks.PERSIMMON_TRAVERTINE);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.PERSIMMON_TRAVERTINE_SLAB, (ItemLike)AtmosphericBlocks.CUT_PERSIMMON_TRAVERTINE, 2);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.PERSIMMON_TRAVERTINE_STAIRS, (ItemLike)AtmosphericBlocks.CUT_PERSIMMON_TRAVERTINE);
        this.stonecutterRecipe(output, RecipeCategory.DECORATIONS, (ItemLike)AtmosphericBlocks.PERSIMMON_TRAVERTINE_WALL, (ItemLike)AtmosphericBlocks.CUT_PERSIMMON_TRAVERTINE);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.CHISELED_PERSIMMON_TRAVERTINE, (ItemLike)AtmosphericBlocks.CUT_PERSIMMON_TRAVERTINE);
        AtmosphericRecipeProvider.twoByTwoPacker((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, AtmosphericBlocks.CUT_SAFFRON_TRAVERTINE, AtmosphericBlocks.SAFFRON_TRAVERTINE);
        AtmosphericRecipeProvider.generateRecipes((RecipeOutput)output, (BlockFamily)AtmosphericBlockFamilies.CUT_SAFFRON_TRAVERTINE_FAMILY);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.SAFFRON_TRAVERTINE_SLAB, (ItemLike)AtmosphericBlocks.SAFFRON_TRAVERTINE, 2);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.SAFFRON_TRAVERTINE_STAIRS, (ItemLike)AtmosphericBlocks.SAFFRON_TRAVERTINE);
        this.stonecutterRecipe(output, RecipeCategory.DECORATIONS, (ItemLike)AtmosphericBlocks.SAFFRON_TRAVERTINE_WALL, (ItemLike)AtmosphericBlocks.SAFFRON_TRAVERTINE);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.CHISELED_SAFFRON_TRAVERTINE, (ItemLike)AtmosphericBlocks.SAFFRON_TRAVERTINE);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.CUT_SAFFRON_TRAVERTINE, (ItemLike)AtmosphericBlocks.SAFFRON_TRAVERTINE);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.SAFFRON_TRAVERTINE_SLAB, (ItemLike)AtmosphericBlocks.CUT_SAFFRON_TRAVERTINE, 2);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.SAFFRON_TRAVERTINE_STAIRS, (ItemLike)AtmosphericBlocks.CUT_SAFFRON_TRAVERTINE);
        this.stonecutterRecipe(output, RecipeCategory.DECORATIONS, (ItemLike)AtmosphericBlocks.SAFFRON_TRAVERTINE_WALL, (ItemLike)AtmosphericBlocks.CUT_SAFFRON_TRAVERTINE);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.CHISELED_SAFFRON_TRAVERTINE, (ItemLike)AtmosphericBlocks.CUT_SAFFRON_TRAVERTINE);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, AtmosphericBlocks.DOLERITE, (int)2).requires(AtmosphericItemTags.TRAVERTINE).requires((ItemLike)Blocks.COBBLESTONE).unlockedBy("has_travertine", AtmosphericRecipeProvider.has(AtmosphericItemTags.TRAVERTINE)).save(output);
        AtmosphericRecipeProvider.generateRecipes((RecipeOutput)output, (BlockFamily)AtmosphericBlockFamilies.DOLERITE_FAMILY);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.DOLERITE_SLAB, (ItemLike)AtmosphericBlocks.DOLERITE, 2);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.DOLERITE_STAIRS, (ItemLike)AtmosphericBlocks.DOLERITE);
        this.stonecutterRecipe(output, RecipeCategory.DECORATIONS, (ItemLike)AtmosphericBlocks.DOLERITE_WALL, (ItemLike)AtmosphericBlocks.DOLERITE);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.POLISHED_DOLERITE, (ItemLike)AtmosphericBlocks.DOLERITE);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.POLISHED_DOLERITE_SLAB, (ItemLike)AtmosphericBlocks.DOLERITE, 2);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.POLISHED_DOLERITE_STAIRS, (ItemLike)AtmosphericBlocks.DOLERITE);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, AtmosphericBlocks.POLISHED_DOLERITE, (int)4).define(Character.valueOf('#'), AtmosphericBlocks.DOLERITE).pattern("##").pattern("##").unlockedBy("has_dolerite", AtmosphericRecipeProvider.has(AtmosphericBlocks.DOLERITE)).save(output);
        AtmosphericRecipeProvider.generateRecipes((RecipeOutput)output, (BlockFamily)AtmosphericBlockFamilies.POLISHED_DOLERITE_FAMILY);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.POLISHED_DOLERITE_SLAB, (ItemLike)AtmosphericBlocks.POLISHED_DOLERITE, 2);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.POLISHED_DOLERITE_STAIRS, (ItemLike)AtmosphericBlocks.POLISHED_DOLERITE);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, AtmosphericBlocks.GRIMWEB).requires(AtmosphericItemTags.GRIMWOOD_LOGS).requires((ItemLike)Items.COBWEB).unlockedBy("has_grimwood", AtmosphericRecipeProvider.has(AtmosphericItemTags.GRIMWOOD_LOGS)).save(output);
        AtmosphericRecipeProvider.generateRecipes((RecipeOutput)output, (BlockFamily)AtmosphericBlockFamilies.ROSEWOOD_PLANKS_FAMILY);
        AtmosphericRecipeProvider.planksFromLogs((RecipeOutput)output, AtmosphericBlocks.ROSEWOOD_PLANKS, AtmosphericItemTags.ROSEWOOD_LOGS, (int)4);
        AtmosphericRecipeProvider.woodFromLogs((RecipeOutput)output, AtmosphericBlocks.ROSEWOOD, AtmosphericBlocks.ROSEWOOD_LOG);
        AtmosphericRecipeProvider.woodFromLogs((RecipeOutput)output, AtmosphericBlocks.STRIPPED_ROSEWOOD, AtmosphericBlocks.STRIPPED_ROSEWOOD_LOG);
        AtmosphericRecipeProvider.hangingSign((RecipeOutput)output, (ItemLike)((ItemLike)AtmosphericBlocks.ROSEWOOD_HANGING_SIGNS.getFirst()), AtmosphericBlocks.STRIPPED_ROSEWOOD_LOG);
        BoatloadRecipeProvider.boatRecipes((RecipeOutput)output, (BoatloadBoatType)AtmosphericBoatTypes.ROSEWOOD);
        WoodworksRecipeProvider.baseRecipes((RecipeOutput)output, AtmosphericBlocks.ROSEWOOD_PLANKS, AtmosphericBlocks.ROSEWOOD_SLAB, AtmosphericBlocks.ROSEWOOD_BOARDS, AtmosphericBlocks.ROSEWOOD_BOOKSHELF, AtmosphericBlocks.CHISELED_ROSEWOOD_BOOKSHELF, AtmosphericBlocks.ROSEWOOD_LADDER, AtmosphericBlocks.ROSEWOOD_BEEHIVE, AtmosphericBlocks.ROSEWOOD_CHEST, AtmosphericBlocks.TRAPPED_ROSEWOOD_CHEST, (String)"atmospheric");
        WoodworksRecipeProvider.sawmillRecipes((RecipeOutput)output, (BlockFamily)AtmosphericBlockFamilies.ROSEWOOD_PLANKS_FAMILY, AtmosphericItemTags.ROSEWOOD_LOGS, AtmosphericBlocks.ROSEWOOD_BOARDS, AtmosphericBlocks.ROSEWOOD_LADDER, (String)"atmospheric");
        WoodworksRecipeProvider.conditionalLeafPileRecipes((RecipeOutput)output, AtmosphericBlocks.ROSEWOOD_LEAVES, AtmosphericBlocks.ROSEWOOD_LEAF_PILE, (String)"atmospheric");
        this.conditionalStorageRecipes(output, (ICondition)AtmosphericConditions.QUARK_LOADED, RecipeCategory.FOOD, (ItemLike)AtmosphericItems.PASSION_FRUIT, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.PASSION_FRUIT_CRATE);
        this.conditionalStorageRecipesWithCustomUnpacking(output, (ICondition)AtmosphericConditions.QUARK_LOADED, RecipeCategory.FOOD, (ItemLike)AtmosphericItems.SHIMMERING_PASSION_FRUIT, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.SHIMMERING_PASSION_FRUIT_CRATE, "shimmering_passion_fruit_from_shimmering_passion_fruit_crate", "shimmering_passion_fruit");
        AtmosphericRecipeProvider.generateRecipes((RecipeOutput)output, (BlockFamily)AtmosphericBlockFamilies.MORADO_PLANKS_FAMILY);
        AtmosphericRecipeProvider.planksFromLogs((RecipeOutput)output, AtmosphericBlocks.MORADO_PLANKS, AtmosphericItemTags.MORADO_LOGS, (int)4);
        AtmosphericRecipeProvider.woodFromLogs((RecipeOutput)output, AtmosphericBlocks.MORADO_WOOD, AtmosphericBlocks.MORADO_LOG);
        AtmosphericRecipeProvider.woodFromLogs((RecipeOutput)output, AtmosphericBlocks.STRIPPED_MORADO_WOOD, AtmosphericBlocks.STRIPPED_MORADO_LOG);
        AtmosphericRecipeProvider.hangingSign((RecipeOutput)output, (ItemLike)((ItemLike)AtmosphericBlocks.MORADO_HANGING_SIGNS.getFirst()), AtmosphericBlocks.STRIPPED_MORADO_LOG);
        BoatloadRecipeProvider.boatRecipes((RecipeOutput)output, (BoatloadBoatType)AtmosphericBoatTypes.MORADO);
        WoodworksRecipeProvider.baseRecipes((RecipeOutput)output, AtmosphericBlocks.MORADO_PLANKS, AtmosphericBlocks.MORADO_SLAB, AtmosphericBlocks.MORADO_BOARDS, AtmosphericBlocks.MORADO_BOOKSHELF, AtmosphericBlocks.CHISELED_MORADO_BOOKSHELF, AtmosphericBlocks.MORADO_LADDER, AtmosphericBlocks.MORADO_BEEHIVE, AtmosphericBlocks.MORADO_CHEST, AtmosphericBlocks.TRAPPED_MORADO_CHEST, (String)"atmospheric");
        WoodworksRecipeProvider.sawmillRecipes((RecipeOutput)output, (BlockFamily)AtmosphericBlockFamilies.MORADO_PLANKS_FAMILY, AtmosphericItemTags.MORADO_LOGS, AtmosphericBlocks.MORADO_BOARDS, AtmosphericBlocks.MORADO_LADDER, (String)"atmospheric");
        WoodworksRecipeProvider.conditionalLeafPileRecipes((RecipeOutput)output, AtmosphericBlocks.MORADO_LEAVES, AtmosphericBlocks.MORADO_LEAF_PILE, (String)"atmospheric");
        WoodworksRecipeProvider.conditionalLeafPileRecipes((RecipeOutput)output, AtmosphericBlocks.FLOWERING_MORADO_LEAVES, AtmosphericBlocks.FLOWERING_MORADO_LEAF_PILE, (String)"atmospheric");
        AtmosphericRecipeProvider.generateRecipes((RecipeOutput)output, (BlockFamily)AtmosphericBlockFamilies.YUCCA_PLANKS_FAMILY);
        AtmosphericRecipeProvider.planksFromLogs((RecipeOutput)output, AtmosphericBlocks.YUCCA_PLANKS, AtmosphericItemTags.YUCCA_LOGS, (int)4);
        AtmosphericRecipeProvider.woodFromLogs((RecipeOutput)output, AtmosphericBlocks.YUCCA_WOOD, AtmosphericBlocks.YUCCA_LOG);
        AtmosphericRecipeProvider.woodFromLogs((RecipeOutput)output, AtmosphericBlocks.STRIPPED_YUCCA_WOOD, AtmosphericBlocks.STRIPPED_YUCCA_LOG);
        AtmosphericRecipeProvider.hangingSign((RecipeOutput)output, (ItemLike)((ItemLike)AtmosphericBlocks.YUCCA_HANGING_SIGNS.getFirst()), AtmosphericBlocks.STRIPPED_YUCCA_LOG);
        BoatloadRecipeProvider.boatRecipes((RecipeOutput)output, (BoatloadBoatType)AtmosphericBoatTypes.YUCCA);
        WoodworksRecipeProvider.baseRecipes((RecipeOutput)output, AtmosphericBlocks.YUCCA_PLANKS, AtmosphericBlocks.YUCCA_SLAB, AtmosphericBlocks.YUCCA_BOARDS, AtmosphericBlocks.YUCCA_BOOKSHELF, AtmosphericBlocks.CHISELED_YUCCA_BOOKSHELF, AtmosphericBlocks.YUCCA_LADDER, AtmosphericBlocks.YUCCA_BEEHIVE, AtmosphericBlocks.YUCCA_CHEST, AtmosphericBlocks.TRAPPED_YUCCA_CHEST, (String)"atmospheric");
        WoodworksRecipeProvider.sawmillRecipes((RecipeOutput)output, (BlockFamily)AtmosphericBlockFamilies.YUCCA_PLANKS_FAMILY, AtmosphericItemTags.YUCCA_LOGS, AtmosphericBlocks.YUCCA_BOARDS, AtmosphericBlocks.YUCCA_LADDER, (String)"atmospheric");
        WoodworksRecipeProvider.conditionalLeafPileRecipes((RecipeOutput)output, AtmosphericBlocks.YUCCA_LEAVES, AtmosphericBlocks.YUCCA_LEAF_PILE, (String)"atmospheric");
        AtmosphericRecipeProvider.foodCookingRecipes((RecipeOutput)output, AtmosphericItems.YUCCA_FRUIT, AtmosphericItems.ROASTED_YUCCA_FRUIT);
        AtmosphericRecipeProvider.foodCookingRecipes((RecipeOutput)output, AtmosphericBlocks.YUCCA_BUNDLE, AtmosphericBlocks.ROASTED_YUCCA_BUNDLE);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, AtmosphericBlocks.YUCCA_GATEAU).define(Character.valueOf('R'), AtmosphericItems.ROASTED_YUCCA_FRUIT).define(Character.valueOf('Y'), AtmosphericItems.ALOE_GEL_BOTTLE).define(Character.valueOf('#'), (ItemLike)Items.WHEAT).define(Character.valueOf('X'), AtmosphericBlocks.YUCCA_FLOWER).pattern("RYR").pattern("#X#").unlockedBy("has_roasted_yucca_fruit", AtmosphericRecipeProvider.has(AtmosphericItems.ROASTED_YUCCA_FRUIT)).save(output);
        this.conditionalStorageRecipes(output, (ICondition)AtmosphericConditions.QUARK_LOADED, RecipeCategory.FOOD, (ItemLike)AtmosphericItems.YUCCA_FRUIT, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.YUCCA_CASK);
        this.conditionalStorageRecipesWithCustomUnpacking(output, (ICondition)AtmosphericConditions.QUARK_LOADED, RecipeCategory.FOOD, (ItemLike)AtmosphericItems.ROASTED_YUCCA_FRUIT, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.ROASTED_YUCCA_CASK, "roasted_yucca_fruit_from_roasted_yucca_cask", "roasted_yucca_fruit");
        AtmosphericRecipeProvider.generateRecipes((RecipeOutput)output, (BlockFamily)AtmosphericBlockFamilies.ASPEN_PLANKS_FAMILY);
        AtmosphericRecipeProvider.planksFromLogs((RecipeOutput)output, AtmosphericBlocks.ASPEN_PLANKS, AtmosphericItemTags.ASPEN_LOGS, (int)4);
        AtmosphericRecipeProvider.woodFromLogs((RecipeOutput)output, AtmosphericBlocks.ASPEN_WOOD, AtmosphericBlocks.ASPEN_LOG);
        AtmosphericRecipeProvider.woodFromLogs((RecipeOutput)output, AtmosphericBlocks.STRIPPED_ASPEN_WOOD, AtmosphericBlocks.STRIPPED_ASPEN_LOG);
        AtmosphericRecipeProvider.woodFromLogs((RecipeOutput)output, AtmosphericBlocks.WATCHFUL_ASPEN_WOOD, AtmosphericBlocks.WATCHFUL_ASPEN_LOG);
        AtmosphericRecipeProvider.woodFromLogs((RecipeOutput)output, AtmosphericBlocks.CRUSTOSE_WOOD, AtmosphericBlocks.CRUSTOSE_LOG);
        AtmosphericRecipeProvider.hangingSign((RecipeOutput)output, (ItemLike)((ItemLike)AtmosphericBlocks.ASPEN_HANGING_SIGNS.getFirst()), AtmosphericBlocks.STRIPPED_ASPEN_LOG);
        BoatloadRecipeProvider.boatRecipes((RecipeOutput)output, (BoatloadBoatType)AtmosphericBoatTypes.ASPEN);
        WoodworksRecipeProvider.baseRecipes((RecipeOutput)output, AtmosphericBlocks.ASPEN_PLANKS, AtmosphericBlocks.ASPEN_SLAB, AtmosphericBlocks.ASPEN_BOARDS, AtmosphericBlocks.ASPEN_BOOKSHELF, AtmosphericBlocks.CHISELED_ASPEN_BOOKSHELF, AtmosphericBlocks.ASPEN_LADDER, AtmosphericBlocks.ASPEN_BEEHIVE, AtmosphericBlocks.ASPEN_CHEST, AtmosphericBlocks.TRAPPED_ASPEN_CHEST, (String)"atmospheric");
        WoodworksRecipeProvider.sawmillRecipes((RecipeOutput)output, (BlockFamily)AtmosphericBlockFamilies.ASPEN_PLANKS_FAMILY, AtmosphericItemTags.ASPEN_LOGS, AtmosphericBlocks.ASPEN_BOARDS, AtmosphericBlocks.ASPEN_LADDER, (String)"atmospheric");
        WoodworksRecipeProvider.conditionalLeafPileRecipes((RecipeOutput)output, AtmosphericBlocks.ASPEN_LEAVES, AtmosphericBlocks.ASPEN_LEAF_PILE, (String)"atmospheric");
        WoodworksRecipeProvider.conditionalLeafPileRecipes((RecipeOutput)output, AtmosphericBlocks.GREEN_ASPEN_LEAVES, AtmosphericBlocks.GREEN_ASPEN_LEAF_PILE, (String)"atmospheric");
        AtmosphericRecipeProvider.generateRecipes((RecipeOutput)output, (BlockFamily)AtmosphericBlockFamilies.LAUREL_PLANKS_FAMILY);
        AtmosphericRecipeProvider.planksFromLogs((RecipeOutput)output, AtmosphericBlocks.LAUREL_PLANKS, AtmosphericItemTags.LAUREL_LOGS, (int)4);
        AtmosphericRecipeProvider.woodFromLogs((RecipeOutput)output, AtmosphericBlocks.LAUREL_WOOD, AtmosphericBlocks.LAUREL_LOG);
        AtmosphericRecipeProvider.woodFromLogs((RecipeOutput)output, AtmosphericBlocks.STRIPPED_LAUREL_WOOD, AtmosphericBlocks.STRIPPED_LAUREL_LOG);
        AtmosphericRecipeProvider.hangingSign((RecipeOutput)output, (ItemLike)((ItemLike)AtmosphericBlocks.LAUREL_HANGING_SIGNS.getFirst()), AtmosphericBlocks.STRIPPED_LAUREL_LOG);
        BoatloadRecipeProvider.boatRecipes((RecipeOutput)output, (BoatloadBoatType)AtmosphericBoatTypes.LAUREL);
        WoodworksRecipeProvider.baseRecipes((RecipeOutput)output, AtmosphericBlocks.LAUREL_PLANKS, AtmosphericBlocks.LAUREL_SLAB, AtmosphericBlocks.LAUREL_BOARDS, AtmosphericBlocks.LAUREL_BOOKSHELF, AtmosphericBlocks.CHISELED_LAUREL_BOOKSHELF, AtmosphericBlocks.LAUREL_LADDER, AtmosphericBlocks.LAUREL_BEEHIVE, AtmosphericBlocks.LAUREL_CHEST, AtmosphericBlocks.TRAPPED_LAUREL_CHEST, (String)"atmospheric");
        WoodworksRecipeProvider.sawmillRecipes((RecipeOutput)output, (BlockFamily)AtmosphericBlockFamilies.LAUREL_PLANKS_FAMILY, AtmosphericItemTags.LAUREL_LOGS, AtmosphericBlocks.LAUREL_BOARDS, AtmosphericBlocks.LAUREL_LADDER, (String)"atmospheric");
        WoodworksRecipeProvider.conditionalLeafPileRecipes((RecipeOutput)output, AtmosphericBlocks.LAUREL_LEAVES, AtmosphericBlocks.LAUREL_LEAF_PILE, (String)"atmospheric");
        WoodworksRecipeProvider.conditionalLeafPileRecipes((RecipeOutput)output, AtmosphericBlocks.DRY_LAUREL_LEAVES, AtmosphericBlocks.DRY_LAUREL_LEAF_PILE, (String)"atmospheric");
        AtmosphericRecipeProvider.generateRecipes((RecipeOutput)output, (BlockFamily)AtmosphericBlockFamilies.KOUSA_PLANKS_FAMILY);
        AtmosphericRecipeProvider.planksFromLogs((RecipeOutput)output, AtmosphericBlocks.KOUSA_PLANKS, AtmosphericItemTags.KOUSA_LOGS, (int)4);
        AtmosphericRecipeProvider.woodFromLogs((RecipeOutput)output, AtmosphericBlocks.KOUSA_WOOD, AtmosphericBlocks.KOUSA_LOG);
        AtmosphericRecipeProvider.woodFromLogs((RecipeOutput)output, AtmosphericBlocks.STRIPPED_KOUSA_WOOD, AtmosphericBlocks.STRIPPED_KOUSA_LOG);
        AtmosphericRecipeProvider.hangingSign((RecipeOutput)output, (ItemLike)((ItemLike)AtmosphericBlocks.KOUSA_HANGING_SIGNS.getFirst()), AtmosphericBlocks.STRIPPED_KOUSA_LOG);
        BoatloadRecipeProvider.boatRecipes((RecipeOutput)output, (BoatloadBoatType)AtmosphericBoatTypes.KOUSA);
        WoodworksRecipeProvider.baseRecipes((RecipeOutput)output, AtmosphericBlocks.KOUSA_PLANKS, AtmosphericBlocks.KOUSA_SLAB, AtmosphericBlocks.KOUSA_BOARDS, AtmosphericBlocks.KOUSA_BOOKSHELF, AtmosphericBlocks.CHISELED_KOUSA_BOOKSHELF, AtmosphericBlocks.KOUSA_LADDER, AtmosphericBlocks.KOUSA_BEEHIVE, AtmosphericBlocks.KOUSA_CHEST, AtmosphericBlocks.TRAPPED_KOUSA_CHEST, (String)"atmospheric");
        WoodworksRecipeProvider.sawmillRecipes((RecipeOutput)output, (BlockFamily)AtmosphericBlockFamilies.KOUSA_PLANKS_FAMILY, AtmosphericItemTags.KOUSA_LOGS, AtmosphericBlocks.KOUSA_BOARDS, AtmosphericBlocks.KOUSA_LADDER, (String)"atmospheric");
        WoodworksRecipeProvider.conditionalLeafPileRecipes((RecipeOutput)output, AtmosphericBlocks.KOUSA_LEAVES, AtmosphericBlocks.KOUSA_LEAF_PILE, (String)"atmospheric");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, AtmosphericItems.ALOE_GEL_BOTTLE, (int)4).requires(AtmosphericBlocks.ALOE_GEL_BLOCK).requires((ItemLike)Items.GLASS_BOTTLE, 4).unlockedBy("has_aloe_gel_block", AtmosphericRecipeProvider.has(AtmosphericBlocks.ALOE_GEL_BLOCK)).save(output, this.getModConversionRecipeName((ItemLike)AtmosphericItems.ALOE_GEL_BOTTLE, (ItemLike)AtmosphericBlocks.ALOE_GEL_BLOCK));
        AtmosphericRecipeProvider.twoByTwoPacker((RecipeOutput)output, (RecipeCategory)RecipeCategory.REDSTONE, AtmosphericBlocks.ALOE_GEL_BLOCK, AtmosphericItems.ALOE_GEL_BOTTLE);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, AtmosphericItems.ALOE_GEL_BOTTLE).requires(AtmosphericItems.ALOE_LEAVES, 8).requires((ItemLike)Items.GLASS_BOTTLE).unlockedBy("has_aloe_leaves", AtmosphericRecipeProvider.has(AtmosphericItems.ALOE_LEAVES)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BREWING, AtmosphericItems.SHIMMERING_PASSION_FRUIT).define(Character.valueOf('#'), Tags.Items.NUGGETS_GOLD).define(Character.valueOf('X'), AtmosphericItems.PASSION_FRUIT).pattern("###").pattern("#X#").pattern("###").unlockedBy("has_passion_fruit", AtmosphericRecipeProvider.has(AtmosphericItems.PASSION_FRUIT)).save(output);
        AtmosphericRecipeProvider.twoByTwoPacker((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, AtmosphericBlocks.CURRANT_STALK_BUNDLE, AtmosphericBlocks.CURRANT_STALK);
        WoodworksRecipeProvider.conditionalLeafPileRecipes((RecipeOutput)output, AtmosphericBlocks.CURRANT_LEAVES, AtmosphericBlocks.CURRANT_LEAF_PILE, (String)"atmospheric");
        AtmosphericRecipeProvider.threeByThreePacker((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, AtmosphericBlocks.ALOE_BUNDLE, AtmosphericItems.ALOE_LEAVES);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AtmosphericItems.ALOE_LEAVES, (int)9).requires(AtmosphericBlocks.ALOE_BUNDLE).unlockedBy("has_aloe_bundle", AtmosphericRecipeProvider.has(AtmosphericBlocks.ALOE_BUNDLE)).save(output);
        AtmosphericRecipeProvider.threeByThreePacker((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, AtmosphericBlocks.PASSION_VINE_BUNDLE, AtmosphericBlocks.PASSION_VINE);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AtmosphericBlocks.PASSION_VINE, (int)9).requires(AtmosphericBlocks.PASSION_VINE_BUNDLE).unlockedBy("has_passion_vine_bundle", AtmosphericRecipeProvider.has(AtmosphericBlocks.PASSION_VINE_BUNDLE)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, AtmosphericItems.PASSION_VINE_COIL).define(Character.valueOf('#'), AtmosphericBlocks.PASSION_VINE).pattern("###").pattern("# #").pattern("###").unlockedBy("has_passion_vine", AtmosphericRecipeProvider.has(AtmosphericBlocks.PASSION_VINE)).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AtmosphericBlocks.PASSION_VINE, (int)8).requires(AtmosphericItems.PASSION_VINE_COIL).unlockedBy("has_passion_vine_coil", AtmosphericRecipeProvider.has(AtmosphericItems.PASSION_VINE_COIL)).save(output, this.getModConversionRecipeName((ItemLike)AtmosphericBlocks.PASSION_VINE, (ItemLike)AtmosphericItems.PASSION_VINE_COIL));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, AtmosphericItems.PASSION_FRUIT_TART).define(Character.valueOf('#'), AtmosphericItemTags.FOODS_PASSION_FRUIT).define(Character.valueOf('X'), Tags.Items.EGGS).pattern("###").pattern("#X#").pattern("###").unlockedBy("has_passion_fruit", AtmosphericRecipeProvider.has(AtmosphericItemTags.FOODS_PASSION_FRUIT)).save(output);
        AtmosphericRecipeProvider.generateRecipes((RecipeOutput)output, (BlockFamily)AtmosphericBlockFamilies.GRIMWOOD_PLANKS_FAMILY);
        AtmosphericRecipeProvider.planksFromLogs((RecipeOutput)output, AtmosphericBlocks.GRIMWOOD_PLANKS, AtmosphericItemTags.GRIMWOOD_LOGS, (int)4);
        AtmosphericRecipeProvider.woodFromLogs((RecipeOutput)output, AtmosphericBlocks.GRIMWOOD, AtmosphericBlocks.GRIMWOOD_LOG);
        AtmosphericRecipeProvider.woodFromLogs((RecipeOutput)output, AtmosphericBlocks.STRIPPED_GRIMWOOD, AtmosphericBlocks.STRIPPED_GRIMWOOD_LOG);
        AtmosphericRecipeProvider.hangingSign((RecipeOutput)output, (ItemLike)((ItemLike)AtmosphericBlocks.GRIMWOOD_HANGING_SIGNS.getFirst()), AtmosphericBlocks.STRIPPED_GRIMWOOD_LOG);
        BoatloadRecipeProvider.boatRecipes((RecipeOutput)output, (BoatloadBoatType)AtmosphericBoatTypes.GRIMWOOD);
        WoodworksRecipeProvider.baseRecipes((RecipeOutput)output, AtmosphericBlocks.GRIMWOOD_PLANKS, AtmosphericBlocks.GRIMWOOD_SLAB, AtmosphericBlocks.GRIMWOOD_BOARDS, AtmosphericBlocks.GRIMWOOD_BOOKSHELF, AtmosphericBlocks.CHISELED_GRIMWOOD_BOOKSHELF, AtmosphericBlocks.GRIMWOOD_LADDER, AtmosphericBlocks.GRIMWOOD_BEEHIVE, AtmosphericBlocks.GRIMWOOD_CHEST, AtmosphericBlocks.TRAPPED_GRIMWOOD_CHEST, (String)"atmospheric");
        WoodworksRecipeProvider.sawmillRecipes((RecipeOutput)output, (BlockFamily)AtmosphericBlockFamilies.GRIMWOOD_PLANKS_FAMILY, AtmosphericItemTags.GRIMWOOD_LOGS, AtmosphericBlocks.GRIMWOOD_BOARDS, AtmosphericBlocks.GRIMWOOD_LADDER, (String)"atmospheric");
        WoodworksRecipeProvider.conditionalLeafPileRecipes((RecipeOutput)output, AtmosphericBlocks.GRIMWOOD_LEAVES, AtmosphericBlocks.GRIMWOOD_LEAF_PILE, (String)"atmospheric");
        AtmosphericRecipeProvider.twoByTwoPacker((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, AtmosphericBlocks.ARID_SANDSTONE, AtmosphericBlocks.ARID_SAND);
        AtmosphericRecipeProvider.generateRecipes((RecipeOutput)output, (BlockFamily)AtmosphericBlockFamilies.ARID_SANDSTONE_FAMILY);
        AtmosphericRecipeProvider.generateRecipes((RecipeOutput)output, (BlockFamily)AtmosphericBlockFamilies.CUT_ARID_SANDSTONE_FAMILY);
        AtmosphericRecipeProvider.generateRecipes((RecipeOutput)output, (BlockFamily)AtmosphericBlockFamilies.SMOOTH_ARID_SANDSTONE_FAMILY);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.ARID_SANDSTONE_SLAB, (ItemLike)AtmosphericBlocks.ARID_SANDSTONE, 2);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.ARID_SANDSTONE_STAIRS, (ItemLike)AtmosphericBlocks.ARID_SANDSTONE);
        this.stonecutterRecipe(output, RecipeCategory.DECORATIONS, (ItemLike)AtmosphericBlocks.ARID_SANDSTONE_WALL, (ItemLike)AtmosphericBlocks.ARID_SANDSTONE);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.CHISELED_ARID_SANDSTONE, (ItemLike)AtmosphericBlocks.ARID_SANDSTONE);
        this.stonecutterRecipe(output, RecipeCategory.DECORATIONS, (ItemLike)AtmosphericBlocks.CUT_ARID_SANDSTONE, (ItemLike)AtmosphericBlocks.ARID_SANDSTONE);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.CUT_ARID_SANDSTONE_SLAB, (ItemLike)AtmosphericBlocks.ARID_SANDSTONE, 2);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.CUT_ARID_SANDSTONE_SLAB, (ItemLike)AtmosphericBlocks.CUT_ARID_SANDSTONE, 2);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.SMOOTH_ARID_SANDSTONE_SLAB, (ItemLike)AtmosphericBlocks.SMOOTH_ARID_SANDSTONE, 2);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.SMOOTH_ARID_SANDSTONE_STAIRS, (ItemLike)AtmosphericBlocks.SMOOTH_ARID_SANDSTONE);
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtmosphericBlocks.ARID_SANDSTONE}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, AtmosphericBlocks.SMOOTH_ARID_SANDSTONE, (float)0.1f, (int)200).unlockedBy("has_arid_sandstone", AtmosphericRecipeProvider.has(AtmosphericBlocks.ARID_SANDSTONE)).save(output);
        AtmosphericRecipeProvider.twoByTwoPacker((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, AtmosphericBlocks.RED_ARID_SANDSTONE, AtmosphericBlocks.RED_ARID_SAND);
        AtmosphericRecipeProvider.generateRecipes((RecipeOutput)output, (BlockFamily)AtmosphericBlockFamilies.RED_ARID_SANDSTONE_FAMILY);
        AtmosphericRecipeProvider.generateRecipes((RecipeOutput)output, (BlockFamily)AtmosphericBlockFamilies.CUT_RED_ARID_SANDSTONE_FAMILY);
        AtmosphericRecipeProvider.generateRecipes((RecipeOutput)output, (BlockFamily)AtmosphericBlockFamilies.SMOOTH_RED_ARID_SANDSTONE_FAMILY);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.RED_ARID_SANDSTONE_SLAB, (ItemLike)AtmosphericBlocks.RED_ARID_SANDSTONE, 2);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.RED_ARID_SANDSTONE_STAIRS, (ItemLike)AtmosphericBlocks.RED_ARID_SANDSTONE);
        this.stonecutterRecipe(output, RecipeCategory.DECORATIONS, (ItemLike)AtmosphericBlocks.RED_ARID_SANDSTONE_WALL, (ItemLike)AtmosphericBlocks.RED_ARID_SANDSTONE);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.CHISELED_RED_ARID_SANDSTONE, (ItemLike)AtmosphericBlocks.RED_ARID_SANDSTONE);
        this.stonecutterRecipe(output, RecipeCategory.DECORATIONS, (ItemLike)AtmosphericBlocks.CUT_RED_ARID_SANDSTONE, (ItemLike)AtmosphericBlocks.RED_ARID_SANDSTONE);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.CUT_RED_ARID_SANDSTONE_SLAB, (ItemLike)AtmosphericBlocks.RED_ARID_SANDSTONE, 2);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.CUT_RED_ARID_SANDSTONE_SLAB, (ItemLike)AtmosphericBlocks.CUT_RED_ARID_SANDSTONE, 2);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.SMOOTH_RED_ARID_SANDSTONE_SLAB, (ItemLike)AtmosphericBlocks.SMOOTH_RED_ARID_SANDSTONE, 2);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)AtmosphericBlocks.SMOOTH_RED_ARID_SANDSTONE_STAIRS, (ItemLike)AtmosphericBlocks.SMOOTH_RED_ARID_SANDSTONE);
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtmosphericBlocks.RED_ARID_SANDSTONE}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, AtmosphericBlocks.SMOOTH_RED_ARID_SANDSTONE, (float)0.1f, (int)200).unlockedBy("has_red_arid_sandstone", AtmosphericRecipeProvider.has(AtmosphericBlocks.RED_ARID_SANDSTONE)).save(output);
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of(AtmosphericItemTags.SMELTS_TO_ARID_GLASS), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, AtmosphericBlocks.ARID_GLASS, (float)0.1f, (int)200).unlockedBy("has_smelts_to_arid_glass", AtmosphericRecipeProvider.has(AtmosphericItemTags.SMELTS_TO_ARID_GLASS)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, AtmosphericBlocks.ARID_GLASS_PANE, (int)16).define(Character.valueOf('#'), AtmosphericBlocks.ARID_GLASS).pattern("###").pattern("###").unlockedBy("has_arid_glass", AtmosphericRecipeProvider.has(AtmosphericBlocks.ARID_GLASS)).save(output);
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtmosphericBlocks.ARID_GLASS}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.GLASS, (float)0.1f, (int)200).unlockedBy("has_arid_glass", AtmosphericRecipeProvider.has(AtmosphericBlocks.ARID_GLASS)).save(output, this.getModConversionRecipeName((ItemLike)Blocks.GLASS, (ItemLike)AtmosphericBlocks.ARID_GLASS));
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AtmosphericBlocks.ARID_GLASS_PANE}), (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Blocks.GLASS_PANE, (float)0.1f, (int)200).unlockedBy("has_arid_glass_pane", AtmosphericRecipeProvider.has(AtmosphericBlocks.ARID_GLASS_PANE)).save(output, this.getModConversionRecipeName((ItemLike)Blocks.GLASS_PANE, (ItemLike)AtmosphericBlocks.ARID_GLASS_PANE));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Blocks.BEACON).define(Character.valueOf('S'), (ItemLike)Items.NETHER_STAR).define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS_COLORLESS).define(Character.valueOf('O'), (ItemLike)Blocks.OBSIDIAN).pattern("GGG").pattern("GSG").pattern("OOO").unlockedBy("has_nether_star", AtmosphericRecipeProvider.has((ItemLike)Items.NETHER_STAR)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)Blocks.DAYLIGHT_DETECTOR).define(Character.valueOf('Q'), (ItemLike)Items.QUARTZ).define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS_COLORLESS).define(Character.valueOf('W'), Ingredient.of((TagKey)ItemTags.WOODEN_SLABS)).pattern("GGG").pattern("QQQ").pattern("WWW").unlockedBy("has_quartz", AtmosphericRecipeProvider.has((ItemLike)Items.QUARTZ)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Items.END_CRYSTAL).define(Character.valueOf('T'), (ItemLike)Items.GHAST_TEAR).define(Character.valueOf('E'), (ItemLike)Items.ENDER_EYE).define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS_COLORLESS).pattern("GGG").pattern("GEG").pattern("GTG").unlockedBy("has_ender_eye", AtmosphericRecipeProvider.has((ItemLike)Items.ENDER_EYE)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BREWING, (ItemLike)Items.GLASS_BOTTLE, (int)3).define(Character.valueOf('#'), Tags.Items.GLASS_BLOCKS_COLORLESS).pattern("# #").pattern(" # ").unlockedBy("has_glass", AtmosphericRecipeProvider.has((ItemLike)Blocks.GLASS)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.TINTED_GLASS, (int)2).define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS_COLORLESS).define(Character.valueOf('S'), Tags.Items.GEMS_AMETHYST).pattern(" S ").pattern("SGS").pattern(" S ").unlockedBy("has_amethyst_shard", AtmosphericRecipeProvider.has((ItemLike)Items.AMETHYST_SHARD)).save(output);
        AtmosphericRecipeProvider.stainedGlassFromGlassAndDye(output, (ItemLike)Blocks.BLACK_STAINED_GLASS, (ItemLike)Items.BLACK_DYE);
        AtmosphericRecipeProvider.stainedGlassPaneFromGlassPaneAndDye(output, (ItemLike)Blocks.BLACK_STAINED_GLASS_PANE, (ItemLike)Items.BLACK_DYE);
        AtmosphericRecipeProvider.stainedGlassFromGlassAndDye(output, (ItemLike)Blocks.BLUE_STAINED_GLASS, (ItemLike)Items.BLUE_DYE);
        AtmosphericRecipeProvider.stainedGlassPaneFromGlassPaneAndDye(output, (ItemLike)Blocks.BLUE_STAINED_GLASS_PANE, (ItemLike)Items.BLUE_DYE);
        AtmosphericRecipeProvider.stainedGlassFromGlassAndDye(output, (ItemLike)Blocks.BROWN_STAINED_GLASS, (ItemLike)Items.BROWN_DYE);
        AtmosphericRecipeProvider.stainedGlassPaneFromGlassPaneAndDye(output, (ItemLike)Blocks.BROWN_STAINED_GLASS_PANE, (ItemLike)Items.BROWN_DYE);
        AtmosphericRecipeProvider.stainedGlassFromGlassAndDye(output, (ItemLike)Blocks.CYAN_STAINED_GLASS, (ItemLike)Items.CYAN_DYE);
        AtmosphericRecipeProvider.stainedGlassPaneFromGlassPaneAndDye(output, (ItemLike)Blocks.CYAN_STAINED_GLASS_PANE, (ItemLike)Items.CYAN_DYE);
        AtmosphericRecipeProvider.stainedGlassFromGlassAndDye(output, (ItemLike)Blocks.GRAY_STAINED_GLASS, (ItemLike)Items.GRAY_DYE);
        AtmosphericRecipeProvider.stainedGlassPaneFromGlassPaneAndDye(output, (ItemLike)Blocks.GRAY_STAINED_GLASS_PANE, (ItemLike)Items.GRAY_DYE);
        AtmosphericRecipeProvider.stainedGlassFromGlassAndDye(output, (ItemLike)Blocks.GREEN_STAINED_GLASS, (ItemLike)Items.GREEN_DYE);
        AtmosphericRecipeProvider.stainedGlassPaneFromGlassPaneAndDye(output, (ItemLike)Blocks.GREEN_STAINED_GLASS_PANE, (ItemLike)Items.GREEN_DYE);
        AtmosphericRecipeProvider.stainedGlassFromGlassAndDye(output, (ItemLike)Blocks.LIGHT_BLUE_STAINED_GLASS, (ItemLike)Items.LIGHT_BLUE_DYE);
        AtmosphericRecipeProvider.stainedGlassPaneFromGlassPaneAndDye(output, (ItemLike)Blocks.LIGHT_BLUE_STAINED_GLASS_PANE, (ItemLike)Items.LIGHT_BLUE_DYE);
        AtmosphericRecipeProvider.stainedGlassFromGlassAndDye(output, (ItemLike)Blocks.LIGHT_GRAY_STAINED_GLASS, (ItemLike)Items.LIGHT_GRAY_DYE);
        AtmosphericRecipeProvider.stainedGlassPaneFromGlassPaneAndDye(output, (ItemLike)Blocks.LIGHT_GRAY_STAINED_GLASS_PANE, (ItemLike)Items.LIGHT_GRAY_DYE);
        AtmosphericRecipeProvider.stainedGlassFromGlassAndDye(output, (ItemLike)Blocks.LIME_STAINED_GLASS, (ItemLike)Items.LIME_DYE);
        AtmosphericRecipeProvider.stainedGlassPaneFromGlassPaneAndDye(output, (ItemLike)Blocks.LIME_STAINED_GLASS_PANE, (ItemLike)Items.LIME_DYE);
        AtmosphericRecipeProvider.stainedGlassFromGlassAndDye(output, (ItemLike)Blocks.MAGENTA_STAINED_GLASS, (ItemLike)Items.MAGENTA_DYE);
        AtmosphericRecipeProvider.stainedGlassPaneFromGlassPaneAndDye(output, (ItemLike)Blocks.MAGENTA_STAINED_GLASS_PANE, (ItemLike)Items.MAGENTA_DYE);
        AtmosphericRecipeProvider.stainedGlassFromGlassAndDye(output, (ItemLike)Blocks.ORANGE_STAINED_GLASS, (ItemLike)Items.ORANGE_DYE);
        AtmosphericRecipeProvider.stainedGlassPaneFromGlassPaneAndDye(output, (ItemLike)Blocks.ORANGE_STAINED_GLASS_PANE, (ItemLike)Items.ORANGE_DYE);
        AtmosphericRecipeProvider.stainedGlassFromGlassAndDye(output, (ItemLike)Blocks.PINK_STAINED_GLASS, (ItemLike)Items.PINK_DYE);
        AtmosphericRecipeProvider.stainedGlassPaneFromGlassPaneAndDye(output, (ItemLike)Blocks.PINK_STAINED_GLASS_PANE, (ItemLike)Items.PINK_DYE);
        AtmosphericRecipeProvider.stainedGlassFromGlassAndDye(output, (ItemLike)Blocks.PURPLE_STAINED_GLASS, (ItemLike)Items.PURPLE_DYE);
        AtmosphericRecipeProvider.stainedGlassPaneFromGlassPaneAndDye(output, (ItemLike)Blocks.PURPLE_STAINED_GLASS_PANE, (ItemLike)Items.PURPLE_DYE);
        AtmosphericRecipeProvider.stainedGlassFromGlassAndDye(output, (ItemLike)Blocks.RED_STAINED_GLASS, (ItemLike)Items.RED_DYE);
        AtmosphericRecipeProvider.stainedGlassPaneFromGlassPaneAndDye(output, (ItemLike)Blocks.RED_STAINED_GLASS_PANE, (ItemLike)Items.RED_DYE);
        AtmosphericRecipeProvider.stainedGlassFromGlassAndDye(output, (ItemLike)Blocks.WHITE_STAINED_GLASS, (ItemLike)Items.WHITE_DYE);
        AtmosphericRecipeProvider.stainedGlassPaneFromGlassPaneAndDye(output, (ItemLike)Blocks.WHITE_STAINED_GLASS_PANE, (ItemLike)Items.WHITE_DYE);
        AtmosphericRecipeProvider.stainedGlassFromGlassAndDye(output, (ItemLike)Blocks.YELLOW_STAINED_GLASS, (ItemLike)Items.YELLOW_DYE);
        AtmosphericRecipeProvider.stainedGlassPaneFromGlassPaneAndDye(output, (ItemLike)Blocks.YELLOW_STAINED_GLASS_PANE, (ItemLike)Items.YELLOW_DYE);
        ClayworksRecipeProvider.bakingRecipe((RecipeOutput)output, (RecipeCategory)RecipeCategory.MISC, AtmosphericBlocks.AGAVE, (ItemLike)Items.CYAN_DYE, (float)1.0f, (int)100, (String)"atmospheric");
        ClayworksRecipeProvider.bakingRecipe((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, AtmosphericBlocks.ARID_SANDSTONE, AtmosphericBlocks.SMOOTH_ARID_SANDSTONE, (float)0.1f, (int)100, (String)"atmospheric");
        ClayworksRecipeProvider.bakingRecipe((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, AtmosphericBlocks.RED_ARID_SANDSTONE, AtmosphericBlocks.SMOOTH_RED_ARID_SANDSTONE, (float)0.1f, (int)100, (String)"atmospheric");
        ClayworksRecipeProvider.bakingRecipe((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, AtmosphericItemTags.SMELTS_TO_ARID_GLASS, (String)"has_smelts_to_arid_glass", AtmosphericBlocks.ARID_GLASS, (float)0.1f, (int)100, (String)"atmospheric");
        ClayworksRecipeProvider.bakingRecipe((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, AtmosphericBlocks.ARID_GLASS, (ItemLike)Blocks.GLASS, (float)0.1f, (int)100, (String)"atmospheric");
        ClayworksRecipeProvider.bakingRecipe((RecipeOutput)output, (RecipeCategory)RecipeCategory.DECORATIONS, AtmosphericBlocks.ARID_GLASS_PANE, (ItemLike)Blocks.GLASS_PANE, (float)0.1f, (int)100, (String)"atmospheric");
    }

    protected static void stainedGlassFromGlassAndDye(RecipeOutput output, ItemLike glass, ItemLike dye) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)glass, (int)8).define(Character.valueOf('#'), Tags.Items.GLASS_BLOCKS_COLORLESS).define(Character.valueOf('X'), dye).pattern("###").pattern("#X#").pattern("###").group("stained_glass").unlockedBy("has_glass", AtmosphericRecipeProvider.has((ItemLike)Blocks.GLASS)).save(output);
    }

    protected static void stainedGlassPaneFromGlassPaneAndDye(RecipeOutput output, ItemLike glassPane, ItemLike dye) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)glassPane, (int)8).define(Character.valueOf('#'), Tags.Items.GLASS_PANES_COLORLESS).define(Character.valueOf('$'), dye).pattern("###").pattern("#$#").pattern("###").group("stained_glass_pane").unlockedBy("has_glass_pane", AtmosphericRecipeProvider.has((ItemLike)Blocks.GLASS_PANE)).unlockedBy(AtmosphericRecipeProvider.getHasName((ItemLike)dye), AtmosphericRecipeProvider.has((ItemLike)dye)).save(output, AtmosphericRecipeProvider.getConversionRecipeName((ItemLike)glassPane, (ItemLike)Blocks.GLASS_PANE));
    }
}

