/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.core.data.server.modifiers;

import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.atmospheric.core.registry.AtmosphericEntityTypes;
import com.teamabnormals.atmospheric.core.registry.AtmosphericItems;
import com.teamabnormals.atmospheric.core.registry.AtmosphericMobEffects;
import com.teamabnormals.atmospheric.core.registry.datapack.AtmosphericBiomes;
import com.teamabnormals.blueprint.common.advancement.modification.AdvancementModifierProvider;
import com.teamabnormals.blueprint.common.advancement.modification.modifiers.CriteriaModifier;
import com.teamabnormals.blueprint.common.advancement.modification.modifiers.EffectsChangedModifier;
import com.teamabnormals.blueprint.core.util.modification.ObjectModifier;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.critereon.BredAnimalsTrigger;
import net.minecraft.advancements.critereon.ConsumeItemTrigger;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicates;
import net.minecraft.advancements.critereon.ItemUsedOnLocationTrigger;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.advancements.critereon.TameAnimalTrigger;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class AtmosphericAdvancementModifierProvider
extends AdvancementModifierProvider {
    private static final EntityType<?>[] BREEDABLE_ANIMALS = new EntityType[]{(EntityType)AtmosphericEntityTypes.COCHINEAL.get()};

    public AtmosphericAdvancementModifierProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
        super("atmospheric", output, provider);
    }

    protected void registerEntries(HolderLookup.Provider provider) {
        this.entry("nether/all_potions").selects(new String[]{"nether/all_potions"}).addModifier((ObjectModifier)new EffectsChangedModifier("all_effects", false, (MobEffectsPredicate)MobEffectsPredicate.Builder.effects().and(AtmosphericMobEffects.RELIEF).and(AtmosphericMobEffects.WORSENING).build().get()), new ICondition[0]);
        this.entry("nether/all_effects").selects(new String[]{"nether/all_effects"}).addModifier((ObjectModifier)new EffectsChangedModifier("all_effects", false, (MobEffectsPredicate)MobEffectsPredicate.Builder.effects().and(AtmosphericMobEffects.RELIEF).and(AtmosphericMobEffects.WORSENING).and(AtmosphericMobEffects.PERSISTENCE).and(AtmosphericMobEffects.SPITTING).build().get()), new ICondition[0]);
        CriteriaModifier.Builder balancedDiet = CriteriaModifier.builder((String)this.modId);
        List<DeferredHolder> items = ((DeferredRegister.Items)AtmosphericItems.ITEMS.getDeferredRegister()).getEntries().stream().filter(i -> ((Item)i.get()).getDefaultInstance().getFoodProperties(null) != null).toList();
        items.forEach(item -> {
            if (item != AtmosphericItems.ENDER_DRAGON_FRUIT) {
                balancedDiet.addCriterion(BuiltInRegistries.ITEM.getKey((Object)((Item)item.get())).getPath(), ConsumeItemTrigger.TriggerInstance.usedItem((ItemLike)((ItemLike)item.get())));
            }
        });
        this.entry("husbandry/balanced_diet").selects(new String[]{"husbandry/balanced_diet"}).addModifier((ObjectModifier)balancedDiet.requirements(AdvancementRequirements.Strategy.AND).build(), new ICondition[0]);
        CriteriaModifier.Builder breedAllAnimals = CriteriaModifier.builder((String)this.modId);
        for (EntityType<?> entityType : BREEDABLE_ANIMALS) {
            breedAllAnimals.addCriterion(BuiltInRegistries.ENTITY_TYPE.getKey(entityType).getPath(), BredAnimalsTrigger.TriggerInstance.bredAnimals((EntityPredicate.Builder)EntityPredicate.Builder.entity().of(entityType)));
        }
        this.entry("husbandry/bred_all_animals").selects(new String[]{"husbandry/bred_all_animals"}).addModifier((ObjectModifier)breedAllAnimals.requirements(AdvancementRequirements.Strategy.AND).build(), new ICondition[0]);
        this.entry("husbandry/whole_pack").selects(new String[]{"husbandry/whole_pack"}).addModifier((ObjectModifier)this.addTamedWolfVariants(provider).requirements(AdvancementRequirements.Strategy.AND).build(), new ICondition[0]);
        CriteriaModifier.Builder adventuringTime = CriteriaModifier.builder((String)this.modId);
        HolderLookup.RegistryLookup biomes = provider.lookupOrThrow(Registries.BIOME);
        for (ResourceKey<Biome> biome : AtmosphericBiomes.NATURAL_BIOMES) {
            adventuringTime.addCriterion(biome.location().toString(), PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)biomes.getOrThrow(biome))));
        }
        this.entry("adventure/adventuring_time").selects(new String[]{"adventure/adventuring_time"}).addModifier((ObjectModifier)adventuringTime.requirements(AdvancementRequirements.Strategy.AND).build(), new ICondition[0]);
        this.entry("husbandry/plant_seed").selects(new String[]{"husbandry/plant_seed"}).addModifier((ObjectModifier)CriteriaModifier.builder((String)this.modId).addCriterion("aloe_vera", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)((Block)AtmosphericBlocks.ALOE_VERA.get()))).addIndexedRequirements(0, false, new String[]{"aloe_vera"}).build(), new ICondition[0]);
    }

    private CriteriaModifier.Builder addTamedWolfVariants(HolderLookup.Provider registries) {
        CriteriaModifier.Builder builder = CriteriaModifier.builder((String)this.modId);
        HolderLookup.RegistryLookup registrylookup = registries.lookupOrThrow(Registries.WOLF_VARIANT);
        registrylookup.listElementIds().filter(key -> key.location().getNamespace().equals("atmospheric")).sorted(Comparator.comparing(ResourceKey::location)).forEach(variant -> {
            Holder.Reference holder = registrylookup.getOrThrow(variant);
            builder.addCriterion(variant.location().toString(), TameAnimalTrigger.TriggerInstance.tamedAnimal((EntityPredicate.Builder)EntityPredicate.Builder.entity().subPredicate(EntitySubPredicates.wolfVariant((HolderSet)HolderSet.direct((Holder[])new Holder[]{holder})))));
        });
        return builder;
    }
}

