/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.core.data.server.modifiers;

import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.atmospheric.core.registry.datapack.AtmosphericBiomes;
import com.teamabnormals.blueprint.common.world.modification.chunk.ChunkGeneratorModifierProvider;
import com.teamabnormals.blueprint.common.world.modification.chunk.modifiers.SurfaceRuleModifier;
import com.teamabnormals.blueprint.core.util.modification.ObjectModifier;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.neoforged.neoforge.common.conditions.ICondition;

public final class AtmosphericChunkGeneratorModifierProvider
extends ChunkGeneratorModifierProvider {
    public AtmosphericChunkGeneratorModifierProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
        super("atmospheric", output, provider);
    }

    protected void registerEntries(HolderLookup.Provider provider) {
        SurfaceRules.ConditionSource isDunes = SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{AtmosphericBiomes.DUNES, AtmosphericBiomes.FLOURISHING_DUNES, AtmosphericBiomes.ROCKY_DUNES, AtmosphericBiomes.PETRIFIED_DUNES});
        SurfaceRules.ConditionSource isSpinyThicket = SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{AtmosphericBiomes.SPINY_THICKET});
        SurfaceRules.ConditionSource isScrubland = SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{AtmosphericBiomes.SCRUBLAND, AtmosphericBiomes.SNOWY_SCRUBLAND});
        SurfaceRules.ConditionSource isHotSprings = SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{AtmosphericBiomes.HOT_SPRINGS});
        SurfaceRules.RuleSource coarseDirt = SurfaceRules.state((BlockState)Blocks.COARSE_DIRT.defaultBlockState());
        SurfaceRules.RuleSource dirt = SurfaceRules.state((BlockState)Blocks.DIRT.defaultBlockState());
        SurfaceRules.RuleSource sand = SurfaceRules.state((BlockState)Blocks.SAND.defaultBlockState());
        SurfaceRules.RuleSource sandstone = SurfaceRules.state((BlockState)Blocks.SANDSTONE.defaultBlockState());
        SurfaceRules.RuleSource redSand = SurfaceRules.state((BlockState)Blocks.RED_SAND.defaultBlockState());
        SurfaceRules.RuleSource redSandstone = SurfaceRules.state((BlockState)Blocks.RED_SANDSTONE.defaultBlockState());
        SurfaceRules.RuleSource aridSand = SurfaceRules.state((BlockState)((Block)AtmosphericBlocks.ARID_SAND.get()).defaultBlockState());
        SurfaceRules.RuleSource aridSandstone = SurfaceRules.state((BlockState)((Block)AtmosphericBlocks.ARID_SANDSTONE.get()).defaultBlockState());
        SurfaceRules.RuleSource redAridSand = SurfaceRules.state((BlockState)((Block)AtmosphericBlocks.RED_ARID_SAND.get()).defaultBlockState());
        SurfaceRules.RuleSource redAridSandstone = SurfaceRules.state((BlockState)((Block)AtmosphericBlocks.RED_ARID_SANDSTONE.get()).defaultBlockState());
        SurfaceRules.RuleSource ivoryTravertine = SurfaceRules.state((BlockState)((Block)AtmosphericBlocks.IVORY_TRAVERTINE.get()).defaultBlockState());
        SurfaceRules.RuleSource peachTravertine = SurfaceRules.state((BlockState)((Block)AtmosphericBlocks.PEACH_TRAVERTINE.get()).defaultBlockState());
        SurfaceRules.RuleSource persimmonTravertine = SurfaceRules.state((BlockState)((Block)AtmosphericBlocks.PERSIMMON_TRAVERTINE.get()).defaultBlockState());
        SurfaceRules.RuleSource saffronTravertine = SurfaceRules.state((BlockState)((Block)AtmosphericBlocks.SAFFRON_TRAVERTINE.get()).defaultBlockState());
        SurfaceRules.RuleSource sandRuleSource = this.sandRuleSource(sand, sandstone);
        SurfaceRules.RuleSource redSandRuleSource = this.sandRuleSource(redSand, redSandstone);
        SurfaceRules.RuleSource aridSandRuleSource = this.sandRuleSource(aridSand, aridSandstone);
        SurfaceRules.RuleSource redAridSandRuleSource = this.sandRuleSource(redAridSand, redAridSandstone);
        SurfaceRules.RuleSource sandRuleSourceCliffs = this.sandRuleSourceCliffs(sand, sandstone);
        SurfaceRules.RuleSource aridSandRuleSourceCliffs = this.sandRuleSourceCliffs(aridSand, aridSandstone);
        SurfaceRules.RuleSource hotSpringsRuleSource = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)AtmosphericChunkGeneratorModifierProvider.noiseRange(0.9f, 1.9f), (SurfaceRules.RuleSource)saffronTravertine), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)AtmosphericChunkGeneratorModifierProvider.noiseRange(0.4f, 2.4f), (SurfaceRules.RuleSource)persimmonTravertine), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)AtmosphericChunkGeneratorModifierProvider.noiseRange(-0.2f, 3.0), (SurfaceRules.RuleSource)peachTravertine), ivoryTravertine}));
        SurfaceRules.RuleSource hotSpringsRuleSource2 = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)AtmosphericChunkGeneratorModifierProvider.noiseRange(0.9f, 1.9f), (SurfaceRules.RuleSource)saffronTravertine), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)AtmosphericChunkGeneratorModifierProvider.noiseRange(0.4f, 2.4f), (SurfaceRules.RuleSource)persimmonTravertine), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)AtmosphericChunkGeneratorModifierProvider.noiseRange(-0.2f, 3.0), (SurfaceRules.RuleSource)peachTravertine), ivoryTravertine}));
        this.entry("atmospheric_surface_rule").selects(new String[]{"minecraft:overworld"}).addModifier((ObjectModifier)new SurfaceRuleModifier(SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.abovePreliminarySurface(), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isDunes, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)AtmosphericChunkGeneratorModifierProvider.noiseRange(0.3f, 2.5), (SurfaceRules.RuleSource)redAridSandRuleSource), aridSandRuleSource}))), false), new ICondition[0]).addModifier((ObjectModifier)new SurfaceRuleModifier(SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.abovePreliminarySurface(), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isSpinyThicket, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)AtmosphericChunkGeneratorModifierProvider.noiseRange(0.1f, 2.5), (SurfaceRules.RuleSource)redAridSandRuleSource), redSandRuleSource}))), false), new ICondition[0]).addModifier((ObjectModifier)new SurfaceRuleModifier(SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.abovePreliminarySurface(), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isScrubland, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)AtmosphericChunkGeneratorModifierProvider.noiseRange(-2.0, -0.5), (SurfaceRules.RuleSource)aridSandRuleSourceCliffs), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)AtmosphericChunkGeneratorModifierProvider.noiseRange(1.0, 2.5), (SurfaceRules.RuleSource)aridSandRuleSourceCliffs), sandRuleSourceCliffs}))), false), new ICondition[0]).addModifier((ObjectModifier)new SurfaceRuleModifier(SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.abovePreliminarySurface(), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{AtmosphericBiomes.ASPEN_PARKLAND}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.waterBlockCheck((int)-1, (int)0), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.waterBlockCheck((int)0, (int)0), (SurfaceRules.RuleSource)coarseDirt), dirt}))))), false), new ICondition[0]).addModifier((ObjectModifier)new SurfaceRuleModifier(SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.abovePreliminarySurface(), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isHotSprings, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)93), (int)0)), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{hotSpringsRuleSource, hotSpringsRuleSource2})))), false), new ICondition[0]);
    }

    private SurfaceRules.RuleSource sandRuleSource(SurfaceRules.RuleSource sand, SurfaceRules.RuleSource sandstone) {
        return SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.waterBlockCheck((int)-1, (int)0), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_CEILING, (SurfaceRules.RuleSource)sandstone), sand}))), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.waterStartCheck((int)-6, (int)-1), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_CEILING, (SurfaceRules.RuleSource)sandstone), sand})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.VERY_DEEP_UNDER_FLOOR, (SurfaceRules.RuleSource)sandstone)}))});
    }

    private SurfaceRules.RuleSource sandRuleSourceCliffs(SurfaceRules.RuleSource sand, SurfaceRules.RuleSource sandstone) {
        return SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.steep(), (SurfaceRules.RuleSource)sandstone), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.waterBlockCheck((int)-1, (int)0), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_CEILING, (SurfaceRules.RuleSource)sandstone), sand}))), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.waterStartCheck((int)-6, (int)-1), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_CEILING, (SurfaceRules.RuleSource)sandstone), sand})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.VERY_DEEP_UNDER_FLOOR, (SurfaceRules.RuleSource)sandstone)}))});
    }

    private static SurfaceRules.ConditionSource noiseRange(double low, double high) {
        return SurfaceRules.noiseCondition((ResourceKey)Noises.SURFACE, (double)(low / 8.25), (double)(high / 8.25));
    }

    private static SurfaceRules.ConditionSource surfaceNoiseAbove(double noise) {
        return SurfaceRules.noiseCondition((ResourceKey)Noises.SURFACE, (double)(noise / 8.25), (double)Double.MAX_VALUE);
    }
}

