/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.core.data.server.modifiers;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapCodec;
import com.teamabnormals.atmospheric.core.Atmospheric;
import com.teamabnormals.atmospheric.core.registry.AtmosphericItems;
import com.teamabnormals.atmospheric.core.registry.datapack.AtmosphericProcessorLists;
import com.teamabnormals.atmospheric.core.registry.datapack.AtmosphericStructures;
import com.teamabnormals.blueprint.common.remolder.Remolder;
import com.teamabnormals.blueprint.common.remolder.RemolderTypes;
import com.teamabnormals.blueprint.common.remolder.data.DynamicReference;
import com.teamabnormals.blueprint.common.remolder.data.RemolderProvider;
import com.teamabnormals.blueprint.common.remolder.util.LootRemolders;
import com.teamabnormals.blueprint.core.util.modification.selection.ConditionedResourceSelector;
import com.teamabnormals.blueprint.core.util.modification.selection.ResourceSelector;
import com.teamabnormals.blueprint.core.util.modification.selection.selectors.NamesResourceSelector;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;

public class AtmosphericDataRemolderProvider
extends RemolderProvider {
    public AtmosphericDataRemolderProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
        super("atmospheric", PackOutput.Target.DATA_PACK, output, provider);
    }

    protected void registerEntries(HolderLookup.Provider provider) {
        this.entry("loot_table/chests/ruined_portal").path(new String[]{"loot_table/chests/ruined_portal"}).remolder((Remolder)RemolderTypes.sequence((Remolder[])new Remolder[]{LootRemolders.addEntry((int)0, (LootPoolEntryContainer)LootItem.lootTableItem((ItemLike)((ItemLike)AtmosphericItems.SHIMMERING_PASSION_FRUIT.get())).setWeight(5).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)3.0f, (float)9.0f))).build()), LootRemolders.addEntry((int)0, (LootPoolEntryContainer)LootItem.lootTableItem((ItemLike)((ItemLike)AtmosphericItems.GOLDEN_DRAGON_FRUIT.get())).setWeight(15).build())}));
        HolderLookup.RegistryLookup structures = provider.lookupOrThrow(Registries.STRUCTURE);
        this.entry("worldgen/structure_set/villages").path(new String[]{"worldgen/structure_set/villages"}).remolder((Remolder)RemolderTypes.add((DynamicReference.Expression)DynamicReference.target((String)"structures[]"), (DynamicReference)DynamicReference.value((Object)StructureSet.entry((Holder)structures.getOrThrow(AtmosphericStructures.VILLAGE_SCRUBLAND), (int)1), (Encoder)StructureSet.StructureSelectionEntry.CODEC)));
        HolderLookup.RegistryLookup processors = provider.lookupOrThrow(Registries.PROCESSOR_LIST);
        Holder.Reference zombie = processors.getOrThrow(AtmosphericProcessorLists.ZOMBIE_SCRUBLAND);
        Codec codec = Codec.mapPair((MapCodec)StructurePoolElement.CODEC.fieldOf("element"), (MapCodec)Codec.intRange((int)1, (int)150).fieldOf("weight")).codec();
        NamesResourceSelector selector = new NamesResourceSelector(new ResourceLocation[]{Atmospheric.location("worldgen/template_pool/village/scrubland/houses")});
        NamesResourceSelector zombieSelector = new NamesResourceSelector(new ResourceLocation[]{Atmospheric.location("worldgen/template_pool/village/scrubland/zombie/houses")});
        ModLoadedCondition incubation = new ModLoadedCondition("incubation");
        ModLoadedCondition abnormalsDelight = new ModLoadedCondition("abnormals_delight");
        this.entry("worldgen/template_pool/village/scrubland/houses/chicken_coop_scrubland").path(new ConditionedResourceSelector((ResourceSelector)selector, new ICondition[]{incubation})).remolder((Remolder)RemolderTypes.add((DynamicReference.Expression)DynamicReference.target((String)"elements[]"), (DynamicReference)DynamicReference.value((Object)Pair.of((Object)((StructurePoolElement)StructurePoolElement.legacy((String)"atmospheric:village/scrubland/houses/scrubland_chicken_coop_1").apply(StructureTemplatePool.Projection.RIGID)), (Object)2), (Encoder)codec)));
        this.entry("worldgen/template_pool/village/scrubland/zombie/houses/chicken_coop_scrubland").path(new ConditionedResourceSelector((ResourceSelector)zombieSelector, new ICondition[]{incubation})).remolder((Remolder)RemolderTypes.add((DynamicReference.Expression)DynamicReference.target((String)"elements[]"), (DynamicReference)DynamicReference.value((Object)Pair.of((Object)((StructurePoolElement)StructurePoolElement.legacy((String)"atmospheric:village/scrubland/houses/scrubland_chicken_coop_1", (Holder)zombie).apply(StructureTemplatePool.Projection.RIGID)), (Object)2), (Encoder)codec)));
        this.entry("worldgen/template_pool/village/scrubland/houses/compost_pile_scrubland").path(new ConditionedResourceSelector((ResourceSelector)selector, new ICondition[]{abnormalsDelight})).remolder((Remolder)RemolderTypes.add((DynamicReference.Expression)DynamicReference.target((String)"elements[]"), (DynamicReference)DynamicReference.value((Object)Pair.of((Object)((StructurePoolElement)StructurePoolElement.legacy((String)"atmospheric:village/scrubland/houses/scrubland_compost_pile_1").apply(StructureTemplatePool.Projection.RIGID)), (Object)3), (Encoder)codec)));
        this.entry("worldgen/template_pool/village/scrubland/zombie/houses/compost_pile_scrubland").path(new ConditionedResourceSelector((ResourceSelector)zombieSelector, new ICondition[]{abnormalsDelight})).remolder((Remolder)RemolderTypes.add((DynamicReference.Expression)DynamicReference.target((String)"elements[]"), (DynamicReference)DynamicReference.value((Object)Pair.of((Object)((StructurePoolElement)StructurePoolElement.legacy((String)"atmospheric:village/scrubland/houses/scrubland_compost_pile_1", (Holder)zombie).apply(StructureTemplatePool.Projection.RIGID)), (Object)3), (Encoder)codec)));
    }
}

