/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.core.mixin;

import com.teamabnormals.atmospheric.common.entity.CamelVariant;
import com.teamabnormals.atmospheric.core.registry.AtmosphericDataSerializers;
import com.teamabnormals.atmospheric.core.registry.AtmosphericRegistries;
import com.teamabnormals.atmospheric.core.registry.datapack.AtmosphericCamelVariants;
import java.lang.invoke.LambdaMetafactory;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Camel.class})
public class CamelMixin
extends AbstractHorse
implements VariantHolder<Holder<CamelVariant>> {
    @Unique
    private static final EntityDataAccessor<Holder<CamelVariant>> DATA_VARIANT_ID = SynchedEntityData.defineId(Camel.class, (EntityDataSerializer)((EntityDataSerializer)AtmosphericDataSerializers.CAMEL_VARIANT.get()));

    protected CamelMixin(EntityType<? extends AbstractHorse> entity, Level level) {
        super(entity, level);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void addAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        this.getVariant().unwrapKey().ifPresent(key -> tag.putString("variant", key.location().toString()));
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void defineSynchedData(SynchedEntityData.Builder builder, CallbackInfo ci) {
        RegistryAccess access = this.registryAccess();
        Registry registry = access.registryOrThrow(AtmosphericRegistries.CAMEL_VARIANT);
        builder.define(DATA_VARIANT_ID, (Object)((Holder)registry.getHolder(AtmosphericCamelVariants.DEFAULT).or(() -> ((Registry)registry).getAny()).orElseThrow()));
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void readAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        Optional.ofNullable(ResourceLocation.tryParse((String)tag.getString("variant"))).map(location -> ResourceKey.create(AtmosphericRegistries.CAMEL_VARIANT, (ResourceLocation)location)).flatMap(key -> this.registryAccess().registryOrThrow(AtmosphericRegistries.CAMEL_VARIANT).getHolder(key)).ifPresent(this::setVariant);
    }

    @Inject(method={"finalizeSpawn"}, at={@At(value="HEAD")})
    private void finalizeSpawn(ServerLevelAccessor level, DifficultyInstance p_251264_, MobSpawnType p_250254_, SpawnGroupData spawnGroupData, CallbackInfoReturnable<SpawnGroupData> cir) {
        this.setVariant(CamelVariant.getSpawnVariant(this.registryAccess(), (Holder<Biome>)level.getBiome(this.blockPosition())));
    }

    /*
     * Unable to fully structure code
     */
    @Inject(method={"getBreedOffspring(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/AgeableMob;)Lnet/minecraft/world/entity/AgeableMob;"}, at={@At(value="RETURN")}, cancellable=true)
    private void getBreedOffspring(ServerLevel level, AgeableMob ageableMob, CallbackInfoReturnable<Camel> cir) {
        block2: {
            camel = (Camel)cir.getReturnValue();
            if (!(ageableMob instanceof Camel)) break block2;
            camelParent = (Camel)ageableMob;
            child = (VariantHolder)camel;
            parent = (VariantHolder)camelParent;
            variant = this.getVariant();
            parentVariant = (Holder)parent.getVariant();
            if (variant.is(AtmosphericCamelVariants.DESERT) && parentVariant.is(AtmosphericCamelVariants.ARID)) ** GOTO lbl13
            if (variant.is(AtmosphericCamelVariants.ARID) && parentVariant.is(AtmosphericCamelVariants.DESERT)) {
lbl13:
                // 2 sources

                this.registryAccess().registryOrThrow(AtmosphericRegistries.CAMEL_VARIANT).getHolder(AtmosphericCamelVariants.HYBRID).ifPresent((Consumer<Holder.Reference>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, setVariant(java.lang.Object ), (Lnet/minecraft/core/Holder$Reference;)V)((VariantHolder)child));
            } else {
                child.setVariant((Object)(this.random.nextBoolean() != false ? variant : parentVariant));
            }
            cir.setReturnValue((Object)((Camel)child));
        }
    }

    public void setVariant(Holder<CamelVariant> variant) {
        this.entityData.set(DATA_VARIANT_ID, variant);
    }

    public Holder<CamelVariant> getVariant() {
        return (Holder)this.entityData.get(DATA_VARIANT_ID);
    }
}

