/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.core.mixin;

import com.teamabnormals.atmospheric.common.block.YuccaBundleBlock;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.Tags;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Item.class})
public abstract class ItemMixin {
    @Inject(method={"isCorrectToolForDrops"}, at={@At(value="RETURN")}, cancellable=true)
    private void isCorrectToolForDrops(ItemStack stack, BlockState state, CallbackInfoReturnable<Boolean> cir) {
        if ((stack.getItem() instanceof SwordItem || stack.is(Tags.Items.TOOLS_SHEAR)) && state.is((Block)AtmosphericBlocks.GRIMWEB.get())) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"getDestroySpeed"}, at={@At(value="RETURN")}, cancellable=true)
    private void getDestroySpeed(ItemStack stack, BlockState state, CallbackInfoReturnable<Float> cir) {
        if (stack.getItem() instanceof SwordItem || stack.is(Tags.Items.TOOLS_SHEAR)) {
            if (state.is((Block)AtmosphericBlocks.GRIMWEB.get())) {
                cir.setReturnValue((Object)Float.valueOf(15.0f));
            }
            if (stack.is(Tags.Items.TOOLS_SHEAR)) {
                if (state.is((Block)AtmosphericBlocks.PASSION_VINE_BUNDLE.get()) || state.is((Block)AtmosphericBlocks.YUCCA_FLOWER.get()) || state.is((Block)AtmosphericBlocks.TALL_YUCCA_FLOWER.get()) || state.is((Block)AtmosphericBlocks.DRAGON_ROOTS.get())) {
                    cir.setReturnValue((Object)Float.valueOf(15.0f));
                }
                if (state.is((Block)AtmosphericBlocks.CURRANT_STALK.get()) || state.is((Block)AtmosphericBlocks.CURRANT_STALK_BUNDLE.get()) || state.getBlock() instanceof YuccaBundleBlock) {
                    cir.setReturnValue((Object)Float.valueOf(5.0f));
                }
            }
        }
    }

    @Inject(method={"mineBlock"}, at={@At(value="RETURN")}, cancellable=true)
    private void mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entity, CallbackInfoReturnable<Boolean> cir) {
        if (stack.is(Tags.Items.TOOLS_SHEAR) && state.is((Block)AtmosphericBlocks.GRIMWEB.get())) {
            cir.setReturnValue((Object)true);
        }
    }
}

