/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.core.other;

import com.mojang.blaze3d.systems.RenderSystem;
import com.teamabnormals.atmospheric.core.Atmospheric;
import com.teamabnormals.atmospheric.core.other.AtmosphericCompat;
import com.teamabnormals.atmospheric.core.registry.AtmosphericItems;
import com.teamabnormals.atmospheric.core.registry.datapack.AtmosphericBiomes;
import net.minecraft.ChatFormatting;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.LightLayer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="atmospheric", value={Dist.CLIENT})
public class AtmosphericClientEvents {
    public static final String[] COMMON = new String[]{"Hey!", "Hey! Hey!", "Hey Apple!", "Apple!"};
    public static final String[] RARE = new String[]{"Knife!", "Orange you glad I didn't say apple again?", "Can you do ten push-ups in ten seconds?", "Blah blah blah!", "Hey Pear!"};

    @SubscribeEvent
    public static void onRenderFog(ViewportEvent.RenderFog event) {
        Entity entity = event.getCamera().getEntity();
        if (entity instanceof LocalPlayer) {
            LocalPlayer player = (LocalPlayer)entity;
            Holder holder = player.level().getBiome(player.blockPosition());
            int brightness = player.level().getBrightness(LightLayer.SKY, player.blockPosition());
            if (holder.is(AtmosphericBiomes.GRIMWOODS) && brightness > 0) {
                RenderSystem.setShaderFogStart((float)0.0f);
                RenderSystem.setShaderFogEnd((float)Math.min(event.getFarPlaneDistance(), 48.0f));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Pre event) {
        Player player;
        RandomSource random;
        if (AtmosphericCompat.isAprilFools() && (random = (player = event.getEntity()).getRandom()).nextInt(401) == 0 && player.getInventory().contains(((Item)AtmosphericItems.ORANGE.get()).getDefaultInstance())) {
            player.displayClientMessage((Component)Component.literal((String)AtmosphericClientEvents.getMessage(random)).withStyle(ChatFormatting.GOLD), true);
        }
    }

    public static void registerItemProperties() {
        ItemProperties.register((Item)((Item)AtmosphericItems.ORANGE.get()), (ResourceLocation)Atmospheric.location("hey_apple"), (stack, level, entity, hash) -> AtmosphericCompat.isAprilFools() ? 1.0f : 0.0f);
    }

    public static String getMessage(RandomSource random) {
        return random.nextInt(4) == 0 ? RARE[random.nextInt(RARE.length - 1)] : COMMON[random.nextInt(COMMON.length - 1)];
    }
}

