/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.core.other;

import com.teamabnormals.atmospheric.core.other.AtmosphericLootTables;
import com.teamabnormals.atmospheric.core.other.tags.AtmosphericEntityTypeTags;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.atmospheric.core.registry.AtmosphericCriteriaTriggers;
import com.teamabnormals.atmospheric.core.registry.AtmosphericItems;
import com.teamabnormals.atmospheric.core.registry.AtmosphericMobEffects;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber(modid="atmospheric")
public class AtmosphericEvents {
    @SubscribeEvent
    public static void projectileImpact(ProjectileImpactEvent event) {
        Projectile projectile = event.getProjectile();
        if (projectile instanceof Snowball) {
            Snowball snowball = (Snowball)projectile;
            HitResult hitResult = event.getRayTraceResult();
            if (hitResult instanceof BlockHitResult) {
                Block newBlock;
                BlockPos pos;
                BlockHitResult result = (BlockHitResult)hitResult;
                Level level = snowball.level();
                BlockState state = level.getBlockState(pos = result.getBlockPos());
                Object object = state.is(Blocks.POTTED_BAMBOO) ? (Block)AtmosphericBlocks.POTTED_SNOWY_BAMBOO.get() : (state.is(Blocks.POTTED_CACTUS) ? (Block)AtmosphericBlocks.POTTED_SNOWY_CACTUS.get() : (newBlock = state.is((Block)AtmosphericBlocks.POTTED_BARREL_CACTUS.get()) ? (Block)AtmosphericBlocks.POTTED_SNOWY_BARREL_CACTUS.get() : null));
                if (newBlock != null) {
                    level.setBlockAndUpdate(pos, newBlock.defaultBlockState());
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingIncomingDamageEvent event) {
        if (event.getEntity().getType().is(AtmosphericEntityTypeTags.CACTUS_IMMUNE) && event.getSource().is(DamageTypes.CACTUS)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void livingHurt(LivingDamageEvent.Pre event) {
        int amplifier;
        LivingEntity entity = event.getEntity();
        boolean undead = entity.isInvertedHealAndHarm();
        boolean hasRelief = entity.hasEffect(AtmosphericMobEffects.RELIEF);
        boolean hasWorsening = entity.hasEffect(AtmosphericMobEffects.WORSENING);
        if (!undead && hasWorsening || undead && hasRelief) {
            amplifier = entity.getEffect(!undead ? AtmosphericMobEffects.WORSENING : AtmosphericMobEffects.RELIEF).getAmplifier();
            if (event.getOriginalDamage() >= (float)(amplifier + 1)) {
                event.setNewDamage(event.getOriginalDamage() + (float)(amplifier + 1));
            }
        }
        if (!undead && hasRelief || undead && hasWorsening) {
            amplifier = entity.getEffect(!undead ? AtmosphericMobEffects.RELIEF : AtmosphericMobEffects.WORSENING).getAmplifier();
            entity.getPersistentData().putInt("PotionHealAmplifier", amplifier);
            entity.getPersistentData().putFloat("IncomingDamage", event.getNewDamage());
            entity.getPersistentData().putBoolean("Heal", true);
        }
    }

    @SubscribeEvent
    public static void livingTick(EntityTickEvent.Pre event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            ServerPlayer player;
            Entity entity2;
            LivingEntity entity3 = (LivingEntity)entity;
            float damage = entity3.getPersistentData().getFloat("IncomingDamage");
            int amplifierHeal = entity3.getPersistentData().getInt("PotionHealAmplifier");
            if (entity3.getPersistentData().getBoolean("Heal") && damage >= (float)(amplifierHeal + 1)) {
                entity3.heal((float)(amplifierHeal + 1));
                entity3.getPersistentData().putBoolean("Heal", false);
            }
            if ((entity2 = event.getEntity()) instanceof ServerPlayer && !(player = (ServerPlayer)entity2).getCommandSenderWorld().isClientSide() && player.hasEffect(AtmosphericMobEffects.PERSISTENCE) && (float)player.getFoodData().getFoodLevel() <= 6.0f) {
                ((PlayerTrigger)AtmosphericCriteriaTriggers.PERSISTENCE_WHILE_STARVING.get()).trigger(player);
            }
        }
    }

    @SubscribeEvent
    public static void onInteractWithBlock(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            RandomizableContainerBlockEntity container;
            ServerPlayer player2 = (ServerPlayer)player;
            BlockPos pos = event.getPos();
            Level level = event.getLevel();
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof RandomizableContainerBlockEntity && (container = (RandomizableContainerBlockEntity)blockEntity).getLootTable() == AtmosphericLootTables.ARID_GARDEN && player2.getItemBySlot(EquipmentSlot.HEAD).is((Item)AtmosphericItems.BARREL_CACTUS.get()) && !player2.getCommandSenderWorld().isClientSide()) {
                ((PlayerTrigger)AtmosphericCriteriaTriggers.LOOT_ARID_GARDEN.get()).trigger(player2);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockToolModify(BlockEvent.BlockToolModificationEvent event) {
        if (event.getItemAbility() == ItemAbilities.HOE_TILL && event.getFinalState().is(AtmosphericBlocks.CRUSTOSE_PATH)) {
            event.setFinalState(Blocks.FARMLAND.defaultBlockState());
        }
    }
}

