/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.core.other;

import com.teamabnormals.atmospheric.core.registry.AtmosphericFeatures;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.biome.OverworldBiomes;
import net.minecraft.data.worldgen.placement.AquaticPlacements;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.levelgen.GenerationStep;

public class AtmosphericGeneration {
    public static void rainforest(BiomeGenerationSettings.Builder generation, boolean basin, boolean sparse) {
        OverworldBiomes.globalOverworldGeneration((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addMossyStoneBlock((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addSavannaGrass((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addForestFlowers((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addFerns((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addJungleGrass((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)generation);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.PODZOL);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.PASSION_VINES);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.MONKEY_BRUSH);
        if (!basin) {
            if (!sparse) {
                generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.TREES_RAINFOREST);
                generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.BUSHES_RAINFOREST);
            } else {
                generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.TREES_SPARSE_RAINFOREST);
                generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.BUSHES_SPARSE_RAINFOREST);
            }
            generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.PATCH_WATER_HYACINTH);
            generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.PATCH_WATERLILY_RAINFOREST);
            generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEAGRASS_SWAMP);
        } else {
            generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.BUSHES_RAINFOREST);
            generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEAGRASS_DEEP_WARM);
            generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.PATCH_WATERLILY_RAINFOREST_BASIN);
            if (!sparse) {
                generation.addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, AtmosphericFeatures.AtmosphericPlacedFeatures.OCEAN_FLOOR_RAISER);
                generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.TREES_RAINFOREST_BASIN);
                generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.PATCH_WATER_HYACINTH);
            } else {
                generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.TREES_SPARSE_RAINFOREST_BASIN);
                generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.PATCH_WATER_HYACINTH_SPARSE);
            }
        }
    }

    public static void dunes(BiomeGenerationSettings.Builder generation, boolean rocky, boolean variant) {
        BiomeDefaultFeatures.addFossilDecoration((BiomeGenerationSettings.Builder)generation);
        OverworldBiomes.globalOverworldGeneration((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)generation);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.PATCH_DEAD_BUSH_2);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)generation);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.PATCH_ARID_SPROUTS);
        if (!rocky) {
            if (!variant) {
                generation.addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, AtmosphericFeatures.AtmosphericPlacedFeatures.DUNE_ROCK);
                generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.TREES_DUNES);
                generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.PATCH_YUCCA_FLOWER);
                generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.PATCH_ALOE_VERA);
                generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.PATCH_BARREL_CACTUS_DUNES);
            } else {
                generation.addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, AtmosphericFeatures.AtmosphericPlacedFeatures.DUNE_ROCK_EXTRA);
                generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.PATCH_MELON_DUNES);
                generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.FLOWER_FLOURISHING_DUNES);
                generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.PATCH_DUNE_GRASS);
                generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.FLOURISHING_DUNES_YUCCA_TREES);
                generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.TREES_FLOURISHING_DUNES);
                generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.PATCH_YUCCA_FLOWER_EXTRA);
                generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.PATCH_ALOE_VERA_EXTRA);
                generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.PATCH_BARREL_CACTUS_FLOURISHING_DUNES);
                generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.PATCH_AGAVE_LARGE);
            }
        } else {
            if (!variant) {
                generation.addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, AtmosphericFeatures.AtmosphericPlacedFeatures.DUNE_ROCK_MANY);
                generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.TREES_ROCKY_DUNES);
                generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.PATCH_ALOE_VERA);
            } else {
                generation.addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, AtmosphericFeatures.AtmosphericPlacedFeatures.DUNE_ROCK);
                generation.addFeature(GenerationStep.Decoration.UNDERGROUND_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.FOSSIL_DUNES);
                generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.TREES_PETRIFIED_DUNES);
            }
            generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.PATCH_BARREL_CACTUS_ROCKY_DUNES);
        }
    }

    public static void spinyThicket(BiomeGenerationSettings.Builder generation) {
        OverworldBiomes.globalOverworldGeneration((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)generation);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.COARSE_DIRT);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.PATCH_DEAD_BUSH_BADLANDS);
        BiomeDefaultFeatures.addSavannaExtraGrass((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)generation);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.PATCH_CACTUS_SPINY_THICKET);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.PATCH_CACTUS_SPINIER_THICKET);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.TREES_SPINY_THICKET);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.TREES_FLOURISHING_DUNES);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.PATCH_BARREL_CACTUS_SPINY_THICKET);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.SINGLE_YUCCA_FLOWER);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.PATCH_AGAVE_LARGE);
    }

    public static void scrubland(BiomeGenerationSettings.Builder generation, boolean snowy) {
        OverworldBiomes.globalOverworldGeneration((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)generation);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, !snowy ? VegetationPlacements.PATCH_DEAD_BUSH_BADLANDS : AtmosphericFeatures.AtmosphericPlacedFeatures.PATCH_DEAD_BUSH_LAUREL_FOREST);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)generation);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, !snowy ? AtmosphericFeatures.AtmosphericPlacedFeatures.PATCH_ARID_SPROUTS : AtmosphericFeatures.AtmosphericPlacedFeatures.PATCH_ARID_SPROUTS_RARE);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.DRAGON_ROOTS);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.TREES_SCRUBLAND);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.FLOWER_SCRUBLAND);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.PATCH_CACTUS_SCRUBLAND);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.PATCH_BARREL_CACTUS_SCRUBLAND);
    }

    public static void aspenParkland(BiomeGenerationSettings.Builder generation) {
        OverworldBiomes.globalOverworldGeneration((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addDefaultFlowers((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addShatteredSavannaGrass((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)generation);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.CRUSTOSE);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.TREES_ASPEN_PARKLAND);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.FALLEN_CRUSTOSE_LOG);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.SINGLE_AGAVE);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.PATCH_AGAVE_LARGE);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.PATCH_GOLDEN_GROWTHS);
    }

    public static void kousaJungle(BiomeGenerationSettings.Builder generation) {
        OverworldBiomes.globalOverworldGeneration((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addMossyStoneBlock((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addDefaultFlowers((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addTaigaGrass((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)generation);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.PATCH_LARGE_FERN_KOUSA);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.CURRANT);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.SNOWY_BAMBOO);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.BIRCH_BUSH);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.TREES_KOUSA_JUNGLE);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.PASSION_VINES);
    }

    public static void grimwoods(BiomeGenerationSettings.Builder generation) {
        OverworldBiomes.globalOverworldGeneration((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)generation);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.COARSE_DIRT);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.PATCH_DEAD_BUSH_BADLANDS);
        BiomeDefaultFeatures.addSavannaExtraGrass((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)generation);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.TREES_GRIMWOODS);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.OMINOUS_BLOCK);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.DEAD_CURRANT);
    }

    public static void laurelForest(BiomeGenerationSettings.Builder generation) {
        OverworldBiomes.globalOverworldGeneration((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addSavannaGrass((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addDefaultFlowers((BiomeGenerationSettings.Builder)generation);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.COARSE_DIRT_LAUREL_FOREST);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.PATCH_DEAD_BUSH_LAUREL_FOREST);
        BiomeDefaultFeatures.addForestGrass((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)generation);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.TREES_LAUREL_FOREST_GIANT);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.TREES_LAUREL_FOREST_LARGE);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.TREES_LAUREL_FOREST);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.PATCH_AGAVE_LARGE);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.PATCH_LARGE_FERN_KOUSA);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.PATCH_GRASS_LAUREL_FOREST);
    }

    public static void hotSprings(BiomeGenerationSettings.Builder generation) {
        OverworldBiomes.globalOverworldGeneration((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addFerns((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addTaigaTrees((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addGiantTaigaVegetation((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addCommonBerryBushes((BiomeGenerationSettings.Builder)generation);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.TREES_OLD_GROWTH_SPRUCE_TAIGA);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.HOT_SPRINGS_ROCK);
    }
}

