/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.core.other;

import com.teamabnormals.atmospheric.core.registry.AtmosphericSoundEvents;
import com.teamabnormals.blueprint.core.api.BlockSetTypeRegistryHelper;
import com.teamabnormals.blueprint.core.api.WoodTypeRegistryHelper;
import com.teamabnormals.blueprint.core.util.PropertyUtil;
import java.util.function.ToIntFunction;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;

public class AtmosphericProperties {
    public static final BlockSetType ROSEWOOD_BLOCK_SET = AtmosphericProperties.blockSetType("rosewood");
    public static final BlockSetType MORADO_BLOCK_SET = AtmosphericProperties.blockSetType("morado");
    public static final BlockSetType YUCCA_BLOCK_SET = AtmosphericProperties.blockSetType("yucca");
    public static final BlockSetType ASPEN_BLOCK_SET = AtmosphericProperties.blockSetType("aspen");
    public static final BlockSetType LAUREL_BLOCK_SET = AtmosphericProperties.blockSetType("laurel");
    public static final BlockSetType KOUSA_BLOCK_SET = AtmosphericProperties.blockSetType("kousa");
    public static final BlockSetType GRIMWOOD_BLOCK_SET = AtmosphericProperties.blockSetType("grimwood");
    public static final WoodType ROSEWOOD_WOOD_TYPE = AtmosphericProperties.woodSetType(ROSEWOOD_BLOCK_SET);
    public static final WoodType MORADO_WOOD_TYPE = AtmosphericProperties.woodSetType(MORADO_BLOCK_SET);
    public static final WoodType YUCCA_WOOD_TYPE = AtmosphericProperties.woodSetType(YUCCA_BLOCK_SET);
    public static final WoodType ASPEN_WOOD_TYPE = AtmosphericProperties.woodSetType(ASPEN_BLOCK_SET);
    public static final WoodType LAUREL_WOOD_TYPE = AtmosphericProperties.woodSetType(LAUREL_BLOCK_SET);
    public static final WoodType KOUSA_WOOD_TYPE = AtmosphericProperties.woodSetType(KOUSA_BLOCK_SET);
    public static final WoodType GRIMWOOD_WOOD_TYPE = AtmosphericProperties.woodSetType(GRIMWOOD_BLOCK_SET);
    public static final PropertyUtil.WoodSetProperties ROSEWOOD = PropertyUtil.WoodSetProperties.builder((MapColor)MapColor.TERRACOTTA_MAGENTA).build();
    public static final PropertyUtil.WoodSetProperties MORADO = PropertyUtil.WoodSetProperties.builder((MapColor)MapColor.COLOR_RED).build();
    public static final PropertyUtil.WoodSetProperties YUCCA = PropertyUtil.WoodSetProperties.builder((MapColor)MapColor.COLOR_ORANGE).build();
    public static final PropertyUtil.WoodSetProperties ASPEN = PropertyUtil.WoodSetProperties.builder((MapColor)MapColor.GOLD).leavesColor(MapColor.GOLD).build();
    public static final PropertyUtil.WoodSetProperties GREEN_ASPEN = PropertyUtil.WoodSetProperties.builder((MapColor)MapColor.GOLD).leavesColor(MapColor.TERRACOTTA_LIGHT_GREEN).build();
    public static final PropertyUtil.WoodSetProperties LAUREL = PropertyUtil.WoodSetProperties.builder((MapColor)MapColor.TERRACOTTA_YELLOW).leavesColor(MapColor.TERRACOTTA_LIGHT_GREEN).build();
    public static final PropertyUtil.WoodSetProperties DRY_LAUREL = PropertyUtil.WoodSetProperties.builder((MapColor)MapColor.TERRACOTTA_YELLOW).leavesColor(MapColor.SAND).build();
    public static final PropertyUtil.WoodSetProperties KOUSA = PropertyUtil.WoodSetProperties.builder((MapColor)MapColor.TERRACOTTA_CYAN).leavesColor(MapColor.SNOW).build();
    public static final PropertyUtil.WoodSetProperties CURRANT = PropertyUtil.WoodSetProperties.builder((MapColor)MapColor.TERRACOTTA_GRAY).logSound((SoundType)AtmosphericSoundEvents.AtmosphericSoundTypes.CURRANT_STALK).leavesColor(MapColor.PODZOL).leavesSound((SoundType)AtmosphericSoundEvents.AtmosphericSoundTypes.CURRANT_LEAVES).build();
    public static final PropertyUtil.WoodSetProperties GRIMWOOD = PropertyUtil.WoodSetProperties.builder((MapColor)MapColor.TERRACOTTA_BLACK).build();
    public static final BlockBehaviour.Properties ARID_SAND = BlockBehaviour.Properties.of().mapColor(MapColor.SAND).strength(0.5f).sound((SoundType)AtmosphericSoundEvents.AtmosphericSoundTypes.ARID_SAND);
    public static final BlockBehaviour.Properties RED_ARID_SAND = BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_ORANGE).strength(0.5f).sound((SoundType)AtmosphericSoundEvents.AtmosphericSoundTypes.ARID_SAND);
    public static final BlockBehaviour.Properties YUCCA_FLOWER = BlockBehaviour.Properties.of().noCollission().strength(0.5f).sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY);
    public static final BlockBehaviour.Properties ARID_SPROUTS = BlockBehaviour.Properties.of().mapColor(MapColor.SAND).replaceable().noCollission().instabreak().sound((SoundType)AtmosphericSoundEvents.AtmosphericSoundTypes.ARID_SPROUTS).offsetType(BlockBehaviour.OffsetType.XYZ).ignitedByLava().pushReaction(PushReaction.DESTROY);
    public static final BlockBehaviour.Properties AGAVE = BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_CYAN).replaceable().noCollission().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XYZ).ignitedByLava().pushReaction(PushReaction.DESTROY);
    public static final BlockBehaviour.Properties GOLDEN_GROWTHS = BlockBehaviour.Properties.of().mapColor(MapColor.GOLD).replaceable().noCollission().instabreak().sound(SoundType.NETHER_SPROUTS).offsetType(BlockBehaviour.OffsetType.XYZ).ignitedByLava().pushReaction(PushReaction.DESTROY);
    public static final BlockBehaviour.Properties CRUSTOSE = BlockBehaviour.Properties.of().mapColor(MapColor.GOLD).randomTicks().strength(0.6f).sound(SoundType.GRASS);
    public static final BlockBehaviour.Properties CRUSTOSE_PATH = BlockBehaviour.Properties.of().mapColor(MapColor.GOLD).strength(0.65f).sound(SoundType.GRASS).isViewBlocking(PropertyUtil::always).isSuffocating(PropertyUtil::always);
    public static final BlockBehaviour.Properties IVORY_TRAVERTINE = BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_WHITE).requiresCorrectToolForDrops().strength(3.5f, 6.0f);
    public static final BlockBehaviour.Properties PEACH_TRAVERTINE = BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_PINK).requiresCorrectToolForDrops().strength(3.5f, 6.0f);
    public static final BlockBehaviour.Properties PERSIMMON_TRAVERTINE = BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_ORANGE).requiresCorrectToolForDrops().strength(3.5f, 6.0f);
    public static final BlockBehaviour.Properties SAFFRON_TRAVERTINE = BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_RED).requiresCorrectToolForDrops().strength(3.5f, 6.0f);
    public static final BlockBehaviour.Properties DOLERITE = BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_WHITE).requiresCorrectToolForDrops().strength(3.5f, 6.0f);
    public static final BlockBehaviour.Properties CARMINE_BLOCK = BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_RED).sound((SoundType)AtmosphericSoundEvents.AtmosphericSoundTypes.CARMINE).strength(0.5f);
    public static final BlockBehaviour.Properties ALOE_VERA = BlockBehaviour.Properties.of().noCollission().instabreak().randomTicks().sound(SoundType.CROP).pushReaction(PushReaction.DESTROY);
    public static final BlockBehaviour.Properties ORANGE = BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).instabreak().sound(SoundType.HONEY_BLOCK).pushReaction(PushReaction.DESTROY);
    public static final BlockBehaviour.Properties YUCCA_GATEAU = BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).strength(0.5f).sound(SoundType.WOOL).pushReaction(PushReaction.DESTROY);
    public static final BlockBehaviour.Properties CANDLE_YUCCA_GATEAU = BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).strength(0.5f).sound(SoundType.WOOL).pushReaction(PushReaction.DESTROY).lightLevel(AtmosphericProperties.litBlockEmission(3));

    public static BlockBehaviour.Properties aridSandstone() {
        return AtmosphericProperties.aridSandstone(MapColor.SAND);
    }

    public static BlockBehaviour.Properties redAridSandstone() {
        return AtmosphericProperties.aridSandstone(MapColor.TERRACOTTA_ORANGE);
    }

    public static BlockBehaviour.Properties smoothAridSandstone() {
        return AtmosphericProperties.smoothAridSandstone(MapColor.SAND);
    }

    public static BlockBehaviour.Properties smoothRedAridSandstone() {
        return AtmosphericProperties.smoothAridSandstone(MapColor.TERRACOTTA_ORANGE);
    }

    public static BlockBehaviour.Properties aridSandstone(MapColor color) {
        return BlockBehaviour.Properties.of().mapColor(color).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(0.8f).sound((SoundType)AtmosphericSoundEvents.AtmosphericSoundTypes.ARID_SANDSTONE);
    }

    public static BlockBehaviour.Properties smoothAridSandstone(MapColor color) {
        return BlockBehaviour.Properties.of().mapColor(color).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f).sound((SoundType)AtmosphericSoundEvents.AtmosphericSoundTypes.ARID_SANDSTONE);
    }

    private static ToIntFunction<BlockState> litBlockEmission(int level) {
        return state -> (Boolean)state.getValue((Property)BlockStateProperties.LIT) != false ? level : 0;
    }

    public static BlockSetType blockSetType(String name) {
        return BlockSetTypeRegistryHelper.register((BlockSetType)new BlockSetType("atmospheric:" + name));
    }

    public static WoodType woodSetType(BlockSetType type) {
        return WoodTypeRegistryHelper.registerWoodType((WoodType)new WoodType(type.name(), type));
    }
}

