/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.core.registry;

import com.mojang.datafixers.util.Pair;
import com.teamabnormals.atmospheric.common.item.AloeGelBottleItem;
import com.teamabnormals.atmospheric.common.item.AloeLeavesItem;
import com.teamabnormals.atmospheric.common.item.BarrelCactusItem;
import com.teamabnormals.atmospheric.common.item.EnderDragonFruitItem;
import com.teamabnormals.atmospheric.common.item.OrangeBlockItem;
import com.teamabnormals.atmospheric.common.item.PassionVineCoilItem;
import com.teamabnormals.atmospheric.common.item.TetraBucketItem;
import com.teamabnormals.atmospheric.core.Atmospheric;
import com.teamabnormals.atmospheric.core.other.AtmosphericCompat;
import com.teamabnormals.atmospheric.core.other.tags.AtmosphericBannerPatternTags;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.atmospheric.core.registry.AtmosphericEntityTypes;
import com.teamabnormals.atmospheric.core.registry.AtmosphericMobEffects;
import com.teamabnormals.atmospheric.core.registry.datapack.AtmosphericTrimPatterns;
import com.teamabnormals.atmospheric.integration.boatload.AtmosphericBoatTypes;
import com.teamabnormals.blueprint.common.item.BlueprintBoatItem;
import com.teamabnormals.blueprint.core.util.item.CreativeModeTabContentsPopulator;
import com.teamabnormals.blueprint.core.util.registry.BlockSubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.ItemSubRegistryHelper;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PlaceOnWaterBlockItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SmithingTemplateItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;
import net.neoforged.neoforge.registries.DeferredItem;

public class AtmosphericItems {
    public static final ItemSubRegistryHelper ITEMS = (ItemSubRegistryHelper)Atmospheric.REGISTRY_HELPER.getItemSubHelper();
    public static final DeferredItem<Item> PASSION_FRUIT = ITEMS.createItem("passion_fruit", () -> new Item(new Item.Properties().food(AtmosphericFoods.PASSION_FRUIT)));
    public static final DeferredItem<Item> SHIMMERING_PASSION_FRUIT = ITEMS.createItem("shimmering_passion_fruit", () -> new Item(new Item.Properties().food(AtmosphericFoods.SHIMMERING_PASSION_FRUIT)));
    public static final DeferredItem<Item> PASSION_FRUIT_TART = ITEMS.createItem("passion_fruit_tart", () -> new Item(new Item.Properties().food(AtmosphericFoods.PASSION_FRUIT_TART)));
    public static final DeferredItem<Item> PASSION_FRUIT_SORBET = ITEMS.createItem("passion_fruit_sorbet", () -> new Item(new Item.Properties().food(AtmosphericFoods.PASSION_FRUIT_SORBET).stacksTo(1).craftRemainder(Items.BOWL)));
    public static final DeferredItem<Item> PASSION_VINE_COIL = ITEMS.createItem("passion_vine_coil", () -> new PassionVineCoilItem(new Item.Properties().stacksTo(16)));
    public static final DeferredItem<Item> WATER_HYACINTH = ITEMS.createItem("water_hyacinth", () -> new PlaceOnWaterBlockItem((Block)AtmosphericBlocks.WATER_HYACINTH.get(), new Item.Properties()));
    public static final DeferredItem<Item> YELLOW_BLOSSOMS = ITEMS.createItem("yellow_blossoms", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> YUCCA_FRUIT = ITEMS.createItem("yucca_fruit", () -> new Item(new Item.Properties().food(AtmosphericFoods.YUCCA_FRUIT)));
    public static final DeferredItem<Item> ROASTED_YUCCA_FRUIT = ITEMS.createItem("roasted_yucca_fruit", () -> new Item(new Item.Properties().food(AtmosphericFoods.ROASTED_YUCCA_FRUIT)));
    public static final DeferredItem<Item> YUCCA_GATEAU = ITEMS.createItem("yucca_gateau", () -> new BlockItem((Block)AtmosphericBlocks.YUCCA_GATEAU.get(), new Item.Properties().stacksTo(1)));
    public static final DeferredItem<Item> BARREL_CACTUS = ITEMS.createItem("barrel_cactus", () -> new BarrelCactusItem(new Item.Properties()));
    public static final DeferredItem<Item> ALOE_KERNELS = ITEMS.createItem("aloe_kernels", () -> new ItemNameBlockItem((Block)AtmosphericBlocks.ALOE_VERA.get(), new Item.Properties()));
    public static final DeferredItem<Item> ALOE_LEAVES = ITEMS.createItem("aloe_leaves", () -> new AloeLeavesItem(new Item.Properties().food(AtmosphericFoods.ALOE_LEAVES)));
    public static final DeferredItem<Item> ALOE_GEL_BOTTLE = ITEMS.createItem("aloe_gel_bottle", () -> new AloeGelBottleItem(new Item.Properties().craftRemainder(Items.GLASS_BOTTLE).food(AtmosphericFoods.ALOE_GEL).stacksTo(16)));
    public static final DeferredItem<Item> CURRANT = ITEMS.createItem("currant", () -> new Item(new Item.Properties().food(AtmosphericFoods.CURRANT)));
    public static final DeferredItem<Item> CURRANT_MUFFIN = ITEMS.createItem("currant_muffin", () -> new Item(new Item.Properties().food(AtmosphericFoods.CURRANT_MUFFIN)));
    public static final DeferredItem<Item> CARMINE_HUSK = ITEMS.createItem("carmine_husk", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> COCHINEAL_BANNER_PATTERN = ITEMS.createItem("cochineal_banner_pattern", () -> new BannerPatternItem(AtmosphericBannerPatternTags.PATTERN_ITEM_COCHINEAL, new Item.Properties().stacksTo(1)));
    public static final DeferredItem<Item> DRAGON_FRUIT = ITEMS.createItem("dragon_fruit", () -> new Item(new Item.Properties().food(AtmosphericFoods.DRAGON_FRUIT)));
    public static final DeferredItem<Item> GOLDEN_DRAGON_FRUIT = ITEMS.createItem("golden_dragon_fruit", () -> new Item(new Item.Properties().food(AtmosphericFoods.GOLDEN_DRAGON_FRUIT)));
    public static final DeferredItem<Item> ENDER_DRAGON_FRUIT = ITEMS.createItem("ender_dragon_fruit", () -> new EnderDragonFruitItem(new Item.Properties().food(AtmosphericFoods.ENDER_DRAGON_FRUIT).rarity(Rarity.EPIC).stacksTo(1)));
    public static final DeferredItem<Item> ORANGE = ITEMS.createItem("orange", () -> new OrangeBlockItem((Block)AtmosphericBlocks.ORANGE.get(), new Item.Properties().food(AtmosphericFoods.ORANGE).stacksTo(AtmosphericCompat.isAprilFools() ? 1 : 64)));
    public static final DeferredItem<Item> ORANGE_PUDDING = ITEMS.createItem("orange_pudding", () -> new Item(new Item.Properties().food(AtmosphericFoods.ORANGE_PUDDING)));
    public static final DeferredItem<Item> ORANGE_SORBET = ITEMS.createItem("orange_sorbet", () -> new Item(new Item.Properties().food(AtmosphericFoods.ORANGE_SORBET).stacksTo(1).craftRemainder(Items.BOWL)));
    public static final DeferredItem<Item> CANDIED_ORANGE_SLICES = ITEMS.createItem("candied_orange_slices", () -> new Item(new Item.Properties().food(AtmosphericFoods.CANDIED_ORANGE_SLICES)));
    public static final DeferredItem<Item> BLOOD_ORANGE = ITEMS.createItem("blood_orange", () -> new OrangeBlockItem((Block)AtmosphericBlocks.BLOOD_ORANGE.get(), new Item.Properties().food(AtmosphericFoods.BLOOD_ORANGE)));
    public static final DeferredItem<Item> SCYTHE_POTTERY_SHERD = ITEMS.createItem("scythe_pottery_sherd", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> SUCCULENT_POTTERY_SHERD = ITEMS.createItem("succulent_pottery_sherd", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> SUN_POTTERY_SHERD = ITEMS.createItem("sun_pottery_sherd", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> APOSTLE_ARMOR_TRIM_SMITHING_TEMPLATE = ITEMS.createItem("apostle_armor_trim_smithing_template", () -> SmithingTemplateItem.createArmorTrimTemplate(AtmosphericTrimPatterns.APOSTLE, (FeatureFlag[])new FeatureFlag[0]));
    public static final DeferredItem<Item> DRUID_ARMOR_TRIM_SMITHING_TEMPLATE = ITEMS.createItem("druid_armor_trim_smithing_template", () -> SmithingTemplateItem.createArmorTrimTemplate(AtmosphericTrimPatterns.DRUID, (FeatureFlag[])new FeatureFlag[0]));
    public static final DeferredItem<Item> PETRIFIED_ARMOR_TRIM_SMITHING_TEMPLATE = ITEMS.createItem("petrified_armor_trim_smithing_template", () -> SmithingTemplateItem.createArmorTrimTemplate(AtmosphericTrimPatterns.PETRIFIED, (FeatureFlag[])new FeatureFlag[0]));
    public static final Pair<DeferredItem<BlueprintBoatItem>, DeferredItem<BlueprintBoatItem>> ROSEWOOD_BOATS = ITEMS.createBoatAndChestBoatItem("rosewood", AtmosphericBlocks.ROSEWOOD_PLANKS);
    public static final DeferredItem<BlueprintBoatItem> ROSEWOOD_BOAT = (DeferredItem)ROSEWOOD_BOATS.getFirst();
    public static final DeferredItem<BlueprintBoatItem> ROSEWOOD_CHEST_BOAT = (DeferredItem)ROSEWOOD_BOATS.getSecond();
    public static final DeferredItem<Item> ROSEWOOD_FURNACE_BOAT = ITEMS.createItem("rosewood_furnace_boat", ModList.get().isLoaded("boatload") ? AtmosphericBoatTypes.ROSEWOOD_FURNACE_BOAT : () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> LARGE_ROSEWOOD_BOAT = ITEMS.createItem("large_rosewood_boat", ModList.get().isLoaded("boatload") ? AtmosphericBoatTypes.LARGE_ROSEWOOD_BOAT : () -> new Item(new Item.Properties()));
    public static final Pair<DeferredItem<BlueprintBoatItem>, DeferredItem<BlueprintBoatItem>> MORADO_BOATS = ITEMS.createBoatAndChestBoatItem("morado", AtmosphericBlocks.MORADO_PLANKS);
    public static final DeferredItem<BlueprintBoatItem> MORADO_BOAT = (DeferredItem)MORADO_BOATS.getFirst();
    public static final DeferredItem<BlueprintBoatItem> MORADO_CHEST_BOAT = (DeferredItem)MORADO_BOATS.getSecond();
    public static final DeferredItem<Item> MORADO_FURNACE_BOAT = ITEMS.createItem("morado_furnace_boat", ModList.get().isLoaded("boatload") ? AtmosphericBoatTypes.MORADO_FURNACE_BOAT : () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> LARGE_MORADO_BOAT = ITEMS.createItem("large_morado_boat", ModList.get().isLoaded("boatload") ? AtmosphericBoatTypes.LARGE_MORADO_BOAT : () -> new Item(new Item.Properties()));
    public static final Pair<DeferredItem<BlueprintBoatItem>, DeferredItem<BlueprintBoatItem>> YUCCA_BOATS = ITEMS.createBoatAndChestBoatItem("yucca", AtmosphericBlocks.YUCCA_PLANKS);
    public static final DeferredItem<BlueprintBoatItem> YUCCA_BOAT = (DeferredItem)YUCCA_BOATS.getFirst();
    public static final DeferredItem<BlueprintBoatItem> YUCCA_CHEST_BOAT = (DeferredItem)YUCCA_BOATS.getSecond();
    public static final DeferredItem<Item> YUCCA_FURNACE_BOAT = ITEMS.createItem("yucca_furnace_boat", ModList.get().isLoaded("boatload") ? AtmosphericBoatTypes.YUCCA_FURNACE_BOAT : () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> LARGE_YUCCA_BOAT = ITEMS.createItem("large_yucca_boat", ModList.get().isLoaded("boatload") ? AtmosphericBoatTypes.LARGE_YUCCA_BOAT : () -> new Item(new Item.Properties()));
    public static final Pair<DeferredItem<BlueprintBoatItem>, DeferredItem<BlueprintBoatItem>> KOUSA_BOATS = ITEMS.createBoatAndChestBoatItem("kousa", AtmosphericBlocks.KOUSA_PLANKS);
    public static final DeferredItem<BlueprintBoatItem> KOUSA_BOAT = (DeferredItem)KOUSA_BOATS.getFirst();
    public static final DeferredItem<BlueprintBoatItem> KOUSA_CHEST_BOAT = (DeferredItem)KOUSA_BOATS.getSecond();
    public static final DeferredItem<Item> KOUSA_FURNACE_BOAT = ITEMS.createItem("kousa_furnace_boat", ModList.get().isLoaded("boatload") ? AtmosphericBoatTypes.KOUSA_FURNACE_BOAT : () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> LARGE_KOUSA_BOAT = ITEMS.createItem("large_kousa_boat", ModList.get().isLoaded("boatload") ? AtmosphericBoatTypes.LARGE_KOUSA_BOAT : () -> new Item(new Item.Properties()));
    public static final Pair<DeferredItem<BlueprintBoatItem>, DeferredItem<BlueprintBoatItem>> ASPEN_BOATS = ITEMS.createBoatAndChestBoatItem("aspen", AtmosphericBlocks.ASPEN_PLANKS);
    public static final DeferredItem<BlueprintBoatItem> ASPEN_BOAT = (DeferredItem)ASPEN_BOATS.getFirst();
    public static final DeferredItem<BlueprintBoatItem> ASPEN_CHEST_BOAT = (DeferredItem)ASPEN_BOATS.getSecond();
    public static final DeferredItem<Item> ASPEN_FURNACE_BOAT = ITEMS.createItem("aspen_furnace_boat", ModList.get().isLoaded("boatload") ? AtmosphericBoatTypes.ASPEN_FURNACE_BOAT : () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> LARGE_ASPEN_BOAT = ITEMS.createItem("large_aspen_boat", ModList.get().isLoaded("boatload") ? AtmosphericBoatTypes.LARGE_ASPEN_BOAT : () -> new Item(new Item.Properties()));
    public static final Pair<DeferredItem<BlueprintBoatItem>, DeferredItem<BlueprintBoatItem>> LAUREL_BOATS = ITEMS.createBoatAndChestBoatItem("laurel", AtmosphericBlocks.LAUREL_PLANKS);
    public static final DeferredItem<BlueprintBoatItem> LAUREL_BOAT = (DeferredItem)LAUREL_BOATS.getFirst();
    public static final DeferredItem<BlueprintBoatItem> LAUREL_CHEST_BOAT = (DeferredItem)LAUREL_BOATS.getSecond();
    public static final DeferredItem<Item> LAUREL_FURNACE_BOAT = ITEMS.createItem("laurel_furnace_boat", ModList.get().isLoaded("boatload") ? AtmosphericBoatTypes.LAUREL_FURNACE_BOAT : () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> LARGE_LAUREL_BOAT = ITEMS.createItem("large_laurel_boat", ModList.get().isLoaded("boatload") ? AtmosphericBoatTypes.LARGE_LAUREL_BOAT : () -> new Item(new Item.Properties()));
    public static final Pair<DeferredItem<BlueprintBoatItem>, DeferredItem<BlueprintBoatItem>> GRIMWOOD_BOATS = ITEMS.createBoatAndChestBoatItem("grimwood", AtmosphericBlocks.GRIMWOOD_PLANKS);
    public static final DeferredItem<BlueprintBoatItem> GRIMWOOD_BOAT = (DeferredItem)GRIMWOOD_BOATS.getFirst();
    public static final DeferredItem<BlueprintBoatItem> GRIMWOOD_CHEST_BOAT = (DeferredItem)GRIMWOOD_BOATS.getSecond();
    public static final DeferredItem<Item> GRIMWOOD_FURNACE_BOAT = ITEMS.createItem("grimwood_furnace_boat", ModList.get().isLoaded("boatload") ? AtmosphericBoatTypes.GRIMWOOD_FURNACE_BOAT : () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> LARGE_GRIMWOOD_BOAT = ITEMS.createItem("large_grimwood_boat", ModList.get().isLoaded("boatload") ? AtmosphericBoatTypes.LARGE_GRIMWOOD_BOAT : () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> TETRA_BUCKET = ITEMS.createItem("tetra_bucket", () -> new TetraBucketItem(new Item.Properties().stacksTo(1)));
    public static final DeferredItem<DeferredSpawnEggItem> TETRA_SPAWN_EGG = ITEMS.createSpawnEggItem("tetra", () -> AtmosphericEntityTypes.TETRA.get(), 16730695, 3211214);
    public static final DeferredItem<DeferredSpawnEggItem> COCHINEAL_SPAWN_EGG = ITEMS.createSpawnEggItem("cochineal", () -> AtmosphericEntityTypes.COCHINEAL.get(), 15686488, 0xAA3D3A);

    public static void setupTabEditors() {
        CreativeModeTabContentsPopulator.mod((String)"atmospheric").tab(CreativeModeTabs.FOOD_AND_DRINKS).addItemsAfter((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.MELON_SLICE}), new Supplier[]{PASSION_FRUIT, SHIMMERING_PASSION_FRUIT, ORANGE, BLOOD_ORANGE, DRAGON_FRUIT, GOLDEN_DRAGON_FRUIT, YUCCA_FRUIT, ROASTED_YUCCA_FRUIT}).addItemsBefore((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.CHORUS_FRUIT}), new Supplier[]{CURRANT}).addItemsBefore((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.PUMPKIN_PIE}), new Supplier[]{YUCCA_GATEAU}).addItemsAfter((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.PUMPKIN_PIE}), new Supplier[]{PASSION_FRUIT_TART, CANDIED_ORANGE_SLICES, ORANGE_PUDDING, CURRANT_MUFFIN}).addItemsBefore((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.MILK_BUCKET}), new Supplier[]{PASSION_FRUIT_SORBET, ORANGE_SORBET}).addItemsAfter((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.DRIED_KELP}), new Supplier[]{ALOE_LEAVES}).addItemsAfter((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.HONEY_BOTTLE}), new Supplier[]{ALOE_GEL_BOTTLE}).tab(CreativeModeTabs.NATURAL_BLOCKS).addItemsAfter((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.BEETROOT_SEEDS}), new Supplier[]{ALOE_KERNELS}).tab(CreativeModeTabs.INGREDIENTS).addItemsAfter((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.HONEYCOMB}), new Supplier[]{CARMINE_HUSK, YELLOW_BLOSSOMS}).addItemsAfter((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.DUNE_ARMOR_TRIM_SMITHING_TEMPLATE}), new Supplier[]{PETRIFIED_ARMOR_TRIM_SMITHING_TEMPLATE, DRUID_ARMOR_TRIM_SMITHING_TEMPLATE, APOSTLE_ARMOR_TRIM_SMITHING_TEMPLATE}).addPotterySherdsAlphabetically(new Supplier[]{SCYTHE_POTTERY_SHERD, SUCCULENT_POTTERY_SHERD, SUN_POTTERY_SHERD}).addItemsAfter((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.GLOBE_BANNER_PATTERN}), new Supplier[]{COCHINEAL_BANNER_PATTERN}).tab(CreativeModeTabs.TOOLS_AND_UTILITIES).addItemsBefore((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.ENDER_PEARL}), new Supplier[]{PASSION_VINE_COIL}).addItemsAfter((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.TROPICAL_FISH_BUCKET}), new Supplier[]{TETRA_BUCKET}).addItemsBefore((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.BAMBOO_RAFT}), new Supplier[]{ROSEWOOD_BOAT, ROSEWOOD_CHEST_BOAT}).addItemsBefore(AtmosphericItems.modLoaded((ItemLike)Items.BAMBOO_RAFT, "boatload"), new Supplier[]{ROSEWOOD_FURNACE_BOAT, LARGE_ROSEWOOD_BOAT}).addItemsBefore((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.BAMBOO_RAFT}), new Supplier[]{MORADO_BOAT, MORADO_CHEST_BOAT}).addItemsBefore(AtmosphericItems.modLoaded((ItemLike)Items.BAMBOO_RAFT, "boatload"), new Supplier[]{MORADO_FURNACE_BOAT, LARGE_MORADO_BOAT}).addItemsBefore((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.BAMBOO_RAFT}), new Supplier[]{YUCCA_BOAT, YUCCA_CHEST_BOAT}).addItemsBefore(AtmosphericItems.modLoaded((ItemLike)Items.BAMBOO_RAFT, "boatload"), new Supplier[]{YUCCA_FURNACE_BOAT, LARGE_YUCCA_BOAT}).addItemsBefore((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.BAMBOO_RAFT}), new Supplier[]{LAUREL_BOAT, LAUREL_CHEST_BOAT}).addItemsBefore(AtmosphericItems.modLoaded((ItemLike)Items.BAMBOO_RAFT, "boatload"), new Supplier[]{LAUREL_FURNACE_BOAT, LARGE_LAUREL_BOAT}).addItemsBefore((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.BAMBOO_RAFT}), new Supplier[]{ASPEN_BOAT, ASPEN_CHEST_BOAT}).addItemsBefore(AtmosphericItems.modLoaded((ItemLike)Items.BAMBOO_RAFT, "boatload"), new Supplier[]{ASPEN_FURNACE_BOAT, LARGE_ASPEN_BOAT}).addItemsBefore((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.BAMBOO_RAFT}), new Supplier[]{KOUSA_BOAT, KOUSA_CHEST_BOAT}).addItemsBefore(AtmosphericItems.modLoaded((ItemLike)Items.BAMBOO_RAFT, "boatload"), new Supplier[]{KOUSA_FURNACE_BOAT, LARGE_KOUSA_BOAT}).addItemsBefore((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.BAMBOO_RAFT}), new Supplier[]{GRIMWOOD_BOAT, GRIMWOOD_CHEST_BOAT}).addItemsBefore(AtmosphericItems.modLoaded((ItemLike)Items.BAMBOO_RAFT, "boatload"), new Supplier[]{GRIMWOOD_FURNACE_BOAT, LARGE_GRIMWOOD_BOAT}).tab(CreativeModeTabs.SPAWN_EGGS).addSpawnEggsAlphabetically(new Supplier[]{TETRA_SPAWN_EGG, COCHINEAL_SPAWN_EGG});
    }

    public static Predicate<ItemStack> modLoaded(ItemLike item, String ... modids) {
        return stack -> Ingredient.of((ItemLike[])new ItemLike[]{item}).test(stack) && BlockSubRegistryHelper.areModsLoaded((String[])modids);
    }

    public static final class AtmosphericFoods {
        public static final FoodProperties PASSION_FRUIT = new FoodProperties.Builder().nutrition(1).saturationModifier(0.1f).fast().alwaysEdible().effect(() -> new MobEffectInstance(AtmosphericMobEffects.SPITTING, 140, 0, false, false, false), 1.0f).build();
        public static final FoodProperties SHIMMERING_PASSION_FRUIT = new FoodProperties.Builder().nutrition(3).saturationModifier(0.1f).fast().alwaysEdible().effect(() -> new MobEffectInstance(AtmosphericMobEffects.SPITTING, 140, 1, false, false, false), 1.0f).build();
        public static final FoodProperties PASSION_FRUIT_TART = new FoodProperties.Builder().nutrition(4).saturationModifier(0.6f).build();
        public static final FoodProperties PASSION_FRUIT_SORBET = new FoodProperties.Builder().nutrition(15).saturationModifier(0.6f).usingConvertsTo((ItemLike)Items.BOWL).effect(() -> new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 300, 4, false, false, true), 1.0f).build();
        public static final FoodProperties YUCCA_FRUIT = new FoodProperties.Builder().nutrition(1).saturationModifier(0.3f).build();
        public static final FoodProperties ROASTED_YUCCA_FRUIT = new FoodProperties.Builder().nutrition(3).saturationModifier(0.6f).effect(() -> new MobEffectInstance(AtmosphericMobEffects.PERSISTENCE, 560, 0, false, false, true), 1.0f).build();
        public static final FoodProperties ALOE_LEAVES = new FoodProperties.Builder().nutrition(2).saturationModifier(0.3f).alwaysEdible().build();
        public static final FoodProperties ALOE_GEL = new FoodProperties.Builder().nutrition(3).saturationModifier(0.6f).alwaysEdible().build();
        public static final FoodProperties CURRANT = new FoodProperties.Builder().nutrition(2).saturationModifier(0.1f).build();
        public static final FoodProperties CURRANT_MUFFIN = new FoodProperties.Builder().nutrition(4).saturationModifier(0.3f).build();
        public static final FoodProperties DRAGON_FRUIT = new FoodProperties.Builder().nutrition(4).saturationModifier(0.3f).build();
        public static final FoodProperties GOLDEN_DRAGON_FRUIT = new FoodProperties.Builder().nutrition(8).saturationModifier(0.1f).effect(() -> new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 3600), 1.0f).build();
        public static final FoodProperties ENDER_DRAGON_FRUIT = new FoodProperties.Builder().nutrition(20).saturationModifier(1.2f).build();
        public static final FoodProperties ORANGE = new FoodProperties.Builder().nutrition(4).saturationModifier(0.3f).build();
        public static final FoodProperties ORANGE_PUDDING = new FoodProperties.Builder().nutrition(8).saturationModifier(0.3f).build();
        public static final FoodProperties ORANGE_SORBET = new FoodProperties.Builder().nutrition(15).saturationModifier(0.6f).usingConvertsTo((ItemLike)Items.BOWL).effect(() -> new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 300, 4, false, false, true), 1.0f).build();
        public static final FoodProperties CANDIED_ORANGE_SLICES = new FoodProperties.Builder().nutrition(6).saturationModifier(0.3f).build();
        public static final FoodProperties BLOOD_ORANGE = new FoodProperties.Builder().nutrition(4).saturationModifier(0.3f).build();
    }
}

