/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.core.registry;

import com.google.common.collect.ImmutableMap;
import com.teamabnormals.atmospheric.core.Atmospheric;
import com.teamabnormals.atmospheric.core.AtmosphericConfig;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.atmospheric.core.registry.AtmosphericItems;
import com.teamabnormals.blueprint.core.util.TradeUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.neoforged.neoforge.event.village.WandererTradesEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(modid="atmospheric")
public class AtmosphericVillagerTypes {
    public static final DeferredRegister<VillagerType> VILLAGER_TYPES = DeferredRegister.create((ResourceKey)Registries.VILLAGER_TYPE, (String)"atmospheric");
    public static final DeferredHolder<VillagerType, ?> SCRUBLAND = AtmosphericVillagerTypes.register("scrubland");

    public static DeferredHolder<VillagerType, ?> register(String name) {
        return VILLAGER_TYPES.register(name, () -> new VillagerType(Atmospheric.location(name).toString()));
    }

    @SubscribeEvent
    public static void onVillagerTradesEvent(VillagerTradesEvent event) {
        TradeUtil.addVillagerTrades((VillagerTradesEvent)event, (VillagerProfession)VillagerProfession.FARMER, (int)2, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade(1, (Item)AtmosphericItems.PASSION_FRUIT_TART.get(), 4, 12, 5), new TradeUtil.BlueprintTrade((Item)AtmosphericItems.ALOE_LEAVES.get(), 4, 1, 16, 15), new TradeUtil.BlueprintTrade((Item)AtmosphericItems.YUCCA_FRUIT.get(), 3, 1, 12, 10)});
        TradeUtil.addVillagerTrades((VillagerTradesEvent)event, (VillagerProfession)VillagerProfession.FARMER, (int)3, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade((Item)AtmosphericItems.PASSION_FRUIT.get(), 8, 1, 12, 10)});
        TradeUtil.addVillagerTrades((VillagerTradesEvent)event, (VillagerProfession)VillagerProfession.FARMER, (int)4, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade(3, (Item)AtmosphericItems.YUCCA_GATEAU.get(), 1, 12, 15)});
        TradeUtil.addVillagerTrades((VillagerTradesEvent)event, (VillagerProfession)VillagerProfession.MASON, (int)4, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade(1, ((Block)AtmosphericBlocks.IVORY_TRAVERTINE.get()).asItem(), 4, 16, 10), new TradeUtil.BlueprintTrade(1, ((Block)AtmosphericBlocks.PEACH_TRAVERTINE.get()).asItem(), 4, 16, 10), new TradeUtil.BlueprintTrade(1, ((Block)AtmosphericBlocks.PERSIMMON_TRAVERTINE.get()).asItem(), 4, 16, 10), new TradeUtil.BlueprintTrade(1, ((Block)AtmosphericBlocks.SAFFRON_TRAVERTINE.get()).asItem(), 4, 16, 10)});
        if (event.getType().equals((Object)VillagerProfession.FISHERMAN)) {
            Int2ObjectMap trades = event.getTrades();
            for (VillagerTrades.ItemListing listing : (List)trades.get(5)) {
                if (!(listing instanceof VillagerTrades.EmeraldsForVillagerTypeItem)) continue;
                VillagerTrades.EmeraldsForVillagerTypeItem trade = (VillagerTrades.EmeraldsForVillagerTypeItem)listing;
                HashMap<VillagerType, Item> newTrades = new HashMap<VillagerType, Item>(trade.trades);
                if (!trade.trades.containsKey(SCRUBLAND.get())) {
                    newTrades.put((VillagerType)SCRUBLAND.get(), (Item)AtmosphericItems.LAUREL_BOAT.get());
                }
                if (newTrades.get(VillagerType.DESERT) == Items.JUNGLE_BOAT && ((Boolean)AtmosphericConfig.COMMON.yuccaDesertVillages.get()).booleanValue()) {
                    newTrades.replace(VillagerType.DESERT, (Item)AtmosphericItems.YUCCA_BOAT.get());
                }
                trade.trades = ImmutableMap.copyOf(newTrades);
            }
        }
    }

    @SubscribeEvent
    public static void onWandererTradesEvent(WandererTradesEvent event) {
        TradeUtil.addWandererTrades((WandererTradesEvent)event, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new TradeUtil.BlueprintTrade(1, ((Block)AtmosphericBlocks.WARM_MONKEY_BRUSH.get()).asItem(), 1, 6, 1), new TradeUtil.BlueprintTrade(1, ((Block)AtmosphericBlocks.HOT_MONKEY_BRUSH.get()).asItem(), 1, 6, 1), new TradeUtil.BlueprintTrade(1, ((Block)AtmosphericBlocks.SCALDING_MONKEY_BRUSH.get()).asItem(), 1, 6, 1), new TradeUtil.BlueprintTrade(4, ((Block)AtmosphericBlocks.PASSION_VINE.get()).asItem(), 1, 8, 1), new TradeUtil.BlueprintTrade(1, ((Block)AtmosphericBlocks.ARID_SAND.get()).asItem(), 8, 8, 1), new TradeUtil.BlueprintTrade(1, ((Block)AtmosphericBlocks.RED_ARID_SAND.get()).asItem(), 4, 6, 1), new TradeUtil.BlueprintTrade(1, ((Block)AtmosphericBlocks.YUCCA_FLOWER.get()).asItem(), 1, 8, 1), new TradeUtil.BlueprintTrade(1, ((Block)AtmosphericBlocks.WATER_HYACINTH.get()).asItem(), 1, 8, 1), new TradeUtil.BlueprintTrade(1, ((Block)AtmosphericBlocks.GILIA.get()).asItem(), 1, 12, 1), new TradeUtil.BlueprintTrade(1, (Item)AtmosphericItems.ALOE_KERNELS.get(), 1, 12, 1), new TradeUtil.BlueprintTrade(3, ((Block)AtmosphericBlocks.BARREL_CACTUS.get()).asItem(), 1, 8, 1), new TradeUtil.BlueprintTrade(1, ((Block)AtmosphericBlocks.AGAVE.get()).asItem(), 1, 8, 1), new TradeUtil.BlueprintTrade(1, ((Block)AtmosphericBlocks.GOLDEN_GROWTHS.get()).asItem(), 1, 8, 1), new TradeUtil.BlueprintTrade(1, ((Block)AtmosphericBlocks.FIRETHORN.get()).asItem(), 1, 12, 1), new TradeUtil.BlueprintTrade(1, ((Block)AtmosphericBlocks.FORSYTHIA.get()).asItem(), 1, 12, 1), new TradeUtil.BlueprintTrade(1, ((Block)AtmosphericBlocks.CRUSTOSE.get()).asItem(), 1, 8, 1), new TradeUtil.BlueprintTrade(3, ((Block)AtmosphericBlocks.DRAGON_ROOTS.get()).asItem(), 1, 5, 1), new TradeUtil.BlueprintTrade(4, ((Block)AtmosphericBlocks.GRIMWEB.get()).asItem(), 1, 5, 1), new TradeUtil.BlueprintTrade(1, (Item)AtmosphericItems.ORANGE.get(), 1, 2, 1), new TradeUtil.BlueprintTrade(5, ((Block)AtmosphericBlocks.ROSEWOOD_SAPLING.get()).asItem(), 1, 8, 1), new TradeUtil.BlueprintTrade(5, ((Block)AtmosphericBlocks.YUCCA_SAPLING.get()).asItem(), 1, 8, 1), new TradeUtil.BlueprintTrade(5, ((Block)AtmosphericBlocks.MORADO_SAPLING.get()).asItem(), 1, 8, 1), new TradeUtil.BlueprintTrade(5, ((Block)AtmosphericBlocks.ASPEN_SAPLING.get()).asItem(), 1, 8, 1), new TradeUtil.BlueprintTrade(5, ((Block)AtmosphericBlocks.GREEN_ASPEN_SAPLING.get()).asItem(), 1, 8, 1), new TradeUtil.BlueprintTrade(5, ((Block)AtmosphericBlocks.KOUSA_SAPLING.get()).asItem(), 1, 8, 1), new TradeUtil.BlueprintTrade(5, ((Block)AtmosphericBlocks.GRIMWOOD_SAPLING.get()).asItem(), 1, 8, 1), new TradeUtil.BlueprintTrade(5, ((Block)AtmosphericBlocks.LAUREL_SAPLING.get()).asItem(), 1, 8, 1), new TradeUtil.BlueprintTrade(5, ((Block)AtmosphericBlocks.DRY_LAUREL_SAPLING.get()).asItem(), 1, 8, 1), new TradeUtil.BlueprintTrade(5, ((Block)AtmosphericBlocks.CURRANT_SEEDLING.get()).asItem(), 1, 8, 1)});
    }
}

