/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.core.registry.datapack;

import com.teamabnormals.atmospheric.core.Atmospheric;
import com.teamabnormals.atmospheric.core.registry.AtmosphericFeatures;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class AtmosphericBiomeModifiers {
    public static void bootstrap(BootstrapContext<BiomeModifier> context) {
        AtmosphericBiomeModifiers.addFeature(context, "yucca_tree_desert", (ResourceKey<Biome>)Biomes.DESERT, GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.DESERT_YUCCA_TREES);
        AtmosphericBiomeModifiers.addFeature(context, "yucca_tree_windswept_savanna", (ResourceKey<Biome>)Biomes.WINDSWEPT_SAVANNA, GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.WINDSWEPT_SAVANNA_YUCCA_TREES);
        AtmosphericBiomeModifiers.addFeature(context, "wooded_badlands_vegetation", (ResourceKey<Biome>)Biomes.WOODED_BADLANDS, GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.WOODED_BADLANDS_YUCCA_TREES, AtmosphericFeatures.AtmosphericPlacedFeatures.PATCH_AGAVE_WOODED_BADLANDS);
    }

    @SafeVarargs
    private static void addFeature(BootstrapContext<BiomeModifier> context, String name, TagKey<Biome> biomes, GenerationStep.Decoration step, ResourceKey<PlacedFeature> ... features) {
        AtmosphericBiomeModifiers.register(context, "add_feature/" + name, () -> new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)context.lookup(Registries.BIOME).getOrThrow(biomes), AtmosphericBiomeModifiers.featureSet(context, features), step));
    }

    @SafeVarargs
    private static void addFeature(BootstrapContext<BiomeModifier> context, String name, ResourceKey<Biome> biome, GenerationStep.Decoration step, ResourceKey<PlacedFeature> ... features) {
        AtmosphericBiomeModifiers.register(context, "add_feature/" + name, () -> new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.BIOME).getOrThrow(biome)}), AtmosphericBiomeModifiers.featureSet(context, features), step));
    }

    private static void register(BootstrapContext<BiomeModifier> context, String name, Supplier<? extends BiomeModifier> modifier) {
        context.register(ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)Atmospheric.location(name)), (Object)modifier.get());
    }

    @SafeVarargs
    private static HolderSet<PlacedFeature> featureSet(BootstrapContext<?> context, ResourceKey<PlacedFeature> ... features) {
        return HolderSet.direct(Stream.of(features).map(placedFeatureKey -> context.lookup(Registries.PLACED_FEATURE).getOrThrow(placedFeatureKey)).collect(Collectors.toList()));
    }
}

