/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.core.registry.datapack;

import com.teamabnormals.atmospheric.core.Atmospheric;
import com.teamabnormals.atmospheric.core.other.AtmosphericGeneration;
import com.teamabnormals.atmospheric.core.registry.AtmosphericEntityTypes;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class AtmosphericBiomes {
    public static final ResourceKey<Biome> RAINFOREST = AtmosphericBiomes.createKey("rainforest");
    public static final ResourceKey<Biome> SPARSE_RAINFOREST = AtmosphericBiomes.createKey("sparse_rainforest");
    public static final ResourceKey<Biome> RAINFOREST_BASIN = AtmosphericBiomes.createKey("rainforest_basin");
    public static final ResourceKey<Biome> SPARSE_RAINFOREST_BASIN = AtmosphericBiomes.createKey("sparse_rainforest_basin");
    public static final ResourceKey<Biome> DUNES = AtmosphericBiomes.createKey("dunes");
    public static final ResourceKey<Biome> FLOURISHING_DUNES = AtmosphericBiomes.createKey("flourishing_dunes");
    public static final ResourceKey<Biome> ROCKY_DUNES = AtmosphericBiomes.createKey("rocky_dunes");
    public static final ResourceKey<Biome> PETRIFIED_DUNES = AtmosphericBiomes.createKey("petrified_dunes");
    public static final ResourceKey<Biome> SPINY_THICKET = AtmosphericBiomes.createKey("spiny_thicket");
    public static final ResourceKey<Biome> SCRUBLAND = AtmosphericBiomes.createKey("scrubland");
    public static final ResourceKey<Biome> SNOWY_SCRUBLAND = AtmosphericBiomes.createKey("snowy_scrubland");
    public static final ResourceKey<Biome> ASPEN_PARKLAND = AtmosphericBiomes.createKey("aspen_parkland");
    public static final ResourceKey<Biome> LAUREL_FOREST = AtmosphericBiomes.createKey("laurel_forest");
    public static final ResourceKey<Biome> KOUSA_JUNGLE = AtmosphericBiomes.createKey("kousa_jungle");
    public static final ResourceKey<Biome> GRIMWOODS = AtmosphericBiomes.createKey("grimwoods");
    public static final ResourceKey<Biome> HOT_SPRINGS = AtmosphericBiomes.createKey("hot_springs");
    public static final List<ResourceKey<Biome>> NATURAL_BIOMES = List.of(RAINFOREST, SPARSE_RAINFOREST, RAINFOREST_BASIN, SPARSE_RAINFOREST_BASIN, DUNES, FLOURISHING_DUNES, ROCKY_DUNES, PETRIFIED_DUNES, SPINY_THICKET, SCRUBLAND, SNOWY_SCRUBLAND, ASPEN_PARKLAND, LAUREL_FOREST, KOUSA_JUNGLE);

    public static void bootstrap(BootstrapContext<Biome> context) {
        HolderGetter features = context.lookup(Registries.PLACED_FEATURE);
        HolderGetter carvers = context.lookup(Registries.CONFIGURED_CARVER);
        context.register(RAINFOREST, (Object)AtmosphericBiomes.rainforest((HolderGetter<PlacedFeature>)features, carvers, false, false));
        context.register(SPARSE_RAINFOREST, (Object)AtmosphericBiomes.rainforest((HolderGetter<PlacedFeature>)features, carvers, false, true));
        context.register(RAINFOREST_BASIN, (Object)AtmosphericBiomes.rainforest((HolderGetter<PlacedFeature>)features, carvers, true, false));
        context.register(SPARSE_RAINFOREST_BASIN, (Object)AtmosphericBiomes.rainforest((HolderGetter<PlacedFeature>)features, carvers, true, true));
        context.register(DUNES, (Object)AtmosphericBiomes.dunes((HolderGetter<PlacedFeature>)features, carvers, false, false));
        context.register(FLOURISHING_DUNES, (Object)AtmosphericBiomes.dunes((HolderGetter<PlacedFeature>)features, carvers, false, true));
        context.register(ROCKY_DUNES, (Object)AtmosphericBiomes.dunes((HolderGetter<PlacedFeature>)features, carvers, true, false));
        context.register(PETRIFIED_DUNES, (Object)AtmosphericBiomes.dunes((HolderGetter<PlacedFeature>)features, carvers, true, true));
        context.register(SPINY_THICKET, (Object)AtmosphericBiomes.spinyThicket((HolderGetter<PlacedFeature>)features, carvers));
        context.register(SCRUBLAND, (Object)AtmosphericBiomes.scrubland((HolderGetter<PlacedFeature>)features, carvers, false));
        context.register(SNOWY_SCRUBLAND, (Object)AtmosphericBiomes.scrubland((HolderGetter<PlacedFeature>)features, carvers, true));
        context.register(ASPEN_PARKLAND, (Object)AtmosphericBiomes.aspenParkland((HolderGetter<PlacedFeature>)features, carvers));
        context.register(LAUREL_FOREST, (Object)AtmosphericBiomes.laurelForest((HolderGetter<PlacedFeature>)features, carvers));
        context.register(KOUSA_JUNGLE, (Object)AtmosphericBiomes.kousaJungle((HolderGetter<PlacedFeature>)features, carvers));
        context.register(GRIMWOODS, (Object)AtmosphericBiomes.grimwoods((HolderGetter<PlacedFeature>)features, carvers));
        context.register(HOT_SPRINGS, (Object)AtmosphericBiomes.hotSprings((HolderGetter<PlacedFeature>)features, carvers));
    }

    public static ResourceKey<Biome> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)Atmospheric.location(name));
    }

    private static Biome rainforest(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers, boolean basin, boolean sparse) {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder(features, carvers);
        AtmosphericGeneration.rainforest(generation, basin, sparse);
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawns);
        BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)spawns);
        spawns.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.PARROT, 40, 1, 2));
        spawns.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.WOLF, 8, 4, 4));
        spawns.addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.SQUID, 1, 1, 1));
        spawns.addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)AtmosphericEntityTypes.TETRA.get(), 20, 3, 12));
        return AtmosphericBiomes.biome(true, 0.9f, 0.95f, 6675400, 408635, spawns, generation, null);
    }

    private static Biome dunes(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers, boolean rocky, boolean variant) {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder(features, carvers);
        AtmosphericGeneration.dunes(generation, rocky, variant);
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.caveSpawns((MobSpawnSettings.Builder)spawns);
        BiomeDefaultFeatures.monsters((MobSpawnSettings.Builder)spawns, (int)19, (int)1, (int)100, (boolean)false);
        spawns.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.HUSK, 80, 4, 4));
        return AtmosphericBiomes.biome(false, 2.0f, 0.0f, 14988944, spawns, generation, null);
    }

    private static Biome spinyThicket(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder(features, carvers);
        AtmosphericGeneration.spinyThicket(generation);
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.caveSpawns((MobSpawnSettings.Builder)spawns);
        BiomeDefaultFeatures.monsters((MobSpawnSettings.Builder)spawns, (int)19, (int)1, (int)100, (boolean)false);
        spawns.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.HUSK, 80, 4, 4));
        return AtmosphericBiomes.biome(false, 2.0f, 0.85f, 14988944, spawns, generation, null);
    }

    private static Biome scrubland(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers, boolean snowy) {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder(features, carvers);
        AtmosphericGeneration.scrubland(generation, snowy);
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        spawns.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.HORSE, 2, 1, 1));
        spawns.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.DONKEY, 1, 1, 1));
        spawns.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.CHICKEN, 2, 2, 4));
        spawns.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AtmosphericEntityTypes.COCHINEAL.get(), 4, 1, 4));
        BiomeDefaultFeatures.caveSpawns((MobSpawnSettings.Builder)spawns);
        BiomeDefaultFeatures.monsters((MobSpawnSettings.Builder)spawns, (int)19, (int)1, (int)(!snowy ? 100 : 20), (boolean)false);
        spawns.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.HUSK, 80, 4, 4));
        if (snowy) {
            spawns.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.STRAY, 80, 4, 4));
        }
        return AtmosphericBiomes.biome(snowy, !snowy ? 2.0f : 0.0f, 0.0f, 13021599, spawns, generation, null);
    }

    private static Biome aspenParkland(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder(features, carvers);
        AtmosphericGeneration.aspenParkland(generation);
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawns);
        spawns.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.WOLF, 10, 1, 1));
        spawns.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.RABBIT, 15, 1, 1));
        return AtmosphericBiomes.biome(true, 2.0f, 0.0f, spawns, generation, Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_FOREST));
    }

    private static Biome kousaJungle(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder(features, carvers);
        AtmosphericGeneration.kousaJungle(generation);
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)spawns);
        spawns.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.WOLF, 8, 4, 4));
        spawns.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.OCELOT, 2, 1, 3));
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawns);
        return AtmosphericBiomes.biome(true, -0.5f, 0.5f, spawns, generation, null);
    }

    private static Biome grimwoods(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder(features, carvers);
        AtmosphericGeneration.grimwoods(generation);
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawns);
        return AtmosphericBiomes.biome(true, 0.25f, 0.0f, 9539946, 8882547, 5403055, 0x131333, 9866116, spawns, generation, null);
    }

    private static Biome laurelForest(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder(features, carvers);
        AtmosphericGeneration.laurelForest(generation);
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawns);
        BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)spawns);
        spawns.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.WOLF, 5, 4, 4));
        return AtmosphericBiomes.biomeWithGrass(true, 0.85f, 0.5f, 12249691, 11392595, spawns, generation, Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_FOREST));
    }

    private static Biome hotSprings(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder(features, carvers);
        AtmosphericGeneration.hotSprings(generation);
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawns);
        BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)spawns);
        spawns.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.WOLF, 8, 4, 4));
        spawns.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.RABBIT, 4, 2, 3));
        spawns.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.FOX, 8, 2, 4));
        return AtmosphericBiomes.biome(false, 0.25f, 0.4f, 4445678, 270131, spawns, generation, null);
    }

    private static Biome biome(boolean precipitation, float temperature, float downfall, MobSpawnSettings.Builder spawns, BiomeGenerationSettings.Builder generation, @Nullable Music music) {
        return AtmosphericBiomes.biome(precipitation, temperature, downfall, 12638463, spawns, generation, music);
    }

    private static Biome biome(boolean precipitation, float temperature, float downfall, int waterColor, int waterFogColor, MobSpawnSettings.Builder spawns, BiomeGenerationSettings.Builder generation, @Nullable Music music) {
        return AtmosphericBiomes.biome(precipitation, temperature, downfall, waterColor, waterFogColor, 12638463, spawns, generation, music);
    }

    private static Biome biome(boolean precipitation, float temperature, float downfall, int fogColor, MobSpawnSettings.Builder spawns, BiomeGenerationSettings.Builder generation, @Nullable Music music) {
        return AtmosphericBiomes.biome(precipitation, temperature, downfall, 4159204, 329011, fogColor, spawns, generation, music);
    }

    private static Biome biome(boolean precipitation, float temperature, float downfall, int waterColor, int waterFogColor, int fogColor, MobSpawnSettings.Builder spawns, BiomeGenerationSettings.Builder generation, @Nullable Music music) {
        return new Biome.BiomeBuilder().hasPrecipitation(precipitation).temperature(temperature).downfall(downfall).specialEffects(new BiomeSpecialEffects.Builder().waterColor(waterColor).waterFogColor(waterFogColor).fogColor(fogColor).skyColor(AtmosphericBiomes.calculateSkyColor(temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(music).build()).mobSpawnSettings(spawns.build()).generationSettings(generation.build()).build();
    }

    private static Biome biomeWithGrass(boolean precipitation, float temperature, float downfall, int grassColor, int foliageColor, MobSpawnSettings.Builder spawns, BiomeGenerationSettings.Builder generation, @Nullable Music music) {
        return new Biome.BiomeBuilder().hasPrecipitation(precipitation).temperature(temperature).downfall(downfall).specialEffects(new BiomeSpecialEffects.Builder().grassColorOverride(grassColor).foliageColorOverride(foliageColor).waterColor(4159204).waterFogColor(329011).fogColor(12638463).skyColor(AtmosphericBiomes.calculateSkyColor(temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(music).build()).mobSpawnSettings(spawns.build()).generationSettings(generation.build()).build();
    }

    private static Biome biome(boolean precipitation, float temperature, float downfall, int grassColor, int foliageColor, int waterColor, int waterFogColor, int fogColor, MobSpawnSettings.Builder spawns, BiomeGenerationSettings.Builder generation, @Nullable Music music) {
        return new Biome.BiomeBuilder().hasPrecipitation(precipitation).temperature(temperature).downfall(downfall).specialEffects(new BiomeSpecialEffects.Builder().grassColorOverride(grassColor).foliageColorOverride(foliageColor).waterColor(waterColor).waterFogColor(waterFogColor).fogColor(fogColor).skyColor(AtmosphericBiomes.calculateSkyColor(temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(music).build()).mobSpawnSettings(spawns.build()).generationSettings(generation.build()).build();
    }

    private static int calculateSkyColor(float temperature) {
        float clampedTemp = Mth.clamp((float)(temperature / 3.0f), (float)-1.0f, (float)1.0f);
        return Mth.hsvToRgb((float)(0.62222224f - clampedTemp * 0.05f), (float)(0.5f + clampedTemp * 0.1f), (float)1.0f);
    }
}

