/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.core.registry.datapack;

import com.teamabnormals.atmospheric.common.entity.CamelVariant;
import com.teamabnormals.atmospheric.core.Atmospheric;
import com.teamabnormals.atmospheric.core.other.tags.AtmosphericBiomeTags;
import com.teamabnormals.atmospheric.core.registry.AtmosphericRegistries;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;

public class AtmosphericCamelVariants {
    public static final ResourceKey<CamelVariant> DESERT = AtmosphericCamelVariants.create("desert");
    public static final ResourceKey<CamelVariant> ARID = AtmosphericCamelVariants.create("arid");
    public static final ResourceKey<CamelVariant> HYBRID = AtmosphericCamelVariants.create("hybrid");
    public static final ResourceKey<CamelVariant> DEFAULT = DESERT;

    public static void bootstrap(BootstrapContext<CamelVariant> context) {
        context.register(DESERT, (Object)new CamelVariant(ResourceLocation.withDefaultNamespace((String)"entity/camel/camel"), (HolderSet<Biome>)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.BIOME).getOrThrow(Biomes.DESERT)})));
        AtmosphericCamelVariants.register(context, ARID, "camel_arid", AtmosphericBiomeTags.SPAWNS_ARID_CAMELS);
        AtmosphericCamelVariants.register(context, HYBRID, "camel_hybrid", (HolderSet<Biome>)HolderSet.direct((Holder[])new Holder[0]));
    }

    public static void register(BootstrapContext<CamelVariant> context, ResourceKey<CamelVariant> key, String name, ResourceKey<Biome> spawnBiome) {
        AtmosphericCamelVariants.register(context, key, name, (HolderSet<Biome>)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.BIOME).getOrThrow(spawnBiome)}));
    }

    public static void register(BootstrapContext<CamelVariant> context, ResourceKey<CamelVariant> key, String name, TagKey<Biome> spawnBiomes) {
        AtmosphericCamelVariants.register(context, key, name, (HolderSet<Biome>)context.lookup(Registries.BIOME).getOrThrow(spawnBiomes));
    }

    public static void register(BootstrapContext<CamelVariant> context, ResourceKey<CamelVariant> key, String name, HolderSet<Biome> spawnBiomes) {
        context.register(key, (Object)new CamelVariant(key.location().withPath("entity/camel/" + name), spawnBiomes));
    }

    public static ResourceKey<CamelVariant> create(String name) {
        return ResourceKey.create(AtmosphericRegistries.CAMEL_VARIANT, (ResourceLocation)Atmospheric.location(name));
    }
}

