/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.core.registry.datapack;

import com.google.common.collect.ImmutableList;
import com.teamabnormals.atmospheric.core.Atmospheric;
import com.teamabnormals.atmospheric.core.other.AtmosphericLootTables;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.CappedProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosAlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.AppendLoot;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.RuleBlockEntityModifier;
import net.minecraft.world.level.storage.loot.LootTable;

public class AtmosphericProcessorLists {
    public static final ResourceKey<StructureProcessorList> ZOMBIE_SCRUBLAND = AtmosphericProcessorLists.createKey("zombie_scrubland");
    public static final ResourceKey<StructureProcessorList> FARM_SCRUBLAND = AtmosphericProcessorLists.createKey("farm_scrubland");
    public static final ResourceKey<StructureProcessorList> ARID_GARDEN = AtmosphericProcessorLists.createKey("arid_garden");
    public static final ResourceKey<StructureProcessorList> PETRIFIED_ARID_GARDEN = AtmosphericProcessorLists.createKey("petrified_arid_garden");
    public static final ResourceKey<StructureProcessorList> ARID_GARDEN_SAND_ARCHAEOLOGY = AtmosphericProcessorLists.createKey("arid_garden_sand_archaeology");

    private static ResourceKey<StructureProcessorList> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PROCESSOR_LIST, (ResourceLocation)Atmospheric.location(name));
    }

    private static void register(BootstrapContext<StructureProcessorList> context, ResourceKey<StructureProcessorList> key, List<StructureProcessor> processors) {
        context.register(key, (Object)new StructureProcessorList(processors));
    }

    public static void bootstrap(BootstrapContext<StructureProcessorList> context) {
        AtmosphericProcessorLists.register(context, ZOMBIE_SCRUBLAND, (List<StructureProcessor>)ImmutableList.of((Object)new RuleProcessor((List)ImmutableList.of((Object)new ProcessorRule((RuleTest)new TagMatchTest(BlockTags.DOORS), (RuleTest)AlwaysTrueTest.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.LANTERN), (RuleTest)AlwaysTrueTest.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new ProcessorRule((RuleTest)new RandomBlockMatchTest((Block)AtmosphericBlocks.LAUREL_LOG.get(), 0.02f), (RuleTest)AlwaysTrueTest.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new ProcessorRule((RuleTest)new RandomBlockMatchTest((Block)AtmosphericBlocks.LAUREL_PLANKS.get(), 0.07f), (RuleTest)AlwaysTrueTest.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new ProcessorRule((RuleTest)new RandomBlockMatchTest((Block)AtmosphericBlocks.MORADO_PLANKS.get(), 0.07f), (RuleTest)AlwaysTrueTest.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new ProcessorRule((RuleTest)new RandomBlockMatchTest((Block)AtmosphericBlocks.CARMINE_SHINGLES.get(), 0.1f), (RuleTest)AlwaysTrueTest.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new ProcessorRule((RuleTest)new RandomBlockMatchTest((Block)AtmosphericBlocks.CARMINE_SHINGLE_STAIRS.get(), 0.1f), (RuleTest)AlwaysTrueTest.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.WHEAT, 0.8f), (RuleTest)AlwaysTrueTest.INSTANCE, Blocks.BEETROOTS.defaultBlockState())))));
        AtmosphericProcessorLists.register(context, FARM_SCRUBLAND, (List<StructureProcessor>)ImmutableList.of((Object)new RuleProcessor((List)ImmutableList.of((Object)new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.WHEAT, 0.8f), (RuleTest)AlwaysTrueTest.INSTANCE, Blocks.BEETROOTS.defaultBlockState())))));
        RandomBlockMatchTest flowerPot = new RandomBlockMatchTest(Blocks.FLOWER_POT, 0.2f);
        AtmosphericProcessorLists.register(context, ARID_GARDEN, (List<StructureProcessor>)ImmutableList.of((Object)new RuleProcessor(List.of(new ProcessorRule((RuleTest)flowerPot, (RuleTest)AlwaysTrueTest.INSTANCE, Blocks.POTTED_DEAD_BUSH.defaultBlockState()), new ProcessorRule((RuleTest)flowerPot, (RuleTest)AlwaysTrueTest.INSTANCE, ((Block)AtmosphericBlocks.POTTED_AGAVE.get()).defaultBlockState()), new ProcessorRule((RuleTest)flowerPot, (RuleTest)AlwaysTrueTest.INSTANCE, ((Block)AtmosphericBlocks.POTTED_YUCCA_FLOWER.get()).defaultBlockState()), new ProcessorRule((RuleTest)flowerPot, (RuleTest)AlwaysTrueTest.INSTANCE, ((Block)AtmosphericBlocks.POTTED_YUCCA_SAPLING.get()).defaultBlockState()), new ProcessorRule((RuleTest)flowerPot, (RuleTest)AlwaysTrueTest.INSTANCE, ((Block)AtmosphericBlocks.POTTED_GILIA.get()).defaultBlockState()), new ProcessorRule((RuleTest)flowerPot, (RuleTest)AlwaysTrueTest.INSTANCE, ((Block)AtmosphericBlocks.POTTED_BARREL_CACTUS.get()).defaultBlockState()))), (Object)AtmosphericProcessorLists.aridGardenArchyLootProcessor(AtmosphericLootTables.ARID_GARDEN_ARCHAEOLOGY_COMMON, 2)));
        AtmosphericProcessorLists.register(context, PETRIFIED_ARID_GARDEN, (List<StructureProcessor>)ImmutableList.of((Object)new CappedProcessor((StructureProcessor)new RuleProcessor(List.of(new ProcessorRule((RuleTest)new BlockMatchTest((Block)AtmosphericBlocks.ARID_SAND.get()), (RuleTest)AlwaysTrueTest.INSTANCE, Blocks.DECORATED_POT.defaultBlockState()))), (IntProvider)ConstantInt.of((int)6)), (Object)AtmosphericProcessorLists.aridGardenArchyLootProcessor(AtmosphericLootTables.ARID_GARDEN_ARCHAEOLOGY_COMMON, 12), (Object)AtmosphericProcessorLists.aridGardenArchyLootProcessor(AtmosphericLootTables.ARID_GARDEN_ARCHAEOLOGY_RARE, 6), (Object)new CappedProcessor((StructureProcessor)new RuleProcessor((List)ImmutableList.of((Object)new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.AIR), (RuleTest)AlwaysTrueTest.INSTANCE, ((Block)AtmosphericBlocks.ARID_SAND.get()).defaultBlockState()))), (IntProvider)ConstantInt.of((int)3000)), (Object)AtmosphericProcessorLists.aridGardenArchyLootProcessor(AtmosphericLootTables.ARID_GARDEN_ARCHAEOLOGY_COMMON, 16), (Object)AtmosphericProcessorLists.aridGardenArchyLootProcessor(AtmosphericLootTables.ARID_GARDEN_ARCHAEOLOGY_RARE, 4)));
        AtmosphericProcessorLists.register(context, ARID_GARDEN_SAND_ARCHAEOLOGY, (List<StructureProcessor>)ImmutableList.of((Object)AtmosphericProcessorLists.aridGardenArchyLootProcessor(AtmosphericLootTables.ARID_GARDEN_ARCHAEOLOGY_COMMON, 3)));
    }

    private static CappedProcessor aridGardenArchyLootProcessor(ResourceKey<LootTable> lootTable, int max) {
        return new CappedProcessor((StructureProcessor)new RuleProcessor(List.of(new ProcessorRule((RuleTest)new BlockMatchTest((Block)AtmosphericBlocks.ARID_SAND.get()), (RuleTest)AlwaysTrueTest.INSTANCE, (PosRuleTest)PosAlwaysTrueTest.INSTANCE, ((Block)AtmosphericBlocks.SUSPICIOUS_ARID_SAND.get()).defaultBlockState(), (RuleBlockEntityModifier)new AppendLoot(lootTable)))), (IntProvider)ConstantInt.of((int)max));
    }
}

