/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.core.registry.datapack;

import com.teamabnormals.atmospheric.core.Atmospheric;
import com.teamabnormals.atmospheric.core.other.AtmosphericConditions;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.atmospheric.core.registry.datapack.AtmosphericStructures;
import com.teamabnormals.blueprint.common.world.modification.structure.StructureRepaletter;
import com.teamabnormals.blueprint.common.world.modification.structure.StructureRepaletterEntry;
import com.teamabnormals.blueprint.core.registry.BlueprintDataPackRegistries;
import com.teamabnormals.woodworks.core.other.WoodworksConditions;
import java.util.function.BiConsumer;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.neoforged.neoforge.common.conditions.ICondition;

public final class AtmosphericStructureRepaletters {
    public static final ResourceKey<StructureRepaletterEntry> YUCCA_DESERT_VILLAGES = AtmosphericStructureRepaletters.create("yucca_desert_villages");
    public static final ResourceKey<StructureRepaletterEntry> YUCCA_DESERT_VILLAGE_LADDERS = AtmosphericStructureRepaletters.create("yucca_desert_village_ladders");
    public static final ResourceKey<StructureRepaletterEntry> YUCCA_DESERT_VILLAGE_BOOKSHELVES = AtmosphericStructureRepaletters.create("yucca_desert_village_bookshelves");
    public static final ResourceKey<StructureRepaletterEntry> YUCCA_DESERT_VILLAGE_CHESTS = AtmosphericStructureRepaletters.create("yucca_desert_village_chests");
    public static final ResourceKey<StructureRepaletterEntry> GRIMWOOD_ANCIENT_CITIES = AtmosphericStructureRepaletters.create("grimwood_ancient_cities");
    public static final ResourceKey<StructureRepaletterEntry> GRIMWOOD_ANCIENT_CITY_LADDERS = AtmosphericStructureRepaletters.create("grimwood_ancient_city_ladders");
    public static final ResourceKey<StructureRepaletterEntry> GRIMWOOD_ANCIENT_CITY_CHESTS = AtmosphericStructureRepaletters.create("grimwood_ancient_city_chests");
    public static final ResourceKey<StructureRepaletterEntry> SCRUBLAND_VILLAGE_LADDERS = AtmosphericStructureRepaletters.create("scrubland_village_ladders");
    public static final ResourceKey<StructureRepaletterEntry> SCRUBLAND_VILLAGE_BOOKSHELVES = AtmosphericStructureRepaletters.create("scrubland_village_bookshelves");
    public static final ResourceKey<StructureRepaletterEntry> SCRUBLAND_VILLAGE_CHESTS = AtmosphericStructureRepaletters.create("scrubland_village_chests");

    public static void bootstrap(BootstrapContext<StructureRepaletterEntry> context) {
        HolderGetter structures = context.lookup(Registries.STRUCTURE);
        HolderSet desertVillage = StructureRepaletterEntry.holder((HolderGetter)structures, (ResourceKey[])new ResourceKey[]{BuiltinStructures.VILLAGE_DESERT});
        context.register(YUCCA_DESERT_VILLAGES, (Object)StructureRepaletterEntry.repalette().repaletters(new StructureRepaletter[]{StructureRepaletterEntry.simple((Block)Blocks.JUNGLE_BUTTON, (Block)((Block)AtmosphericBlocks.YUCCA_BUTTON.get())), StructureRepaletterEntry.simple((Block)Blocks.JUNGLE_DOOR, (Block)((Block)AtmosphericBlocks.YUCCA_DOOR.get())), StructureRepaletterEntry.simple((Block)Blocks.JUNGLE_FENCE, (Block)((Block)AtmosphericBlocks.YUCCA_FENCE.get())), StructureRepaletterEntry.simple((Block)Blocks.JUNGLE_FENCE_GATE, (Block)((Block)AtmosphericBlocks.YUCCA_FENCE_GATE.get())), StructureRepaletterEntry.simple((Block)Blocks.JUNGLE_TRAPDOOR, (Block)((Block)AtmosphericBlocks.YUCCA_TRAPDOOR.get()))}).select(desertVillage));
        context.register(YUCCA_DESERT_VILLAGE_LADDERS, (Object)StructureRepaletterEntry.repalette().priority(50).repaletters(new StructureRepaletter[]{StructureRepaletterEntry.simple((Block)Blocks.LADDER, (Block)((Block)AtmosphericBlocks.YUCCA_LADDER.get()))}).select(desertVillage));
        context.register(YUCCA_DESERT_VILLAGE_BOOKSHELVES, (Object)StructureRepaletterEntry.repalette().priority(50).repaletters(new StructureRepaletter[]{StructureRepaletterEntry.simple((Block)Blocks.BOOKSHELF, (Block)((Block)AtmosphericBlocks.YUCCA_BOOKSHELF.get()))}).select(desertVillage));
        context.register(YUCCA_DESERT_VILLAGE_CHESTS, (Object)StructureRepaletterEntry.repalette().priority(50).repaletters(new StructureRepaletter[]{StructureRepaletterEntry.simple((Block)Blocks.CHEST, (Block)((Block)AtmosphericBlocks.YUCCA_CHEST.get()))}).select(desertVillage));
        HolderSet ancientCity = StructureRepaletterEntry.holder((HolderGetter)structures, (ResourceKey[])new ResourceKey[]{BuiltinStructures.ANCIENT_CITY});
        context.register(GRIMWOOD_ANCIENT_CITIES, (Object)StructureRepaletterEntry.repalette().repaletters(new StructureRepaletter[]{StructureRepaletterEntry.simple((Block)Blocks.DARK_OAK_LOG, (Block)((Block)AtmosphericBlocks.GRIMWOOD_LOG.get())), StructureRepaletterEntry.simple((Block)Blocks.DARK_OAK_FENCE, (Block)((Block)AtmosphericBlocks.GRIMWOOD_FENCE.get())), StructureRepaletterEntry.simple((Block)Blocks.DARK_OAK_PLANKS, (Block)((Block)AtmosphericBlocks.GRIMWOOD_PLANKS.get()))}).select(ancientCity));
        context.register(GRIMWOOD_ANCIENT_CITY_LADDERS, (Object)StructureRepaletterEntry.repalette().priority(50).repaletters(new StructureRepaletter[]{StructureRepaletterEntry.simple((Block)Blocks.LADDER, (Block)((Block)AtmosphericBlocks.GRIMWOOD_LADDER.get()))}).select(ancientCity));
        context.register(GRIMWOOD_ANCIENT_CITY_CHESTS, (Object)StructureRepaletterEntry.repalette().priority(50).repaletters(new StructureRepaletter[]{StructureRepaletterEntry.simple((Block)Blocks.CHEST, (Block)((Block)AtmosphericBlocks.GRIMWOOD_CHEST.get()))}).select(ancientCity));
        HolderSet scrublandVillage = StructureRepaletterEntry.holder((HolderGetter)structures, (ResourceKey[])new ResourceKey[]{AtmosphericStructures.VILLAGE_SCRUBLAND});
        context.register(SCRUBLAND_VILLAGE_LADDERS, (Object)StructureRepaletterEntry.repalette().repaletters(new StructureRepaletter[]{StructureRepaletterEntry.simple((Block)Blocks.LADDER, (Block)((Block)AtmosphericBlocks.LAUREL_LADDER.get()))}).select(scrublandVillage));
        context.register(SCRUBLAND_VILLAGE_BOOKSHELVES, (Object)StructureRepaletterEntry.repalette().repaletters(new StructureRepaletter[]{StructureRepaletterEntry.simple((Block)Blocks.BOOKSHELF, (Block)((Block)AtmosphericBlocks.LAUREL_BOOKSHELF.get()))}).select(scrublandVillage));
        context.register(SCRUBLAND_VILLAGE_CHESTS, (Object)StructureRepaletterEntry.repalette().repaletters(new StructureRepaletter[]{StructureRepaletterEntry.weighted((Block)Blocks.CHEST, (WeightedEntry.Wrapper[])new WeightedEntry.Wrapper[]{WeightedEntry.wrap((Object)((Block)AtmosphericBlocks.LAUREL_CHEST.get()), (int)1), WeightedEntry.wrap((Object)((Block)AtmosphericBlocks.MORADO_CHEST.get()), (int)1)})}).select(scrublandVillage));
    }

    public static void applyConditions(BiConsumer<ResourceKey<?>, ICondition> builder) {
        builder.accept(YUCCA_DESERT_VILLAGES, (ICondition)AtmosphericConditions.YUCCA_DESERT_VILLAGES);
        builder.accept(YUCCA_DESERT_VILLAGE_LADDERS, (ICondition)WoodworksConditions.compat((ICondition[])new ICondition[]{AtmosphericConditions.YUCCA_DESERT_VILLAGES, WoodworksConditions.WOODEN_LADDERS_IN_VILLAGES}));
        builder.accept(YUCCA_DESERT_VILLAGE_BOOKSHELVES, (ICondition)WoodworksConditions.compat((ICondition[])new ICondition[]{AtmosphericConditions.YUCCA_DESERT_VILLAGES, WoodworksConditions.WOODEN_BOOKSHELVES_IN_VILLAGES}));
        builder.accept(YUCCA_DESERT_VILLAGE_CHESTS, (ICondition)WoodworksConditions.compat((ICondition[])new ICondition[]{AtmosphericConditions.YUCCA_DESERT_VILLAGES, WoodworksConditions.WOODEN_CHESTS_IN_VILLAGES}));
        builder.accept(GRIMWOOD_ANCIENT_CITIES, (ICondition)AtmosphericConditions.GRIMWOOD_ANCIENT_CITIES);
        builder.accept(GRIMWOOD_ANCIENT_CITY_LADDERS, (ICondition)WoodworksConditions.compat((ICondition[])new ICondition[]{AtmosphericConditions.GRIMWOOD_ANCIENT_CITIES, WoodworksConditions.WOODEN_LADDERS_IN_VILLAGES}));
        builder.accept(GRIMWOOD_ANCIENT_CITY_CHESTS, (ICondition)WoodworksConditions.compat((ICondition[])new ICondition[]{AtmosphericConditions.GRIMWOOD_ANCIENT_CITIES, WoodworksConditions.WOODEN_CHESTS_IN_VILLAGES}));
        builder.accept(SCRUBLAND_VILLAGE_LADDERS, (ICondition)WoodworksConditions.compat((ICondition[])new ICondition[]{WoodworksConditions.WOODEN_LADDERS_IN_VILLAGES}));
        builder.accept(SCRUBLAND_VILLAGE_BOOKSHELVES, (ICondition)WoodworksConditions.compat((ICondition[])new ICondition[]{WoodworksConditions.WOODEN_BOOKSHELVES_IN_VILLAGES}));
        builder.accept(SCRUBLAND_VILLAGE_CHESTS, (ICondition)WoodworksConditions.compat((ICondition[])new ICondition[]{WoodworksConditions.WOODEN_CHESTS_IN_VILLAGES}));
    }

    private static ResourceKey<StructureRepaletterEntry> create(String name) {
        return ResourceKey.create((ResourceKey)BlueprintDataPackRegistries.STRUCTURE_REPALETTERS, (ResourceLocation)Atmospheric.location(name));
    }
}

