/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.core.registry.datapack;

import com.teamabnormals.atmospheric.core.Atmospheric;
import com.teamabnormals.atmospheric.core.other.tags.AtmosphericBiomeTags;
import com.teamabnormals.atmospheric.core.registry.datapack.AtmosphericTemplatePools;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;

public class AtmosphericStructures {
    public static final ResourceKey<Structure> ARID_GARDEN = AtmosphericStructures.create("arid_garden");
    public static final ResourceKey<Structure> KOUSA_SANCTUM = AtmosphericStructures.create("kousa_sanctum");
    public static final ResourceKey<Structure> VILLAGE_SCRUBLAND = AtmosphericStructures.create("village_scrubland");

    public static void bootstrap(BootstrapContext<Structure> context) {
        HolderGetter biomes = context.lookup(Registries.BIOME);
        HolderGetter templatePools = context.lookup(Registries.TEMPLATE_POOL);
        context.register(ARID_GARDEN, (Object)new JigsawStructure(new Structure.StructureSettings.Builder((HolderSet)biomes.getOrThrow(AtmosphericBiomeTags.HAS_ARID_GARDEN)).terrainAdapation(TerrainAdjustment.BEARD_THIN).build(), (Holder)templatePools.getOrThrow(AtmosphericTemplatePools.ARID_GARDEN), 6, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)0)), false, Heightmap.Types.WORLD_SURFACE_WG));
        context.register(KOUSA_SANCTUM, (Object)new JigsawStructure(new Structure.StructureSettings.Builder((HolderSet)biomes.getOrThrow(AtmosphericBiomeTags.HAS_KOUSA_SANCTUM)).terrainAdapation(TerrainAdjustment.BEARD_THIN).build(), (Holder)templatePools.getOrThrow(AtmosphericTemplatePools.KOUSA_SANCTUM), 2, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)0)), false, Heightmap.Types.WORLD_SURFACE_WG));
        context.register(VILLAGE_SCRUBLAND, (Object)new JigsawStructure(new Structure.StructureSettings.Builder((HolderSet)biomes.getOrThrow(AtmosphericBiomeTags.HAS_VILLAGE_SCRUBLAND)).terrainAdapation(TerrainAdjustment.BEARD_THIN).build(), (Holder)templatePools.getOrThrow(AtmosphericTemplatePools.VILLAGE_SCRUBLAND_TOWN_CENTERS), Optional.empty(), 6, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)0)), true, Optional.of(Heightmap.Types.WORLD_SURFACE_WG), 80, List.of(), JigsawStructure.DEFAULT_DIMENSION_PADDING, LiquidSettings.IGNORE_WATERLOGGING));
    }

    private static ResourceKey<Structure> create(String name) {
        return ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)Atmospheric.location(name));
    }

    public static class AtmosphericStructureSets {
        public static final ResourceKey<StructureSet> ARID_GARDENS = AtmosphericStructureSets.create("arid_gardens");
        public static final ResourceKey<StructureSet> KOUSA_SANCTUMS = AtmosphericStructureSets.create("kousa_sanctums");

        public static void bootstrap(BootstrapContext<StructureSet> context) {
            HolderGetter structures = context.lookup(Registries.STRUCTURE);
            context.register(ARID_GARDENS, (Object)new StructureSet((Holder)structures.getOrThrow(ARID_GARDEN), (StructurePlacement)new RandomSpreadStructurePlacement(24, 6, RandomSpreadType.LINEAR, 304972539)));
            context.register(KOUSA_SANCTUMS, (Object)new StructureSet((Holder)structures.getOrThrow(KOUSA_SANCTUM), (StructurePlacement)new RandomSpreadStructurePlacement(32, 8, RandomSpreadType.LINEAR, 502973253)));
        }

        private static ResourceKey<StructureSet> create(String name) {
            return ResourceKey.create((ResourceKey)Registries.STRUCTURE_SET, (ResourceLocation)Atmospheric.location(name));
        }
    }
}

