/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.core.registry.datapack;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.teamabnormals.atmospheric.core.Atmospheric;
import com.teamabnormals.atmospheric.core.registry.AtmosphericFeatures;
import com.teamabnormals.atmospheric.core.registry.datapack.AtmosphericProcessorLists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import org.apache.commons.compress.utils.Lists;

public class AtmosphericTemplatePools {
    public static final ResourceKey<StructureTemplatePool> KOUSA_SANCTUM = AtmosphericTemplatePools.create("kousa_sanctum");
    public static final ResourceKey<StructureTemplatePool> ARID_GARDEN = AtmosphericTemplatePools.create("arid_garden/arid_garden");
    public static final ResourceKey<StructureTemplatePool> PETRIFIED_GARDEN = AtmosphericTemplatePools.create("arid_garden/petrified_garden");
    public static final ResourceKey<StructureTemplatePool> ARID_GARDEN_DECOR = AtmosphericTemplatePools.create("arid_garden/decor");
    public static final ResourceKey<StructureTemplatePool> ARID_GARDEN_SAND = AtmosphericTemplatePools.create("arid_garden/sand");
    public static final ResourceKey<StructureTemplatePool> VILLAGE_SCRUBLAND_TOWN_CENTERS = AtmosphericTemplatePools.create("village/scrubland/town_centers");

    public static void bootstrap(BootstrapContext<StructureTemplatePool> context) {
        HolderGetter features = context.lookup(Registries.PLACED_FEATURE);
        HolderGetter processors = context.lookup(Registries.PROCESSOR_LIST);
        HolderGetter templatePools = context.lookup(Registries.TEMPLATE_POOL);
        Holder.Reference empty = templatePools.getOrThrow(Pools.EMPTY);
        context.register(ARID_GARDEN, (Object)AtmosphericTemplatePools.templatePool((Holder<StructureTemplatePool>)empty, "arid_garden/arid_garden", 6, (Holder<StructureProcessorList>)processors.getOrThrow(AtmosphericProcessorLists.ARID_GARDEN)));
        context.register(PETRIFIED_GARDEN, (Object)AtmosphericTemplatePools.singleTemplatePool((Holder<StructureTemplatePool>)empty, "arid_garden/petrified_garden/petrified_garden", 6, (Holder<StructureProcessorList>)processors.getOrThrow(AtmosphericProcessorLists.PETRIFIED_ARID_GARDEN)));
        context.register(ARID_GARDEN_DECOR, (Object)new StructureTemplatePool((Holder)empty, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.feature((Holder)features.getOrThrow(AtmosphericFeatures.AtmosphericPlacedFeatures.BABY_YUCCA_WITH_FLOWERS)), (Object)4)), StructureTemplatePool.Projection.RIGID));
        context.register(ARID_GARDEN_SAND, (Object)new StructureTemplatePool((Holder)empty, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.legacy((String)Atmospheric.location("arid_garden/sand").toString(), (Holder)processors.getOrThrow(AtmosphericProcessorLists.ARID_GARDEN_SAND_ARCHAEOLOGY)), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(KOUSA_SANCTUM, (Object)new StructureTemplatePool((Holder)empty, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.legacy((String)KOUSA_SANCTUM.location().toString(), (Holder)processors.getOrThrow(ProcessorLists.MOSSIFY_70_PERCENT)), (Object)1)), StructureTemplatePool.Projection.RIGID));
    }

    public static StructureTemplatePool templatePool(Holder<StructureTemplatePool> fallback, String name, int count, Holder<StructureProcessorList> processor) {
        ArrayList elements = Lists.newArrayList();
        for (int i = 1; i <= count; ++i) {
            String id = Atmospheric.location(name + "_" + i).toString();
            elements.add(Pair.of((Object)StructurePoolElement.legacy((String)id, processor), (Object)1));
        }
        return new StructureTemplatePool(fallback, (List)ImmutableList.copyOf((Collection)elements), StructureTemplatePool.Projection.RIGID);
    }

    public static StructureTemplatePool singleTemplatePool(Holder<StructureTemplatePool> fallback, String name, int count, Holder<StructureProcessorList> processor) {
        ArrayList elements = Lists.newArrayList();
        for (int i = 1; i <= count; ++i) {
            String id = Atmospheric.location(name + "_" + i).toString();
            elements.add(Pair.of((Object)StructurePoolElement.single((String)id, processor), (Object)1));
        }
        return new StructureTemplatePool(fallback, (List)ImmutableList.copyOf((Collection)elements), StructureTemplatePool.Projection.RIGID);
    }

    public static ResourceKey<StructureTemplatePool> create(String name) {
        return ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)Atmospheric.location(name));
    }
}

