/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.core.registry.datapack;

import com.teamabnormals.atmospheric.common.entity.TetraVariant;
import com.teamabnormals.atmospheric.core.Atmospheric;
import com.teamabnormals.atmospheric.core.registry.AtmosphericRegistries;
import net.minecraft.Util;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class AtmosphericTetraVariants {
    public static final ResourceKey<TetraVariant> NEON = AtmosphericTetraVariants.create("neon");
    public static final ResourceKey<TetraVariant> CARDINAL = AtmosphericTetraVariants.create("cardinal");
    public static final ResourceKey<TetraVariant> BEACON = AtmosphericTetraVariants.create("beacon");
    public static final ResourceKey<TetraVariant> DIAMOND = AtmosphericTetraVariants.create("diamond");
    public static final ResourceKey<TetraVariant> EMBER = AtmosphericTetraVariants.create("ember");
    public static final ResourceKey<TetraVariant> EMPEROR = AtmosphericTetraVariants.create("emperor");
    public static final ResourceKey<TetraVariant> FLAME = AtmosphericTetraVariants.create("flame");
    public static final ResourceKey<TetraVariant> JEWEL = AtmosphericTetraVariants.create("jewel");
    public static final ResourceKey<TetraVariant> ORNATE = AtmosphericTetraVariants.create("ornate");
    public static final ResourceKey<TetraVariant> ROYAL = AtmosphericTetraVariants.create("royal");
    public static final ResourceKey<TetraVariant> DEFAULT = NEON;

    public static void bootstrap(BootstrapContext<TetraVariant> context) {
        AtmosphericTetraVariants.register(context, NEON, 50);
        AtmosphericTetraVariants.register(context, CARDINAL, 50);
        AtmosphericTetraVariants.register(context, BEACON, 1);
        AtmosphericTetraVariants.register(context, DIAMOND, 1);
        AtmosphericTetraVariants.register(context, EMBER, 1);
        AtmosphericTetraVariants.register(context, EMPEROR, 1);
        AtmosphericTetraVariants.register(context, FLAME, 1);
        AtmosphericTetraVariants.register(context, JEWEL, 1);
        AtmosphericTetraVariants.register(context, ORNATE, 1);
        AtmosphericTetraVariants.register(context, ROYAL, 1);
    }

    public static void register(BootstrapContext<TetraVariant> context, ResourceKey<TetraVariant> key, int weight) {
        context.register(key, (Object)new TetraVariant(key.location().withPrefix("entity/tetra/"), (Component)Component.translatable((String)Util.makeDescriptionId((String)"tetra_variant", (ResourceLocation)key.location())), weight));
    }

    public static ResourceKey<TetraVariant> create(String name) {
        return ResourceKey.create(AtmosphericRegistries.TETRA_VARIANT, (ResourceLocation)Atmospheric.location(name));
    }
}

