/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.core.registry.datapack;

import com.teamabnormals.atmospheric.core.Atmospheric;
import com.teamabnormals.atmospheric.core.registry.AtmosphericItems;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimPattern;

public class AtmosphericTrimPatterns {
    public static final ResourceKey<TrimPattern> APOSTLE = AtmosphericTrimPatterns.createKey("apostle");
    public static final ResourceKey<TrimPattern> DRUID = AtmosphericTrimPatterns.createKey("druid");
    public static final ResourceKey<TrimPattern> PETRIFIED = AtmosphericTrimPatterns.createKey("petrified");

    public static void bootstrap(BootstrapContext<TrimPattern> context) {
        AtmosphericTrimPatterns.register(context, APOSTLE, (Item)AtmosphericItems.APOSTLE_ARMOR_TRIM_SMITHING_TEMPLATE.get());
        AtmosphericTrimPatterns.register(context, DRUID, (Item)AtmosphericItems.DRUID_ARMOR_TRIM_SMITHING_TEMPLATE.get());
        AtmosphericTrimPatterns.register(context, PETRIFIED, (Item)AtmosphericItems.PETRIFIED_ARMOR_TRIM_SMITHING_TEMPLATE.get());
    }

    public static ResourceKey<TrimPattern> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.TRIM_PATTERN, (ResourceLocation)Atmospheric.location(name));
    }

    private static void register(BootstrapContext<TrimPattern> context, ResourceKey<TrimPattern> key, Item item) {
        context.register(key, (Object)new TrimPattern(key.location(), BuiltInRegistries.ITEM.wrapAsHolder((Object)item), (Component)Component.translatable((String)Util.makeDescriptionId((String)"trim_pattern", (ResourceLocation)key.location())), false));
    }
}

