/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.core.registry.datapack;

import com.teamabnormals.atmospheric.core.Atmospheric;
import com.teamabnormals.atmospheric.core.registry.datapack.AtmosphericBiomes;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.animal.WolfVariant;
import net.minecraft.world.level.biome.Biome;

public class AtmosphericWolfVariants {
    public static final ResourceKey<WolfVariant> BUSH = AtmosphericWolfVariants.create("bush");
    public static final ResourceKey<WolfVariant> CREAM = AtmosphericWolfVariants.create("cream");
    public static final ResourceKey<WolfVariant> GOLDEN = AtmosphericWolfVariants.create("golden");
    public static final ResourceKey<WolfVariant> MANED = AtmosphericWolfVariants.create("maned");
    public static final ResourceKey<WolfVariant> MASKED = AtmosphericWolfVariants.create("masked");

    public static void bootstrap(BootstrapContext<WolfVariant> context) {
        AtmosphericWolfVariants.register(context, BUSH, "wolf_bush", AtmosphericBiomes.RAINFOREST);
        AtmosphericWolfVariants.register(context, CREAM, "wolf_cream", AtmosphericBiomes.LAUREL_FOREST);
        AtmosphericWolfVariants.register(context, GOLDEN, "wolf_golden", AtmosphericBiomes.ASPEN_PARKLAND);
        AtmosphericWolfVariants.register(context, MANED, "wolf_maned", AtmosphericBiomes.SPARSE_RAINFOREST);
        AtmosphericWolfVariants.register(context, MASKED, "wolf_masked", AtmosphericBiomes.KOUSA_JUNGLE);
    }

    private static ResourceKey<WolfVariant> create(String name) {
        return ResourceKey.create((ResourceKey)Registries.WOLF_VARIANT, (ResourceLocation)Atmospheric.location(name));
    }

    static void register(BootstrapContext<WolfVariant> context, ResourceKey<WolfVariant> key, String name, ResourceKey<Biome> spawnBiome) {
        AtmosphericWolfVariants.register(context, key, name, (HolderSet<Biome>)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.BIOME).getOrThrow(spawnBiome)}));
    }

    private static void register(BootstrapContext<WolfVariant> context, ResourceKey<WolfVariant> key, String name, TagKey<Biome> spawnBiomes) {
        AtmosphericWolfVariants.register(context, key, name, (HolderSet<Biome>)context.lookup(Registries.BIOME).getOrThrow(spawnBiomes));
    }

    private static void register(BootstrapContext<WolfVariant> context, ResourceKey<WolfVariant> key, String name, HolderSet<Biome> spawnBiomes) {
        ResourceLocation texture = Atmospheric.location("entity/wolf/" + name);
        ResourceLocation tame = Atmospheric.location("entity/wolf/" + name + "_tame");
        ResourceLocation angry = Atmospheric.location("entity/wolf/" + name + "_angry");
        context.register(key, (Object)new WolfVariant(texture, tame, angry, spawnBiomes));
    }
}

