/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast;

import com.mojang.logging.LogUtils;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.slf4j.Logger;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoBlockRenderer;
import team.recrafted.blastfromthepast.client.models.block.AntlerDisplayBlockModel;
import team.recrafted.blastfromthepast.client.models.boats.BFTPBoatModel;
import team.recrafted.blastfromthepast.client.models.boats.BFTPChestBoatModel;
import team.recrafted.blastfromthepast.client.renderers.block.BearTrapRenderer;
import team.recrafted.blastfromthepast.client.renderers.boat.BFTPBoatRenderer;
import team.recrafted.blastfromthepast.client.renderers.entity.BurrelRenderer;
import team.recrafted.blastfromthepast.client.renderers.entity.FrostomperRenderer;
import team.recrafted.blastfromthepast.client.renderers.entity.GlacerosRenderer;
import team.recrafted.blastfromthepast.client.renderers.entity.HollowRenderer;
import team.recrafted.blastfromthepast.client.renderers.entity.PsychoBearRenderer;
import team.recrafted.blastfromthepast.client.renderers.entity.SapRenderer;
import team.recrafted.blastfromthepast.client.renderers.entity.SnowdoRenderer;
import team.recrafted.blastfromthepast.client.renderers.entity.SpeartoothRenderer;
import team.recrafted.blastfromthepast.client.renderers.projectile.TarArrowRenderer;
import team.recrafted.blastfromthepast.client.renderers.projectile.ThrownIceSpearRenderer;
import team.recrafted.blastfromthepast.entity.boats.BFTPBoat;
import team.recrafted.blastfromthepast.entity.pack.EntityPacks;
import team.recrafted.blastfromthepast.events.CuriosCompat;
import team.recrafted.blastfromthepast.init.ModBlockEntities;
import team.recrafted.blastfromthepast.init.ModBlocks;
import team.recrafted.blastfromthepast.init.ModDataSerializers;
import team.recrafted.blastfromthepast.init.ModDecoratedPatterns;
import team.recrafted.blastfromthepast.init.ModEnchantments;
import team.recrafted.blastfromthepast.init.ModEntities;
import team.recrafted.blastfromthepast.init.ModFeatures;
import team.recrafted.blastfromthepast.init.ModFoliageTypes;
import team.recrafted.blastfromthepast.init.ModItems;
import team.recrafted.blastfromthepast.init.ModMobEffects;
import team.recrafted.blastfromthepast.init.ModSounds;
import team.recrafted.blastfromthepast.init.ModStructureProcessors;
import team.recrafted.blastfromthepast.init.ModTabs;
import team.recrafted.blastfromthepast.network.BearGloveWallAnimPayload;
import team.recrafted.blastfromthepast.network.FrostomperCollidePayload;
import team.recrafted.blastfromthepast.network.PsychoedEffectPayload;
import team.recrafted.blastfromthepast.network.RiddenEntityPayload;
import team.recrafted.blastfromthepast.network.ScreenShakePayload;
import team.recrafted.blastfromthepast.network.handlers.ClientPayloadHandler;
import team.recrafted.blastfromthepast.network.handlers.ServerPayloadHandler;

@Mod(value="blastfromthepast")
public class BlastFromThePast {
    public static final String MOD_ID = "blastfromthepast";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final boolean CURIOS_LOADED = ModList.get().isLoaded("curios");
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"blastfromthepast", (String)"main"), () -> "1", "1"::equals, "1"::equals);

    public BlastFromThePast(FMLJavaModLoadingContext context) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus modEventBus = context.getModEventBus();
        modEventBus.addListener(this::addCreative);
        ModEntities.ENTITIES.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        ModTabs.CREATIVE_TABS.register(modEventBus);
        ModBlocks.BLOCKS.register(modEventBus);
        ModSounds.SOUND_EVENTS.register(modEventBus);
        ModBlockEntities.BLOCK_ENTITY_TYPES.register(modEventBus);
        ModDecoratedPatterns.PATTERNS.register(modEventBus);
        ModFeatures.FEATURES.register(modEventBus);
        ModFeatures.TREE_DECORATORS.register(modEventBus);
        ModDataSerializers.DATA_SERIALIZERS.register(modEventBus);
        ModFoliageTypes.FOLIAGE_PLACER_TYPES.register(modEventBus);
        ModMobEffects.MOB_EFFECTS.register(modEventBus);
        ModStructureProcessors.STRUCTURE_PROCESSORS.register(modEventBus);
        ModEnchantments.ENCHANTMENTS.register(modEventBus);
        if (CURIOS_LOADED) {
            MinecraftForge.EVENT_BUS.register(CuriosCompat.class);
        }
        BlastFromThePast.registerPayloadHandlers();
    }

    private static void registerPayloadHandlers() {
        int i = 0;
        INSTANCE.registerMessage(i++, RiddenEntityPayload.class, RiddenEntityPayload::write, RiddenEntityPayload::read, ServerPayloadHandler::handleRiddenEntityPayload);
        INSTANCE.registerMessage(i++, FrostomperCollidePayload.class, FrostomperCollidePayload::write, FrostomperCollidePayload::read, ServerPayloadHandler::handleFroststomperCollidePayload);
        INSTANCE.registerMessage(i++, BearGloveWallAnimPayload.class, BearGloveWallAnimPayload::write, BearGloveWallAnimPayload::read, ClientPayloadHandler::handleBearGloveAnim);
        INSTANCE.registerMessage(i++, ScreenShakePayload.class, ScreenShakePayload::write, ScreenShakePayload::read, ClientPayloadHandler::handleScreenShake);
        INSTANCE.registerMessage(i++, PsychoedEffectPayload.class, PsychoedEffectPayload::write, PsychoedEffectPayload::read, ClientPayloadHandler::handlePsychoedShader);
    }

    public static EntityPacks getEntityPacks(ServerLevel level) {
        return (EntityPacks)level.m_8895_().m_164861_(tag -> EntityPacks.load(level, tag), () -> new EntityPacks(level), EntityPacks.getFileId());
    }

    public static EntityPacks getUniversalEntityPacks(MinecraftServer server) {
        return BlastFromThePast.getEntityPacks(server.m_129783_());
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.LevelTickEvent event) {
        Level level = event.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (event.level.m_46472_().equals((Object)Level.f_46428_) && serverLevel.m_7654_().m_130010_()) {
                BlastFromThePast.getEntityPacks(serverLevel).tick();
            }
        }
    }

    public static ResourceLocation location(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)name);
    }

    @Mod.EventBusSubscriber(modid="blastfromthepast", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.GLACEROS.get()), GlacerosRenderer::new);
                EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.SNOWDO.get()), SnowdoRenderer::new);
                EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.FROSTOMPER.get()), FrostomperRenderer::new);
                EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.PSYCHO_BEAR.get()), PsychoBearRenderer::new);
                EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.SPEARTOOTH.get()), SpeartoothRenderer::new);
                EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.BURREL.get()), BurrelRenderer::new);
                EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.HOLLOW.get()), HollowRenderer::new);
                EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.TAR_ARROW.get()), TarArrowRenderer::new);
                EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.SAP.get()), SapRenderer::new);
                EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.BFTPBOAT.get()), pContext -> new BFTPBoatRenderer(pContext, false));
                EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.BFTPCHEST_BOAT.get()), pContext -> new BFTPBoatRenderer(pContext, true));
                EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.ICE_SPEAR.get()), ThrownIceSpearRenderer::new);
                BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModBlockEntities.BEAR_TRAP.get()), BearTrapRenderer::new);
                BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModBlockEntities.SIGN.get()), SignRenderer::new);
                BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModBlockEntities.HANGING_SIGN.get()), HangingSignRenderer::new);
                BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModBlockEntities.ANTLER_DISPLAY.get()), context -> new GeoBlockRenderer((GeoModel)new AntlerDisplayBlockModel()));
                ItemProperties.register((Item)((Item)ModItems.ICE_SPEAR.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)BlastFromThePast.MOD_ID, (String)"throwing"), (stack, level, living, j) -> living != null && living.m_6117_() && living.m_21211_() == stack ? 1.0f : 0.0f);
            });
        }

        @SubscribeEvent
        public static void registerLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
            for (BFTPBoat.BoatType boat$type : BFTPBoat.BoatType.values()) {
                event.registerLayerDefinition(BFTPBoatRenderer.createBoatModelName(boat$type), BFTPBoatModel::createBodyModel);
                event.registerLayerDefinition(BFTPBoatRenderer.createChestBoatModelName(boat$type), BFTPChestBoatModel::createBodyModel);
            }
        }
    }
}

