/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.block;

import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DoubleHighBlockItem;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import team.recrafted.blastfromthepast.block.CedarLeavesBlock;
import team.recrafted.blastfromthepast.block.CedarLogBlock;
import team.recrafted.blastfromthepast.block.CustomLogBlock;
import team.recrafted.blastfromthepast.block.signs.BFTPCeilingHangingSignBlock;
import team.recrafted.blastfromthepast.block.signs.BFTPStandingSignBlock;
import team.recrafted.blastfromthepast.block.signs.BFTPWallHangingSignBlock;
import team.recrafted.blastfromthepast.block.signs.BFTPWallSignBlock;
import team.recrafted.blastfromthepast.init.ModItems;

public class BFTPWoodGroup {
    public final RegistryObject<Block> BLOCK;
    public final RegistryObject<SlabBlock> SLAB;
    public final RegistryObject<StairBlock> STAIRS;
    public final RegistryObject<FenceBlock> FENCE;
    public final RegistryObject<FenceGateBlock> FENCE_GATE;
    public final RegistryObject<RotatedPillarBlock> LOG;
    public final RegistryObject<RotatedPillarBlock> WOOD;
    public final RegistryObject<RotatedPillarBlock> STRIPPED_WOOD;
    public final RegistryObject<RotatedPillarBlock> STRIPPED_LOG;
    public final RegistryObject<DoorBlock> DOOR;
    public final RegistryObject<ButtonBlock> BUTTON;
    public final RegistryObject<PressurePlateBlock> PRESSURE_PLATE;
    public final RegistryObject<TrapDoorBlock> TRAPDOOR;
    public final RegistryObject<StandingSignBlock> SIGN;
    public final RegistryObject<WallSignBlock> WALL_SIGN;
    public final RegistryObject<CeilingHangingSignBlock> HANGING_SIGN;
    public final RegistryObject<WallHangingSignBlock> HANGING_SIGN_WALL;
    public final RegistryObject<Block> LEAVES;
    public final RegistryObject<Item> SIGN_ITEM;
    public final RegistryObject<Item> HANGING_SIGN_ITEM;
    public final WoodType woodType;
    public final BlockSetType woodSetType;

    public BFTPWoodGroup(String name, MapColor color, Item.Properties empty, DeferredRegister<Block> blockRegister) {
        this.woodSetType = BlockSetType.m_272115_((BlockSetType)new BlockSetType(name, true, SoundType.f_56736_, SoundEvents.f_12626_, SoundEvents.f_12627_, SoundEvents.f_12628_, SoundEvents.f_12628_, SoundEvents.f_12636_, SoundEvents.f_12637_, SoundEvents.f_12631_, SoundEvents.f_12632_));
        this.woodType = WoodType.m_61844_((WoodType)new WoodType("blastfromthepast:" + name, this.woodSetType));
        this.BLOCK = blockRegister.register(name, () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_).m_284180_(color)));
        this.SLAB = blockRegister.register(name + "_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50398_).m_284180_(color)));
        this.STAIRS = blockRegister.register(name + "_stairs", () -> new StairBlock(() -> ((Block)this.BLOCK.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50086_).m_284180_(color)));
        this.FENCE = blockRegister.register(name + "_fence", () -> new FenceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50132_).m_284180_(color)));
        this.FENCE_GATE = blockRegister.register(name + "_fence_gate", () -> new FenceGateBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50192_).m_284180_(color), this.woodType));
        this.STRIPPED_LOG = blockRegister.register("stripped_" + name + "_log", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50010_).m_284180_(color)));
        this.LOG = name.equals("cedar") ? blockRegister.register(name + "_log", () -> new CedarLogBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49999_).m_284180_(color), (Supplier<? extends RotatedPillarBlock>)this.STRIPPED_LOG)) : blockRegister.register(name + "_log", () -> new CustomLogBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49999_).m_284180_(color), (Supplier<? extends RotatedPillarBlock>)this.STRIPPED_LOG));
        this.STRIPPED_WOOD = blockRegister.register("stripped_" + name + "_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50044_).m_284180_(color)));
        this.WOOD = blockRegister.register(name + "_wood", () -> new CustomLogBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50011_).m_284180_(color), (Supplier<? extends RotatedPillarBlock>)this.STRIPPED_WOOD));
        this.DOOR = blockRegister.register(name + "_door", () -> new DoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50154_).m_284180_(color), this.woodSetType));
        this.BUTTON = blockRegister.register(name + "_button", () -> new ButtonBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50251_).m_284180_(color), this.woodSetType, 30, true));
        this.PRESSURE_PLATE = blockRegister.register(name + "_pressure_plate", () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50167_).m_284180_(color), this.woodSetType));
        this.SIGN = blockRegister.register(name + "_sign", () -> new BFTPStandingSignBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50095_).m_284180_(color), this.woodType));
        this.TRAPDOOR = blockRegister.register(name + "_trapdoor", () -> new TrapDoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50216_).m_284180_(color), this.woodSetType));
        this.WALL_SIGN = blockRegister.register(name + "_wall_sign", () -> new BFTPWallSignBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50158_).m_284180_(color), this.woodType));
        this.HANGING_SIGN = blockRegister.register(name + "_hanging_sign", () -> new BFTPCeilingHangingSignBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_244319_).m_284180_(color), this.woodType));
        this.HANGING_SIGN_WALL = blockRegister.register(name + "_hanging_wall_sign", () -> new BFTPWallHangingSignBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_244093_).m_284180_(color), this.woodType));
        this.LEAVES = name.equals("cedar") ? blockRegister.register("cedar_leaves", () -> new CedarLeavesBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60978_(0.2f).m_60977_().m_60918_(SoundType.f_56740_).m_60955_().m_60922_((pState, pLevel, pPos, pValue) -> pValue == EntityType.f_20505_ || pValue == EntityType.f_20508_).m_60960_((pState, pLevel, pPos) -> false).m_60971_((pState, pLevel, pPos) -> false).m_278183_().m_278166_(PushReaction.DESTROY).m_60924_((pState, pLevel, pPos) -> false))) : blockRegister.register(name + "_leaves", BFTPWoodGroup::leaves);
        ModItems.register(name, () -> new BlockItem((Block)this.BLOCK.get(), empty));
        ModItems.register(name + "_slab", () -> new BlockItem((Block)this.SLAB.get(), empty));
        ModItems.register(name + "_stairs", () -> new BlockItem((Block)this.STAIRS.get(), empty));
        ModItems.register(name + "_fence", () -> new BlockItem((Block)this.FENCE.get(), empty));
        ModItems.register(name + "_fence_gate", () -> new BlockItem((Block)this.FENCE_GATE.get(), empty));
        ModItems.register("stripped_" + name + "_log", () -> new BlockItem((Block)this.STRIPPED_LOG.get(), empty));
        ModItems.register(name + "_log", () -> new BlockItem((Block)this.LOG.get(), empty));
        ModItems.register(name + "_wood", () -> new BlockItem((Block)this.WOOD.get(), empty));
        ModItems.register("stripped_" + name + "_wood", () -> new BlockItem((Block)this.STRIPPED_WOOD.get(), empty));
        ModItems.register(name + "_button", () -> new BlockItem((Block)this.BUTTON.get(), empty));
        ModItems.register(name + "_pressure_plate", () -> new BlockItem((Block)this.PRESSURE_PLATE.get(), empty));
        ModItems.register(name + "_trapdoor", () -> new BlockItem((Block)this.TRAPDOOR.get(), empty));
        this.SIGN_ITEM = ModItems.register(name + "_sign", () -> new SignItem(empty, (Block)this.SIGN.get(), (Block)this.WALL_SIGN.get()));
        this.HANGING_SIGN_ITEM = ModItems.register(name + "_hanging_sign", () -> new HangingSignItem((Block)this.HANGING_SIGN.get(), (Block)this.HANGING_SIGN_WALL.get(), empty));
        ModItems.register(name + "_door", () -> new DoubleHighBlockItem((Block)this.DOOR.get(), empty));
        ModItems.register(name + "_leaves", () -> new BlockItem((Block)this.LEAVES.get(), empty));
    }

    public static Block leaves() {
        return new LeavesBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60978_(0.2f).m_60977_().m_60918_(SoundType.f_56740_).m_60955_().m_60922_((pState, pLevel, pPos, pValue) -> pValue == EntityType.f_20505_ || pValue == EntityType.f_20508_).m_60960_((pState, pLevel, pPos) -> false).m_60971_((pState, pLevel, pPos) -> false).m_278183_().m_278166_(PushReaction.DESTROY).m_60924_((pState, pLevel, pPos) -> false));
    }
}

