/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.block;

import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import team.recrafted.blastfromthepast.init.ModBlocks;
import team.recrafted.blastfromthepast.init.ModItems;
import team.recrafted.blastfromthepast.util.ShapeUtils;

public class BeastChopsBlock
extends RotatedPillarBlock {
    public static final IntegerProperty STATES = IntegerProperty.m_61631_((String)"states", (int)0, (int)4);
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    private static final VoxelShape FULL = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape FIRST = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0)});
    private static final VoxelShape SECOND = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0)});
    private static final VoxelShape THIRD = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), (VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0));
    private static VoxelShape FOURTH = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    protected static int levelModifier = 2;
    protected static float saturationmodifier = 0.1f;

    public BeastChopsBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)STATES, (Comparable)Integer.valueOf(0))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public BeastChopsBlock setLevelAndSaturation(int pLevelModifier, float pSaturationModifier) {
        levelModifier = pLevelModifier;
        saturationmodifier = pSaturationModifier;
        return this;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape baseShape = this.getVoxelShapeForState((Integer)state.m_61143_((Property)STATES));
        Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_);
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        return ShapeUtils.rotateShape(baseShape, axis, facing);
    }

    private VoxelShape getVoxelShapeForState(int state) {
        switch (state) {
            case 1: {
                return FIRST;
            }
            case 2: {
                return SECOND;
            }
            case 3: {
                return THIRD;
            }
            case 4: {
                return FOURTH;
            }
        }
        return FULL;
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder params) {
        if ((Integer)state.m_61143_((Property)STATES) == 0) {
            return super.m_49635_(state, params);
        }
        return Collections.emptyList();
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack itemStack = player.m_21120_(hand);
        if (!itemStack.m_41619_()) {
            this.useItemOn(itemStack, state, level, pos, player, hand, hitResult);
        }
        return this.useWithoutItem(state, level, pos, player, hitResult);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if ((Integer)state.m_61143_((Property)STATES) == 4) {
            return InteractionResult.PASS;
        }
        if (level.f_46443_) {
            if (BeastChopsBlock.eat((LevelAccessor)level, pos, state, player).m_19077_()) {
                return InteractionResult.SUCCESS;
            }
            if (player.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
                return InteractionResult.CONSUME;
            }
        }
        return BeastChopsBlock.eat((LevelAccessor)level, pos, state, player);
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_41720_() == ModItems.SAP_BALL.get()) {
            if (this != ModBlocks.BEAST_CHOPS_COOKED.get() || (Integer)state.m_61143_((Property)STATES) == 4) {
                return InteractionResult.FAIL;
            }
            level.m_7731_(pos, (BlockState)((BlockState)((BlockState)((Block)ModBlocks.BEAST_CHOPS_GLAZED.get()).m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)))).m_61124_((Property)f_55923_, (Comparable)((Direction.Axis)state.m_61143_((Property)f_55923_)))).m_61124_((Property)STATES, (Comparable)((Integer)state.m_61143_((Property)STATES))), 3);
            if (!player.m_7500_()) {
                itemStack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected static InteractionResult eat(LevelAccessor pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        if (!pPlayer.m_36391_(false)) {
            return InteractionResult.PASS;
        }
        pPlayer.m_36324_().m_38707_(levelModifier, saturationmodifier);
        int i = (Integer)pState.m_61143_((Property)STATES);
        pLevel.m_142346_((Entity)pPlayer, GameEvent.f_157806_, pPos);
        if (i < 5) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)STATES, (Comparable)Integer.valueOf(i + 1)), 3);
        } else {
            pLevel.m_7471_(pPos, false);
            pLevel.m_142346_((Entity)pPlayer, GameEvent.f_157794_, pPos);
        }
        pPlayer.m_5496_(SoundEvents.f_11912_, 1.0f, Mth.m_216283_((RandomSource)pLevel.m_213780_(), (float)0.8f, (float)1.2f));
        return InteractionResult.SUCCESS;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos belowPos = pos.m_7495_();
        BlockState belowState = level.m_8055_(belowPos);
        return belowState.m_60783_((BlockGetter)level, belowPos, Direction.UP);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{STATES, FACING, f_55923_});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)(context.m_43719_().m_122434_() == Direction.Axis.X ? context.m_43719_().m_122424_() : context.m_43719_()))).m_61124_((Property)f_55923_, (Comparable)context.m_43719_().m_122434_());
    }

    public boolean m_7357_(BlockState p_60475_, BlockGetter p_60476_, BlockPos p_60477_, PathComputationType p_60478_) {
        return false;
    }
}

