/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import team.recrafted.blastfromthepast.init.ModBlocks;
import team.recrafted.blastfromthepast.init.ModTreeGrowers;

public class PineconeBlock
extends SaplingBlock {
    public static final BooleanProperty HANGING;
    protected static final VoxelShape SHAPE;
    protected static final VoxelShape SHAPE_HANGING;
    private final AbstractTreeGrower treeGrower;

    public PineconeBlock(AbstractTreeGrower treeGrower, BlockBehaviour.Properties properties) {
        super(treeGrower, properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(false)));
        this.treeGrower = treeGrower;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_55973_}).m_61104_(new Property[]{HANGING});
    }

    protected boolean m_6266_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return super.m_6266_(state, level, pos) || state.m_60713_(Blocks.f_50129_);
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState state, @NotNull Direction directionUpdated, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        return directionUpdated == Direction.UP && !state.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, directionUpdated, facingState, level, currentPos, facingPos);
    }

    public boolean m_7898_(@NotNull BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        if (PineconeBlock.isHanging(state)) {
            return level.m_8055_(pos.m_7494_()).m_60713_((Block)ModBlocks.CEDAR.LEAVES.get());
        }
        return super.m_7898_(state, level, pos);
    }

    public void m_222000_(@NotNull ServerLevel level, @NotNull BlockPos pos, BlockState state, @NotNull RandomSource random) {
        if ((Integer)state.m_61143_((Property)f_55973_) == 0) {
            level.m_7731_(pos, (BlockState)state.m_61122_((Property)f_55973_), 4);
        } else if (random.m_188503_(100) < 20 || level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50599_)) {
            ModTreeGrowers.RUSTY_CEDAR.m_213817_(level, level.m_7726_().m_8481_(), pos, state, random);
        } else {
            this.treeGrower.m_213817_(level, level.m_7726_().m_8481_(), pos, state, random);
        }
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        if (PineconeBlock.isHanging(state)) {
            return SHAPE_HANGING;
        }
        return SHAPE;
    }

    public void m_213898_(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (!PineconeBlock.isHanging(state)) {
            super.m_213898_(state, level, pos, random);
        }
    }

    public boolean m_7370_(@NotNull LevelReader level, @NotNull BlockPos pos, @NotNull BlockState state, boolean p_55994_) {
        return !PineconeBlock.isHanging(state);
    }

    public boolean m_214167_(@NotNull Level level, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        return !PineconeBlock.isHanging(state) && super.m_214167_(level, random, pos, state);
    }

    private static boolean isHanging(BlockState state) {
        return (Boolean)state.m_61143_((Property)HANGING);
    }

    static {
        SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)4.0, (double)11.0);
        SHAPE_HANGING = Block.m_49796_((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0);
        HANGING = BlockStateProperties.f_61435_;
    }
}

