/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;
import team.recrafted.blastfromthepast.entity.SnowdoEntity;
import team.recrafted.blastfromthepast.init.ModEntities;

public class SnowdoEggBlock
extends Block {
    public static final int MAX_HATCH_LEVEL = 2;
    public static final int MIN_EGGS = 1;
    public static final int MAX_EGGS = 3;
    public static final IntegerProperty HATCH = BlockStateProperties.f_61416_;
    public static final IntegerProperty EGGS = IntegerProperty.m_61631_((String)"snowdo_eggs", (int)1, (int)3);

    public SnowdoEggBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HATCH, (Comparable)Integer.valueOf(0))).m_61124_((Property)EGGS, (Comparable)Integer.valueOf(1)));
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (!entity.m_20161_()) {
            this.destroyEgg(level, state, pos, entity, 100);
        }
        super.m_141947_(level, pos, state, entity);
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (!(entity instanceof Zombie)) {
            this.destroyEgg(level, state, pos, entity, 3);
        }
        super.m_142072_(level, state, pos, entity, fallDistance);
    }

    private void destroyEgg(Level level, BlockState state, BlockPos pos, Entity entity, int chance) {
        if (this.canDestroyEgg(level, entity) && !level.f_46443_ && level.f_46441_.m_188503_(chance) == 0 && state.m_60713_(Blocks.f_50578_)) {
            this.decreaseEggs(level, pos, state);
        }
    }

    private void decreaseEggs(Level level, BlockPos pos, BlockState state) {
        level.m_5594_(null, pos, SoundEvents.f_12533_, SoundSource.BLOCKS, 0.7f, 0.9f + level.f_46441_.m_188501_() * 0.2f);
        int i = (Integer)state.m_61143_((Property)EGGS);
        if (i <= 1) {
            level.m_46961_(pos, false);
        } else {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)EGGS, (Comparable)Integer.valueOf(i - 1)), 2);
            level.m_220407_(GameEvent.f_157794_, pos, GameEvent.Context.m_223722_((BlockState)state));
            level.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
        }
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (this.shouldUpdateHatchLevel((Level)level) && SnowdoEggBlock.onSuitableBlock((BlockGetter)level, pos)) {
            int i = (Integer)state.m_61143_((Property)HATCH);
            if (i < 2) {
                level.m_5594_(null, pos, SoundEvents.f_12534_, SoundSource.BLOCKS, 0.7f, 0.9f + random.m_188501_() * 0.2f);
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)HATCH, (Comparable)Integer.valueOf(i + 1)), 2);
                level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)state));
            } else {
                level.m_5594_(null, pos, SoundEvents.f_12535_, SoundSource.BLOCKS, 0.7f, 0.9f + random.m_188501_() * 0.2f);
                level.m_7471_(pos, false);
                level.m_220407_(GameEvent.f_157794_, pos, GameEvent.Context.m_223722_((BlockState)state));
                for (int j = 0; j < (Integer)state.m_61143_((Property)EGGS); ++j) {
                    level.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
                    SnowdoEntity turtle = (SnowdoEntity)((EntityType)ModEntities.SNOWDO.get()).m_20615_((Level)level);
                    if (turtle == null) continue;
                    turtle.m_146762_(-24000);
                    turtle.m_7678_((double)pos.m_123341_() + 0.3 + (double)j * 0.2, pos.m_123342_(), (double)pos.m_123343_() + 0.3, 0.0f, 0.0f);
                    level.m_7967_((Entity)turtle);
                }
            }
        }
    }

    public static boolean onSuitableBlock(BlockGetter level, BlockPos pos) {
        return SnowdoEggBlock.isSuitableBlock(level, pos.m_7495_());
    }

    public static boolean isSuitableBlock(BlockGetter reader, BlockPos pos) {
        BlockState state = reader.m_8055_(pos);
        return state.m_204336_(BlockTags.f_144274_) || state.m_60713_(Blocks.f_50127_) || state.m_60713_(Blocks.f_50125_);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (SnowdoEggBlock.onSuitableBlock((BlockGetter)level, pos) && !level.f_46443_) {
            level.m_46796_(2012, pos, 15);
        }
    }

    private boolean shouldUpdateHatchLevel(Level level) {
        return level.f_46441_.m_188503_(10) == 0;
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        super.m_6240_(level, player, pos, state, te, stack);
        this.decreaseEggs(level, pos, state);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        return !useContext.m_7078_() && useContext.m_43722_().m_150930_(this.m_5456_()) && (Integer)state.m_61143_((Property)EGGS) < 3 || super.m_6864_(state, useContext);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = context.m_43725_().m_8055_(context.m_8083_());
        return blockstate.m_60713_((Block)this) ? (BlockState)blockstate.m_61124_((Property)EGGS, (Comparable)Integer.valueOf(Math.min(3, (Integer)blockstate.m_61143_((Property)EGGS) + 1))) : super.m_5573_(context);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.0, (double)0.125, (double)0.3125, (double)0.3125, (double)0.3125), (BooleanOp)BooleanOp.f_82695_);
        if ((Integer)state.m_61143_((Property)EGGS) > 2) {
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.0, (double)0.625, (double)0.5, (double)0.5, (double)0.875), (BooleanOp)BooleanOp.f_82695_);
        }
        if ((Integer)state.m_61143_((Property)EGGS) > 1) {
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.625, (double)0.0, (double)0.25, (double)0.875, (double)0.375, (double)0.5), (BooleanOp)BooleanOp.f_82695_);
        }
        return shape;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HATCH, EGGS});
    }

    private boolean canDestroyEgg(Level level, Entity entity) {
        if (!(entity instanceof SnowdoEntity) && !(entity instanceof Bat)) {
            return !(entity instanceof LivingEntity) ? false : entity instanceof Player || ForgeEventFactory.getMobGriefingEvent((Level)level, (Entity)entity);
        }
        return false;
    }
}

