/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.block;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import team.recrafted.blastfromthepast.util.EntityHelper;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class TarBlock
extends Block {
    public static FogType FOG_TYPE;
    private static final float IN_BLOCK_HORIZONTAL_SPEED_MULTIPLIER = 0.25f;
    private static final float IN_BLOCK_VERTICAL_SPEED_MULTIPLIER = 0.1f;
    private static final float NUM_BLOCKS_TO_FALL_INTO_BLOCK = 2.5f;
    private static final VoxelShape FALLING_COLLISION_SHAPE;
    private static final double MINIMUM_FALL_DISTANCE_FOR_SOUND = 4.0;
    private static final double MINIMUM_FALL_DISTANCE_FOR_BIG_SOUND = 7.0;
    private static final float DROWNING_DAMAGE = 2.0f;
    public static final BooleanProperty COVER;

    public TarBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)COVER, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_6104_(BlockState state, BlockState adjacentState, Direction direction) {
        return adjacentState.m_60713_((Block)this) && state.m_61143_((Property)COVER) == adjacentState.m_61143_((Property)COVER) || super.m_6104_(state, adjacentState, direction);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.m_83040_();
    }

    public void m_7892_(BlockState state, Level level, BlockPos blockPos, Entity entity) {
        if (level.m_8055_(entity.m_20183_()).m_60713_((Block)this)) {
            entity.m_7601_(state, new Vec3(0.25, (double)0.1f, 0.25));
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            if (entity.f_19802_ == 0 && !entity.m_20147_()) {
                Vec3 checkPos = entity.m_146892_();
                if (((Boolean)state.m_61143_((Property)COVER)).booleanValue()) {
                    checkPos = checkPos.m_82520_(0.0, 0.07, 0.0);
                }
                if (BlockPos.m_274446_((Position)checkPos).equals((Object)blockPos)) {
                    entity.m_6469_(entity.m_269291_().m_269063_(), 2.0f);
                }
            }
        }
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (!((double)fallDistance < 4.0) && entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            LivingEntity.Fallsounds fallSounds = livingentity.m_196493_();
            SoundEvent soundevent = (double)fallDistance < 7.0 ? fallSounds.f_196626_() : fallSounds.f_196627_();
            entity.m_5496_(soundevent, 1.0f, 1.0f);
        }
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        EntityCollisionContext entitycollisioncontext;
        Entity entity;
        if (context instanceof EntityCollisionContext && (entity = (entitycollisioncontext = (EntityCollisionContext)context).m_193113_()) != null) {
            if (entity.f_19789_ > 2.5f) {
                return FALLING_COLLISION_SHAPE;
            }
            boolean flag = entity instanceof FallingBlockEntity;
            if (flag || TarBlock.canEntityWalkOn(entity) && context.m_6513_(Shapes.m_83144_(), pos, false) && !context.m_6226_()) {
                return super.m_5939_(state, level, pos, context);
            }
        }
        return Shapes.m_83040_();
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public static boolean canEntityWalkOn(Entity entity) {
        LivingEntity living;
        return entity instanceof LivingEntity && EntityHelper.canWalkOnTarBlocks(living = (LivingEntity)entity);
    }

    public boolean m_7357_(BlockState p_60475_, BlockGetter p_60476_, BlockPos p_60477_, PathComputationType p_60478_) {
        return false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{COVER});
    }

    static {
        FALLING_COLLISION_SHAPE = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.9f, (double)1.0);
        COVER = BooleanProperty.m_61465_((String)"cover");
    }
}

