/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.client.models.boats;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.WaterPatchModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import team.recrafted.blastfromthepast.entity.boats.BFTPBoat;

public class BFTPBoatModel
extends ListModel<BFTPBoat>
implements WaterPatchModel {
    private final ModelPart leftPaddle;
    private final ModelPart rightPaddle;
    private final ModelPart waterPatch;
    private final ImmutableList<ModelPart> parts;

    public BFTPBoatModel(ModelPart pRoot) {
        this.leftPaddle = pRoot.m_171324_("left_paddle");
        this.rightPaddle = pRoot.m_171324_("right_paddle");
        this.waterPatch = pRoot.m_171324_("water_patch");
        this.parts = this.createPartsBuilder(pRoot).build();
    }

    protected ImmutableList.Builder<ModelPart> createPartsBuilder(ModelPart pRoot) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.add((Object[])new ModelPart[]{pRoot.m_171324_("bottom"), pRoot.m_171324_("back"), pRoot.m_171324_("front"), pRoot.m_171324_("right"), pRoot.m_171324_("left"), this.leftPaddle, this.rightPaddle});
        return builder;
    }

    public static void createChildren(PartDefinition pRoot) {
        pRoot.m_171599_("bottom", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-14.0f, -9.0f, -3.0f, 28.0f, 16.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)1.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        pRoot.m_171599_("back", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171481_(-13.0f, -7.0f, -1.0f, 18.0f, 6.0f, 2.0f), PartPose.m_171423_((float)-15.0f, (float)4.0f, (float)4.0f, (float)0.0f, (float)4.712389f, (float)0.0f));
        pRoot.m_171599_("front", CubeListBuilder.m_171558_().m_171514_(0, 27).m_171481_(-8.0f, -7.0f, -1.0f, 16.0f, 6.0f, 2.0f), PartPose.m_171423_((float)15.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)1.5707964f, (float)0.0f));
        pRoot.m_171599_("right", CubeListBuilder.m_171558_().m_171514_(0, 35).m_171481_(-14.0f, -7.0f, -1.0f, 28.0f, 6.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)-9.0f, (float)0.0f, (float)((float)Math.PI), (float)0.0f));
        pRoot.m_171599_("left", CubeListBuilder.m_171558_().m_171514_(0, 43).m_171481_(-14.0f, -7.0f, -1.0f, 28.0f, 6.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)9.0f));
        pRoot.m_171599_("left_paddle", CubeListBuilder.m_171558_().m_171514_(62, 0).m_171481_(-1.0f, 0.0f, -5.0f, 2.0f, 2.0f, 18.0f).m_171481_(-1.001f, -3.0f, 8.0f, 1.0f, 6.0f, 7.0f), PartPose.m_171423_((float)3.0f, (float)-5.0f, (float)9.0f, (float)0.0f, (float)0.0f, (float)0.19634955f));
        pRoot.m_171599_("right_paddle", CubeListBuilder.m_171558_().m_171514_(62, 20).m_171481_(-1.0f, 0.0f, -5.0f, 2.0f, 2.0f, 18.0f).m_171481_(0.001f, -3.0f, 8.0f, 1.0f, 6.0f, 7.0f), PartPose.m_171423_((float)3.0f, (float)-5.0f, (float)-9.0f, (float)0.0f, (float)((float)Math.PI), (float)0.19634955f));
        pRoot.m_171599_("water_patch", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-14.0f, -9.0f, -3.0f, 28.0f, 16.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)1.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
    }

    public static LayerDefinition createBodyModel() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        BFTPBoatModel.createChildren(partdefinition);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(BFTPBoat pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        BFTPBoatModel.animatePaddle(pEntity, 0, this.leftPaddle, pLimbSwing);
        BFTPBoatModel.animatePaddle(pEntity, 1, this.rightPaddle, pLimbSwing);
    }

    public ImmutableList<ModelPart> parts() {
        return this.parts;
    }

    public ModelPart m_102282_() {
        return this.waterPatch;
    }

    private static void animatePaddle(BFTPBoat pBoat, int pSide, ModelPart pPaddle, float pLimbSwing) {
        float f = pBoat.m_38315_(pSide, pLimbSwing);
        pPaddle.f_104203_ = Mth.m_144920_((float)-1.0471976f, (float)-0.2617994f, (float)((Mth.m_14031_((float)(-f)) + 1.0f) / 2.0f));
        pPaddle.f_104204_ = Mth.m_144920_((float)-0.7853982f, (float)0.7853982f, (float)((Mth.m_14031_((float)(-f + 1.0f)) + 1.0f) / 2.0f));
        if (pSide == 1) {
            pPaddle.f_104204_ = (float)Math.PI - pPaddle.f_104204_;
        }
    }
}

