/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.datagen.client;

import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;
import team.recrafted.blastfromthepast.BlastFromThePast;
import team.recrafted.blastfromthepast.block.BFTPBlockGroup;
import team.recrafted.blastfromthepast.block.BFTPStoneGroup;
import team.recrafted.blastfromthepast.block.BFTPWoodGroup;
import team.recrafted.blastfromthepast.block.BeastChopsBlock;
import team.recrafted.blastfromthepast.block.FemurBlock;
import team.recrafted.blastfromthepast.block.PsychoBerryBush;
import team.recrafted.blastfromthepast.block.SnowdoEggBlock;
import team.recrafted.blastfromthepast.block.TarBlock;
import team.recrafted.blastfromthepast.block.signs.SnowyStoneBlock;
import team.recrafted.blastfromthepast.init.ModBlocks;

public class ModBlockStateGen
extends BlockStateProvider {
    public ModBlockStateGen(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "blastfromthepast", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.logBlock((RotatedPillarBlock)ModBlocks.SAPPY_CEDAR_LOG.get());
        this.registerWoodGroup(ModBlocks.CEDAR);
        this.registerStoneGroup(ModBlocks.PERMAFROST);
        this.createDoublePlantBlock(ModBlocks.ROYAL_LARKSPUR);
        this.createDoublePlantBlock(ModBlocks.SHIVER_LARKSPUR);
        this.createDoublePlantBlock(ModBlocks.BLUSH_LARKSPUR);
        this.createDoublePlantBlock(ModBlocks.SNOW_LARKSPUR);
        this.createFemurBlock();
        this.createPsychoBerryBush();
        this.createSinglePlant(ModBlocks.PSYCHO_BERRY_SPROUT);
        this.createSnowdoEggs();
        this.generateBeastChopsBlockState(ModBlocks.BEAST_CHOPS);
        this.generateBeastChopsBlockState(ModBlocks.BEAST_CHOPS_COOKED);
        this.generateBeastChopsBlockState(ModBlocks.BEAST_CHOPS_GLAZED);
        this.generateTarModel();
        this.registerBlockGroup(ModBlocks.SNOW_BRICK);
        this.registerBlockGroup(ModBlocks.ICE_BRICK);
        this.createSinglePlant(ModBlocks.SILENE);
        this.simpleBlock((Block)ModBlocks.CHILLY_MOSS.get());
        this.simpleBlock((Block)ModBlocks.CHILLY_MOSS_SPROUT.get(), (ModelFile)((BlockModelBuilder)this.models().cubeBottomTop(ModBlocks.CHILLY_MOSS_SPROUT.getId().m_135815_(), this.modLoc("block/" + ModBlocks.CHILLY_MOSS_SPROUT.getId().m_135815_()), this.modLoc("block/empty"), this.modLoc("block/empty"))).renderType("cutout_mipped"));
        this.generatePermafrostPainting(ModBlocks.PERMAFROST_BURREL_PAINTING);
        this.generatePermafrostPainting(ModBlocks.PERMAFROST_SNOWDO_PAINTING);
        this.generatePermafrostPainting(ModBlocks.PERMAFROST_GLACEROS_PAINTING);
        this.generatePermafrostPainting(ModBlocks.PERMAFROST_PSYCHO_BEAR_PAINTING);
        this.generatePermafrostPainting(ModBlocks.PERMAFROST_SPEARTOOTH_PAINTING);
        this.generatePermafrostPainting(ModBlocks.PERMAFROST_FROSTOMPER_PAINTING_TOP_RIGHT);
        this.generatePermafrostPainting(ModBlocks.PERMAFROST_FROSTOMPER_PAINTING_TOP_LEFT);
        this.generatePermafrostPainting(ModBlocks.PERMAFROST_FROSTOMPER_PAINTING_BOTTOM_RIGHT);
        this.generatePermafrostPainting(ModBlocks.PERMAFROST_FROSTOMPER_PAINTING_BOTTOM_LEFT);
        this.generateTotemPole(ModBlocks.BURREL_TOTEM_POLE);
        this.generateTotemPole(ModBlocks.SNOWDO_TOTEM_POLE);
        this.generateTotemPole(ModBlocks.GLACEROS_TOTEM_POLE);
        this.generateTotemPole(ModBlocks.PSYCHO_BEAR_TOTEM_POLE);
        this.generateTotemPole(ModBlocks.SPEARTOOTH_TOTEM_POLE);
        this.generateTotemPole(ModBlocks.FROSTOMPER_TOTEM_POLE);
    }

    public void generateTotemPole(RegistryObject<Block> block) {
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> {
            Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
            return ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(block.getId())).rotationY(dir.m_122434_().m_122478_() ? 0 : ((int)dir.m_122435_() + 180) % 360).build();
        });
    }

    public void generatePermafrostPainting(RegistryObject<Block> block) {
        ResourceLocation permafrost = this.modLoc("block/permafrost");
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> {
            Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().cube(block.getId().m_135815_(), permafrost, this.modLoc("block/" + block.getId().m_135815_()), permafrost, permafrost, permafrost, permafrost)).texture("particle", permafrost)).rotationX(dir == Direction.DOWN ? 180 : (dir.m_122434_().m_122479_() ? -90 : 0)).rotationY(dir.m_122434_().m_122478_() ? 0 : (int)dir.m_122435_() % 360).build();
        });
    }

    public void generateTarModel() {
        ModelFile.ExistingModelFile tar = this.models().getExistingFile(BlastFromThePast.location("tar"));
        ModelFile.ExistingModelFile tar_cover = this.models().getExistingFile(BlastFromThePast.location("tar_cover"));
        this.getVariantBuilder((Block)ModBlocks.TAR.get()).forAllStates(state -> {
            boolean cover = (Boolean)state.m_61143_((Property)TarBlock.COVER);
            ModelFile.ExistingModelFile modelFile = tar;
            if (cover) {
                modelFile = tar_cover;
            }
            return ConfiguredModel.builder().modelFile((ModelFile)modelFile).build();
        });
    }

    public void generateBeastChopsBlockState(RegistryObject<Block> block) {
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> {
            Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_);
            int blockState = (Integer)state.m_61143_((Property)BeastChopsBlock.STATES);
            Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
            String modelPath = block.getId().m_135815_() + "_" + blockState;
            if (blockState == 4) {
                modelPath = ModBlocks.BEAST_CHOPS.getId().m_135815_() + "_4";
            }
            ConfiguredModel.Builder builder = ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(this.modLoc(modelPath)));
            if (axis == Direction.Axis.Y) {
                builder.rotationX(facing == Direction.DOWN ? 180 : 0);
            } else if (axis == Direction.Axis.Z) {
                builder.rotationX(90).rotationY(facing == Direction.NORTH ? 0 : 180);
            } else if (axis == Direction.Axis.X) {
                builder.rotationX(90).rotationY(facing == Direction.WEST ? 90 : 270);
            }
            return builder.build();
        });
    }

    private void createSnowdoEggs() {
        BlockModelBuilder three_eggs_smooth = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("three_eggs_smooth", this.modLoc("block/snowdo_eggs"))).texture("1", this.modLoc("block/three_eggs_smooth"));
        BlockModelBuilder three_eggs_chipped = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("three_eggs_chipped", this.modLoc("block/snowdo_eggs"))).texture("1", this.modLoc("block/three_eggs_chipped"));
        BlockModelBuilder three_eggs_cracked = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("three_eggs_cracked", this.modLoc("block/snowdo_eggs"))).texture("1", this.modLoc("block/three_eggs_cracked"));
        BlockModelBuilder two_eggs_smooth = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("two_eggs_smooth", this.modLoc("block/snowdo_eggs"))).texture("1", this.modLoc("block/two_eggs_smooth"));
        BlockModelBuilder two_eggs_chipped = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("two_eggs_chipped", this.modLoc("block/snowdo_eggs"))).texture("1", this.modLoc("block/two_eggs_chipped"));
        BlockModelBuilder two_eggs_cracked = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("two_eggs_cracked", this.modLoc("block/snowdo_eggs"))).texture("1", this.modLoc("block/two_eggs_cracked"));
        BlockModelBuilder one_egg_smooth = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("one_egg_smooth", this.modLoc("block/snowdo_eggs"))).texture("1", this.modLoc("block/one_egg_smooth"));
        BlockModelBuilder one_egg_chipped = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("one_egg_chipped", this.modLoc("block/snowdo_eggs"))).texture("1", this.modLoc("block/one_egg_chipped"));
        BlockModelBuilder one_egg_cracked = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("one_egg_cracked", this.modLoc("block/snowdo_eggs"))).texture("1", this.modLoc("block/one_egg_cracked"));
        this.getVariantBuilder((Block)ModBlocks.SNOWDO_EGG.get()).forAllStates(state -> {
            BlockModelBuilder modelBuilder;
            int hatch = (Integer)state.m_61143_((Property)BlockStateProperties.f_61416_);
            int eggs = (Integer)state.m_61143_((Property)SnowdoEggBlock.EGGS);
            if (eggs == 3) {
                modelBuilder = switch (hatch) {
                    case 1 -> three_eggs_chipped;
                    case 2 -> three_eggs_cracked;
                    default -> three_eggs_smooth;
                };
            } else if (eggs == 2) {
                modelBuilder = switch (hatch) {
                    case 1 -> two_eggs_chipped;
                    case 2 -> two_eggs_cracked;
                    default -> two_eggs_smooth;
                };
            } else {
                modelBuilder = switch (hatch) {
                    case 1 -> one_egg_chipped;
                    case 2 -> one_egg_cracked;
                    default -> one_egg_smooth;
                };
            }
            return ConfiguredModel.builder().modelFile((ModelFile)modelBuilder).uvLock(false).build();
        });
    }

    private void createFemurBlock() {
        BlockModelBuilder connectedFemur = (BlockModelBuilder)this.models().withExistingParent("femur_connected", this.modLoc("block/tipless_beastly_femur"));
        BlockModelBuilder femur = (BlockModelBuilder)this.models().withExistingParent("femur", this.modLoc("block/beastly_femur"));
        this.getVariantBuilder((Block)ModBlocks.BEASTLY_FEMUR.get()).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)((Boolean)state.m_61143_((Property)FemurBlock.CONNECTED) != false ? connectedFemur : femur)).rotationY((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() % 360).build(), new Property[0]);
    }

    private void createPsychoBerryBush() {
        BlockModelBuilder berriesBush = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("grown_psycho_berry_bush", this.modLoc("block/thorns"))).texture("2", "block/thorn_berries");
        BlockModelBuilder flowerBush = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("flower_psycho_berry_bush", this.modLoc("block/thorns"))).texture("2", "block/thorn_flowers");
        BlockModelBuilder bush = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("psycho_berry_bush", this.modLoc("block/thorns"))).texture("2", "block/thorns");
        this.getVariantBuilder((Block)ModBlocks.PSYCHO_BERRY_BUSH.get()).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)((Integer)state.m_61143_((Property)PsychoBerryBush.AGE) == 2 ? berriesBush : ((Integer)state.m_61143_((Property)PsychoBerryBush.AGE) == 1 ? flowerBush : bush))).build(), new Property[0]);
    }

    private void registerStoneGroup(BFTPStoneGroup stoneGroup) {
        this.createSnowyBlock(stoneGroup.STONE, (ModelFile)this.models().cubeAll(this.name((Block)stoneGroup.STONE.get()), this.blockTexture((Block)stoneGroup.STONE.get())), (ModelFile)this.models().cubeBottomTop("snowy_" + this.name((Block)stoneGroup.STONE.get()), this.modLoc("block/snowy_" + stoneGroup.STONE.getId().m_135815_()), this.blockTexture((Block)stoneGroup.STONE.get()), this.blockTexture(Blocks.f_50125_)));
        this.stairsBlock((StairBlock)stoneGroup.STAIRS.get(), this.blockTexture((Block)stoneGroup.STONE.get()));
        this.slabBlock((SlabBlock)stoneGroup.SLAB.get(), this.blockTexture((Block)stoneGroup.STONE.get()), this.blockTexture((Block)stoneGroup.STONE.get()));
        this.wallBlock((WallBlock)stoneGroup.WALL.get(), this.blockTexture((Block)stoneGroup.STONE.get()));
        this.simpleBlock((Block)stoneGroup.BRICKS.get());
        this.stairsBlock((StairBlock)stoneGroup.BRICKS_STAIRS.get(), this.blockTexture((Block)stoneGroup.BRICKS.get()));
        this.slabBlock((SlabBlock)stoneGroup.BRICKS_SLAB.get(), this.blockTexture((Block)stoneGroup.BRICKS.get()), this.blockTexture((Block)stoneGroup.BRICKS.get()));
        this.wallBlock((WallBlock)stoneGroup.BRICKS_WALL.get(), this.blockTexture((Block)stoneGroup.BRICKS.get()));
        this.simpleBlock((Block)stoneGroup.COBBLESTONE.get());
        this.stairsBlock((StairBlock)stoneGroup.COBBLESTONE_STAIRS.get(), this.blockTexture((Block)stoneGroup.COBBLESTONE.get()));
        this.slabBlock((SlabBlock)stoneGroup.COBBLESTONE_SLAB.get(), this.blockTexture((Block)stoneGroup.COBBLESTONE.get()), this.blockTexture((Block)stoneGroup.COBBLESTONE.get()));
        this.wallBlock((WallBlock)stoneGroup.COBBLESTONE_WALL.get(), this.blockTexture((Block)stoneGroup.COBBLESTONE.get()));
        this.simpleBlock((Block)stoneGroup.POLISHED.get());
        this.stairsBlock((StairBlock)stoneGroup.POLISHED_STAIRS.get(), this.blockTexture((Block)stoneGroup.POLISHED.get()));
        this.slabBlock((SlabBlock)stoneGroup.POLISHED_SLAB.get(), this.blockTexture((Block)stoneGroup.POLISHED.get()), this.blockTexture((Block)stoneGroup.POLISHED.get()));
        this.wallBlock((WallBlock)stoneGroup.POLISHED_WALL.get(), this.blockTexture((Block)stoneGroup.POLISHED.get()));
        this.simpleBlock((Block)stoneGroup.CHISELED_BRICKS.get());
        for (RegistryObject<? extends Block> block : stoneGroup.blocks) {
            if (!block.getId().m_135815_().contains("ore")) continue;
            this.simpleBlock((Block)block.get());
        }
    }

    private void registerWoodGroup(BFTPWoodGroup group) {
        this.simpleBlock((Block)group.BLOCK.get());
        if (group != ModBlocks.CEDAR) {
            this.simpleBlock((Block)group.LEAVES.get());
        }
        this.logBlock((RotatedPillarBlock)group.LOG.get());
        this.logBlock((RotatedPillarBlock)group.STRIPPED_LOG.get());
        this.axisBlock((RotatedPillarBlock)group.WOOD.get(), this.blockTexture((Block)group.LOG.get()), this.blockTexture((Block)group.LOG.get()));
        this.axisBlock((RotatedPillarBlock)group.STRIPPED_WOOD.get(), this.blockTexture((Block)group.STRIPPED_LOG.get()), this.blockTexture((Block)group.STRIPPED_LOG.get()));
        this.slabBlock((SlabBlock)group.SLAB.get(), this.blockTexture((Block)group.BLOCK.get()), this.blockTexture((Block)group.BLOCK.get()));
        this.stairsBlock((StairBlock)group.STAIRS.get(), this.blockTexture((Block)group.BLOCK.get()));
        this.models().fenceInventory(this.name((Block)group.FENCE.get()) + "_inventory", this.blockTexture((Block)group.BLOCK.get()));
        this.fenceBlock((FenceBlock)group.FENCE.get(), this.blockTexture((Block)group.BLOCK.get()));
        this.fenceGateBlock((FenceGateBlock)group.FENCE_GATE.get(), this.blockTexture((Block)group.BLOCK.get()));
        this.doorBlockWithRenderType((DoorBlock)group.DOOR.get(), this.blockTexture((Block)group.DOOR.get()).m_266382_("_bottom"), this.blockTexture((Block)group.DOOR.get()).m_266382_("_top"), "cutout_mipped");
        this.trapdoorBlockWithRenderType((TrapDoorBlock)group.TRAPDOOR.get(), this.blockTexture((Block)group.TRAPDOOR.get()), true, "cutout_mipped");
        this.pressurePlateBlock((PressurePlateBlock)group.PRESSURE_PLATE.get(), this.blockTexture((Block)group.BLOCK.get()));
        this.models().buttonInventory(this.name((Block)group.BUTTON.get()) + "_inventory", this.blockTexture((Block)group.BLOCK.get()));
        this.buttonBlock((ButtonBlock)group.BUTTON.get(), this.blockTexture((Block)group.BLOCK.get()));
        this.signBlock((StandingSignBlock)group.SIGN.get(), (WallSignBlock)group.WALL_SIGN.get(), this.blockTexture((Block)group.BLOCK.get()));
        this.hangingSign(group.HANGING_SIGN, group.HANGING_SIGN_WALL, this.blockTexture((Block)group.STRIPPED_LOG.get()));
    }

    private void registerBlockGroup(BFTPBlockGroup blockGroup) {
        this.simpleBlock((Block)blockGroup.BLOCK.get());
        this.stairsBlock((StairBlock)blockGroup.STAIRS.get(), this.blockTexture((Block)blockGroup.BLOCK.get()));
        this.slabBlock((SlabBlock)blockGroup.SLAB.get(), this.blockTexture((Block)blockGroup.BLOCK.get()), this.blockTexture((Block)blockGroup.BLOCK.get()));
        this.wallBlock((WallBlock)blockGroup.WALL.get(), this.blockTexture((Block)blockGroup.BLOCK.get()));
    }

    private void hangingSign(RegistryObject<CeilingHangingSignBlock> hangingSignBlock, RegistryObject<WallHangingSignBlock> wallHangingSignBlock, ResourceLocation texture) {
        ModelBuilder sign = this.models().sign(hangingSignBlock.getId().m_135815_(), texture);
        this.hangingSign(hangingSignBlock, wallHangingSignBlock, (ModelFile)sign);
    }

    private void hangingSign(RegistryObject<CeilingHangingSignBlock> hangingSignBlock, RegistryObject<WallHangingSignBlock> wallHangingSignBlock, ModelFile sign) {
        this.simpleBlock((Block)hangingSignBlock.get(), sign);
        this.simpleBlock((Block)wallHangingSignBlock.get(), sign);
    }

    private String name(Block block) {
        return BuiltInRegistries.f_256975_.m_7981_((Object)block).m_135815_();
    }

    private void createSinglePlant(RegistryObject<Block> block) {
        this.createSinglePlant(block, (ModelFile)((BlockModelBuilder)this.models().cross(block.getId().m_135815_(), this.modLoc("block/" + block.getId().m_135815_()))).renderType("cutout_mipped"));
    }

    private void createSinglePlant(RegistryObject<Block> block, ModelFile model) {
        this.getVariantBuilder((Block)block.get()).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile(model).uvLock(true).build(), new Property[0]);
    }

    private void createDoublePlantBlock(RegistryObject<Block> block) {
        this.createDoublePlantBlock(block, (ModelFile)((BlockModelBuilder)this.models().cross(block.getId().m_135815_() + "_top", this.modLoc("block/" + block.getId().m_135815_() + "_top"))).renderType("cutout_mipped"), (ModelFile)((BlockModelBuilder)this.models().cross(block.getId().m_135815_() + "_bottom", this.modLoc("block/" + block.getId().m_135815_() + "_bottom"))).renderType("cutout_mipped"));
    }

    private void createDoublePlantBlock(RegistryObject<Block> block, ModelFile upper, ModelFile bottom) {
        this.getVariantBuilder((Block)block.get()).forAllStatesExcept(state -> {
            ModelFile model = bottom;
            if (state.m_61143_((Property)DoublePlantBlock.f_52858_) == DoubleBlockHalf.UPPER) {
                model = upper;
            }
            return ConfiguredModel.builder().modelFile(model).uvLock(true).build();
        }, new Property[0]);
    }

    private void createSnowyBlock(RegistryObject<Block> block, ModelFile stone, ModelFile snowy) {
        this.getVariantBuilder((Block)block.get()).forAllStatesExcept(state -> {
            ModelFile model = stone;
            if (((Boolean)state.m_61143_((Property)SnowyStoneBlock.SNOWY)).booleanValue()) {
                model = snowy;
            }
            return ConfiguredModel.builder().modelFile(model).uvLock(true).build();
        }, new Property[0]);
    }

    private ResourceLocation key(Block block) {
        return BuiltInRegistries.f_256975_.m_7981_((Object)block);
    }
}

