/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import team.recrafted.blastfromthepast.entity.ai.goal.burrel.BurrelClimbTreeGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.burrel.BurrelEatGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.burrel.BurrelGoToTreesGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.burrel.BurrelRandomStrollGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.burrel.BurrelSleepGoal;
import team.recrafted.blastfromthepast.entity.ai.navigation.AzureNavigation;
import team.recrafted.blastfromthepast.init.ModBlocks;
import team.recrafted.blastfromthepast.init.ModEntities;
import team.recrafted.blastfromthepast.init.ModSounds;
import team.recrafted.blastfromthepast.util.EntityHelper;

public class BurrelEntity
extends TamableAnimal
implements GeoEntity {
    public static final RawAnimation WALK = RawAnimation.begin().then("animation.burrel.walk", Animation.LoopType.DEFAULT);
    public static final RawAnimation IDLE = RawAnimation.begin().then("animation.burrel.idle", Animation.LoopType.DEFAULT);
    public static final RawAnimation LOOK = RawAnimation.begin().then("animation.burrel.look", Animation.LoopType.DEFAULT);
    public static final RawAnimation CLIMB = RawAnimation.begin().then("animation.burrel.climb", Animation.LoopType.DEFAULT);
    public static final RawAnimation DANCE = RawAnimation.begin().then("animation.burrel.dance", Animation.LoopType.DEFAULT);
    public static final RawAnimation EAT = RawAnimation.begin().then("animation.burrel.eat", Animation.LoopType.DEFAULT);
    public static final RawAnimation SLEEP = RawAnimation.begin().then("animation.burrel.sleep", Animation.LoopType.DEFAULT);
    private static final EntityDataAccessor<Integer> TYPES = SynchedEntityData.m_135353_(BurrelEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> BABY = SynchedEntityData.m_135353_(BurrelEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SLEEPING = SynchedEntityData.m_135353_(BurrelEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> WANTS_TO_BE_ON_GROUND = SynchedEntityData.m_135353_(BurrelEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CLIMBING = SynchedEntityData.m_135353_(BurrelEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Direction> ATTACHED_FACE = SynchedEntityData.m_135353_(BurrelEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135040_);
    private static final Direction[] POSSIBLE_DIRECTIONS = new Direction[]{Direction.DOWN, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    public BlockPos targetTree;
    private float wantsToBeOnGroundTicks = 0.0f;
    public float attachChangeProgress = 0.0f;
    public float prevAttachChangeProgress = 0.0f;
    private boolean partyBurrel;
    @javax.annotation.Nullable
    private BlockPos jukebox;
    public Direction prevAttachDir = Direction.DOWN;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public BurrelEntity(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 5;
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_274367_(0.6f);
    }

    public void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.5));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new BurrelSleepGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new BurrelEatGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new BurrelClimbTreeGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new BurrelGoToTreesGoal(this, 1.2));
        this.f_21345_.m_25352_(4, (Goal)new BurrelRandomStrollGoal(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 5.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new BreedGoal((Animal)this, 1.0));
    }

    protected PathNavigation m_6037_(Level level) {
        return new AzureNavigation((Mob)this, level);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(ATTACHED_FACE, (Object)Direction.m_122376_((int)compound.m_128445_("attachface")));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128344_("attachface", (byte)((Direction)this.f_19804_.m_135370_(ATTACHED_FACE)).m_122411_());
    }

    public void m_8107_() {
        if (this.jukebox == null || !this.jukebox.m_203195_((Position)this.m_20182_(), 7.0) || !this.m_9236_().m_8055_(this.jukebox).m_60713_(Blocks.f_50131_)) {
            this.partyBurrel = false;
            this.jukebox = null;
        }
        super.m_8107_();
    }

    public void m_6818_(BlockPos pos, boolean isPartying) {
        this.jukebox = pos;
        this.partyBurrel = isPartying;
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevAttachChangeProgress = this.attachChangeProgress;
        if (this.attachChangeProgress > 0.0f) {
            this.attachChangeProgress -= 0.25f;
        }
        if (this.prevAttachDir != this.getAttachmentFacing()) {
            this.attachChangeProgress = 1.0f;
        }
        this.prevAttachDir = this.getAttachmentFacing();
        Vec3 vector3d = this.m_20184_();
        if (!this.m_9236_().m_5776_()) {
            if (this.m_9236_().m_46462_()) {
                this.setWantsToBeOnGround(false);
                this.wantsToBeOnGroundTicks = 0.0f;
            } else {
                if (this.wantsToBeOnGround()) {
                    this.wantsToBeOnGroundTicks += 1.0f;
                }
                if (this.wantsToBeOnGroundTicks >= 4800.0f) {
                    this.setWantsToBeOnGround(false);
                }
                if (!this.wantsToBeOnGround() && this.f_19796_.m_216332_(1, 6000) == 1) {
                    this.wantsToBeOnGroundTicks = 0.0f;
                    this.setWantsToBeOnGround(true);
                }
            }
            if (this.m_20096_() || this.m_20069_() || this.m_20077_()) {
                this.setDirectionFacing(Direction.DOWN);
            } else {
                Direction closestDirection = Direction.DOWN;
                double closesDistance = 100.0;
                for (Direction direction : POSSIBLE_DIRECTIONS) {
                    BlockPos antPos = new BlockPos(Mth.m_14107_((double)this.m_20185_()), Mth.m_14107_((double)this.m_20186_()), Mth.m_14107_((double)this.m_20189_()));
                    BlockPos offsetPos = antPos.m_121945_(direction);
                    Vec3 offset = Vec3.m_82512_((Vec3i)offsetPos);
                    if (!(closesDistance > this.m_20182_().m_82554_(offset)) || !this.m_9236_().m_46578_(offsetPos, (Entity)this, direction.m_122424_())) continue;
                    closesDistance = this.m_20182_().m_82554_(offset);
                    closestDirection = direction;
                }
                this.f_19804_.m_135381_(ATTACHED_FACE, (Object)(closesDistance > (double)(this.m_20205_() * 0.5f + 0.7f) ? Direction.DOWN : closestDirection));
            }
        }
        if (this.getAttachmentFacing() != Direction.DOWN && !this.f_19862_ && this.getAttachmentFacing() != Direction.UP) {
            Vec3 vec3 = Vec3.m_82528_((Vec3i)this.getAttachmentFacing().m_122436_());
            this.m_20256_(vector3d.m_82549_(vec3.m_82541_().m_82542_((double)0.1f, (double)0.1f, (double)0.1f)));
        }
        if (this.getAttachmentFacing() != Direction.DOWN) {
            this.m_20256_(vector3d.m_82542_(0.6, 0.4, 0.6));
        }
        if (!this.m_5803_() && this.f_19796_.m_216332_(1, 2000) == 1) {
            this.m_5496_((SoundEvent)ModSounds.BURREL_IDLE.get(), this.m_6121_(), this.m_6100_());
        }
        if (!this.isBesideClimbableBlock() && !this.m_5803_() && this.wantsToBeOnGround() && this.f_19796_.m_216332_(1, 500) == 1) {
            this.triggerAnim("second", "look");
        }
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.BURREL_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ModSounds.BURREL_HURT.get();
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (this.m_6898_(itemStack)) {
            if (!this.m_6162_()) {
                this.m_27595_(player);
            }
            if (!this.m_9236_().f_46443_) {
                this.m_5496_((SoundEvent)ModSounds.BURREL_EAT.get(), this.m_6121_(), this.m_6100_());
                this.m_21573_().m_26573_();
                CriteriaTriggers.f_10592_.m_23682_((ServerPlayer)player, itemStack);
            }
            EntityHelper.consumeStack(1, (LivingEntity)this, itemStack);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public boolean m_142535_(float fallDistance, float multiplier, DamageSource source) {
        return false;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BABY, (Object)false);
        this.f_19804_.m_135372_(TYPES, (Object)0);
        this.f_19804_.m_135372_(CLIMBING, (Object)false);
        this.f_19804_.m_135372_(ATTACHED_FACE, (Object)Direction.DOWN);
        this.f_19804_.m_135372_(WANTS_TO_BE_ON_GROUND, (Object)false);
        this.f_19804_.m_135372_(SLEEPING, (Object)false);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        this.jukebox = null;
        this.partyBurrel = false;
        return super.m_6469_(source, amount);
    }

    protected void m_7840_(double y, boolean onGround, BlockState state, BlockPos pos) {
    }

    public void setDirectionFacing(Direction directionFacing) {
        this.f_19804_.m_135381_(ATTACHED_FACE, (Object)directionFacing);
    }

    public Direction getAttachmentFacing() {
        return (Direction)this.f_19804_.m_135370_(ATTACHED_FACE);
    }

    public boolean m_6147_() {
        return this.isBesideClimbableBlock();
    }

    public boolean isBesideClimbableBlock() {
        return (Boolean)this.f_19804_.m_135370_(CLIMBING);
    }

    public void setBesideClimbableBlock(boolean climbing) {
        this.f_19804_.m_135381_(CLIMBING, (Object)climbing);
    }

    public boolean wantsToBeOnGround() {
        return (Boolean)this.f_19804_.m_135370_(WANTS_TO_BE_ON_GROUND);
    }

    public void setWantsToBeOnGround(boolean bool) {
        this.f_19804_.m_135381_(WANTS_TO_BE_ON_GROUND, (Object)bool);
    }

    public boolean m_6162_() {
        return (Boolean)this.f_19804_.m_135370_(BABY);
    }

    public void m_6863_(boolean b) {
        this.f_19804_.m_135381_(BABY, (Object)b);
    }

    public int getTypes() {
        return (Integer)this.f_19804_.m_135370_(TYPES);
    }

    public void setTypes(int i) {
        this.f_19804_.m_135381_(TYPES, (Object)i);
    }

    public boolean getSpawnBabyChance(RandomSource p) {
        return this.f_19796_.m_188501_() < 0.05f;
    }

    public boolean m_5803_() {
        return (Boolean)this.f_19804_.m_135370_(SLEEPING);
    }

    public void setSleeping(boolean bool) {
        this.f_19804_.m_135381_(SLEEPING, (Object)bool);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        Object sg = super.m_6518_(level, difficulty, spawnType, spawnGroupData, compoundTag);
        if (!(sg instanceof BurrelGroupData)) {
            int variant = 0;
            if (this.f_19796_.m_216332_(1, 5) == 5) {
                variant = 1;
            }
            sg = new BurrelGroupData(variant);
        }
        this.setTypes(((BurrelGroupData)((Object)sg)).variant);
        return sg;
    }

    public boolean m_6898_(ItemStack itemStack) {
        return itemStack.m_150930_(((Block)ModBlocks.PINECONE.get()).m_5456_());
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        BurrelEntity burrel = new BurrelEntity((EntityType<? extends TamableAnimal>)((EntityType)ModEntities.BURREL.get()), (Level)serverLevel);
        burrel.m_6863_(true);
        return burrel;
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Animal.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, (double)0.22f);
        builder = builder.m_22268_(Attributes.f_22276_, 6.0);
        builder = builder.m_22268_(Attributes.f_22277_, 64.0);
        return builder;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "main", 5, state -> {
            if (this.m_5803_()) {
                return state.setAndContinue(SLEEP);
            }
            if (this.isBesideClimbableBlock()) {
                return state.setAndContinue(CLIMB);
            }
            if (state.isMoving()) {
                return state.setAndContinue(WALK);
            }
            if (this.partyBurrel) {
                return state.setAndContinue(DANCE);
            }
            return state.setAndContinue(IDLE);
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "second", state -> PlayState.STOP).triggerableAnim("eat", EAT).triggerableAnim("look", LOOK)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean isPanicking() {
        if (this.f_20939_.m_21874_(MemoryModuleType.f_217768_)) {
            return this.f_20939_.m_21952_(MemoryModuleType.f_217768_).isPresent();
        }
        for (WrappedGoal wrappedgoal : this.f_21345_.m_148105_()) {
            if (!wrappedgoal.m_7620_() || !(wrappedgoal.m_26015_() instanceof PanicGoal)) continue;
            return true;
        }
        return false;
    }

    public static class BurrelGroupData
    extends AgeableMob.AgeableMobGroupData {
        public final int variant;

        public BurrelGroupData(int variant) {
            super(false);
            this.variant = variant;
        }
    }
}

