/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity;

import com.google.common.base.Predicates;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStandGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import team.recrafted.blastfromthepast.BlastFromThePast;
import team.recrafted.blastfromthepast.entity.Roaring;
import team.recrafted.blastfromthepast.entity.ai.controller.OverridableBodyRotationControl;
import team.recrafted.blastfromthepast.entity.ai.controller.OverridableMoveControl;
import team.recrafted.blastfromthepast.entity.ai.goal.CustomPanicGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.HitboxAdjustedBreedGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.HitboxAdjustedFollowParentGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.attacker.AnimatedMeleeAttackGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.charge.ChargeForwardAttackGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.pack.PackHurtByTargetGoal;
import team.recrafted.blastfromthepast.entity.ai.navigation.AzureNavigation;
import team.recrafted.blastfromthepast.entity.misc.AnimatedAttacker;
import team.recrafted.blastfromthepast.entity.misc.ChargeForward;
import team.recrafted.blastfromthepast.entity.misc.OverrideAnimatedAttacker;
import team.recrafted.blastfromthepast.entity.misc.StateValue;
import team.recrafted.blastfromthepast.entity.pack.EntityPack;
import team.recrafted.blastfromthepast.entity.pack.EntityPackAgeableMobData;
import team.recrafted.blastfromthepast.entity.pack.EntityPackHolder;
import team.recrafted.blastfromthepast.init.ModDataSerializers;
import team.recrafted.blastfromthepast.init.ModEntities;
import team.recrafted.blastfromthepast.init.ModSounds;
import team.recrafted.blastfromthepast.init.ModTags;
import team.recrafted.blastfromthepast.network.FrostomperCollidePayload;
import team.recrafted.blastfromthepast.network.ScreenShakePayload;
import team.recrafted.blastfromthepast.util.EntityHelper;
import team.recrafted.blastfromthepast.util.HitboxHelper;

@ParametersAreNonnullByDefault
public class FrostomperEntity
extends AbstractChestedHorse
implements GeoEntity,
EntityPackHolder<FrostomperEntity>,
OverrideAnimatedAttacker<FrostomperEntity, FrostomperAttackType>,
ChargeForward,
Roaring {
    public static final EntityDimensions BABY_FROSTOMPER_DIMENSIONS = EntityDimensions.m_20395_((float)HitboxHelper.pixelsToBlocks(28.0f), (float)HitboxHelper.pixelsToBlocks(22.0f));
    private static final EntityDataAccessor<OptionalInt> DATA_ACTIVE_ATTACK_TYPE = SynchedEntityData.m_135353_(FrostomperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135044_);
    private static final EntityDataAccessor<IdleState> DATA_IDLE_STATE = SynchedEntityData.m_135353_(FrostomperEntity.class, (EntityDataSerializer)((EntityDataSerializer)ModDataSerializers.FROSTOMPER_IDLE_STATE.get()));
    private static final EntityDataAccessor<Boolean> DATA_CHARGING_FORWARD = SynchedEntityData.m_135353_(FrostomperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final double PARENT_TARGETING_DISTANCE = 16.0;
    private static final int CHARGE_ATTACK_COOLDOWN = 900;
    private static final int FLAG_ROARING = 128;
    private static final UniformInt CHARGE_ATTACK_DURATION = UniformInt.m_146622_((int)Mth.m_14143_((float)66.666664f), (int)Mth.m_14143_((float)83.33333f));
    public static final int MAX_TRUMPET_TICKS_ADULT = Mth.m_14143_((float)30.0f);
    public static final int MAX_TRUMPET_TICKS_BABY = Mth.m_14143_((float)8.334f);
    protected static final TargetingConditions PARENT_TARGETING = TargetingConditions.m_148353_().m_148355_().m_26888_(entity -> entity instanceof FrostomperEntity && ((FrostomperEntity)entity).m_30623_());
    protected final TargetingConditions parentTargeting;
    @org.jetbrains.annotations.Nullable
    private EntityPack<FrostomperEntity> pack;
    private final AnimatedAttacker.AttackTicker<FrostomperEntity, FrostomperAttackType> attackTicker = new AnimatedAttacker.AttackTicker(this);
    private int ticksUntilNextCharge;
    private int roarCounter;
    private int trumpetCounter;
    private int idleAnimationTimer = -1;
    private boolean lastCollide = false;
    public boolean serverHorizontalCollide = false;
    public boolean canAnimateLook = true;
    private boolean party;
    @Nullable
    private BlockPos jukebox;
    public static final RawAnimation IDLE = RawAnimation.begin().then("animation.frostomper.idle", Animation.LoopType.DEFAULT);
    public static final RawAnimation CRUSH = RawAnimation.begin().then("animation.frostomper.crush", Animation.LoopType.DEFAULT);
    public static final RawAnimation STOMP = RawAnimation.begin().then("animation.frostomper.stomp", Animation.LoopType.DEFAULT);
    public static final RawAnimation STOMP_FLIPPED = RawAnimation.begin().then("animation.frostomper.stomp_flipped", Animation.LoopType.DEFAULT);
    public static final RawAnimation FLING = RawAnimation.begin().then("animation.frostomper.fling", Animation.LoopType.DEFAULT);
    public static final RawAnimation CHARGE = RawAnimation.begin().then("animation.frostomper.charge", Animation.LoopType.DEFAULT);
    public static final RawAnimation TAILS = RawAnimation.begin().then("animation.frostomper.tail", Animation.LoopType.DEFAULT);
    public static final RawAnimation EARS = RawAnimation.begin().then("animation.frostomper.ears", Animation.LoopType.DEFAULT);
    public static final RawAnimation WALK = RawAnimation.begin().then("animation.frostomper.walk", Animation.LoopType.DEFAULT);
    public static final RawAnimation TRUMPET = RawAnimation.begin().then("animation.frostomper.trumpet", Animation.LoopType.DEFAULT);
    public static final RawAnimation DANCE = RawAnimation.begin().then("animation.frostomper.dance", Animation.LoopType.DEFAULT);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final double MINIMUM_ATTACK_SIZE = HitboxHelper.calculateMinimumAttackHitboxWidth(((EntityType)ModEntities.FROSTOMPER.get()).m_20678_());
    private static final Vec3 DEFAULT_ATTACK_SIZE = new Vec3(MINIMUM_ATTACK_SIZE + 1.0, MINIMUM_ATTACK_SIZE + 1.0, MINIMUM_ATTACK_SIZE + 1.0);

    public FrostomperEntity(EntityType<? extends FrostomperEntity> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new OverridableMoveControl<FrostomperEntity>(this);
        this.m_21441_(BlockPathTypes.LEAVES, 0.0f);
        this.parentTargeting = PARENT_TARGETING.m_148354_().m_26888_(entity -> HitboxHelper.isCloseEnoughForTargeting((LivingEntity)this, entity, true, 16.0));
        this.m_274367_(1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return AgeableMob.m_21552_().m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22278_, 0.75).m_22268_(Attributes.f_22281_, 12.0).m_22268_(Attributes.f_22282_, 1.5).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22288_, (double)0.42f);
    }

    @NotNull
    public EntityDimensions m_6972_(Pose pose) {
        return this.m_6162_() ? BABY_FROSTOMPER_DIMENSIONS : super.m_6972_(pose);
    }

    protected float m_6431_(Pose p_30578_, EntityDimensions p_30579_) {
        return this.m_6162_() ? HitboxHelper.pixelsToBlocks(15.0f) : HitboxHelper.pixelsToBlocks(55.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, new CustomPanicGoal<FrostomperEntity>(this, FrostomperEntity::shouldPanic, 1.2, EntityHelper.getPanicInducingDamageTypes()));
        this.f_21345_.m_25352_(2, (Goal)new HitboxAdjustedBreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new HitboxAdjustedFollowParentGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, new ChargeForwardAttackGoal<FrostomperEntity>(this, CHARGE_ATTACK_DURATION, 1.2));
        this.f_21345_.m_25352_(5, new AnimatedMeleeAttackGoal(this, 1.0, true));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.7));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        if (this.m_245259_()) {
            this.f_21345_.m_25352_(9, (Goal)new RandomStandGoal((AbstractHorse)this));
        }
        this.m_7509_();
        this.f_21346_.m_25352_(0, new PackHurtByTargetGoal<FrostomperEntity>(this, Predicate.not(AgeableMob::m_6162_), AgeableMob::m_6162_, new Class[0]));
    }

    protected boolean shouldPanic() {
        return this.m_6162_() || this.m_5448_() == null;
    }

    protected void m_8022_() {
        boolean canControlMove = this.m_6688_() == null;
        boolean canControlJump = !(this.m_20202_() instanceof Boat);
        this.f_21345_.m_25360_(Goal.Flag.MOVE, canControlMove);
        this.f_21345_.m_25360_(Goal.Flag.JUMP, canControlMove && canControlJump);
        this.f_21345_.m_25360_(Goal.Flag.LOOK, canControlMove);
        this.f_21345_.m_25360_(Goal.Flag.TARGET, canControlMove);
    }

    protected void m_7509_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, this.isTemptItem(), false));
    }

    protected Ingredient isTemptItem() {
        return this.m_6162_() ? Ingredient.m_204132_(ModTags.Items.BABY_FROSTOMPER_TEMPT_ITEMS) : Ingredient.m_204132_(ModTags.Items.FROSTOMPER_TEMPT_ITEMS);
    }

    protected void m_214179_(RandomSource random) {
    }

    protected void m_7567_() {
        FrostomperEntity mommy;
        if (this.m_30623_() && this.m_6162_() && !this.m_30617_() && (mommy = (FrostomperEntity)this.m_9236_().m_45963_(FrostomperEntity.class, this.parentTargeting, (LivingEntity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_20191_().m_82400_(16.0))) != null && HitboxHelper.getDistSqrBetweenHitboxes((Entity)this, (Entity)mommy) > 4.0) {
            this.f_21344_.m_6570_((Entity)mommy, 0);
        }
    }

    protected void m_6835_(Player player) {
        if (this.m_30614_()) {
            super.m_6835_(player);
            if (!this.m_9236_().f_46443_) {
                this.setRoaring(false);
                this.serverHorizontalCollide = false;
            }
        }
    }

    public boolean m_142535_(float fallDistance, float multiplier, DamageSource source) {
        int i = this.m_5639_(fallDistance, multiplier);
        if (i <= 0) {
            return false;
        }
        this.m_6469_(source, i);
        if (this.m_20160_()) {
            for (Entity entity : this.m_146897_()) {
                entity.m_6469_(source, (float)i);
            }
        }
        this.m_21229_();
        return true;
    }

    @NotNull
    protected PathNavigation m_6037_(Level level) {
        return new AzureNavigation((Mob)this, level);
    }

    public int m_8085_() {
        return 45;
    }

    public boolean m_6898_(ItemStack itemStack) {
        return itemStack.m_204117_(this.m_6162_() ? ModTags.Items.BABY_FROSTOMPER_FOOD : ModTags.Items.FROSTOMPER_FOOD);
    }

    @org.jetbrains.annotations.Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob otherParent) {
        FrostomperEntity offspring = (FrostomperEntity)((EntityType)ModEntities.FROSTOMPER.get()).m_20615_((Level)serverLevel);
        if (offspring != null) {
            this.m_149508_(otherParent, (AbstractHorse)offspring);
        }
        return offspring;
    }

    protected void m_149508_(AgeableMob parent, AbstractHorse child) {
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @org.jetbrains.annotations.Nullable SpawnGroupData spawnGroupData, CompoundTag compoundTag) {
        if (spawnGroupData == null) {
            spawnGroupData = new FrostomperGroupData(BlastFromThePast.getUniversalEntityPacks(level.m_6018_().m_7654_()).createFreshPack(), true);
        }
        if (spawnGroupData instanceof FrostomperGroupData) {
            FrostomperGroupData frostomperGroupData = (FrostomperGroupData)spawnGroupData;
            frostomperGroupData.addPackMember((Mob)this);
        }
        SpawnGroupData spawnData = super.m_6518_(level, difficulty, spawnType, spawnGroupData, compoundTag);
        if (this.m_6162_()) {
            this.m_146762_(-24000);
        }
        this.idleAnimationTimer = IdleState.NONE.animationTime();
        return spawnData;
    }

    public void m_6863_(boolean baby) {
        this.m_146762_(baby ? -24000 : 0);
    }

    public int m_5792_() {
        return 6;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.FROSTOMPER_IDLE.get();
    }

    protected SoundEvent m_7871_() {
        return (SoundEvent)ModSounds.FROSTOMPER_TRUMPET.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.FROSTOMPER_DEATH.get();
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent m_7872_() {
        return SoundEvents.f_11912_;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ModSounds.FROSTOMPER_HURT.get();
    }

    protected float m_6121_() {
        return 1.0f;
    }

    protected void m_7486_() {
    }

    protected void m_5877_(SoundType soundType) {
    }

    protected void m_7355_(BlockPos pos, BlockState block) {
    }

    protected void m_7609_() {
        this.m_5496_(SoundEvents.f_11811_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
    }

    @NotNull
    public SoundEvent m_246265_() {
        return SoundEvents.f_12034_;
    }

    public void m_6478_(MoverType type, Vec3 pos) {
        super.m_6478_(type, pos);
        if (this.m_146862_((Predicate)Predicates.alwaysTrue()) && this.lastCollide != this.f_19862_) {
            BlastFromThePast.INSTANCE.sendToServer((Object)new FrostomperCollidePayload(this.m_19879_(), this.f_19862_));
        }
    }

    protected boolean m_5994_(Player player, ItemStack stack) {
        SoundEvent eatingSound;
        if (!this.m_6898_(stack)) {
            return false;
        }
        boolean fed = false;
        if (this.m_21223_() < this.m_21233_()) {
            this.m_5634_(2.0f);
            fed = true;
        }
        if (this.m_146764_() == 0 && this.m_5957_()) {
            this.m_27595_(player);
            fed = true;
        }
        if (this.m_6162_()) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0.0, 0.0, 0.0);
            if (!this.m_9236_().f_46443_) {
                this.m_146740_(FrostomperEntity.m_216967_((int)(-this.m_146764_())), true);
                fed = true;
            }
        }
        if (!(this.m_30614_() || this.m_30624_() >= this.m_7555_() || this.m_9236_().f_46443_ || ForgeEventFactory.onAnimalTame((Animal)this, (Player)player))) {
            this.m_30653_(10);
            if (this.m_30624_() >= this.m_7555_() && this.canBeTamedBy(player) && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                this.m_30637_(player);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            fed = true;
        }
        if (!fed) {
            return false;
        }
        if (!this.m_20067_() && (eatingSound = this.m_7872_()) != null) {
            this.m_5496_(eatingSound, this.m_6121_(), this.m_6100_());
        }
        this.m_5634_(4.0f);
        this.m_146850_(GameEvent.f_157806_);
        return true;
    }

    public void m_277117_(ServerLevel level, Animal animal, @org.jetbrains.annotations.Nullable AgeableMob baby) {
        super.m_277117_(level, animal, baby);
        if (baby instanceof FrostomperEntity) {
            FrostomperEntity babyFrostomper = (FrostomperEntity)baby;
            Optional.ofNullable(this.m_27592_()).or(() -> Optional.ofNullable(animal.m_27592_())).ifPresent(loveCause -> babyFrostomper.m_30657_(true));
        }
    }

    protected boolean canBeTamedBy(Player player) {
        return this.m_6162_() || this.m_30623_() || player.m_7500_();
    }

    protected boolean m_245259_() {
        return false;
    }

    public boolean m_7848_(Animal otherAnimal) {
        if (otherAnimal != this && otherAnimal instanceof FrostomperEntity) {
            FrostomperEntity frostomper = (FrostomperEntity)otherAnimal;
            return this.m_30628_() && frostomper.m_30628_();
        }
        return false;
    }

    @Override
    @org.jetbrains.annotations.Nullable
    public EntityPack<FrostomperEntity> getPack() {
        return this.pack;
    }

    @Override
    public void setPack(@org.jetbrains.annotations.Nullable EntityPack<FrostomperEntity> pack) {
        this.pack = pack;
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.readPackData(compound, (Mob)this, serverLevel);
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        this.savePackData(compound);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ACTIVE_ATTACK_TYPE, (Object)OptionalInt.empty());
        this.f_19804_.m_135372_(DATA_CHARGING_FORWARD, (Object)false);
        this.f_19804_.m_135372_(DATA_IDLE_STATE, (Object)IdleState.NONE);
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        super.m_7350_(pKey);
        if (DATA_ACTIVE_ATTACK_TYPE.equals(pKey)) {
            this.attackTicker.reset();
        }
        if (!this.f_19803_ && DATA_CHARGING_FORWARD.equals(pKey)) {
            this.ticksUntilNextCharge = this.ticksUntilNextCharge == 0 ? 900 : this.ticksUntilNextCharge;
        }
    }

    @NotNull
    protected BodyRotationControl m_7560_() {
        return new OverridableBodyRotationControl<FrostomperEntity>(this);
    }

    @Override
    public void setActiveAttackType(@org.jetbrains.annotations.Nullable FrostomperAttackType attackType) {
        this.f_19804_.m_135381_(DATA_ACTIVE_ATTACK_TYPE, (Object)(attackType == null ? OptionalInt.empty() : OptionalInt.of(attackType.ordinal())));
        if (attackType != null && !this.m_9236_().f_46443_) {
            if (this.isRoaring()) {
                this.setRoaring(false);
            }
            if (this.m_30622_()) {
                this.m_30665_(false);
            }
            if (this.m_30617_()) {
                this.m_30661_(false);
            }
        }
    }

    @Override
    @org.jetbrains.annotations.Nullable
    public FrostomperAttackType getActiveAttackType() {
        OptionalInt ordinal = (OptionalInt)this.f_19804_.m_135370_(DATA_ACTIVE_ATTACK_TYPE);
        return ordinal.isEmpty() ? null : FrostomperAttackType.byOrdinal(ordinal.getAsInt());
    }

    protected void m_19956_(@NotNull Entity passenger, @NotNull Entity.MoveFunction callback) {
        if (this.m_20363_(passenger)) {
            double y = this.m_20186_() + this.m_20191_().m_82376_() - 0.6;
            float bodyYawRad = this.f_20883_ * ((float)Math.PI / 180);
            double forwardOffset = 0.0;
            double sideOffset = -0.0;
            double x = this.m_20185_() + (double)Mth.m_14031_((float)bodyYawRad) * forwardOffset + (double)Mth.m_14089_((float)bodyYawRad) * sideOffset;
            double z = this.m_20189_() - (double)Mth.m_14089_((float)bodyYawRad) * forwardOffset + (double)Mth.m_14031_((float)bodyYawRad) * sideOffset;
            callback.m_20372_(passenger, x, y, z);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_6084_() && !this.m_6162_()) {
            if (this.idleAnimationTimer <= -1) {
                IdleState newState = this.m_20088_().m_135370_(DATA_IDLE_STATE) == IdleState.NONE ? (this.f_19796_.m_188499_() ? IdleState.EARS : IdleState.TAIL) : IdleState.NONE;
                this.m_20088_().m_135381_(DATA_IDLE_STATE, (Object)newState);
                this.idleAnimationTimer = newState.animationTime();
            } else {
                --this.idleAnimationTimer;
            }
        }
        this.attackTicker.tick();
        if (this.ticksUntilNextCharge > 0) {
            --this.ticksUntilNextCharge;
            if (this.ticksUntilNextCharge == 0) {
                this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_244032_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
        }
        if (!this.m_9236_().f_46443_ && this.roarCounter > 0 && ++this.roarCounter > (this.m_6162_() ? MAX_TRUMPET_TICKS_BABY : MAX_TRUMPET_TICKS_ADULT)) {
            this.roarCounter = 0;
            this.setRoaring(false);
        }
        if (!this.m_9236_().f_46443_) {
            if (this.f_19796_.m_188503_(500) == 0 && this.canRoar() && this.trumpetCounter == 0) {
                this.roarIfPossible();
                this.trumpetCounter = 200 + this.m_9236_().f_46441_.m_188503_(200);
            }
            if (this.trumpetCounter > 0) {
                --this.trumpetCounter;
            }
        }
    }

    public void m_21561_(boolean aggressive) {
        boolean wasAggressive = this.m_5912_();
        super.m_21561_(aggressive);
        if (!wasAggressive && aggressive && !this.m_9236_().f_46443_) {
            this.m_7564_();
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        this.jukebox = null;
        this.party = false;
        return super.m_6469_(source, amount);
    }

    public void m_8107_() {
        if (this.jukebox == null || !this.jukebox.m_203195_((Position)this.m_20182_(), 15.0) || !this.m_9236_().m_8055_(this.jukebox).m_60713_(Blocks.f_50131_)) {
            this.party = false;
            this.jukebox = null;
        }
        super.m_8107_();
        if (this.m_6084_() && !this.m_9236_().f_46443_ && (this.f_19862_ || this.serverHorizontalCollide) && ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) {
            boolean destroyedBlock = false;
            AABB breakBox = this.m_20191_().m_82400_(0.2);
            for (BlockPos nearbyBlockPos : BlockPos.m_121976_((int)Mth.m_14107_((double)breakBox.f_82288_), (int)Mth.m_14107_((double)breakBox.f_82289_), (int)Mth.m_14107_((double)breakBox.f_82290_), (int)Mth.m_14107_((double)breakBox.f_82291_), (int)Mth.m_14107_((double)breakBox.f_82292_), (int)Mth.m_14107_((double)breakBox.f_82293_))) {
                BlockState nearbyBlockState = this.m_9236_().m_8055_(nearbyBlockPos);
                if (!nearbyBlockState.m_204336_(ModTags.Blocks.FROSTOMPER_CAN_BREAK) || !nearbyBlockState.canEntityDestroy((BlockGetter)this.m_9236_(), nearbyBlockPos, (Entity)this) || !ForgeEventFactory.onEntityDestroyBlock((LivingEntity)this, (BlockPos)nearbyBlockPos, (BlockState)nearbyBlockState)) continue;
                destroyedBlock = this.m_9236_().m_46953_(nearbyBlockPos, true, (Entity)this) || destroyedBlock;
            }
        }
    }

    public void m_6818_(BlockPos pos, boolean isPartying) {
        this.jukebox = pos;
        this.party = isPartying;
    }

    public void m_7564_() {
        if (!this.isRoaring()) {
            this.roarIfPossible();
        }
    }

    @Override
    public void roarIfPossible() {
        if (this.canRoar() && !this.m_9236_().f_46443_) {
            this.roarCounter = 1;
            this.setRoaring(true);
            if (this.m_7871_() != null) {
                this.m_5496_(this.m_7871_(), this.m_6121_(), this.m_6100_());
            }
            for (Player player : this.m_9236_().m_45976_(Player.class, new AABB(this.m_20183_()).m_82400_((double)(this.m_7871_().m_215668_(this.m_6121_()) - 1.0f)))) {
                BlastFromThePast.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new ScreenShakePayload(20.0f, 60));
            }
        }
    }

    @Override
    public boolean canRoar() {
        return this.getActiveAttackType() == null;
    }

    @Override
    public boolean isRoaring() {
        return this.m_30647_(128);
    }

    @Override
    public void setRoaring(boolean roaring) {
        this.m_30597_(128, roaring);
    }

    public void m_7023_(Vec3 travelVector) {
        if (!this.canMove() && this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82542_(0.0, 1.0, 0.0));
            travelVector = travelVector.m_82542_(0.0, 1.0, 0.0);
        }
        super.m_7023_(travelVector);
    }

    public boolean m_6779_(LivingEntity target) {
        return this.m_269323_() != target && super.m_6779_(target);
    }

    public Team m_5647_() {
        LivingEntity owner;
        if (this.m_30614_() && (owner = this.m_269323_()) != null) {
            return owner.m_5647_();
        }
        return super.m_5647_();
    }

    public boolean m_7307_(Entity other) {
        if (other == null) {
            return false;
        }
        if (this.m_30614_()) {
            LivingEntity owner = this.m_269323_();
            if (other == owner) {
                return true;
            }
            if (owner != null) {
                if (other instanceof OwnableEntity) {
                    OwnableEntity otherOwnable = (OwnableEntity)other;
                    return otherOwnable.m_269323_() == owner;
                }
                return owner.m_7307_(other);
            }
        }
        if (super.m_7307_(other)) {
            return true;
        }
        if (this.isAlliedToDefault(other)) {
            OwnableEntity otherOwnable;
            if (other instanceof OwnableEntity && (otherOwnable = (OwnableEntity)other).m_269323_() != null) {
                return false;
            }
            return this.m_5647_() == null && other.m_5647_() == null;
        }
        return false;
    }

    protected boolean isAlliedToDefault(Entity other) {
        return other.m_6095_().equals(this.m_6095_());
    }

    @Override
    public FrostomperAttackType selectAttackTypeForTarget(@org.jetbrains.annotations.Nullable LivingEntity target) {
        if (target != null) {
            boolean canCharge;
            boolean bl = canCharge = this.ticksUntilNextCharge <= 0;
            if (canCharge) {
                int randomInt = this.f_19796_.m_188503_(10);
                if (randomInt < 7) {
                    return FrostomperAttackType.CHARGE;
                }
                if (randomInt < 9) {
                    return FrostomperAttackType.FLING;
                }
                return FrostomperAttackType.DOUBLE_STOMP;
            }
            int randomInt = this.f_19796_.m_188503_(3);
            if (randomInt < 2) {
                return FrostomperAttackType.FLING;
            }
            return FrostomperAttackType.DOUBLE_STOMP;
        }
        return null;
    }

    @NotNull
    protected Vec2 m_274391_(LivingEntity entity) {
        boolean rotationBlocked = !this.canRotate();
        return rotationBlocked ? new Vec2(this.m_146909_(), this.m_146908_()) : super.m_274391_(entity);
    }

    @NotNull
    protected Vec3 m_274312_(Player player, Vec3 travelVector) {
        boolean movementBlocked = !this.canMove();
        return movementBlocked ? Vec3.f_82478_ : super.m_274312_(player, travelVector);
    }

    @Override
    public boolean isChargingForward() {
        return (Boolean)this.f_19804_.m_135370_(DATA_CHARGING_FORWARD);
    }

    @Override
    public void setIsChargingForward(boolean charging) {
        this.f_19804_.m_135381_(DATA_CHARGING_FORWARD, (Object)charging);
    }

    public boolean m_5843_() {
        if (this.isChargingForward()) {
            return true;
        }
        return super.m_5843_();
    }

    public boolean m_7132_() {
        return this.getActiveAttackType() == null && super.m_7132_();
    }

    public void m_7199_(int jumpPower) {
        if (jumpPower >= 90) {
            this.setActiveAttackType(FrostomperAttackType.DOUBLE_STOMP);
        } else {
            this.setActiveAttackType(FrostomperAttackType.SINGLE_STOMP);
        }
    }

    public int m_245614_() {
        return this.attackTicker.get();
    }

    protected boolean m_30628_() {
        return !this.m_20160_() && !this.m_20159_() && !this.m_6162_() && this.m_21223_() >= this.m_21233_() && this.m_27593_();
    }

    @Override
    public boolean canAnimateLook() {
        if (this.isRoaring()) {
            return false;
        }
        return OverrideAnimatedAttacker.super.canAnimateLook() && this.canAnimateLook;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "main", 5, state -> {
            FrostomperAttackType activeAttackType = this.getActiveAttackType();
            if (!this.m_6162_()) {
                if (!this.canRotateHead()) {
                    this.m_5618_(this.m_146908_());
                    this.f_20884_ = this.m_146908_();
                }
                if (activeAttackType == FrostomperAttackType.DOUBLE_STOMP) {
                    return state.setAndContinue(CRUSH);
                }
                if (activeAttackType == FrostomperAttackType.SINGLE_STOMP && !this.m_21526_()) {
                    return state.setAndContinue(STOMP);
                }
                if (activeAttackType == FrostomperAttackType.SINGLE_STOMP && this.m_21526_()) {
                    return state.setAndContinue(STOMP_FLIPPED);
                }
                if (activeAttackType == FrostomperAttackType.FLING) {
                    return state.setAndContinue(FLING);
                }
                if (activeAttackType == FrostomperAttackType.CHARGE) {
                    return state.setAndContinue(CHARGE);
                }
            }
            if (this.isRoaring()) {
                return state.setAndContinue(TRUMPET);
            }
            if (state.isMoving() && this.canAnimateWalk()) {
                return state.setAndContinue(WALK);
            }
            if (this.party && !this.m_6162_()) {
                return state.setAndContinue(DANCE);
            }
            return state.setAndContinue(IDLE);
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "idle", 5, state -> {
            IdleState idleState = (IdleState)this.m_20088_().m_135370_(DATA_IDLE_STATE);
            if (idleState == IdleState.TAIL) {
                return state.setAndContinue(TAILS);
            }
            if (idleState == IdleState.EARS) {
                return state.setAndContinue(EARS);
            }
            return PlayState.STOP;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected static class FrostomperGroupData
    extends EntityPackAgeableMobData<FrostomperEntity> {
        public FrostomperGroupData(EntityPack<FrostomperEntity> entityPack, boolean shouldSpawnBaby) {
            super(entityPack, shouldSpawnBaby);
        }
    }

    public static enum IdleState implements StateValue
    {
        NONE(0, -1),
        EARS(1, 22),
        TAIL(2, 25);

        private final int id;
        private final int animationTime;

        private IdleState(int id, int animationTime) {
            this.id = id;
            this.animationTime = animationTime;
        }

        @Override
        public int id() {
            return this.id;
        }

        public int animationTime() {
            return this.animationTime != -1 ? this.animationTime : 300 + (int)(Math.random() * 300.0);
        }
    }

    public static enum FrostomperAttackType implements AnimatedAttacker.AttackType<FrostomperEntity, FrostomperAttackType>
    {
        FLING(Mth.m_14143_((float)7.6f), Mth.m_14143_((float)15.0f), DEFAULT_ATTACK_SIZE, 8.0f, 1.5f),
        SINGLE_STOMP(Mth.m_14143_((float)12.6f), 20, DEFAULT_ATTACK_SIZE.m_82490_(0.5), 5.0f, 0.75f),
        DOUBLE_STOMP(Mth.m_14143_((float)12.6f), 20, DEFAULT_ATTACK_SIZE, 10.0f, 1.5f),
        CHARGE(0, 10, DEFAULT_ATTACK_SIZE, 12.0f, 1.5f);

        private final int attackPoint;
        private final int attackDuration;
        private final Vec3 attackSize;
        private final float attackDamage;
        private final float attackKnockback;

        private FrostomperAttackType(int attackPoint, int attackDuration, Vec3 attackSize, float attackDamage, float attackKnockback) {
            this.attackPoint = attackPoint;
            this.attackDuration = attackDuration;
            this.attackSize = attackSize;
            this.attackDamage = attackDamage;
            this.attackKnockback = attackKnockback;
        }

        @Override
        public int getAttackPoint() {
            return this.attackPoint;
        }

        @Override
        public int getAttackDuration() {
            return this.attackDuration;
        }

        @Override
        public Vec3 getAttackSize() {
            return this.attackSize;
        }

        @Override
        public float getAttackDamage() {
            return this.attackDamage;
        }

        @Override
        public float getAttackKnockback() {
            return this.attackKnockback;
        }

        @Override
        public boolean blocksMovementInput() {
            return this == DOUBLE_STOMP || this == SINGLE_STOMP;
        }

        @Override
        public boolean blocksWalkAnimation() {
            return this == DOUBLE_STOMP || this == SINGLE_STOMP || this == CHARGE;
        }

        @Override
        public boolean blocksRotationInput() {
            return this == DOUBLE_STOMP || this == SINGLE_STOMP;
        }

        @Override
        public boolean blocksBodyRotation() {
            return this == DOUBLE_STOMP || this == SINGLE_STOMP;
        }

        @Override
        public boolean blocksHeadRotation() {
            return this == DOUBLE_STOMP || this == FLING || this == CHARGE;
        }

        @Override
        public boolean hasAttackPointAt(int attackTicker) {
            if (this == CHARGE) {
                return true;
            }
            return this.getAttackPoint() == attackTicker;
        }

        @Override
        public void executeAttackPoint(FrostomperEntity attacker, int attackTicker) {
            Vec3 attackSize = this.getAttackSize().m_82490_((double)attacker.m_6134_());
            AABB attackBounds = HitboxHelper.createHitboxRelativeToFront((LivingEntity)attacker, attackSize.m_7096_(), attackSize.m_7098_(), attackSize.m_7094_());
            if (this == CHARGE) {
                if (attackTicker == 0) {
                    if (!attacker.m_9236_().f_46443_) {
                        attacker.setIsChargingForward(true);
                    }
                    attacker.m_5496_((SoundEvent)ModSounds.FROSTOMPER_CHARGE.get(), attacker.m_6121_(), attacker.m_6100_());
                }
                if (attacker.isChargingForward()) {
                    List<LivingEntity> hitTargets = EntityHelper.hitTargetsWithAOEAttack(attacker, attackBounds, this.getAttackDamage(), 0.0f, false);
                    for (LivingEntity hitTarget : hitTargets) {
                        EntityHelper.strongKnockback((LivingEntity)attacker, hitTarget, this.getAttackKnockback());
                    }
                }
            } else if (this == FLING) {
                List<LivingEntity> hitTargets = EntityHelper.hitTargetsWithAOEAttack(attacker, attackBounds, this.getAttackDamage(), 0.0f, false);
                for (LivingEntity hitTarget : hitTargets) {
                    EntityHelper.throwTarget((LivingEntity)attacker, hitTarget, this.getAttackKnockback());
                }
            } else if (this == SINGLE_STOMP) {
                attacker.m_5496_((SoundEvent)ModSounds.FROSTOMPER_STOMP.get(), attacker.m_6121_(), attacker.m_6100_());
                Vec3 lateralOffset = Vec3.f_82478_.m_82520_(attacker.m_21526_() ? 1.0 : -1.0, 0.0, 0.0).m_82490_((double)attacker.m_6134_()).m_82524_(-attacker.m_6080_() * ((float)Math.PI / 180));
                attackBounds = attackBounds.m_82383_(lateralOffset);
                EntityHelper.hitTargetsWithAOEAttack(attacker, attackBounds, this.getAttackDamage(), this.getAttackKnockback(), true);
            } else if (this == DOUBLE_STOMP) {
                attacker.m_5496_((SoundEvent)ModSounds.FROSTOMPER_STOMP.get(), attacker.m_6121_() * 2.0f, attacker.m_6100_());
                List<LivingEntity> hitTargets = EntityHelper.hitTargetsWithAOEAttack(attacker, attackBounds, this.getAttackDamage(), this.getAttackKnockback(), true);
                for (LivingEntity hitTarget : hitTargets) {
                    if (!hitTarget.m_142079_()) continue;
                    hitTarget.m_146917_(hitTarget.m_146888_() + 600);
                }
            } else {
                EntityHelper.hitTargetsWithAOEAttack(attacker, attackBounds, this.getAttackDamage(), this.getAttackKnockback(), true);
            }
        }

        @Override
        public boolean isFinished(FrostomperEntity attacker, int attackTicker) {
            if (this == CHARGE) {
                return !attacker.isChargingForward();
            }
            return attackTicker >= this.getAttackDuration();
        }

        public static FrostomperAttackType byOrdinal(int pOrdinal) {
            if (pOrdinal < 0 || pOrdinal > FrostomperAttackType.values().length) {
                pOrdinal = 0;
            }
            return FrostomperAttackType.values()[pOrdinal];
        }
    }
}

