/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import team.recrafted.blastfromthepast.BlastFromThePast;
import team.recrafted.blastfromthepast.datagen.server.ModEntityLootGen;
import team.recrafted.blastfromthepast.entity.PsychoBearEntity;
import team.recrafted.blastfromthepast.entity.ai.goal.CustomPanicGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.EatDelphiniumGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.GlacerosAlertPanicGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.GlacerosSparGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.MoveAwayFromBlockGoal;
import team.recrafted.blastfromthepast.entity.ai.navigation.AzureNavigation;
import team.recrafted.blastfromthepast.entity.pack.EntityPack;
import team.recrafted.blastfromthepast.entity.pack.EntityPackAgeableMobData;
import team.recrafted.blastfromthepast.entity.pack.EntityPackHolder;
import team.recrafted.blastfromthepast.entity.speartooth.SpeartoothEntity;
import team.recrafted.blastfromthepast.init.ModBlocks;
import team.recrafted.blastfromthepast.init.ModEntities;
import team.recrafted.blastfromthepast.init.ModItems;
import team.recrafted.blastfromthepast.init.ModSounds;

public class GlacerosEntity
extends Animal
implements GeoEntity,
VariantHolder<Variant>,
EntityPackHolder<GlacerosEntity> {
    public static final ResourceLocation STEP_ATTRIBUTE = ResourceLocation.fromNamespaceAndPath((String)"blastfromthepast", (String)"glaceros_jump");
    private static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.m_135353_(GlacerosEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> PANICKING = SynchedEntityData.m_135353_(GlacerosEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> EATING = SynchedEntityData.m_135353_(GlacerosEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> SHEARED = SynchedEntityData.m_135353_(GlacerosEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> RUNNING = SynchedEntityData.m_135353_(GlacerosEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> CHARGING = SynchedEntityData.m_135353_(GlacerosEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> RUSHING = SynchedEntityData.m_135353_(GlacerosEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Optional<UUID>> SPARRING_PARTNER = SynchedEntityData.m_135353_(GlacerosEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public int antlerGrowCooldown;
    public int alertCooldown;
    public boolean shouldSparInstantly;
    public int sparringCooldown = 150 + this.m_217043_().m_188503_(50);
    public int chargeTimer;
    private boolean party;
    @Nullable
    private BlockPos jukebox;
    private EntityPack<GlacerosEntity> pack;
    public static final RawAnimation IDLE = RawAnimation.begin().then("animation.glaceros.idle", Animation.LoopType.DEFAULT);
    public static final RawAnimation EAT = RawAnimation.begin().then("animation.glaceros.eat", Animation.LoopType.DEFAULT);
    public static final RawAnimation CHARGE = RawAnimation.begin().then("animation.glaceros.charge", Animation.LoopType.DEFAULT);
    public static final RawAnimation CHARGE_PREPARE = RawAnimation.begin().then("animation.glaceros.charge_prepare", Animation.LoopType.DEFAULT);
    public static final RawAnimation TAIL = RawAnimation.begin().then("animation.glaceros.tail", Animation.LoopType.DEFAULT);
    public static final RawAnimation WALK = RawAnimation.begin().then("animation.glaceros.walk", Animation.LoopType.DEFAULT);
    public static final RawAnimation FLEE = RawAnimation.begin().then("animation.glaceros.flee", Animation.LoopType.DEFAULT);
    public static final RawAnimation DANCE = RawAnimation.begin().then("animation.glaceros.dance", Animation.LoopType.DEFAULT);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public GlacerosEntity(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 5;
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_274367_(1.5f);
    }

    @NotNull
    protected PathNavigation m_6037_(Level level) {
        return new AzureNavigation((Mob)this, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22281_, 0.0);
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new GlacerosAlertPanicGoal(this, 3.5));
        this.f_21345_.m_25352_(3, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new BreedGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{this.getVariant().getDelphinium().m_5456_()}), false));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new EatDelphiniumGoal(this, 1.0, 15));
        this.f_21345_.m_25352_(7, (Goal)new GlacerosLookAtPlayerGoal((Mob)this, Player.class, 5.0f));
        this.f_21345_.m_25352_(7, (Goal)new MoveAwayFromBlockGoal((PathfinderMob)this, Blocks.f_50083_, 1.7, 12));
        this.f_21345_.m_25352_(8, (Goal)new GlacerosLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new GlacerosSparGoal(this));
        this.f_21346_.m_25352_(5, (Goal)new AvoidEntityGoal((PathfinderMob)this, PsychoBearEntity.class, 20.0f, (double)1.2f, 2.0));
        this.f_21346_.m_25352_(5, (Goal)new AvoidSpeartoothGoal((PathfinderMob)this, 20.0f, 1.2f, 2.0));
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @org.jetbrains.annotations.Nullable SpawnGroupData spawnGroupData, CompoundTag compoundTag) {
        Variant glaceros$variant;
        RandomSource randomsource = level.m_213780_();
        if (spawnGroupData instanceof GlacerosGroupData) {
            GlacerosGroupData glacerosGroupData = (GlacerosGroupData)spawnGroupData;
            glaceros$variant = ((GlacerosGroupData)spawnGroupData).variant;
            glacerosGroupData.addPackMember((Mob)this);
        } else {
            glaceros$variant = this.getVariantFromChance(randomsource);
            spawnGroupData = new GlacerosGroupData(BlastFromThePast.getUniversalEntityPacks(level.m_6018_().m_7654_()).createFreshPack(), glaceros$variant);
        }
        this.setVariant(glaceros$variant);
        return super.m_6518_(level, difficulty, spawnType, spawnGroupData, compoundTag);
    }

    private Variant getVariantFromChance(RandomSource random) {
        float chance = random.m_188501_();
        if ((double)chance <= 0.25) {
            return Variant.STRAIGHT;
        }
        if (0.25 < (double)chance && (double)chance <= 0.5) {
            return Variant.SPIKEY;
        }
        if (0.5 < (double)chance && (double)chance <= 0.75) {
            return Variant.CURLY;
        }
        return Variant.BROAD;
    }

    public void m_8107_() {
        if (this.jukebox == null || !this.jukebox.m_203195_((Position)this.m_20182_(), 7.0) || !this.m_9236_().m_8055_(this.jukebox).m_60713_(Blocks.f_50131_)) {
            this.party = false;
            this.jukebox = null;
        }
        super.m_8107_();
    }

    public void m_6818_(BlockPos pos, boolean isPartying) {
        this.jukebox = pos;
        this.party = isPartying;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "main", 5, state -> {
            if (this.isRushing()) {
                return state.setAndContinue(CHARGE);
            }
            if (this.isCharging()) {
                return state.setAndContinue(CHARGE_PREPARE);
            }
            if (this.isEating()) {
                return state.setAndContinue(EAT);
            }
            if ((this.isPanicking() || this.isRunning()) && state.isMoving()) {
                return state.setAndContinue(FLEE);
            }
            if (this.m_20184_().m_165925_() > 1.0E-6) {
                return state.setAndContinue(WALK);
            }
            if (this.party && !this.m_6162_()) {
                return state.setAndContinue(DANCE);
            }
            return state.setAndContinue(IDLE);
        })}).add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "second", 5, state -> PlayState.STOP).triggerableAnim("tail", TAIL)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    @org.jetbrains.annotations.Nullable
    public EntityPack<GlacerosEntity> getPack() {
        return this.pack;
    }

    @Override
    public void setPack(@org.jetbrains.annotations.Nullable EntityPack<GlacerosEntity> pack) {
        this.pack = pack;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        this.jukebox = null;
        this.party = false;
        return super.m_6469_(source, amount);
    }

    protected void m_6475_(DamageSource damageSource, float damageAmount) {
        List glacerosEntities;
        super.m_6475_(damageSource, damageAmount);
        if (CustomPanicGoal.isMobDamage((Mob)this) && !(glacerosEntities = this.m_9236_().m_45976_(GlacerosEntity.class, this.m_20191_().m_82400_(16.0))).isEmpty()) {
            for (GlacerosEntity glaceros : glacerosEntities) {
                glaceros.setPanicking(true);
                glaceros.alertCooldown = 150 + glaceros.m_217043_().m_188503_(100);
            }
        }
    }

    @NotNull
    public ResourceLocation m_7582_() {
        if (this.isSheared()) {
            return this.m_6095_().m_20677_();
        }
        ResourceLocation key = switch (this.getVariant()) {
            default -> throw new IncompatibleClassChangeError();
            case Variant.BROAD -> ModEntityLootGen.GLACEROS_BROAD;
            case Variant.CURLY -> ModEntityLootGen.GLACEROS_CURLY;
            case Variant.SPIKEY -> ModEntityLootGen.GLACEROS_SPIKEY;
            case Variant.STRAIGHT -> ModEntityLootGen.GLACEROS_STRAIGHT;
        };
        return key;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.sparringCooldown > 0) {
            --this.sparringCooldown;
        }
        if (!this.m_9236_().f_46443_) {
            if (this.alertCooldown != 0) {
                --this.alertCooldown;
            } else {
                this.setPanicking(false);
            }
            this.setRunning(this.f_21342_.m_24999_() > 1.1 && !this.isSparring());
            if (this.isCharging()) {
                this.m_21564_(0.0f);
                this.m_21573_().m_26573_();
            }
            if (this.isSparring() && this.getSparringPartner() != null) {
                this.m_21563_().m_148051_(this.getSparringPartner());
            }
            if (this.getSparringPartner() == null) {
                this.setCharging(false);
                this.setRushing(false);
            }
            if (this.isSheared()) {
                if (this.antlerGrowCooldown != 0) {
                    --this.antlerGrowCooldown;
                } else {
                    this.setSheared(false);
                }
            }
            if (!this.isPanicking() && this.m_217043_().m_188503_(this.m_6162_() ? 30 : 100) == 0) {
                this.triggerAnim("second", "tail");
            }
        }
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_150930_(this.getVariant().getDelphinium().m_5456_());
    }

    @org.jetbrains.annotations.Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob otherParent) {
        GlacerosEntity child = (GlacerosEntity)((EntityType)ModEntities.GLACEROS.get()).m_20615_((Level)level);
        child.m_6863_(true);
        child.setVariant(this.getVariant());
        GlacerosEntity otherGlaceros = (GlacerosEntity)otherParent;
        if (otherGlaceros.getVariant() != this.getVariant() && (double)this.m_217043_().m_188501_() < 0.5) {
            child.setVariant(otherGlaceros.getVariant());
        }
        return child;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_VARIANT_ID, (Object)0);
        this.f_19804_.m_135372_(PANICKING, (Object)false);
        this.f_19804_.m_135372_(EATING, (Object)false);
        this.f_19804_.m_135372_(SHEARED, (Object)false);
        this.f_19804_.m_135372_(RUNNING, (Object)false);
        this.f_19804_.m_135372_(CHARGING, (Object)false);
        this.f_19804_.m_135372_(RUSHING, (Object)false);
        this.f_19804_.m_135372_(SPARRING_PARTNER, Optional.empty());
    }

    @org.jetbrains.annotations.Nullable
    public UUID getSparringPartnerUUID() {
        return ((Optional)this.f_19804_.m_135370_(SPARRING_PARTNER)).orElse(null);
    }

    public void setSparringPartnerUUID(UUID sparringPartner) {
        this.f_19804_.m_135381_(SPARRING_PARTNER, Optional.ofNullable(sparringPartner));
    }

    @org.jetbrains.annotations.Nullable
    public Entity getSparringPartner() {
        UUID id = this.getSparringPartnerUUID();
        if (id != null && !this.m_9236_().f_46443_) {
            return ((ServerLevel)this.m_9236_()).m_8791_(id);
        }
        return null;
    }

    public void setSparringPartner(@org.jetbrains.annotations.Nullable Entity sparringPartner) {
        if (sparringPartner == null) {
            this.setSparringPartnerUUID(null);
        } else {
            this.setSparringPartnerUUID(sparringPartner.m_20148_());
        }
    }

    public boolean isPanicking() {
        return (Boolean)this.f_19804_.m_135370_(PANICKING);
    }

    public void setPanicking(boolean panicking) {
        this.f_19804_.m_135381_(PANICKING, (Object)panicking);
    }

    public boolean isCharging() {
        return (Boolean)this.f_19804_.m_135370_(CHARGING);
    }

    public void setCharging(boolean charging) {
        this.f_19804_.m_135381_(CHARGING, (Object)charging);
    }

    public boolean isRushing() {
        return (Boolean)this.f_19804_.m_135370_(RUSHING);
    }

    public void setRushing(boolean rushing) {
        this.f_19804_.m_135381_(RUSHING, (Object)rushing);
    }

    public boolean isSparring() {
        return this.isRushing() || this.isCharging();
    }

    public boolean isEating() {
        return (Boolean)this.f_19804_.m_135370_(EATING);
    }

    public void setEating(boolean eating) {
        this.f_19804_.m_135381_(EATING, (Object)eating);
    }

    public boolean isSheared() {
        return (Boolean)this.f_19804_.m_135370_(SHEARED);
    }

    public void setSheared(boolean sheared) {
        this.f_19804_.m_135381_(SHEARED, (Object)sheared);
    }

    public boolean isRunning() {
        return (Boolean)this.f_19804_.m_135370_(RUNNING);
    }

    public void setRunning(boolean running) {
        this.f_19804_.m_135381_(RUNNING, (Object)running);
    }

    public void setVariant(Variant variant) {
        this.f_19804_.m_135381_(DATA_VARIANT_ID, (Object)variant.id);
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.f_19804_.m_135370_(DATA_VARIANT_ID));
    }

    public boolean canSparWith(GlacerosEntity glaceros) {
        return !glaceros.isSparring() && !glaceros.isSheared() && !glaceros.m_6162_() && glaceros.getSparringPartnerUUID() == null && glaceros.sparringCooldown == 0;
    }

    public void knockBackSparring(GlacerosEntity glacerosEntity, float strength) {
        this.applyKnockbackFromGlaceros(strength, glacerosEntity.m_20185_() - this.m_20185_(), glacerosEntity.m_20189_() - this.m_20189_());
    }

    private void applyKnockbackFromGlaceros(float strength, double ratioX, double ratioZ) {
        if (!(strength <= 0.0f)) {
            this.m_5496_((SoundEvent)ModSounds.GLACEROS_CLASH.get(), 5.0f, 5.0f);
            this.f_19812_ = true;
            Vec3 vector3d = this.m_20184_();
            Vec3 vector3d1 = new Vec3(ratioX, 0.0, ratioZ).m_82541_().m_82490_((double)strength);
            this.m_20334_(vector3d.f_82479_ / 2.0 - vector3d1.f_82479_, 0.3f, vector3d.f_82481_ / 2.0 - vector3d1.f_82481_);
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant().id);
        compound.m_128379_("Panicking", this.isPanicking());
        compound.m_128379_("Eating", this.isEating());
        compound.m_128379_("Sheared", this.isSheared());
        compound.m_128379_("Charging", this.isCharging());
        compound.m_128379_("Rushing", this.isRushing());
        compound.m_128405_("AntlerCooldown", this.antlerGrowCooldown);
        compound.m_128405_("AlertCooldown", this.alertCooldown);
        compound.m_128405_("SparringCooldown", this.sparringCooldown);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(Variant.byId(compound.m_128451_("Variant")));
        this.setPanicking(compound.m_128471_("Panicking"));
        this.setEating(compound.m_128471_("Eating"));
        this.setSheared(compound.m_128471_("Sheared"));
        this.setCharging(compound.m_128471_("Charging"));
        this.setRushing(compound.m_128471_("Rushing"));
        this.antlerGrowCooldown = compound.m_128451_("AntlerCooldown");
        this.alertCooldown = compound.m_128451_("AlertCooldown");
        this.sparringCooldown = compound.m_128451_("SparringCooldown");
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ModSounds.GLACEROS_HURT.get();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.GLACEROS_IDLE.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.GLACEROS_DEATH.get();
    }

    public static enum Variant implements StringRepresentable
    {
        STRAIGHT(0, "normal", (Block)ModBlocks.SNOW_LARKSPUR.get(), (Item)ModItems.STRAIGHT_GLACEROS_ANTLERS.get()),
        BROAD(1, "broad", (Block)ModBlocks.SHIVER_LARKSPUR.get(), (Item)ModItems.BROAD_GLACEROS_ANTLERS.get()),
        CURLY(2, "curly", (Block)ModBlocks.BLUSH_LARKSPUR.get(), (Item)ModItems.CURLY_GLACEROS_ANTLERS.get()),
        SPIKEY(3, "spikey", (Block)ModBlocks.ROYAL_LARKSPUR.get(), (Item)ModItems.SPIKEY_GLACEROS_ANTLERS.get());

        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;
        private final Block delphinium;
        private final Item antlerItem;

        private Variant(int id, String name, Block delphinium, Item antlerItem) {
            this.id = id;
            this.name = name;
            this.delphinium = delphinium;
            this.antlerItem = antlerItem;
        }

        public Block getDelphinium() {
            return this.delphinium;
        }

        public Item getAntlerItem() {
            return this.antlerItem;
        }

        public int getId() {
            return this.id;
        }

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        public String m_7912_() {
            return this.name;
        }

        static {
            BY_ID = ByIdMap.m_262839_(Variant::getId, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.CLAMP);
        }
    }

    public class GlacerosLookAtPlayerGoal
    extends LookAtPlayerGoal {
        public GlacerosLookAtPlayerGoal(Mob mob, Class<? extends LivingEntity> lookAtType, float lookDistance) {
            super(mob, lookAtType, lookDistance);
        }

        public boolean m_8036_() {
            if (GlacerosEntity.this.isSparring()) {
                return false;
            }
            return super.m_8036_();
        }

        public boolean m_8045_() {
            if (GlacerosEntity.this.isSparring()) {
                return false;
            }
            return super.m_8045_();
        }
    }

    public class GlacerosLookAroundGoal
    extends RandomLookAroundGoal {
        public GlacerosLookAroundGoal(Mob mob) {
            super(mob);
        }

        public boolean m_8036_() {
            if (GlacerosEntity.this.isSparring()) {
                return false;
            }
            return super.m_8036_();
        }

        public boolean m_8045_() {
            if (GlacerosEntity.this.isSparring()) {
                return false;
            }
            return super.m_8045_();
        }
    }

    public class AvoidSpeartoothGoal
    extends AvoidEntityGoal<SpeartoothEntity> {
        private final TargetingConditions avoidEntityTargeting;

        public AvoidSpeartoothGoal(PathfinderMob mob, float maxDistance, double walkSpeedModifier, double sprintSpeedModifier) {
            super(mob, SpeartoothEntity.class, maxDistance, walkSpeedModifier, sprintSpeedModifier);
            this.avoidEntityTargeting = TargetingConditions.m_148352_().m_26883_((double)maxDistance).m_26888_(this.f_25022_.and(this.f_25021_));
        }

        public boolean m_8036_() {
            this.f_25016_ = this.f_25015_.m_9236_().m_45982_(this.f_25015_.m_9236_().m_6443_(this.f_25020_, this.f_25015_.m_20191_().m_82377_((double)this.f_25017_, 3.0, (double)this.f_25017_), p_148078_ -> true), this.avoidEntityTargeting, (LivingEntity)this.f_25015_, this.f_25015_.m_20185_(), this.f_25015_.m_20186_(), this.f_25015_.m_20189_());
            if (this.f_25016_ == null || ((SpeartoothEntity)this.f_25016_).getState() == SpeartoothEntity.State.STALK || ((SpeartoothEntity)this.f_25016_).m_21824_()) {
                return false;
            }
            Vec3 vec3 = DefaultRandomPos.m_148407_((PathfinderMob)this.f_25015_, (int)16, (int)7, (Vec3)((SpeartoothEntity)this.f_25016_).m_20182_());
            if (vec3 == null) {
                return false;
            }
            if (((SpeartoothEntity)this.f_25016_).m_20275_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_) < ((SpeartoothEntity)this.f_25016_).m_20280_((Entity)this.f_25015_)) {
                return false;
            }
            this.f_25018_ = this.f_25019_.m_26524_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0);
            return this.f_25018_ != null;
        }
    }

    static class GlacerosGroupData
    extends EntityPackAgeableMobData<GlacerosEntity> {
        public final Variant variant;

        GlacerosGroupData(EntityPack<GlacerosEntity> pack, Variant variant) {
            super(pack, true);
            this.variant = variant;
        }
    }
}

