/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import team.recrafted.blastfromthepast.BlastFromThePast;
import team.recrafted.blastfromthepast.access.PlayerBFTPDataAccess;
import team.recrafted.blastfromthepast.entity.misc.TransitioningState;
import team.recrafted.blastfromthepast.events.CuriosCompat;
import team.recrafted.blastfromthepast.init.ModDataSerializers;
import team.recrafted.blastfromthepast.init.ModEntities;
import team.recrafted.blastfromthepast.util.DebugFlags;
import team.recrafted.blastfromthepast.util.EntityHelper;

public class HollowEntity
extends LivingEntity
implements GeoEntity {
    private static final EntityDataAccessor<TransitioningState> STATE = SynchedEntityData.m_135353_(HollowEntity.class, (EntityDataSerializer)((EntityDataSerializer)ModDataSerializers.TRANSITIONING_STATE.get()));
    @Nullable
    private StoredInventory storedInventory;
    @Nullable
    private Player trackedPlayer;
    private int transitionTicks = -1;
    public static final RawAnimation IDLE = RawAnimation.begin().then("animation.hollow.idle", Animation.LoopType.DEFAULT);
    public static final RawAnimation IDLE_ORBLESS = RawAnimation.begin().then("animation.hollow.idle_orbless", Animation.LoopType.DEFAULT);
    public static final RawAnimation ORB_SPAWN = RawAnimation.begin().then("animation.hollow.orb_spawn", Animation.LoopType.DEFAULT);
    public static final RawAnimation ORB_DESPAWN = RawAnimation.begin().then("animation.hollow.orb_despawn", Animation.LoopType.DEFAULT);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public HollowEntity(EntityType<? extends HollowEntity> hollowEntityEntityType, Level level) {
        super(hollowEntityEntityType, level);
    }

    public boolean m_20068_() {
        return true;
    }

    public static HollowEntity create(ServerPlayer player) {
        HollowEntity hollow = (HollowEntity)((EntityType)ModEntities.HOLLOW.get()).m_20615_(player.m_9236_());
        assert (hollow != null);
        hollow.m_146884_(player.m_20182_());
        BlockPos safePos = EntityHelper.findSafeSpot(hollow);
        if (safePos != null) {
            hollow.m_6034_(safePos.m_123341_(), safePos.m_123342_(), safePos.m_123343_());
        }
        if (DebugFlags.DEBUG_HOLLOW) {
            hollow.m_7292_(new MobEffectInstance(MobEffects.f_19619_, -1, 0, true, false));
            player.m_20194_().m_6846_().m_11314_().forEach(p -> p.m_213846_((Component)Component.m_237113_((String)("Hollow created at " + String.valueOf(hollow.m_20182_()) + " for " + String.valueOf(player.m_7755_())))));
        }
        hollow.m_19915_(player.m_146908_(), 0.0f);
        hollow.storeInventory(player);
        return hollow;
    }

    public void storeInventory(ServerPlayer player) {
        ListTag inventoryData = new ListTag();
        player.m_150109_().m_36026_(inventoryData);
        List<ItemStack> additionalItems = BlastFromThePast.CURIOS_LOADED ? CuriosCompat.getCuriosItems(player) : null;
        this.storedInventory = new StoredInventory(player.m_20148_(), inventoryData, Optional.ofNullable(additionalItems));
        ((PlayerBFTPDataAccess)player).bftp$markInventoryStored();
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_20334_(0.0, 0.0, 0.0);
        TransitioningState state = (TransitioningState)this.m_20088_().m_135370_(STATE);
        if (this.transitionTicks > 0) {
            --this.transitionTicks;
        } else if (this.transitionTicks == 0) {
            if (state.isTransitional()) {
                switch (state) {
                    case INACTIVE_TO_ACTIVE: {
                        this.m_20088_().m_135381_(STATE, (Object)TransitioningState.ACTIVE);
                        this.transitionTicks = 40;
                        break;
                    }
                    case ACTIVE_TO_INACTIVE: {
                        this.m_20088_().m_135381_(STATE, (Object)TransitioningState.INACTIVE);
                    }
                }
            } else {
                this.transitionTicks = -1;
            }
        } else if (this.storedInventory != null) {
            Player owner = this.getOwnerNearby();
            if (state == TransitioningState.INACTIVE && owner != null) {
                this.trackedPlayer = owner;
                this.m_20088_().m_135381_(STATE, (Object)TransitioningState.INACTIVE_TO_ACTIVE);
                this.transitionTicks = 20;
            } else if (state == TransitioningState.ACTIVE && owner == null) {
                this.trackedPlayer = null;
                this.m_20088_().m_135381_(STATE, (Object)TransitioningState.ACTIVE_TO_INACTIVE);
                this.transitionTicks = 10;
            }
        }
    }

    @Nullable
    public Player getOwnerNearby() {
        if (this.storedInventory == null) {
            return null;
        }
        List nearbyPlayer = this.m_9236_().m_45971_(Player.class, TargetingConditions.m_148353_().m_26888_(p -> p.m_6084_() && p.m_20148_().equals(this.storedInventory.playerUuid)), (LivingEntity)this, this.m_20191_().m_82400_(5.0));
        return nearbyPlayer.isEmpty() ? null : (Player)nearbyPlayer.get(0);
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STATE, (Object)TransitioningState.INACTIVE);
    }

    @NotNull
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return super.m_6096_(player, hand);
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.storedInventory != null && player.m_20148_().equals(this.storedInventory.playerUuid)) {
            FakePlayer fakePlayer = EntityHelper.getFakePlayer(serverLevel);
            fakePlayer.m_150109_().m_36035_(this.storedInventory.inventoryData);
            for (int i = 0; i < fakePlayer.m_150109_().m_6643_(); ++i) {
                ItemStack stack2 = fakePlayer.m_150109_().m_8020_(i);
                if (stack2.m_41619_() || !player.m_150109_().m_8020_(i).m_41619_()) continue;
                player.m_150109_().m_6836_(i, stack2);
                fakePlayer.m_150109_().m_6836_(i, ItemStack.f_41583_);
            }
            List additionalItems = this.storedInventory.additionalItems.orElse(Collections.emptyList());
            additionalItems.removeIf(stack -> player.m_150109_().m_36054_(stack));
            if (fakePlayer.m_150109_().m_7983_() && additionalItems.isEmpty()) {
                this.storedInventory = null;
                this.m_146870_();
            } else {
                if (!fakePlayer.m_150109_().m_7983_()) {
                    for (int i = 0; i < fakePlayer.m_150109_().m_6643_(); ++i) {
                        int slot;
                        ItemStack stack3 = fakePlayer.m_150109_().m_8020_(i);
                        if (stack3.m_41619_()) continue;
                        if (player.m_150109_().m_36054_(stack3)) {
                            fakePlayer.m_150109_().m_6836_(i, ItemStack.f_41583_);
                            continue;
                        }
                        if (stack3.m_41741_() <= 1 || (slot = player.m_150109_().m_36030_(stack3)) == -1) continue;
                        ItemStack existing = player.m_150109_().m_8020_(slot);
                        int count = Math.min(stack3.m_41613_(), existing.m_41741_() - existing.m_41613_());
                        existing.m_41769_(count);
                        stack3.m_41774_(count);
                        fakePlayer.m_150109_().m_6836_(i, stack3);
                    }
                }
                if (fakePlayer.m_150109_().m_7983_() && additionalItems.isEmpty()) {
                    this.storedInventory = null;
                    this.m_146870_();
                } else {
                    ListTag inventoryData = new ListTag();
                    fakePlayer.m_150109_().m_36026_(inventoryData);
                    this.storedInventory = new StoredInventory(player.m_20148_(), inventoryData, Optional.of(additionalItems));
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6096_(player, hand);
    }

    public void restoreAdditionalItems(ServerPlayer player) {
        if (this.storedInventory == null) {
            return;
        }
        List additionalItems = this.storedInventory.additionalItems.orElse(Collections.emptyList());
        additionalItems.removeIf(stack -> player.m_150109_().m_36054_(stack));
        this.storedInventory = new StoredInventory(player.m_20148_(), this.storedInventory.inventoryData, Optional.of(additionalItems));
    }

    public boolean m_6673_(DamageSource source) {
        return !source.m_276093_(DamageTypes.f_286979_);
    }

    public Iterable<ItemStack> m_6168_() {
        return List.of(ItemStack.f_41583_);
    }

    public ItemStack m_6844_(EquipmentSlot slot) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot slot, ItemStack stack) {
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("stored_inventory")) {
            this.storedInventory = StoredInventory.fromSaveData(compound.m_128469_("stored_inventory"));
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.storedInventory != null) {
            compound.m_128365_("stored_inventory", (Tag)this.storedInventory.getSaveData());
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "main", 5, state -> {
            TransitioningState state1 = (TransitioningState)this.m_20088_().m_135370_(STATE);
            if (state1 == TransitioningState.INACTIVE_TO_ACTIVE) {
                return state.setAndContinue(ORB_SPAWN);
            }
            if (state1 == TransitioningState.ACTIVE_TO_INACTIVE) {
                return state.setAndContinue(ORB_DESPAWN);
            }
            if (state1 == TransitioningState.INACTIVE) {
                return state.setAndContinue(IDLE_ORBLESS);
            }
            if (state1 == TransitioningState.ACTIVE) {
                return state.setAndContinue(IDLE);
            }
            return PlayState.STOP;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public record StoredInventory(UUID playerUuid, ListTag inventoryData, Optional<List<ItemStack>> additionalItems) {
        public CompoundTag getSaveData() {
            CompoundTag data = new CompoundTag();
            data.m_128362_("player", this.playerUuid);
            data.m_128365_("items", (Tag)this.inventoryData);
            ListTag additionalItems = new ListTag();
            this.additionalItems.ifPresent(items -> items.forEach(item -> additionalItems.add((Object)item.m_41739_(data))));
            if (!additionalItems.isEmpty()) {
                data.m_128365_("additional_items", (Tag)additionalItems);
            }
            return data;
        }

        public static StoredInventory fromSaveData(CompoundTag data) {
            ArrayList additionalItems = new ArrayList();
            if (data.m_128441_("additional_items")) {
                ListTag additionalItemsData = data.m_128437_("additional_items", 10);
                for (Tag tag : additionalItemsData) {
                    Optional.of(ItemStack.m_41712_((CompoundTag)((CompoundTag)tag))).ifPresent(additionalItems::add);
                }
            }
            return new StoredInventory(data.m_128342_("player"), data.m_128437_("items", 10), Optional.of(additionalItems));
        }
    }
}

