/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity;

import java.util.OptionalInt;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;
import team.recrafted.blastfromthepast.BlastFromThePast;
import team.recrafted.blastfromthepast.entity.Roaring;
import team.recrafted.blastfromthepast.entity.ai.controller.OverridableBodyRotationControl;
import team.recrafted.blastfromthepast.entity.ai.controller.OverridableLookControl;
import team.recrafted.blastfromthepast.entity.ai.controller.OverridableMoveControl;
import team.recrafted.blastfromthepast.entity.ai.goal.AgeableHurtByTargetGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.CustomPanicGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.HitboxAdjustedBreedGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.HitboxAdjustedFollowParentGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.PredicatedGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.RaidFoodContainerGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.ScratchBackOnTreeGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.attacker.AnimatedMeleeAttackGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.complex_animal.MoveToOrSitWithItemGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.complex_animal.SeekShelterGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.complex_animal.SleepGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.roar.RoarAtTargetGoal;
import team.recrafted.blastfromthepast.entity.ai.navigation.AzureNavigation;
import team.recrafted.blastfromthepast.entity.misc.AnimatedAttacker;
import team.recrafted.blastfromthepast.entity.misc.BackScratcher;
import team.recrafted.blastfromthepast.entity.misc.ComplexAnimal;
import team.recrafted.blastfromthepast.entity.misc.OverrideAnimatedAttacker;
import team.recrafted.blastfromthepast.entity.misc.Pacifiable;
import team.recrafted.blastfromthepast.entity.misc.TransitioningState;
import team.recrafted.blastfromthepast.init.ModCriteriaTriggers;
import team.recrafted.blastfromthepast.init.ModEntities;
import team.recrafted.blastfromthepast.init.ModSounds;
import team.recrafted.blastfromthepast.init.ModTags;
import team.recrafted.blastfromthepast.network.ScreenShakePayload;
import team.recrafted.blastfromthepast.util.DebugFlags;
import team.recrafted.blastfromthepast.util.EntityHelper;
import team.recrafted.blastfromthepast.util.HitboxHelper;

public class PsychoBearEntity
extends Animal
implements GeoEntity,
OverrideAnimatedAttacker<PsychoBearEntity, PsychoBearAttackType>,
ComplexAnimal,
Pacifiable,
Roaring,
BackScratcher {
    public static final EntityDimensions PSYCHO_BEAR_BABY_DIMENSIONS = EntityDimensions.m_20395_((float)HitboxHelper.pixelsToBlocks(18.0f), (float)HitboxHelper.pixelsToBlocks(13.0f));
    private static final EntityDataAccessor<OptionalInt> DATA_ACTIVE_ATTACK_TYPE = SynchedEntityData.m_135353_(PsychoBearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135044_);
    private static final EntityDataAccessor<Byte> DATA_FLAGS = SynchedEntityData.m_135353_(PsychoBearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> DATA_PACIFIED = SynchedEntityData.m_135353_(PsychoBearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_EATING = SynchedEntityData.m_135353_(PsychoBearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Byte> DATA_SLEEP_STATE = SynchedEntityData.m_135353_(PsychoBearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> DATA_BACK_SCRATCH_STATE = SynchedEntityData.m_135353_(PsychoBearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> DATA_PREPARING_TO_SCRATCH_BACK = SynchedEntityData.m_135353_(PsychoBearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final byte SITTING_FLAG = 1;
    private static final int ROARING_FLAG = 2;
    private static final int MAX_EAT_TIME = Mth.m_14143_((float)50.0f);
    public static final int FINISH_CHEWING_ACTION_POINT = Mth.m_14143_((float)35.0f);
    public static final int START_CHEWING_ACTION_POINT = Mth.m_14143_((float)15.0f);
    public static final int MAX_ROAR_TICKS = Mth.m_14143_((float)50.0f);
    private static final TargetingConditions ALERT_CONDITIONS = TargetingConditions.m_148352_().m_148355_();
    public static final float ADULT_VERTICAL_WIDTH = HitboxHelper.pixelsToBlocks(21.0f);
    private final AnimatedAttacker.AttackTicker<PsychoBearEntity, PsychoBearAttackType> attackTicker = new AnimatedAttacker.AttackTicker(this);
    private int pacifiedTicks = 0;
    private int eatCounter = 0;
    private Player lastFedPlayer;
    private int moreFoodTicks;
    private int itchReliefTicks;
    private int roarCounter;
    private boolean party;
    @Nullable
    private BlockPos jukebox;
    private static final int LIE_DOWN_DURATION = Mth.m_14143_((float)20.0f);
    private static final int WAKE_UP_DURATION = Mth.m_14143_((float)20.0f);
    private static final int BACK_SCRATCH_START_DURATION = Mth.m_14143_((float)10.0f);
    private static final int BACK_SCRATCH_END_DURATION = Mth.m_14143_((float)10.0f);
    private final TransitioningState.TransitionTicker sleepTicker = new TransitioningState.TransitionTicker(this::getSleepState, this::setSleepState, LIE_DOWN_DURATION, WAKE_UP_DURATION);
    private final TransitioningState.TransitionTicker backScratchTicker = new TransitioningState.TransitionTicker(this::getBackScratchState, this::setBackScratchState, BACK_SCRATCH_START_DURATION, BACK_SCRATCH_END_DURATION);
    public static final RawAnimation IDLE = RawAnimation.begin().then("animation.psycho_bear.idle", Animation.LoopType.DEFAULT);
    public static final RawAnimation ROAR = RawAnimation.begin().then("animation.psycho_bear.roar", Animation.LoopType.DEFAULT);
    public static final RawAnimation ATTACK_FLIPPED = RawAnimation.begin().then("animation.psycho_bear.attack_flipped", Animation.LoopType.DEFAULT);
    public static final RawAnimation ATTACK = RawAnimation.begin().then("animation.psycho_bear.attack", Animation.LoopType.DEFAULT);
    public static final RawAnimation EAT = RawAnimation.begin().then("animation.psycho_bear.eat", Animation.LoopType.DEFAULT);
    public static final RawAnimation SLEEP_START = RawAnimation.begin().then("animation.psycho_bear.sleep_start", Animation.LoopType.DEFAULT);
    public static final RawAnimation SLEEP = RawAnimation.begin().then("animation.psycho_bear.sleep", Animation.LoopType.DEFAULT);
    public static final RawAnimation SLEEP_END = RawAnimation.begin().then("animation.psycho_bear.sleep_end", Animation.LoopType.DEFAULT);
    public static final RawAnimation SCRATCH_START = RawAnimation.begin().then("animation.psycho_bear.back_scratch_start", Animation.LoopType.DEFAULT);
    public static final RawAnimation SCRATCH_LOOP = RawAnimation.begin().then("animation.psycho_bear.back_scratch_loop", Animation.LoopType.DEFAULT);
    public static final RawAnimation SCRATCH_STOP = RawAnimation.begin().then("animation.psycho_bear.back_scratch_stop", Animation.LoopType.DEFAULT);
    public static final RawAnimation WALK = RawAnimation.begin().then("animation.psycho_bear.walk", Animation.LoopType.DEFAULT);
    public static final RawAnimation DANCE = RawAnimation.begin().then("animation.psycho_bear.dance", Animation.LoopType.DEFAULT);
    private static final double MINIMUM_ATTACK_SIZE = HitboxHelper.calculateMinimumAttackHitboxWidth(((EntityType)ModEntities.PSYCHO_BEAR.get()).m_20678_());
    private static final Vec3 DEFAULT_ATTACK_SIZE = new Vec3(MINIMUM_ATTACK_SIZE + 1.0, MINIMUM_ATTACK_SIZE + 1.0, MINIMUM_ATTACK_SIZE + 1.0);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public PsychoBearEntity(EntityType<? extends PsychoBearEntity> entityType, Level level) {
        super(entityType, level);
        this.f_21365_ = new OverridableLookControl<PsychoBearEntity>(this);
        this.f_21342_ = new OverridableMoveControl<PsychoBearEntity>(this);
        this.m_21441_(BlockPathTypes.DAMAGE_OTHER, 0.0f);
        this.m_21553_(true);
        this.m_274367_(1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22276_, 70.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ACTIVE_ATTACK_TYPE, (Object)OptionalInt.empty());
        this.f_19804_.m_135372_(DATA_FLAGS, (Object)0);
        this.f_19804_.m_135372_(DATA_PACIFIED, (Object)false);
        this.f_19804_.m_135372_(DATA_EATING, (Object)false);
        this.f_19804_.m_135372_(DATA_SLEEP_STATE, (Object)((byte)TransitioningState.INACTIVE.ordinal()));
        this.f_19804_.m_135372_(DATA_BACK_SCRATCH_STATE, (Object)((byte)TransitioningState.INACTIVE.ordinal()));
        this.f_19804_.m_135372_(DATA_PREPARING_TO_SCRATCH_BACK, (Object)false);
    }

    protected boolean getFlag(int flag) {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS) & flag) != 0;
    }

    protected void setFlag(int flagId, boolean value) {
        byte flags = (Byte)this.f_19804_.m_135370_(DATA_FLAGS);
        if (value) {
            this.f_19804_.m_135381_(DATA_FLAGS, (Object)((byte)(flags | flagId)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS, (Object)((byte)(flags & ~flagId)));
        }
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        super.m_7350_(pKey);
        if (DATA_ACTIVE_ATTACK_TYPE.equals(pKey)) {
            this.attackTicker.reset();
        }
        if (!this.f_19803_ && DATA_EATING.equals(pKey)) {
            this.eatCounter = 0;
        }
        if (DATA_SLEEP_STATE.equals(pKey)) {
            this.sleepTicker.triggerStateChange();
        }
        if (DATA_BACK_SCRATCH_STATE.equals(pKey)) {
            this.m_6210_();
            this.backScratchTicker.triggerStateChange();
        }
        if (DATA_PREPARING_TO_SCRATCH_BACK.equals(pKey)) {
            this.m_6210_();
        }
    }

    protected BodyRotationControl m_7560_() {
        return new OverridableBodyRotationControl<PsychoBearEntity>(this);
    }

    protected PathNavigation m_6037_(Level level) {
        return new AzureNavigation((Mob)this, level);
    }

    public EntityDimensions m_6972_(Pose pose) {
        if (this.isBackScratching() || this.isPreparingToScratchBack()) {
            EntityDimensions normalDimensions = this.m_6095_().m_20680_();
            return EntityDimensions.m_20395_((float)ADULT_VERTICAL_WIDTH, (float)normalDimensions.f_20377_);
        }
        return this.m_6162_() ? PSYCHO_BEAR_BABY_DIMENSIONS : super.m_6972_(pose);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, new RoarAtTargetGoal<PsychoBearEntity>(this, 3.0));
        this.f_21345_.m_25352_(2, new PredicatedGoal<PsychoBearEntity>((Goal)new AnimatedMeleeAttackGoal(this, 1.0, true), this, Predicate.not(OverrideAnimatedAttacker::isAllActionBlocked)));
        this.f_21345_.m_25352_(3, new CustomPanicGoal<PsychoBearEntity>(this, 2.0, EntityHelper.getPanicInducingDamageTypes()));
        this.f_21345_.m_25352_(4, new SeekShelterGoal<PsychoBearEntity>(this, 1.0));
        this.f_21345_.m_25352_(5, new SleepGoal<PsychoBearEntity>(this));
        this.f_21345_.m_25352_(6, (Goal)new HitboxAdjustedBreedGoal(this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new TemptGoal((PathfinderMob)this, 1.25, this.isTemptItem(), false));
        this.f_21345_.m_25352_(8, new MoveToOrSitWithItemGoal<PsychoBearEntity>(this, this::isWantedItem, 1.0));
        this.f_21345_.m_25352_(9, (Goal)new HitboxAdjustedFollowParentGoal(this, 1.25));
        this.f_21345_.m_25352_(10, new RaidFoodContainerGoal<PsychoBearEntity>(this, 1.0, 16, 1));
        this.f_21345_.m_25352_(11, new ScratchBackOnTreeGoal<PsychoBearEntity>(this, 1.0, 16, 1, this::isBackScratchBlock));
        this.f_21345_.m_25352_(12, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(13, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(14, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, new AgeableHurtByTargetGoal<PsychoBearEntity>(this));
        this.f_21346_.m_25352_(2, new PredicatedGoal<PsychoBearEntity>((Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, null), this, PsychoBearEntity::canBeAggressive, true));
        this.f_21346_.m_25352_(3, new PredicatedGoal<PsychoBearEntity>((Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, true, this::canTarget), this, PsychoBearEntity::canBeAggressive, true));
    }

    private boolean isBackScratchBlock(BlockState blockState) {
        return blockState.m_204336_(ModTags.Blocks.PSYCHO_BEAR_SCRATCHES_BACK_ON);
    }

    protected boolean canBeAggressive() {
        return !this.isPacified() && !this.m_6162_() && !this.m_5803_();
    }

    protected boolean canTarget(LivingEntity target) {
        return target.m_5789_() && !target.m_6095_().m_204039_(ModTags.EntityTypes.PSYCHO_BEAR_IGNORES);
    }

    private Ingredient isTemptItem() {
        return Ingredient.m_204132_(this.m_6162_() ? ModTags.Items.BABY_PSYCHO_BEAR_TEMPT_ITEMS : ModTags.Items.PSYCHO_BEAR_TEMPT_ITEMS);
    }

    public boolean m_6898_(ItemStack itemStack) {
        return this.m_6162_() ? itemStack.m_204117_(ModTags.Items.BABY_PSYCHO_BEAR_FOOD) : itemStack.m_204117_(ModTags.Items.PSYCHO_BEAR_FOOD);
    }

    public boolean isPacifier(ItemStack stack) {
        return stack.m_204117_(ModTags.Items.PSYCHO_BEAR_PACIFIER);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack playerItemInHand = player.m_21120_(hand);
        if (playerItemInHand.m_150930_(Items.f_42751_)) {
            player.m_5661_((Component)Component.m_237113_((String)String.format("%s %s states: Eating[%s], Sitting[%s], Sleeping[%s], Pacified[%s], Roaring[%s]", this.m_5446_().getString(), this.m_9236_().f_46443_ ? "Client" : "Server", this.isEating(), this.isSitting(), this.m_5803_(), this.isPacified(), this.isRoaring())), false);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        boolean canEat = false;
        if (this.isPacifier(playerItemInHand) && !this.m_6162_() && !this.isPacified()) {
            canEat = true;
        } else if (this.m_6898_(playerItemInHand)) {
            if (this.m_6162_()) {
                this.m_142075_(player, hand, playerItemInHand);
                this.m_146740_(PsychoBearEntity.m_216967_((int)(-this.m_146764_())), true);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (!this.m_9236_().f_46443_ && this.m_146764_() == 0 && this.m_5957_()) {
                this.m_142075_(player, hand, playerItemInHand);
                this.m_27595_(player);
                return InteractionResult.SUCCESS;
            }
            canEat = true;
        }
        if (canEat) {
            if (!this.canMove() || this.m_6162_()) {
                return InteractionResult.PASS;
            }
            if (!this.m_9236_().f_46443_) {
                this.tryToSit();
                this.lastFedPlayer = player;
                this.setEating(true);
                ItemStack mainHandItem = this.getItemInMouth();
                if (!mainHandItem.m_41619_() && !player.m_7500_()) {
                    this.m_19983_(mainHandItem);
                }
                this.putItemInMouth(new ItemStack((ItemLike)playerItemInHand.m_41720_(), 1), false);
                this.m_142075_(player, hand, playerItemInHand);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return InteractionResult.PASS;
    }

    @org.jetbrains.annotations.Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (AgeableMob)((EntityType)ModEntities.PSYCHO_BEAR.get()).m_20615_((Level)serverLevel);
    }

    @Override
    public void setActiveAttackType(@org.jetbrains.annotations.Nullable PsychoBearAttackType attackType) {
        this.f_19804_.m_135381_(DATA_ACTIVE_ATTACK_TYPE, (Object)(attackType == null ? OptionalInt.empty() : OptionalInt.of(attackType.ordinal())));
        if (attackType != null && !this.m_9236_().f_46443_) {
            if (this.isRoaring()) {
                this.setRoaring(false);
            }
            if (this.isEating()) {
                this.setEating(false);
            }
        }
    }

    @Override
    @org.jetbrains.annotations.Nullable
    public PsychoBearAttackType getActiveAttackType() {
        OptionalInt ordinal = (OptionalInt)this.f_19804_.m_135370_(DATA_ACTIVE_ATTACK_TYPE);
        return ordinal.isEmpty() ? null : PsychoBearAttackType.byOrdinal(ordinal.getAsInt());
    }

    @Override
    public PsychoBearAttackType selectAttackTypeForTarget(@org.jetbrains.annotations.Nullable LivingEntity target) {
        return PsychoBearAttackType.SLASH;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_21515_()) {
            boolean inWater = this.m_20069_();
            if (this.m_5448_() != null && this.m_5803_()) {
                this.m_6710_(null);
            }
            if (inWater || this.m_9236_().m_46470_()) {
                this.setSleeping(false);
            }
            if (inWater || this.m_5803_()) {
                this.setSitting(false);
                this.setEating(false);
            }
        }
        if (!this.canRotateHead()) {
            this.clampHeadRotationToBody();
        }
        if (this.isSitting()) {
            this.m_146926_(0.0f);
        }
        this.attackTicker.tick();
        if (this.pacifiedTicks > 0) {
            --this.pacifiedTicks;
            if (this.pacifiedTicks == 0 && !this.m_9236_().f_46443_) {
                this.setPacified(false);
            }
        }
        this.handleEating();
        if (this.roarCounter > 0 && ++this.roarCounter > MAX_ROAR_TICKS) {
            this.roarCounter = 0;
            if (!this.m_9236_().f_46443_) {
                this.setRoaring(false);
            }
        }
        this.sleepTicker.tick(!this.m_9236_().f_46443_);
        this.backScratchTicker.tick(!this.m_9236_().f_46443_);
    }

    protected void clampHeadRotationToBody() {
        float f = this.m_8085_();
        float f1 = this.m_6080_();
        float f2 = Mth.m_14177_((float)(this.f_20883_ - f1));
        float f3 = Mth.m_14036_((float)Mth.m_14177_((float)(this.f_20883_ - f1)), (float)(-f), (float)f);
        float f4 = f1 + f2 - f3;
        this.m_5616_(f4);
    }

    @Override
    public boolean isRoaring() {
        return this.getFlag(2);
    }

    @Override
    public void setRoaring(boolean roaring) {
        this.setFlag(2, roaring);
    }

    @Override
    public void roarIfPossible() {
        if (this.canRoar() && !this.m_9236_().f_46443_) {
            this.roarCounter = 1;
            this.setRoaring(true);
            this.m_5496_((SoundEvent)ModSounds.PSYCHO_BEAR_ROAR.get(), 6.0f, this.m_6100_());
            for (Player player : this.m_9236_().m_45976_(Player.class, new AABB(this.m_20183_()).m_82400_((double)(((SoundEvent)ModSounds.PSYCHO_BEAR_ROAR.get()).m_215668_(6.0f) - 1.0f)))) {
                BlastFromThePast.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new ScreenShakePayload(20.0f, 60));
            }
        }
    }

    @Override
    public boolean canRoar() {
        return this.getActiveAttackType() == null && this.canPerformAction();
    }

    public void m_8107_() {
        if (this.m_5803_() || this.m_6107_()) {
            this.f_20899_ = false;
            this.f_20900_ = 0.0f;
            this.f_20902_ = 0.0f;
        }
        if (this.jukebox == null || !this.jukebox.m_203195_((Position)this.m_20182_(), 7.0) || !this.m_9236_().m_8055_(this.jukebox).m_60713_(Blocks.f_50131_)) {
            this.party = false;
            this.jukebox = null;
        }
        super.m_8107_();
    }

    public void m_6818_(BlockPos pos, boolean isPartying) {
        this.jukebox = pos;
        this.party = isPartying;
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.moreFoodTicks > 0) {
            --this.moreFoodTicks;
        }
        if (this.itchReliefTicks > 0) {
            --this.itchReliefTicks;
        }
    }

    @Override
    public void tryToSit() {
        if (!this.m_20069_()) {
            this.m_21564_(0.0f);
            this.m_21573_().m_26573_();
            this.setSitting(true);
        }
    }

    @Override
    public boolean isSitting() {
        return this.getFlag(1);
    }

    @Override
    public void setSitting(boolean sitting) {
        this.setFlag(1, sitting);
    }

    @Override
    public boolean canPerformAction() {
        return !this.isEating() && !this.isSitting() && !this.m_5803_() && !this.isBackScratching();
    }

    @Override
    public boolean isEating() {
        return (Boolean)this.f_19804_.m_135370_(DATA_EATING);
    }

    @Override
    public void setEating(boolean eating) {
        this.f_19804_.m_135381_(DATA_EATING, (Object)eating);
    }

    @Override
    public ItemStack getItemInMouth() {
        return this.m_6844_(EquipmentSlot.MAINHAND);
    }

    private void handleEating() {
        ItemStack eatItem = this.getItemInMouth();
        if (!this.isEating() && this.isSitting() && !eatItem.m_41619_() && !this.m_9236_().f_46443_) {
            if (DebugFlags.DEBUG_BEAR_EAT) {
                BlastFromThePast.LOGGER.info("Started eating animation for {}", (Object)this);
            }
            this.setEating(true);
        } else if (this.isEating() && (eatItem.m_41619_() && !this.isAboutToFinishEating() || !this.isSitting()) && !this.m_9236_().f_46443_) {
            if (DebugFlags.DEBUG_BEAR_EAT) {
                BlastFromThePast.LOGGER.info("Stopped in-progress {}/{} eating animation for {}", new Object[]{this.eatCounter, MAX_EAT_TIME, this});
            }
            this.setEating(false);
        }
        if (this.isEating()) {
            if (this.isChewing()) {
                this.addEatingParticles();
            }
            if (!this.m_9236_().f_46443_) {
                if (this.finishedChewing() && this.isFoodOrPacifier(eatItem)) {
                    if (this.isPacifier(eatItem)) {
                        this.setPacified(true);
                        this.m_6710_(null);
                        if (this.lastFedPlayer != null) {
                            ModCriteriaTriggers.PACIFY_BEAR_TRIGGER.trigger((ServerPlayer)this.lastFedPlayer, this);
                        }
                    }
                    this.putItemInMouth(ItemStack.f_41583_, false);
                    this.m_146850_(GameEvent.f_157806_);
                    this.gotFood(40);
                    if (DebugFlags.DEBUG_BEAR_EAT) {
                        BlastFromThePast.LOGGER.info("Finished chewing part of eating animation for {}", (Object)this);
                    }
                } else if (this.finishedEating()) {
                    this.setSitting(false);
                    this.setEating(false);
                    if (DebugFlags.DEBUG_BEAR_EAT) {
                        BlastFromThePast.LOGGER.info("Finished eating animation for {}", (Object)this);
                    }
                }
            }
            ++this.eatCounter;
        }
    }

    private boolean finishedEating() {
        return this.eatCounter >= MAX_EAT_TIME;
    }

    private boolean isChewing() {
        return this.startedChewing() && !this.finishedChewing();
    }

    private boolean isAboutToFinishEating() {
        return this.finishedChewing() && this.eatCounter <= MAX_EAT_TIME;
    }

    private boolean finishedChewing() {
        return this.eatCounter >= FINISH_CHEWING_ACTION_POINT;
    }

    private boolean startedChewing() {
        return this.eatCounter >= START_CHEWING_ACTION_POINT;
    }

    public boolean isFoodOrPacifier(ItemStack stack) {
        return this.m_6898_(stack) || this.isPacifier(stack);
    }

    protected boolean isWantedItem(ItemEntity itemEntity) {
        return itemEntity.m_6084_() && !itemEntity.m_32063_() && this.isFoodOrPacifier(itemEntity.m_32055_());
    }

    public boolean m_7066_(ItemStack itemstack) {
        EquipmentSlot slotForItem = PsychoBearEntity.m_147233_((ItemStack)itemstack);
        return this.m_6844_(slotForItem).m_41619_() && slotForItem == EquipmentSlot.MAINHAND && super.m_7066_(itemstack);
    }

    protected void m_7581_(ItemEntity itemEntity) {
        if (this.getItemInMouth().m_41619_() && this.isWantedItem(itemEntity)) {
            this.m_21053_(itemEntity);
            ItemStack item = itemEntity.m_32055_();
            this.putItemInMouth(item, true);
            this.m_7938_((Entity)itemEntity, item.m_41613_());
            itemEntity.m_146870_();
        }
    }

    @Override
    public void putItemInMouth(ItemStack item, boolean guaranteeDrop) {
        this.m_8061_(EquipmentSlot.MAINHAND, item);
        if (guaranteeDrop) {
            this.m_21508_(EquipmentSlot.MAINHAND);
            this.m_21530_();
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        this.jukebox = null;
        this.party = false;
        if (!this.m_9236_().f_46443_) {
            this.clearStates();
        }
        return super.m_6469_(source, amount);
    }

    private void addEatingParticles() {
        if (this.eatCounter % 5 == 0) {
            this.m_5496_((SoundEvent)ModSounds.PSYCHO_BEAR_EAT.get(), 0.5f + 0.5f * (float)this.f_19796_.m_188503_(2), (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
            for (int i = 0; i < 6; ++i) {
                Vec3 particleSpeedVec = new Vec3(((double)this.f_19796_.m_188501_() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, ((double)this.f_19796_.m_188501_() - 0.5) * 0.1);
                particleSpeedVec = particleSpeedVec.m_82496_(-this.m_146909_() * ((float)Math.PI / 180));
                particleSpeedVec = particleSpeedVec.m_82524_(-this.m_146908_() * ((float)Math.PI / 180));
                double randomYOffset = (double)(-this.f_19796_.m_188501_()) * 0.6 - 0.3;
                Vec3 particlePosVec = new Vec3(((double)this.f_19796_.m_188501_() - 0.5) * 0.8, randomYOffset, 1.0 + ((double)this.f_19796_.m_188501_() - 0.5) * 0.4);
                particlePosVec = particlePosVec.m_82524_(-this.f_20883_ * ((float)Math.PI / 180));
                particlePosVec = particlePosVec.m_82520_(this.m_20185_(), this.m_20188_() + 1.0, this.m_20189_());
                this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, this.getItemInMouth()), particlePosVec.f_82479_, particlePosVec.f_82480_, particlePosVec.f_82481_, particleSpeedVec.f_82479_, particleSpeedVec.f_82480_ + 0.05, particleSpeedVec.f_82481_);
            }
        }
    }

    public void m_7023_(Vec3 travelVector) {
        if (!this.canMove() && this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82542_(0.0, 1.0, 0.0));
            travelVector = travelVector.m_82542_(0.0, 1.0, 0.0);
        }
        super.m_7023_(travelVector);
    }

    public boolean m_7307_(Entity other) {
        if (other == null) {
            return false;
        }
        if (super.m_7307_(other)) {
            return true;
        }
        if (this.isAlliedToDefault(other)) {
            return this.m_5647_() == null && other.m_5647_() == null;
        }
        return false;
    }

    protected boolean isAlliedToDefault(Entity other) {
        return other.m_6095_().equals(this.m_6095_());
    }

    protected SoundEvent m_7515_() {
        if (this.m_5803_()) {
            return (SoundEvent)ModSounds.PSYCHO_BEAR_SNORE.get();
        }
        return (SoundEvent)ModSounds.PSYCHO_BEAR_IDLE.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.PSYCHO_BEAR_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ModSounds.PSYCHO_BEAR_HURT.get();
    }

    @Override
    public boolean isAllActionBlocked() {
        return !this.canPerformAction();
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.readPacifiedData(compound);
        this.readAnimalStates(compound);
    }

    @Override
    public void readAnimalStates(CompoundTag compound) {
        if (compound.m_128425_("Sleeping", 1)) {
            this.setSleepState(TransitioningState.byOrdinal(compound.m_128445_("Sleeping")));
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        this.writePacifiedData(compound);
        this.writeAnimalStates(compound);
    }

    @Override
    public void writeAnimalStates(CompoundTag compound) {
        TransitioningState sleepState = this.getSleepState();
        if (!sleepState.isTransitional()) {
            compound.m_128344_("Sleeping", (byte)sleepState.ordinal());
        }
    }

    @Override
    public void setPacifiedTicks(int pacifiedTicks) {
        int previousPacifiedTicks = this.getPacifiedTicks();
        this.pacifiedTicks = pacifiedTicks;
        if (previousPacifiedTicks > 0 && pacifiedTicks <= 0 || previousPacifiedTicks <= 0 && pacifiedTicks > 0) {
            this.f_19804_.m_135381_(DATA_PACIFIED, (Object)(pacifiedTicks > 0 ? 1 : 0));
        }
    }

    @Override
    public int getPacifiedTicks() {
        if (this.m_9236_().f_46443_) {
            return (Boolean)this.f_19804_.m_135370_(DATA_PACIFIED) != false ? 1 : -1;
        }
        return this.pacifiedTicks;
    }

    @Override
    public boolean wantsMoreFood() {
        return this.moreFoodTicks <= 0 && !this.isWantedFood(this.getItemInMouth()) && !this.isEating();
    }

    @Override
    public void gotFood(int ticks) {
        this.moreFoodTicks = ticks;
    }

    @Override
    public boolean isWantedFood(ItemStack stack) {
        return this.isFoodOrPacifier(stack);
    }

    @Override
    public void takeFood(ItemStack stack) {
        this.putItemInMouth(stack, true);
    }

    @Override
    public void setSleeping(boolean sleeping) {
        TransitioningState.transition(sleeping, this::getSleepState, this::setSleepState);
    }

    private void setSleepState(TransitioningState sleepState) {
        this.f_19804_.m_135381_(DATA_SLEEP_STATE, (Object)((byte)sleepState.ordinal()));
    }

    @Override
    public boolean isSleepingFlag() {
        return this.getSleepState() != TransitioningState.INACTIVE;
    }

    private TransitioningState getSleepState() {
        return TransitioningState.byOrdinal(((Byte)this.f_19804_.m_135370_(DATA_SLEEP_STATE)).byteValue());
    }

    public boolean m_5803_() {
        return this.isSleepingFlag();
    }

    @Override
    public void prepareToStartSleeping() {
        this.setSitting(false);
        this.setEating(false);
        this.m_6862_(false);
    }

    @Override
    public boolean canSleep() {
        return this.m_9236_().m_46462_() && this.f_20902_ == 0.0f && this.hasShelter() && !this.alertable() && !this.f_146808_ && this.m_5448_() == null && this.m_21225_() == null;
    }

    @Override
    public boolean shouldFindShelter(boolean urgent) {
        if (urgent) {
            return this.m_9236_().m_46470_() && this.m_9236_().m_45527_(this.m_20183_());
        }
        return this.m_9236_().m_46462_() && this.m_9236_().m_45527_(this.m_20183_()) && !((ServerLevel)this.m_9236_()).m_8802_(this.m_20183_());
    }

    @Override
    public void clearStates() {
        this.setSitting(false);
        this.setEating(false);
        this.setSleeping(false);
        this.setBackScratching(false);
    }

    @Override
    public boolean canAnimateWalk() {
        if (this.isRoaring() || this.isBackScratching()) {
            return false;
        }
        return OverrideAnimatedAttacker.super.canAnimateWalk();
    }

    @Override
    public boolean canAnimateLook() {
        if (this.isRoaring() || this.isBackScratching() || this.isEating()) {
            return false;
        }
        return OverrideAnimatedAttacker.super.canAnimateLook();
    }

    protected boolean hasShelter() {
        BlockPos topOfSelfPos = BlockPos.m_274561_((double)this.m_20185_(), (double)this.m_20191_().f_82292_, (double)this.m_20189_());
        return EntityHelper.hasBlocksAbove((PathfinderMob)this, topOfSelfPos);
    }

    protected boolean alertable() {
        return false;
    }

    @Override
    public boolean isBackScratching() {
        return this.getBackScratchState() != TransitioningState.INACTIVE;
    }

    private TransitioningState getBackScratchState() {
        return TransitioningState.byOrdinal(((Byte)this.f_19804_.m_135370_(DATA_BACK_SCRATCH_STATE)).byteValue());
    }

    @Override
    public void setBackScratching(boolean backScratching) {
        TransitioningState.transition(backScratching, this::getBackScratchState, this::setBackScratchState);
    }

    @Override
    public boolean wantsToScratchBack() {
        return this.itchReliefTicks <= 0;
    }

    @Override
    public void scratchedBack() {
        this.itchReliefTicks = 100;
    }

    @Override
    public void playBackScratchSound() {
        this.m_5496_((SoundEvent)ModSounds.PSYCHO_BEAR_SCRATCH.get(), this.m_6121_(), this.m_6100_());
    }

    @Override
    public void setPreparingToScratchBack(boolean prepare) {
        this.f_19804_.m_135381_(DATA_PREPARING_TO_SCRATCH_BACK, (Object)prepare);
    }

    @Override
    public boolean isPreparingToScratchBack() {
        return (Boolean)this.f_19804_.m_135370_(DATA_PREPARING_TO_SCRATCH_BACK);
    }

    private void setBackScratchState(TransitioningState backScratchState) {
        this.f_19804_.m_135381_(DATA_BACK_SCRATCH_STATE, (Object)((byte)backScratchState.ordinal()));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "main", 5, state -> {
            PsychoBearAttackType activeAttackType = this.getActiveAttackType();
            if (!this.m_6162_()) {
                if (this.isRoaring()) {
                    return state.setAndContinue(ROAR);
                }
                if (activeAttackType == PsychoBearAttackType.SLASH && !this.m_21526_()) {
                    return state.setAndContinue(ATTACK_FLIPPED);
                }
                if (activeAttackType == PsychoBearAttackType.SLASH && this.m_21526_()) {
                    return state.setAndContinue(ATTACK);
                }
                if (activeAttackType == null && this.isEating()) {
                    return state.setAndContinue(EAT);
                }
                if (activeAttackType == null && this.getSleepState() == TransitioningState.INACTIVE_TO_ACTIVE) {
                    return state.setAndContinue(SLEEP_START);
                }
                if (activeAttackType == null && this.getSleepState() == TransitioningState.ACTIVE) {
                    return state.setAndContinue(SLEEP);
                }
                if (activeAttackType == null && this.getSleepState() == TransitioningState.ACTIVE_TO_INACTIVE) {
                    return state.setAndContinue(SLEEP_END);
                }
                if (activeAttackType == null && this.getBackScratchState() == TransitioningState.INACTIVE_TO_ACTIVE) {
                    return state.setAndContinue(SCRATCH_START);
                }
                if (activeAttackType == null && this.getBackScratchState() == TransitioningState.ACTIVE) {
                    return state.setAndContinue(SCRATCH_LOOP);
                }
                if (activeAttackType == null && this.getBackScratchState() == TransitioningState.ACTIVE_TO_INACTIVE) {
                    return state.setAndContinue(SCRATCH_STOP);
                }
            }
            if (state.isMoving()) {
                return state.setAndContinue(WALK);
            }
            if (this.party && !this.m_6162_()) {
                return state.setAndContinue(DANCE);
            }
            return state.setAndContinue(IDLE);
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static enum PsychoBearAttackType implements AnimatedAttacker.AttackType<PsychoBearEntity, PsychoBearAttackType>
    {
        BITE(Mth.m_14143_((float)7.6f), 20, DEFAULT_ATTACK_SIZE, 8.0f, 0.0f),
        SLASH(Mth.m_14143_((float)7.6f), 20, DEFAULT_ATTACK_SIZE, 8.0f, 0.0f);

        private final int attackPoint;
        private final int attackDuration;
        private final Vec3 attackSize;
        private final float attackDamage;
        private final float attackKnockback;

        private PsychoBearAttackType(int attackPoint, int attackDuration, Vec3 attackSize, float attackDamage, float attackKnockback) {
            this.attackPoint = attackPoint;
            this.attackDuration = attackDuration;
            this.attackSize = attackSize;
            this.attackDamage = attackDamage;
            this.attackKnockback = attackKnockback;
        }

        @Override
        public void executeAttackPoint(PsychoBearEntity attacker, int attackTicker) {
            Vec3 attackSize = this.getAttackSize().m_82490_((double)attacker.m_6134_());
            AABB attackBounds = HitboxHelper.createHitboxRelativeToFront((LivingEntity)attacker, attackSize.m_7096_(), attackSize.m_7098_(), attackSize.m_7094_());
            if (this == SLASH) {
                attacker.m_5496_((SoundEvent)ModSounds.PSYCHO_BEAR_SLASH.get(), attacker.m_6121_(), attacker.m_6100_());
                EntityHelper.hitTargetsWithAOEAttack(attacker, attackBounds, this.getAttackDamage(), this.getAttackKnockback(), false);
            }
        }

        @Override
        public int getAttackPoint() {
            return this.attackPoint;
        }

        @Override
        public int getAttackDuration() {
            return this.attackDuration;
        }

        @Override
        public Vec3 getAttackSize() {
            return this.attackSize;
        }

        @Override
        public float getAttackDamage() {
            return this.attackDamage;
        }

        @Override
        public float getAttackKnockback() {
            return this.attackKnockback;
        }

        public static PsychoBearAttackType byOrdinal(int pOrdinal) {
            if (pOrdinal < 0 || pOrdinal > PsychoBearAttackType.values().length) {
                pOrdinal = 0;
            }
            return PsychoBearAttackType.values()[pOrdinal];
        }
    }
}

