/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import team.recrafted.blastfromthepast.entity.ai.goal.SnowdoBreedGoal;
import team.recrafted.blastfromthepast.init.ModCriteriaTriggers;
import team.recrafted.blastfromthepast.init.ModEntities;
import team.recrafted.blastfromthepast.init.ModItems;
import team.recrafted.blastfromthepast.init.ModSounds;

public class SnowdoEntity
extends Animal
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> TRIPPED = SynchedEntityData.m_135353_(SnowdoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Optional<UUID>> RIDDEN_PLAYER = SynchedEntityData.m_135353_(SnowdoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public static final EntityDataAccessor<Boolean> GLIDING = SynchedEntityData.m_135353_(SnowdoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_SHEARED = SynchedEntityData.m_135353_(SnowdoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final float movementSpeed = 0.12f;
    public int tripTicks;
    public int featherGrowthTimer;
    private boolean party;
    @javax.annotation.Nullable
    private BlockPos jukebox;
    public static final RawAnimation IDLE = RawAnimation.begin().then("animation.snowdo.idle", Animation.LoopType.DEFAULT);
    public static final RawAnimation TRIP = RawAnimation.begin().then("animation.snowdo.trip", Animation.LoopType.DEFAULT);
    public static final RawAnimation FALL = RawAnimation.begin().then("animation.snowdo.fall", Animation.LoopType.DEFAULT);
    public static final RawAnimation TAIL = RawAnimation.begin().then("animation.snowdo.tail", Animation.LoopType.DEFAULT);
    public static final RawAnimation WALK = RawAnimation.begin().then("animation.snowdo.walk", Animation.LoopType.DEFAULT);
    public static final RawAnimation DANCE = RawAnimation.begin().then("animation.snowdo.dance", Animation.LoopType.DEFAULT);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public SnowdoEntity(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 2;
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22279_, (double)0.12f).m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22277_, 16.0);
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SnowdoBreedGoal(this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new PanicGoal((PathfinderMob)this, 1.5));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.MELON_ICE_CREAM.get()}), false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 5.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void m_8107_() {
        if (this.jukebox == null || !this.jukebox.m_203195_((Position)this.m_20182_(), 7.0) || !this.m_9236_().m_8055_(this.jukebox).m_60713_(Blocks.f_50131_)) {
            this.party = false;
            this.jukebox = null;
        }
        super.m_8107_();
    }

    public void m_6818_(@NotNull BlockPos pos, boolean isPartying) {
        this.jukebox = pos;
        if (!this.m_9236_().f_46443_ && isPartying && this.jukebox != null && this.jukebox.m_203195_((Position)this.m_20182_(), 15.0) && this.m_9236_().m_8055_(this.jukebox).m_60713_(Blocks.f_50131_)) {
            this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82400_(10.0)).forEach(player -> ModCriteriaTriggers.DANCE_TRIGGER.trigger((ServerPlayer)player, this));
        }
    }

    public void setTripped(boolean tripped) {
        this.f_19804_.m_135381_(TRIPPED, (Object)tripped);
        if (tripped) {
            this.m_21051_(Attributes.f_22279_).m_22100_(0.0);
            this.tripTicks = 30;
        } else {
            this.m_21051_(Attributes.f_22279_).m_22100_((double)0.12f);
            this.tripTicks = 0;
        }
    }

    public boolean isTripped() {
        return (Boolean)this.f_19804_.m_135370_(TRIPPED);
    }

    public void setGliding(boolean isGliding) {
        this.f_19804_.m_135381_(GLIDING, (Object)isGliding);
    }

    public boolean isGliding() {
        return (Boolean)this.f_19804_.m_135370_(GLIDING);
    }

    public boolean isSheared() {
        return (Boolean)this.f_19804_.m_135370_(IS_SHEARED);
    }

    public void setSheared(boolean sheared) {
        if (sheared) {
            this.featherGrowthTimer = 2400;
        }
        this.f_19804_.m_135381_(IS_SHEARED, (Object)sheared);
    }

    public void setRiddenPlayer(Optional<UUID> uuid) {
        this.f_19804_.m_135381_(RIDDEN_PLAYER, uuid);
    }

    public Optional<UUID> getRiddenPlayer() {
        return (Optional)this.f_19804_.m_135370_(RIDDEN_PLAYER);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TRIPPED, (Object)false);
        this.f_19804_.m_135372_(RIDDEN_PLAYER, Optional.empty());
        this.f_19804_.m_135372_(GLIDING, (Object)false);
        this.f_19804_.m_135372_(IS_SHEARED, (Object)false);
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pose) {
        return this.m_6162_() ? EntityDimensions.m_20398_((float)0.35f, (float)0.35f) : super.m_6972_(pose);
    }

    protected float m_6431_(@NotNull Pose p_21131_, @NotNull EntityDimensions p_21132_) {
        return this.m_6162_() ? 0.2f : super.m_6431_(p_21131_, p_21132_);
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        this.jukebox = null;
        this.party = false;
        return super.m_6469_(source, amount);
    }

    public void m_8119_() {
        Player player;
        super.m_8119_();
        if (this.m_20202_() instanceof Player && this.m_20072_()) {
            this.m_8127_();
            this.setRiddenPlayer(Optional.empty());
        }
        if (this.m_20202_() == null) {
            Vec3 vec3 = this.m_20184_();
            if (!this.m_20096_() && vec3.f_82480_ < 0.0) {
                this.m_20256_(vec3.m_82542_(1.0, 0.6, 1.0));
            }
        }
        if (!this.m_9236_().m_5776_()) {
            if (this.featherGrowthTimer > 0) {
                --this.featherGrowthTimer;
                if (this.featherGrowthTimer == 0) {
                    this.setSheared(false);
                }
            }
            if (this.m_217043_().m_188503_(500) == 0 && this.m_20184_().m_165925_() > 1.0E-6 && this.m_20096_() && !this.m_20159_()) {
                this.setTripped(true);
                this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)ModSounds.SNOWDO_TRIP.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
            }
            if (this.isTripped()) {
                --this.tripTicks;
            }
            if (this.tripTicks <= 0) {
                this.setTripped(false);
            }
            if (this.m_20159_() && !this.m_20202_().m_20096_() || !this.m_20159_() && !this.m_20096_()) {
                this.setGliding(true);
            } else if (this.isGliding()) {
                this.setGliding(false);
            }
            Entity entity = this.m_20202_();
            if (entity instanceof Player) {
                player = (Player)entity;
                this.m_19915_(player.m_146908_(), player.m_146909_() * 0.5f);
                this.f_19859_ = this.f_20883_ = this.m_146908_();
                Vec3 vec3 = player.m_20184_();
                if (!player.m_20096_() && vec3.f_82480_ < 0.0) {
                    player.m_20256_(vec3.m_82542_(1.0, 0.6, 1.0));
                    player.f_19864_ = true;
                    player.m_183634_();
                }
            }
        }
        Player player2 = player = this.getRiddenPlayer().isPresent() ? this.m_9236_().m_46003_(this.getRiddenPlayer().get()) : null;
        if (!(this.m_20202_() instanceof Player) && this.getRiddenPlayer().isPresent() && player != null && !player.m_6047_()) {
            this.m_20329_((Entity)player);
        }
        if (player == null || player.m_6047_()) {
            this.m_8127_();
            this.setRiddenPlayer(Optional.empty());
        }
        if (this.m_217043_().m_188503_(100) == 0 && !this.m_6162_()) {
            this.triggerAnim("second", "tail");
        }
    }

    public boolean m_142535_(float fallDistance, float multiplier, @NotNull DamageSource source) {
        if (this.isGliding()) {
            return false;
        }
        return super.m_142535_(fallDistance, multiplier, source);
    }

    @NotNull
    public InteractionResult m_6071_(Player player, @NotNull InteractionHand hand) {
        if (player.m_21205_().m_41619_() && !this.m_6162_() && player.m_146895_() == null) {
            this.m_7998_((Entity)player, true);
            this.setRiddenPlayer(Optional.of(player.m_20148_()));
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (player.m_21205_().m_41720_() == Items.f_42574_ && this.featherGrowthTimer == 0) {
            this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12344_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.setSheared(true);
            this.m_19983_(new ItemStack((ItemLike)Items.f_42402_, this.f_19796_.m_216332_(1, 3)));
        }
        return super.m_6071_(player, hand);
    }

    protected SoundEvent m_7975_(@NotNull DamageSource damageSource) {
        return (SoundEvent)ModSounds.SNOWDO_HURT.get();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.SNOWDO_IDLE.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.SNOWDO_DEATH.get();
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_150930_((Item)ModItems.MELON_ICE_CREAM.get());
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel level, @NotNull AgeableMob otherParent) {
        return (AgeableMob)((EntityType)ModEntities.SNOWDO.get()).m_20615_((Level)level);
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.setTripped(compound.m_128471_("tripped"));
        this.tripTicks = compound.m_128451_("tripTicks");
        if (compound.m_128441_("RiddenPlayer")) {
            this.setRiddenPlayer(Optional.of(compound.m_128342_("RiddenPlayer")));
        }
        this.setSheared(compound.m_128471_("sheared"));
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("tripped", this.isTripped());
        compound.m_128405_("tripTicks", this.tripTicks);
        if (this.getRiddenPlayer().isPresent()) {
            compound.m_128362_("RiddenPlayer", this.getRiddenPlayer().get());
        }
        compound.m_128379_("sheared", this.isSheared());
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "main", 5, state -> {
            if (this.isTripped()) {
                return state.setAndContinue(TRIP);
            }
            if (!this.m_6162_() && this.isGliding()) {
                return state.setAndContinue(FALL);
            }
            if (state.isMoving()) {
                return state.setAndContinue(WALK);
            }
            if (this.party && !this.m_6162_()) {
                return state.setAndContinue(DANCE);
            }
            return state.setAndContinue(IDLE);
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "second", 0, state -> PlayState.STOP).triggerableAnim("tail", TAIL)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

