/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity.ai.goal;

import java.util.function.Predicate;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.PanicGoal;

public class CustomPanicGoal<T extends PathfinderMob>
extends PanicGoal {
    private final T typedMob;
    private final Predicate<T> shouldPanic;
    private final Predicate<T> shouldAttackSourcePanic;

    public CustomPanicGoal(T mob, double speedModifier, Predicate<T> shouldAttackSourcePanic) {
        this((PathfinderMob)mob, p -> true, speedModifier, (Predicate<PathfinderMob>)shouldAttackSourcePanic);
    }

    public CustomPanicGoal(T mob, Predicate<T> shouldPanic, double speedModifier) {
        this((PathfinderMob)mob, (Predicate<PathfinderMob>)shouldPanic, speedModifier, p -> true);
    }

    public CustomPanicGoal(T mob, Predicate<T> shouldPanic, double speedModifier, Predicate<T> shouldAttackSourcePanic) {
        super(mob, speedModifier);
        this.typedMob = mob;
        this.shouldPanic = shouldPanic;
        this.shouldAttackSourcePanic = shouldAttackSourcePanic;
    }

    protected boolean m_202729_() {
        return this.shouldPanic.test(this.typedMob) && this.shouldAttackSourcePanic.test(this.typedMob);
    }

    public static boolean isMobDamage(Mob mob) {
        return mob.m_21188_() != null;
    }

    public static boolean isEnvironmentDamage(Mob mob) {
        return mob.m_203117_() || mob.m_6060_();
    }

    public static boolean isAllDamage(Mob mob) {
        return CustomPanicGoal.isMobDamage(mob) || CustomPanicGoal.isEnvironmentDamage(mob);
    }
}

