/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity.ai.goal;

import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.pathfinder.Path;
import team.recrafted.blastfromthepast.entity.GlacerosEntity;

public class GlacerosSparGoal
extends Goal {
    private final GlacerosEntity glaceros;
    private GlacerosEntity targetGlaceros;
    private Path path;

    public GlacerosSparGoal(GlacerosEntity glaceros) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.TARGET));
        this.glaceros = glaceros;
    }

    public boolean m_8036_() {
        if (this.glaceros.m_6162_() || this.glaceros.isPanicking() || this.glaceros.isSheared() || this.glaceros.sparringCooldown > 0) {
            return false;
        }
        if (this.glaceros.shouldSparInstantly || this.glaceros.m_217043_().m_188503_(200) == 0) {
            this.glaceros.shouldSparInstantly = false;
            if (this.glaceros.getSparringPartner() instanceof GlacerosEntity) {
                this.targetGlaceros = (GlacerosEntity)this.glaceros.getSparringPartner();
                this.path = this.glaceros.m_21573_().m_6570_((Entity)this.targetGlaceros, 0);
                if (this.path == null || !this.path.m_77403_()) {
                    return false;
                }
                return this.targetGlaceros.sparringCooldown == 0;
            }
            GlacerosEntity possiblePartner = this.getNearbyGlacerosForSparring();
            if (possiblePartner != null) {
                this.glaceros.setSparringPartner((Entity)possiblePartner);
                possiblePartner.setSparringPartner((Entity)this.glaceros);
                this.targetGlaceros = possiblePartner;
                this.targetGlaceros.shouldSparInstantly = true;
                this.path = this.glaceros.m_21573_().m_6570_((Entity)this.targetGlaceros, 0);
                return this.path != null && this.path.m_77403_();
            }
        }
        return false;
    }

    public void m_8056_() {
        super.m_8056_();
        this.glaceros.chargeTimer = 0;
        this.glaceros.setRushing(false);
        this.glaceros.m_21573_().m_26573_();
    }

    public void m_8041_() {
        super.m_8041_();
        this.glaceros.setCharging(false);
        this.glaceros.setRushing(false);
        this.glaceros.chargeTimer = 0;
        this.glaceros.m_21573_().m_26573_();
        this.glaceros.sparringCooldown = this.generateSparCooldown(this.glaceros);
        if (this.targetGlaceros != null) {
            this.targetGlaceros.setCharging(false);
            this.targetGlaceros.setRushing(false);
            this.targetGlaceros.chargeTimer = 0;
            this.targetGlaceros.m_21573_().m_26573_();
            this.targetGlaceros.sparringCooldown = this.generateSparCooldown(this.targetGlaceros);
        }
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.targetGlaceros != null) {
            this.glaceros.m_21563_().m_148051_((Entity)this.targetGlaceros);
            this.targetGlaceros.m_21563_().m_148051_((Entity)this.glaceros);
            this.glaceros.setCharging(true);
            this.targetGlaceros.setCharging(true);
            ++this.glaceros.chargeTimer;
            ++this.targetGlaceros.chargeTimer;
            if (this.glaceros.chargeTimer > 100 || this.targetGlaceros.chargeTimer > 100) {
                this.glaceros.setRushing(true);
                this.targetGlaceros.setRushing(true);
                this.glaceros.setCharging(false);
                this.targetGlaceros.setCharging(false);
                this.glaceros.f_19812_ = true;
                if ((double)this.glaceros.m_20270_((Entity)this.targetGlaceros) > 1.5) {
                    this.glaceros.m_21573_().m_5624_((Entity)this.targetGlaceros, 2.5);
                    this.targetGlaceros.m_21573_().m_5624_((Entity)this.glaceros, 2.5);
                } else {
                    if (this.glaceros.m_20096_()) {
                        this.glaceros.knockBackSparring(this.targetGlaceros, 1.25f);
                    }
                    if (this.targetGlaceros.m_20096_()) {
                        this.targetGlaceros.knockBackSparring(this.glaceros, 1.25f);
                    }
                    this.glaceros.chargeTimer = 0;
                    this.glaceros.sparringCooldown = this.generateSparCooldown(this.glaceros);
                    this.targetGlaceros.chargeTimer = 0;
                    this.targetGlaceros.sparringCooldown = this.generateSparCooldown(this.targetGlaceros);
                    this.m_8041_();
                }
            }
        }
    }

    public boolean m_8045_() {
        if (this.targetGlaceros != null) {
            this.path = this.glaceros.m_21573_().m_6570_((Entity)this.targetGlaceros, 0);
            if (this.path == null || !this.path.m_77403_()) {
                return false;
            }
        }
        return !this.glaceros.m_6162_() && !this.glaceros.isSheared() && !this.glaceros.isPanicking() && !this.targetGlaceros.isPanicking() && this.targetGlaceros != null && !this.targetGlaceros.isSheared() && this.targetGlaceros.m_6084_() && this.targetGlaceros.sparringCooldown == 0 && this.glaceros.sparringCooldown == 0;
    }

    public boolean m_6767_() {
        return false;
    }

    @Nullable
    private GlacerosEntity getNearbyGlacerosForSparring() {
        List listOfGlaceros = this.glaceros.m_9236_().m_45976_(GlacerosEntity.class, this.glaceros.m_20191_().m_82400_(10.0));
        double lvt_2_1_ = 100.0;
        GlacerosEntity nearbyGlaceros = null;
        for (GlacerosEntity glacerosEntity : listOfGlaceros) {
            if (this.glaceros == glacerosEntity || !this.glaceros.canSparWith(glacerosEntity) || !(this.glaceros.m_20280_((Entity)glacerosEntity) < lvt_2_1_) || !(this.glaceros.m_20280_((Entity)glacerosEntity) > 6.0)) continue;
            nearbyGlaceros = glacerosEntity;
            lvt_2_1_ = this.glaceros.m_20280_((Entity)glacerosEntity);
        }
        return nearbyGlaceros;
    }

    private int generateSparCooldown(GlacerosEntity entity) {
        return 400 + entity.m_217043_().m_188503_(100);
    }
}

