/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity.ai.goal;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import team.recrafted.blastfromthepast.mixin.BreedGoalAccessor;
import team.recrafted.blastfromthepast.util.EntityHelper;
import team.recrafted.blastfromthepast.util.HitboxHelper;

public class HitboxAdjustedBreedGoal
extends BreedGoal {
    private static final TargetingConditions PARTNER_TARGETING = TargetingConditions.m_148353_().m_148355_();
    protected boolean testInvisible = true;
    protected double range = 15.0;
    protected TargetingConditions partnerTargeting = PARTNER_TARGETING.m_148354_();

    public HitboxAdjustedBreedGoal(Animal animal, double speedModifier) {
        this(animal, speedModifier, animal.getClass());
    }

    public HitboxAdjustedBreedGoal(Animal animal, double speedModifier, Class<? extends Animal> partnerClass) {
        super(animal, speedModifier, partnerClass);
        this.partnerTargeting.m_26888_(this::isCloseEnoughToBreed);
    }

    protected boolean isCloseEnoughToBreed(LivingEntity target) {
        return HitboxHelper.isCloseEnoughForTargeting((LivingEntity)this.f_25113_, target, this.testInvisible, this.range);
    }

    public boolean m_8036_() {
        if (!this.f_25113_.m_27593_()) {
            return false;
        }
        this.f_25115_ = this.findPartner();
        return this.f_25115_ != null;
    }

    public void m_8037_() {
        this.f_25113_.m_21563_().m_24960_((Entity)this.f_25115_, 10.0f, (float)this.f_25113_.m_8132_());
        this.f_25113_.m_21573_().m_5624_((Entity)this.f_25115_, this.access().getSpeedModifier());
        this.access().setLoveTime(this.access().getLoveTime() + 1);
        double distanceToPartnerSqr = HitboxHelper.getDistSqrBetweenHitboxes((Entity)this.f_25113_, (Entity)this.f_25115_);
        if (this.access().getLoveTime() >= this.m_183277_(60) && distanceToPartnerSqr < 13.0) {
            this.m_8026_();
        }
    }

    @Nullable
    protected Animal findPartner() {
        List potentialPartners = this.f_25114_.m_45971_(this.access().getPartnerClass(), this.partnerTargeting, (LivingEntity)this.f_25113_, this.f_25113_.m_20191_().m_82400_(this.range));
        double closestDistanceToSqr = Double.MAX_VALUE;
        Animal partner = null;
        for (Animal potentialPartner : potentialPartners) {
            if (!this.f_25113_.m_7848_(potentialPartner) || EntityHelper.isPanicking(potentialPartner) || !(this.f_25113_.m_20280_((Entity)potentialPartner) < closestDistanceToSqr)) continue;
            partner = potentialPartner;
            closestDistanceToSqr = this.f_25113_.m_20280_((Entity)potentialPartner);
        }
        return partner;
    }

    protected BreedGoalAccessor access() {
        return (BreedGoalAccessor)((Object)this);
    }
}

