/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import team.recrafted.blastfromthepast.BlastFromThePast;
import team.recrafted.blastfromthepast.entity.misc.ComplexAnimal;
import team.recrafted.blastfromthepast.mixin.ServerPlayerAccessor;
import team.recrafted.blastfromthepast.util.DebugFlags;
import team.recrafted.blastfromthepast.util.EntityHelper;
import team.recrafted.blastfromthepast.util.HitboxHelper;

public class RaidFoodContainerGoal<T extends PathfinderMob>
extends MoveToBlockGoal {
    private static final int SATURATION_TICKS = 40;
    private static final int CHEST_CLOSE_DELAY = 40;
    private final T foodRaider;
    private boolean wantsToRaid;
    private boolean canRaid;
    private int openCounter = 0;

    public RaidFoodContainerGoal(T mob, double speedModifier, int searchRange) {
        this(mob, speedModifier, searchRange, 1);
    }

    public RaidFoodContainerGoal(T mob, double speedModifier, int searchRange, int verticalSearchRange) {
        super(mob, speedModifier, searchRange, verticalSearchRange);
        this.foodRaider = mob;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.f_25600_ <= 0) {
            if (!ForgeEventFactory.getMobGriefingEvent((Level)this.foodRaider.m_9236_(), this.foodRaider)) {
                return false;
            }
            this.canRaid = false;
            this.wantsToRaid = ((ComplexAnimal)this.foodRaider).wantsMoreFood();
            if (this.wantsToRaid && DebugFlags.DEBUG_RAID_FOOD_CONTAINER) {
                BlastFromThePast.LOGGER.info("{} is ready to look for a food container to raid!", this.foodRaider);
            }
        }
        return super.m_8036_();
    }

    protected int m_6099_(PathfinderMob creature) {
        return DebugFlags.DEBUG_RAID_FOOD_CONTAINER ? 40 : super.m_6099_(creature);
    }

    public void m_8056_() {
        super.m_8056_();
        this.openCounter = 0;
    }

    public boolean m_8045_() {
        if (this.canRaid && this.openCounter > 0) {
            return true;
        }
        return this.canRaid && super.m_8045_();
    }

    public double m_8052_() {
        return HitboxHelper.getHitboxAdjustedDistance(this.foodRaider, 1.5);
    }

    public void m_8037_() {
        super.m_8037_();
        boolean close = false;
        if (this.openCounter > 0) {
            --this.openCounter;
            if (this.openCounter <= 0) {
                close = true;
            }
        }
        this.foodRaider.m_21563_().m_24950_((double)this.f_25602_.m_123341_() + 0.5, (double)(this.f_25602_.m_123342_() + 1), (double)this.f_25602_.m_123343_() + 0.5, 10.0f, (float)this.foodRaider.m_8132_());
        if (this.m_25625_()) {
            boolean raiding = false;
            Level level = this.foodRaider.m_9236_();
            BlockPos above = this.f_25602_.m_7494_();
            BlockEntity blockEntity = level.m_7702_(above);
            if (this.canRaid && blockEntity instanceof BaseContainerBlockEntity) {
                BaseContainerBlockEntity bcbe = (BaseContainerBlockEntity)blockEntity;
                raiding = true;
                if (close) {
                    this.tryTakeFood(bcbe);
                    RaidFoodContainerGoal.closeMenu(this.getFakePlayer((ServerLevel)level));
                } else if (this.openCounter <= 0) {
                    if (DebugFlags.DEBUG_RAID_FOOD_CONTAINER) {
                        BlastFromThePast.LOGGER.info("{} is raiding a food container at {}", this.foodRaider, (Object)above);
                    }
                    RaidFoodContainerGoal.openMenu(this.getFakePlayer((ServerLevel)level), (MenuProvider)bcbe);
                    this.openCounter = 40;
                }
            }
            if (!raiding || close) {
                if (DebugFlags.DEBUG_RAID_FOOD_CONTAINER) {
                    BlastFromThePast.LOGGER.info("{} is no longer raiding a food container at {}", this.foodRaider, (Object)above);
                }
                this.canRaid = false;
            }
        }
    }

    private void tryTakeFood(BaseContainerBlockEntity bcbe) {
        for (int slot = 0; slot < bcbe.m_6643_(); ++slot) {
            ItemStack itemStack;
            ItemStack itemInSlot = bcbe.m_8020_(slot);
            if (!((ComplexAnimal)this.foodRaider).isWantedFood(itemInSlot) || (itemStack = bcbe.m_7407_(slot, 1)).m_41619_()) continue;
            ((ComplexAnimal)this.foodRaider).takeFood(itemStack);
            ((ComplexAnimal)this.foodRaider).gotFood(40);
            BlastFromThePast.LOGGER.info("{} finished raiding a food container {}", this.foodRaider, (Object)bcbe);
            break;
        }
    }

    private static void closeMenu(FakePlayer fakePlayer) {
        BlastFromThePast.LOGGER.info("Closing menu {} for {}", (Object)fakePlayer.f_36096_, (Object)fakePlayer);
        fakePlayer.m_6915_();
    }

    private static void openMenu(FakePlayer player, MenuProvider menuProvider) {
        if (menuProvider != null) {
            if (player.f_36096_ != player.f_36095_) {
                player.m_6915_();
            }
            ((ServerPlayerAccessor)player).blastfromthepast$callNextContainerCounter();
            AbstractContainerMenu menu = menuProvider.m_7208_(((ServerPlayerAccessor)player).blastfromthepast$getContainerCounter(), player.m_150109_(), (Player)player);
            if (DebugFlags.DEBUG_RAID_FOOD_CONTAINER) {
                BlastFromThePast.LOGGER.info("Opening menu {} for {}", (Object)menu, (Object)player);
            }
            if (menu != null) {
                try {
                    ((ServerPlayerAccessor)player).blastfromthepast$initMenu(menu);
                    player.f_36096_ = menu;
                }
                catch (Exception e) {
                    BlastFromThePast.LOGGER.debug("Check RaidFoodContainerGoal class line 164.", (Throwable)e);
                }
            }
        }
    }

    protected FakePlayer getFakePlayer(ServerLevel level) {
        return EntityHelper.getFakePlayer(level);
    }

    protected boolean m_25626_() {
        boolean foundNearestBlock = super.m_25626_();
        if (foundNearestBlock && DebugFlags.DEBUG_RAID_FOOD_CONTAINER) {
            BlastFromThePast.LOGGER.info("{} found a food container to raid!", this.foodRaider);
        }
        return foundNearestBlock;
    }

    protected boolean m_6465_(LevelReader level, BlockPos pos) {
        BlockPos above = pos.m_7494_();
        BlockEntity blockEntity = level.m_7702_(above);
        if (blockEntity instanceof BaseContainerBlockEntity && this.wantsToRaid && !this.canRaid) {
            this.canRaid = true;
            if (DebugFlags.DEBUG_RAID_FOOD_CONTAINER) {
                BlastFromThePast.LOGGER.info("{} can raid a food container!", this.foodRaider);
            }
            return true;
        }
        return false;
    }

    public void m_8041_() {
        super.m_8041_();
        if (this.openCounter > 0) {
            this.openCounter = 0;
            if (DebugFlags.DEBUG_RAID_FOOD_CONTAINER) {
                BlastFromThePast.LOGGER.info("Forcing open food container to be closed for {}", this.foodRaider);
            }
            RaidFoodContainerGoal.closeMenu(this.getFakePlayer((ServerLevel)this.foodRaider.m_9236_()));
        }
    }
}

