/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity.ai.goal;

import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import team.recrafted.blastfromthepast.BlastFromThePast;
import team.recrafted.blastfromthepast.entity.misc.BackScratcher;
import team.recrafted.blastfromthepast.util.DebugFlags;
import team.recrafted.blastfromthepast.util.EntityHelper;
import team.recrafted.blastfromthepast.util.HitboxHelper;

public class ScratchBackOnTreeGoal<T extends PathfinderMob>
extends MoveToBlockGoal {
    private static final int MAX_BACK_SCRATCH_TIME = 120;
    private final T backScratcher;
    private final Predicate<BlockState> isBackScratchBlock;
    private boolean wantsToScratchBack;
    private boolean canScratchBack;
    private boolean turning;
    private int backScratchCounter = 0;

    public ScratchBackOnTreeGoal(T mob, double speedModifier, int searchRange, Predicate<BlockState> isBackScratchBlock) {
        this(mob, speedModifier, searchRange, 1, isBackScratchBlock);
    }

    public ScratchBackOnTreeGoal(T mob, double speedModifier, int searchRange, int verticalSearchRange, Predicate<BlockState> isBackScratchBlock) {
        super(mob, speedModifier, searchRange, verticalSearchRange);
        this.backScratcher = mob;
        this.isBackScratchBlock = isBackScratchBlock;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.f_25598_.m_5803_()) {
            return false;
        }
        if (this.f_25600_ <= 0) {
            this.canScratchBack = false;
            this.wantsToScratchBack = ((BackScratcher)this.backScratcher).wantsToScratchBack();
            if (this.wantsToScratchBack && DebugFlags.DEBUG_BACK_SCRATCH) {
                BlastFromThePast.LOGGER.info("{} is ready to look for a tree to scratch their back on!", this.backScratcher);
            }
        }
        return super.m_8036_();
    }

    protected int m_6099_(@NotNull PathfinderMob creature) {
        return DebugFlags.DEBUG_BACK_SCRATCH ? 40 : super.m_6099_(creature);
    }

    public void m_8056_() {
        ((BackScratcher)this.backScratcher).setPreparingToScratchBack(true);
        this.backScratchCounter = 0;
        this.turning = false;
        super.m_8056_();
    }

    public boolean m_8045_() {
        if (this.f_25598_.m_5803_()) {
            return false;
        }
        if (this.canScratchBack && (this.backScratchCounter > 0 || this.turning)) {
            return true;
        }
        return this.canScratchBack && (((BackScratcher)this.backScratcher).isPreparingToScratchBack() || super.m_8045_());
    }

    public double m_8052_() {
        return HitboxHelper.getHitboxAdjustedDistance(this.backScratcher.m_20205_(), 1.0);
    }

    public void m_8037_() {
        super.m_8037_();
        boolean stopScratchingBack = false;
        if (this.backScratchCounter > 0) {
            --this.backScratchCounter;
            if (this.backScratchCounter <= 0) {
                stopScratchingBack = true;
            }
        }
        Vec3 lookTarget = new Vec3((double)this.f_25602_.m_123341_() + 0.5, (double)(this.f_25602_.m_123342_() + 1), (double)this.f_25602_.m_123343_() + 0.5);
        this.turning = false;
        if (this.m_25625_()) {
            boolean backScratching = false;
            Level level = this.backScratcher.m_9236_();
            BlockPos above = this.f_25602_.m_7494_();
            if (this.canScratchBack && this.isTree((LevelReader)level, this.f_25602_)) {
                backScratching = true;
                if (stopScratchingBack) {
                    ((BackScratcher)this.backScratcher).scratchedBack();
                    ((BackScratcher)this.backScratcher).setBackScratching(false);
                } else if (this.backScratchCounter <= 0) {
                    if (EntityHelper.isLookingAwayFrom(this.backScratcher, lookTarget, 0.025, true, false)) {
                        if (DebugFlags.DEBUG_BACK_SCRATCH) {
                            BlastFromThePast.LOGGER.info("{} is scratching their back on a tree at {}", this.backScratcher, (Object)above);
                        }
                        ((BackScratcher)this.backScratcher).setBackScratching(true);
                        ((BackScratcher)this.backScratcher).playBackScratchSound();
                        this.backScratchCounter = 120;
                    } else {
                        this.turning = true;
                        if (DebugFlags.DEBUG_BACK_SCRATCH) {
                            BlastFromThePast.LOGGER.info("{} is turning around to face away from {}", this.backScratcher, (Object)above);
                        }
                        Vec3 lookAwayOffset = lookTarget.m_82505_(this.backScratcher.m_146892_()).m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_(HitboxHelper.getHitboxAdjustedDistance(this.backScratcher, 1.0));
                        this.backScratcher.m_21563_().m_24950_(this.backScratcher.m_20185_() + lookAwayOffset.m_7096_(), this.backScratcher.m_20188_() + lookAwayOffset.m_7098_(), this.backScratcher.m_20189_() + lookAwayOffset.m_7094_(), 30.0f, (float)this.backScratcher.m_8132_());
                    }
                }
            }
            if (!backScratching || stopScratchingBack) {
                if (DebugFlags.DEBUG_BACK_SCRATCH) {
                    BlastFromThePast.LOGGER.info("{} is no longer scratching their back at {}", this.backScratcher, (Object)above);
                }
                this.canScratchBack = false;
            }
        } else {
            if (this.backScratchCounter > 0) {
                BlastFromThePast.LOGGER.info("Forcibly stopping active back scratch animation for {}", this.backScratcher);
                ((BackScratcher)this.backScratcher).setBackScratching(false);
            }
            this.backScratcher.m_21563_().m_24950_(lookTarget.m_7096_(), lookTarget.m_7098_(), lookTarget.m_7094_(), 10.0f, (float)this.backScratcher.m_8132_());
        }
    }

    protected boolean m_25626_() {
        boolean foundNearestBlock = super.m_25626_();
        if (foundNearestBlock && DebugFlags.DEBUG_BACK_SCRATCH) {
            BlastFromThePast.LOGGER.info("{} found a tree to scratch their back on!", this.backScratcher);
        }
        return foundNearestBlock;
    }

    protected boolean m_6465_(@NotNull LevelReader level, @NotNull BlockPos pos) {
        boolean isTree = this.isTree(level, pos);
        if (isTree && this.wantsToScratchBack && !this.canScratchBack) {
            this.canScratchBack = true;
            if (DebugFlags.DEBUG_BACK_SCRATCH) {
                BlastFromThePast.LOGGER.info("{} can scratch their back on a tree!", this.backScratcher);
            }
            return true;
        }
        return false;
    }

    private boolean isTree(LevelReader level, BlockPos pos) {
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        boolean foundTree = false;
        for (int i = 0; i < 3; ++i) {
            mutable.m_122173_(Direction.UP);
            foundTree = this.isBackScratchBlock.test(level.m_8055_((BlockPos)mutable));
        }
        return foundTree;
    }

    public void m_8041_() {
        super.m_8041_();
        this.turning = false;
        if (this.backScratchCounter > 0) {
            this.backScratchCounter = 0;
        } else if (DebugFlags.DEBUG_BACK_SCRATCH) {
            BlastFromThePast.LOGGER.info("Prematurely ending scratch back behavior for {}", this.backScratcher);
        }
        ((BackScratcher)this.backScratcher).setBackScratching(false);
        ((BackScratcher)this.backScratcher).setPreparingToScratchBack(false);
    }
}

