/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity.ai.goal;

import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import team.recrafted.blastfromthepast.block.SnowdoEggBlock;
import team.recrafted.blastfromthepast.init.ModBlocks;
import team.recrafted.blastfromthepast.util.EntityHelper;

public class SnowdoBreedGoal
extends Goal {
    private static final TargetingConditions PARTNER_TARGETING = TargetingConditions.m_148353_().m_26883_(8.0).m_148355_();
    protected final Animal animal;
    private final Class<? extends Animal> partnerClass;
    protected final Level level;
    @Nullable
    protected Animal partner;
    private int loveTime;
    private final double speedModifier;

    public SnowdoBreedGoal(Animal animal, double speedModifier) {
        this(animal, speedModifier, animal.getClass());
    }

    public SnowdoBreedGoal(Animal animal, double speedModifier, Class<? extends Animal> partnerClass) {
        this.animal = animal;
        this.level = animal.m_9236_();
        this.partnerClass = partnerClass;
        this.speedModifier = speedModifier;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.animal.m_27593_()) {
            return false;
        }
        this.partner = this.getFreePartner();
        return this.partner != null;
    }

    public boolean m_8045_() {
        return this.partner.m_6084_() && this.partner.m_27593_() && this.loveTime < 60 && !EntityHelper.isPanicking(this.partner);
    }

    public void m_8041_() {
        this.partner = null;
        this.loveTime = 0;
    }

    public void m_8037_() {
        this.animal.m_21563_().m_24960_((Entity)this.partner, 10.0f, (float)this.animal.m_8132_());
        this.animal.m_21573_().m_5624_((Entity)this.partner, this.speedModifier);
        ++this.loveTime;
        if (this.loveTime >= this.m_183277_(60) && this.animal.m_20280_((Entity)this.partner) < 9.0) {
            this.breed();
        }
    }

    @Nullable
    private Animal getFreePartner() {
        List list = this.level.m_45971_(this.partnerClass, PARTNER_TARGETING, (LivingEntity)this.animal, this.animal.m_20191_().m_82400_(8.0));
        double d0 = Double.MAX_VALUE;
        Animal animal = null;
        for (Animal animal1 : list) {
            if (!this.animal.m_7848_(animal1) || EntityHelper.isPanicking(animal1) || !(this.animal.m_20280_((Entity)animal1) < d0)) continue;
            animal = animal1;
            d0 = this.animal.m_20280_((Entity)animal1);
        }
        return animal;
    }

    protected void breed() {
        int number = this.animal.m_217043_().m_188503_(3) + 1;
        boolean eggSpawnFailed = false;
        BlockState snowdoEggs = (BlockState)((Block)ModBlocks.SNOWDO_EGG.get()).m_49966_().m_61124_((Property)SnowdoEggBlock.EGGS, (Comparable)Integer.valueOf(number));
        BlockPos eggsPos = this.animal.m_20183_();
        if (!this.animal.m_9236_().m_8055_(this.animal.m_20183_()).m_60795_() && (eggsPos = this.findSuitableEggPosition(this.animal.m_20183_())) == this.animal.m_20183_()) {
            eggSpawnFailed = true;
        }
        if (!eggSpawnFailed) {
            this.level.m_7731_(eggsPos, snowdoEggs, 2);
        }
        this.animal.m_146762_(6000);
        assert (this.partner != null);
        this.partner.m_146762_(6000);
        this.animal.m_27594_();
        this.partner.m_27594_();
    }

    private BlockPos findSuitableEggPosition(BlockPos startPos) {
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)startPos.m_7918_(-1, -1, -1), (BlockPos)startPos.m_7918_(1, 1, 1))) {
            if (!this.level.m_8055_(pos).m_60795_() || !this.level.m_8055_(pos.m_7495_()).m_280296_()) continue;
            return pos;
        }
        return startPos;
    }
}

