/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity.ai.goal.burrel;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import team.recrafted.blastfromthepast.entity.BurrelEntity;
import team.recrafted.blastfromthepast.init.ModItems;
import team.recrafted.blastfromthepast.init.ModSounds;

public class BurrelEatGoal
extends TargetGoal {
    private final BurrelEntity burrel;
    private int unseenTicks;
    ItemEntity itemTarget;

    public BurrelEatGoal(BurrelEntity burrel) {
        super((Mob)burrel, true);
        this.burrel = burrel;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        if (this.burrel.m_21023_(MobEffects.f_19597_) && this.burrel.m_21124_(MobEffects.f_19597_).m_19557_() <= 40) {
            return false;
        }
        this.findTarget();
        return this.itemTarget != null;
    }

    public void m_8056_() {
        this.unseenTicks = 0;
        this.burrel.m_6710_(null);
        this.burrel.setWantsToBeOnGround(true);
    }

    public void m_8041_() {
        this.itemTarget = null;
        this.burrel.m_21573_().m_26573_();
    }

    public void m_8037_() {
        if (this.itemTarget == null || this.itemTarget.m_213877_()) {
            return;
        }
        float entityDistance = this.burrel.m_20270_((Entity)this.itemTarget);
        if ((double)entityDistance < 1.5) {
            this.burrel.m_5496_((SoundEvent)ModSounds.BURREL_EAT.get(), 1.0f, this.burrel.m_6100_());
            this.burrel.triggerAnim("second", "eat");
            this.itemTarget.m_146870_();
            this.burrel.m_21573_().m_26573_();
            this.burrel.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40, 255, false, false, false));
        }
    }

    protected void findTarget() {
        List itemEntityList = this.f_26135_.m_9236_().m_6443_(ItemEntity.class, this.burrel.m_20191_().m_82377_(20.0, 30.0, 20.0), livingEntity -> true);
        ItemEntity targetCandidate = null;
        float distance = 0.0f;
        for (ItemEntity entry : itemEntityList) {
            if (!this.burrel.m_6898_(entry.m_32055_()) && !entry.m_32055_().m_150930_((Item)ModItems.SAP_BALL.get()) || !this.burrel.m_142582_((Entity)entry)) continue;
            float entityDistance = this.burrel.m_20270_((Entity)entry);
            if ((double)entityDistance < 1.5) {
                this.burrel.m_5496_((SoundEvent)ModSounds.BURREL_EAT.get(), 1.0f, this.burrel.m_6100_());
                this.burrel.triggerAnim("second", "eat");
                this.burrel.m_21573_().m_26573_();
                entry.m_146870_();
                this.burrel.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40, 255, false, false, false));
                return;
            }
            if (targetCandidate != null && !(entityDistance < distance)) continue;
            targetCandidate = entry;
            distance = this.burrel.m_20270_((Entity)entry);
        }
        this.itemTarget = targetCandidate;
        if (targetCandidate != null) {
            this.burrel.m_21573_().m_5624_((Entity)this.itemTarget, 1.0);
            this.burrel.m_21563_().m_148051_((Entity)this.itemTarget);
        }
    }

    public boolean m_8045_() {
        if (this.itemTarget == null || this.itemTarget.m_213877_() || !this.burrel.m_142582_((Entity)this.itemTarget)) {
            this.findTarget();
            if (this.itemTarget == null || this.itemTarget.m_213877_()) {
                return false;
            }
        }
        double d = this.m_7623_();
        if (this.f_26135_.m_20280_((Entity)this.itemTarget) > d * d) {
            return false;
        }
        if (this.f_26136_) {
            if (this.f_26135_.m_21574_().m_148306_((Entity)this.itemTarget)) {
                this.unseenTicks = 0;
            } else if (++this.unseenTicks > BurrelEatGoal.m_186073_((int)this.f_26138_)) {
                return false;
            }
        }
        return true;
    }
}

