/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity.ai.goal.burrel;

import java.util.EnumSet;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import team.recrafted.blastfromthepast.entity.BurrelEntity;
import team.recrafted.blastfromthepast.entity.ai.navigation.AzureNavigation;

public class BurrelGoToTreesGoal
extends Goal {
    private final BurrelEntity burrel;
    private final double speed;
    private BlockPos target;

    public BurrelGoToTreesGoal(BurrelEntity burrel, double speed) {
        this.burrel = burrel;
        this.speed = speed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        if (this.burrel.m_6162_()) {
            return false;
        }
        if (this.burrel.isBesideClimbableBlock() || this.burrel.wantsToBeOnGround() || this.burrel.m_21573_().m_26572_() || this.burrel.isPanicking() || this.burrel.m_9236_().m_8055_(this.burrel.m_20183_().m_7495_()).m_204336_(BlockTags.f_13035_)) {
            return false;
        }
        BlockPos burrelPos = this.burrel.m_20183_();
        for (int x = -10; x <= 10; ++x) {
            for (int z = -10; z <= 10; ++z) {
                BlockPos checkPos = burrelPos.m_7918_(x, 0, z);
                if (!this.goodTarget(checkPos) || !this.isTree(checkPos)) continue;
                for (int y = -5; y < 0; ++y) {
                    BlockPos checkPos2 = checkPos.m_7918_(0, y, 0);
                    if (!this.goodTarget(checkPos2)) continue;
                    this.burrel.targetTree = checkPos2;
                    return true;
                }
                this.burrel.targetTree = checkPos;
                return true;
            }
        }
        return false;
    }

    public boolean isTree(BlockPos pos) {
        BlockState blockState;
        do {
            pos = pos.m_7494_();
            blockState = this.burrel.m_9236_().m_8055_(pos);
            if (!blockState.m_204336_(BlockTags.f_13035_)) continue;
            return true;
        } while (blockState.m_204336_(BlockTags.f_13106_));
        return false;
    }

    public boolean goodTarget(BlockPos pos) {
        return this.burrel.m_9236_().m_8055_(pos).m_204336_(BlockTags.f_13106_) && this.hasLineOfSightWithBlock(pos);
    }

    public void m_8056_() {
        AzureNavigation navigation = (AzureNavigation)this.burrel.m_21573_();
        this.target = this.getClimbingPosition(this.burrel.targetTree);
        navigation.m_26536_(navigation.m_7864_(this.target, 1), this.speed);
        Vec3 targetCentre = this.target.m_252807_();
        this.burrel.m_21563_().m_24946_(targetCentre.m_7096_(), targetCentre.m_7098_(), targetCentre.m_7094_());
    }

    private BlockPos getClimbingPosition(BlockPos pos) {
        BlockHitResult hitResult = (BlockHitResult)this.rayTrace(pos);
        switch (hitResult.m_82434_()) {
            case EAST: {
                return pos.m_122029_();
            }
            case WEST: {
                return pos.m_122024_();
            }
            case NORTH: {
                return pos.m_122012_();
            }
            case SOUTH: {
                return pos.m_122019_();
            }
        }
        return pos;
    }

    private boolean hasLineOfSightWithBlock(BlockPos pos) {
        HitResult result = this.rayTrace(pos);
        return result.m_6662_() == HitResult.Type.BLOCK && ((BlockHitResult)result).m_82425_().m_252807_().equals((Object)pos.m_252807_()) && ((BlockHitResult)result).m_82434_() != Direction.DOWN && ((BlockHitResult)result).m_82434_() != Direction.UP;
    }

    private HitResult rayTrace(BlockPos pos) {
        Vec2 lookDirection = this.lookAngle(EntityAnchorArgument.Anchor.EYES, pos.m_252807_());
        Vec3 eyePosition = this.burrel.m_146892_();
        Vec3 endPosition = this.calculateViewVector(lookDirection.f_82470_, lookDirection.f_82471_).m_82490_(20.0).m_82549_(eyePosition);
        return this.burrel.m_9236_().m_45547_(new ClipContext(eyePosition, endPosition, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.burrel));
    }

    protected final Vec3 calculateViewVector(float xRot, float yRot) {
        float f = xRot * ((float)Math.PI / 180);
        float g = -yRot * ((float)Math.PI / 180);
        float h = Mth.m_14089_((float)g);
        float i = Mth.m_14031_((float)g);
        float j = Mth.m_14089_((float)f);
        float k = Mth.m_14031_((float)f);
        return new Vec3((double)(i * j), (double)(-k), (double)(h * j));
    }

    public Vec2 lookAngle(EntityAnchorArgument.Anchor anchor, Vec3 target) {
        Vec3 vec3 = anchor.m_90377_((Entity)this.burrel);
        double d = target.f_82479_ - vec3.f_82479_;
        double e = target.f_82480_ - vec3.f_82480_;
        double f = target.f_82481_ - vec3.f_82481_;
        double g = Math.sqrt(d * d + f * f);
        return new Vec2(Mth.m_14177_((float)((float)(-(Mth.m_14136_((double)e, (double)g) * 57.2957763671875)))), Mth.m_14177_((float)((float)(Mth.m_14136_((double)f, (double)d) * 57.2957763671875) - 90.0f)));
    }

    public void m_8037_() {
        Vec3 vec3 = this.target.m_252807_();
        if (this.burrel.m_20275_(vec3.f_82479_, this.burrel.m_20186_(), vec3.f_82481_) <= 2.0) {
            Vec3 vec = new Vec3((double)this.target.m_123341_() + 0.5, this.burrel.m_20186_(), (double)this.target.m_123343_() + 0.5).m_82546_(this.burrel.m_20182_());
            this.burrel.m_146884_(this.burrel.m_20182_().m_82549_(vec.m_82490_(0.1)));
        }
        if (this.burrel.m_20275_(vec3.f_82479_, this.burrel.m_20186_(), vec3.f_82481_) <= 0.5) {
            this.burrel.m_146884_(new Vec3((double)this.target.m_123341_() + 0.5, this.burrel.m_20186_(), (double)this.target.m_123343_() + 0.5));
            this.burrel.setBesideClimbableBlock(true);
        }
    }

    public boolean m_8045_() {
        BlockPos treePos = this.target;
        return this.burrel.targetTree != null && treePos != null && !this.burrel.isBesideClimbableBlock() && !this.burrel.m_21573_().m_26571_() && !(this.burrel.m_20275_(treePos.m_123341_(), treePos.m_123342_(), treePos.m_123343_()) <= 2.0) && !this.burrel.isPanicking() && !this.burrel.wantsToBeOnGround();
    }

    public void m_8041_() {
        BlockPos treePos = this.burrel.targetTree;
        if (treePos != null && this.burrel.m_20275_(treePos.m_123341_(), this.burrel.m_20186_(), treePos.m_123343_()) <= 2.0) {
            this.burrel.m_20219_(this.target.m_252807_());
            this.burrel.setBesideClimbableBlock(true);
        }
        this.burrel.m_21573_().m_26573_();
    }
}

